package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.OfficeClientCheckinStatus;
import odata.msgraph.client.beta.complex.OfficeUserCheckinSummary;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class WindowsOfficeClientSecurityConfiguration extends OfficeClientConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsOfficeClientSecurityConfiguration";
    }

    protected WindowsOfficeClientSecurityConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsOfficeClientSecurityConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<OfficeClientCheckinStatus> checkinStatuses;
        private String checkinStatusesNextLink;
        private String description;
        private String displayName;
        private String policyPayload;
        private Integer priority;
        private OfficeUserCheckinSummary userCheckinSummary;
        private String userPreferencePayload;
        private List<OfficeClientConfigurationAssignment> assignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder checkinStatuses(List<OfficeClientCheckinStatus> checkinStatuses) {
            this.checkinStatuses = checkinStatuses;
            this.changedFields = changedFields.add("checkinStatuses");
            return this;
        }

        public Builder checkinStatuses(OfficeClientCheckinStatus... checkinStatuses) {
            return checkinStatuses(Arrays.asList(checkinStatuses));
        }

        public Builder checkinStatusesNextLink(String checkinStatusesNextLink) {
            this.checkinStatusesNextLink = checkinStatusesNextLink;
            this.changedFields = changedFields.add("checkinStatuses");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder policyPayload(String policyPayload) {
            this.policyPayload = policyPayload;
            this.changedFields = changedFields.add("policyPayload");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder userCheckinSummary(OfficeUserCheckinSummary userCheckinSummary) {
            this.userCheckinSummary = userCheckinSummary;
            this.changedFields = changedFields.add("userCheckinSummary");
            return this;
        }

        public Builder userPreferencePayload(String userPreferencePayload) {
            this.userPreferencePayload = userPreferencePayload;
            this.changedFields = changedFields.add("userPreferencePayload");
            return this;
        }

        public Builder assignments(List<OfficeClientConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(OfficeClientConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public WindowsOfficeClientSecurityConfiguration build() {
            WindowsOfficeClientSecurityConfiguration _x = new WindowsOfficeClientSecurityConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsOfficeClientSecurityConfiguration";
            _x.id = id;
            _x.checkinStatuses = checkinStatuses;
            _x.checkinStatusesNextLink = checkinStatusesNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.policyPayload = policyPayload;
            _x.priority = priority;
            _x.userCheckinSummary = userCheckinSummary;
            _x.userPreferencePayload = userPreferencePayload;
            _x.assignments = assignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public WindowsOfficeClientSecurityConfiguration withUnmappedField(String name, Object value) {
        WindowsOfficeClientSecurityConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsOfficeClientSecurityConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsOfficeClientSecurityConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsOfficeClientSecurityConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsOfficeClientSecurityConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsOfficeClientSecurityConfiguration _copy() {
        WindowsOfficeClientSecurityConfiguration _x = new WindowsOfficeClientSecurityConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.checkinStatuses = checkinStatuses;
        _x.description = description;
        _x.displayName = displayName;
        _x.policyPayload = policyPayload;
        _x.priority = priority;
        _x.userCheckinSummary = userCheckinSummary;
        _x.userPreferencePayload = userPreferencePayload;
        _x.assignments = assignments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsOfficeClientSecurityConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("checkinStatuses=");
        b.append(this.checkinStatuses);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("policyPayload=");
        b.append(this.policyPayload);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("userCheckinSummary=");
        b.append(this.userCheckinSummary);
        b.append(", ");
        b.append("userPreferencePayload=");
        b.append(this.userPreferencePayload);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
