package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MalwareStateForWindowsDeviceCollectionRequest;
import odata.msgraph.client.beta.enums.WindowsMalwareCategory;
import odata.msgraph.client.beta.enums.WindowsMalwareSeverity;


/**
 * <i>“Malware information entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "additionalInformationUrl", 
    "category", 
    "displayName", 
    "lastDetectionDateTime", 
    "severity", 
    "deviceMalwareStates"})
@JsonInclude(Include.NON_NULL)
public class WindowsMalwareInformation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMalwareInformation";
    }

    @JsonProperty("additionalInformationUrl")
    protected String additionalInformationUrl;

    @JsonProperty("category")
    protected WindowsMalwareCategory category;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastDetectionDateTime")
    protected OffsetDateTime lastDetectionDateTime;

    @JsonProperty("severity")
    protected WindowsMalwareSeverity severity;

    @JsonProperty("deviceMalwareStates")
    protected List<MalwareStateForWindowsDevice> deviceMalwareStates;

    protected WindowsMalwareInformation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsMalwareInformation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String additionalInformationUrl;
        private WindowsMalwareCategory category;
        private String displayName;
        private OffsetDateTime lastDetectionDateTime;
        private WindowsMalwareSeverity severity;
        private List<MalwareStateForWindowsDevice> deviceMalwareStates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Information URL to learn more about the malware”</i>
         * 
         * @param additionalInformationUrl
         *            value of {@code additionalInformationUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder additionalInformationUrl(String additionalInformationUrl) {
            this.additionalInformationUrl = additionalInformationUrl;
            this.changedFields = changedFields.add("additionalInformationUrl");
            return this;
        }

        /**
         * <i>“Category of the malware”</i>
         * 
         * @param category
         *            value of {@code category} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder category(WindowsMalwareCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        /**
         * <i>“Malware name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The last time the malware is detected”</i>
         * 
         * @param lastDetectionDateTime
         *            value of {@code lastDetectionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastDetectionDateTime(OffsetDateTime lastDetectionDateTime) {
            this.lastDetectionDateTime = lastDetectionDateTime;
            this.changedFields = changedFields.add("lastDetectionDateTime");
            return this;
        }

        /**
         * <i>“Severity of the malware”</i>
         * 
         * @param severity
         *            value of {@code severity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder severity(WindowsMalwareSeverity severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        /**
         * <i>“List of devices affected by current malware with the malware state on each
         * device”</i>
         * 
         * @param deviceMalwareStates
         *            value of {@code deviceMalwareStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceMalwareStates(List<MalwareStateForWindowsDevice> deviceMalwareStates) {
            this.deviceMalwareStates = deviceMalwareStates;
            this.changedFields = changedFields.add("deviceMalwareStates");
            return this;
        }

        /**
         * <i>“List of devices affected by current malware with the malware state on each
         * device”</i>
         * 
         * @param deviceMalwareStates
         *            value of {@code deviceMalwareStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceMalwareStates(MalwareStateForWindowsDevice... deviceMalwareStates) {
            return deviceMalwareStates(Arrays.asList(deviceMalwareStates));
        }

        public WindowsMalwareInformation build() {
            WindowsMalwareInformation _x = new WindowsMalwareInformation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsMalwareInformation";
            _x.id = id;
            _x.additionalInformationUrl = additionalInformationUrl;
            _x.category = category;
            _x.displayName = displayName;
            _x.lastDetectionDateTime = lastDetectionDateTime;
            _x.severity = severity;
            _x.deviceMalwareStates = deviceMalwareStates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Information URL to learn more about the malware”</i>
     * 
     * @return property additionalInformationUrl
     */
    @Property(name="additionalInformationUrl")
    @JsonIgnore
    public Optional<String> getAdditionalInformationUrl() {
        return Optional.ofNullable(additionalInformationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * additionalInformationUrl} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Information URL to learn more about the malware”</i>
     * 
     * @param additionalInformationUrl
     *            new value of {@code additionalInformationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code additionalInformationUrl} field changed
     */
    public WindowsMalwareInformation withAdditionalInformationUrl(String additionalInformationUrl) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("additionalInformationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.additionalInformationUrl = additionalInformationUrl;
        return _x;
    }

    /**
     * <i>“Category of the malware”</i>
     * 
     * @return property category
     */
    @Property(name="category")
    @JsonIgnore
    public Optional<WindowsMalwareCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code category} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Category of the malware”</i>
     * 
     * @param category
     *            new value of {@code category} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code category} field changed
     */
    public WindowsMalwareInformation withCategory(WindowsMalwareCategory category) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.category = category;
        return _x;
    }

    /**
     * <i>“Malware name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Malware name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsMalwareInformation withDisplayName(String displayName) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The last time the malware is detected”</i>
     * 
     * @return property lastDetectionDateTime
     */
    @Property(name="lastDetectionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastDetectionDateTime() {
        return Optional.ofNullable(lastDetectionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastDetectionDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The last time the malware is detected”</i>
     * 
     * @param lastDetectionDateTime
     *            new value of {@code lastDetectionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastDetectionDateTime} field changed
     */
    public WindowsMalwareInformation withLastDetectionDateTime(OffsetDateTime lastDetectionDateTime) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("lastDetectionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.lastDetectionDateTime = lastDetectionDateTime;
        return _x;
    }

    /**
     * <i>“Severity of the malware”</i>
     * 
     * @return property severity
     */
    @Property(name="severity")
    @JsonIgnore
    public Optional<WindowsMalwareSeverity> getSeverity() {
        return Optional.ofNullable(severity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code severity} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Severity of the malware”</i>
     * 
     * @param severity
     *            new value of {@code severity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code severity} field changed
     */
    public WindowsMalwareInformation withSeverity(WindowsMalwareSeverity severity) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("severity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.severity = severity;
        return _x;
    }

    public WindowsMalwareInformation withUnmappedField(String name, Object value) {
        WindowsMalwareInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“List of devices affected by current malware with the malware state on each
     * device”</i>
     * 
     * @return navigational property deviceMalwareStates
     */
    @NavigationProperty(name="deviceMalwareStates")
    @JsonIgnore
    public MalwareStateForWindowsDeviceCollectionRequest getDeviceMalwareStates() {
        return new MalwareStateForWindowsDeviceCollectionRequest(
                        contextPath.addSegment("deviceMalwareStates"), Optional.ofNullable(deviceMalwareStates));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceMalwareStates} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of devices affected by current malware with the malware state on each
     * device”</i>
     * 
     * @param deviceMalwareStates
     *            new value of {@code deviceMalwareStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceMalwareStates} field changed
     */
    public WindowsMalwareInformation withDeviceMalwareStates(List<MalwareStateForWindowsDevice> deviceMalwareStates) {
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = changedFields.add("deviceMalwareStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareInformation");
        _x.deviceMalwareStates = deviceMalwareStates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsMalwareInformation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsMalwareInformation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsMalwareInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsMalwareInformation _copy() {
        WindowsMalwareInformation _x = new WindowsMalwareInformation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.additionalInformationUrl = additionalInformationUrl;
        _x.category = category;
        _x.displayName = displayName;
        _x.lastDetectionDateTime = lastDetectionDateTime;
        _x.severity = severity;
        _x.deviceMalwareStates = deviceMalwareStates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMalwareInformation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("additionalInformationUrl=");
        b.append(this.additionalInformationUrl);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastDetectionDateTime=");
        b.append(this.lastDetectionDateTime);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("deviceMalwareStates=");
        b.append(this.deviceMalwareStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
