package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.ConfigurationUsage;


/**
 * <i>“This entity provides descriptions of the declared methods, properties and
 * relationships exposed by Windows Hello for Business.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "enhancedAntiSpoofingForFacialFeaturesEnabled", 
    "pinExpirationInDays", 
    "pinLowercaseCharactersUsage", 
    "pinMaximumLength", 
    "pinMinimumLength", 
    "pinPreviousBlockCount", 
    "pinRecoveryEnabled", 
    "pinSpecialCharactersUsage", 
    "pinUppercaseCharactersUsage", 
    "securityDeviceRequired", 
    "unlockWithBiometricsEnabled", 
    "useCertificatesForOnPremisesAuthEnabled", 
    "useSecurityKeyForSignin", 
    "windowsHelloForBusinessBlocked"})
@JsonInclude(Include.NON_NULL)
public class WindowsIdentityProtectionConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsIdentityProtectionConfiguration";
    }

    @JsonProperty("enhancedAntiSpoofingForFacialFeaturesEnabled")
    protected Boolean enhancedAntiSpoofingForFacialFeaturesEnabled;

    @JsonProperty("pinExpirationInDays")
    protected Integer pinExpirationInDays;

    @JsonProperty("pinLowercaseCharactersUsage")
    protected ConfigurationUsage pinLowercaseCharactersUsage;

    @JsonProperty("pinMaximumLength")
    protected Integer pinMaximumLength;

    @JsonProperty("pinMinimumLength")
    protected Integer pinMinimumLength;

    @JsonProperty("pinPreviousBlockCount")
    protected Integer pinPreviousBlockCount;

    @JsonProperty("pinRecoveryEnabled")
    protected Boolean pinRecoveryEnabled;

    @JsonProperty("pinSpecialCharactersUsage")
    protected ConfigurationUsage pinSpecialCharactersUsage;

    @JsonProperty("pinUppercaseCharactersUsage")
    protected ConfigurationUsage pinUppercaseCharactersUsage;

    @JsonProperty("securityDeviceRequired")
    protected Boolean securityDeviceRequired;

    @JsonProperty("unlockWithBiometricsEnabled")
    protected Boolean unlockWithBiometricsEnabled;

    @JsonProperty("useCertificatesForOnPremisesAuthEnabled")
    protected Boolean useCertificatesForOnPremisesAuthEnabled;

    @JsonProperty("useSecurityKeyForSignin")
    protected Boolean useSecurityKeyForSignin;

    @JsonProperty("windowsHelloForBusinessBlocked")
    protected Boolean windowsHelloForBusinessBlocked;

    protected WindowsIdentityProtectionConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsIdentityProtectionConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean enhancedAntiSpoofingForFacialFeaturesEnabled;
        private Integer pinExpirationInDays;
        private ConfigurationUsage pinLowercaseCharactersUsage;
        private Integer pinMaximumLength;
        private Integer pinMinimumLength;
        private Integer pinPreviousBlockCount;
        private Boolean pinRecoveryEnabled;
        private ConfigurationUsage pinSpecialCharactersUsage;
        private ConfigurationUsage pinUppercaseCharactersUsage;
        private Boolean securityDeviceRequired;
        private Boolean unlockWithBiometricsEnabled;
        private Boolean useCertificatesForOnPremisesAuthEnabled;
        private Boolean useSecurityKeyForSignin;
        private Boolean windowsHelloForBusinessBlocked;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Boolean value used to enable enhanced anti-spoofing for facial feature
         * recognition on Windows Hello face authentication.”</i>
         * 
         * @param enhancedAntiSpoofingForFacialFeaturesEnabled
         *            value of {@code enhancedAntiSpoofingForFacialFeaturesEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enhancedAntiSpoofingForFacialFeaturesEnabled(Boolean enhancedAntiSpoofingForFacialFeaturesEnabled) {
            this.enhancedAntiSpoofingForFacialFeaturesEnabled = enhancedAntiSpoofingForFacialFeaturesEnabled;
            this.changedFields = changedFields.add("enhancedAntiSpoofingForFacialFeaturesEnabled");
            return this;
        }

        /**
         * <i>“Integer value specifies the period (in days) that a PIN can be used before the
         * system requires the user to change it. Valid values are 0 to 730 inclusive.
         * Valid values 0 to 730”</i>
         * 
         * @param pinExpirationInDays
         *            value of {@code pinExpirationInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinExpirationInDays(Integer pinExpirationInDays) {
            this.pinExpirationInDays = pinExpirationInDays;
            this.changedFields = changedFields.add("pinExpirationInDays");
            return this;
        }

        /**
         * <i>“This value configures the use of lowercase characters in the Windows Hello for
         * Business PIN.”</i>
         * 
         * @param pinLowercaseCharactersUsage
         *            value of {@code pinLowercaseCharactersUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinLowercaseCharactersUsage(ConfigurationUsage pinLowercaseCharactersUsage) {
            this.pinLowercaseCharactersUsage = pinLowercaseCharactersUsage;
            this.changedFields = changedFields.add("pinLowercaseCharactersUsage");
            return this;
        }

        /**
         * <i>“Integer value that sets the maximum number of characters allowed for the work
         * PIN. Valid values are 4 to 127 inclusive and greater than or equal to the value
         * set for the minimum PIN. Valid values 4 to 127”</i>
         * 
         * @param pinMaximumLength
         *            value of {@code pinMaximumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinMaximumLength(Integer pinMaximumLength) {
            this.pinMaximumLength = pinMaximumLength;
            this.changedFields = changedFields.add("pinMaximumLength");
            return this;
        }

        /**
         * <i>“Integer value that sets the minimum number of characters required for the
         * Windows Hello for Business PIN. Valid values are 4 to 127 inclusive and less
         * than or equal to the value set for the maximum PIN. Valid values 4 to 127”</i>
         * 
         * @param pinMinimumLength
         *            value of {@code pinMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinMinimumLength(Integer pinMinimumLength) {
            this.pinMinimumLength = pinMinimumLength;
            this.changedFields = changedFields.add("pinMinimumLength");
            return this;
        }

        /**
         * <i>“Controls the ability to prevent users from using past PINs. This must be set
         * between 0 and 50, inclusive, and the current PIN of the user is included in that
         * count. If set to 0, previous PINs are not stored. PIN history is not preserved
         * through a PIN reset. Valid values 0 to 50”</i>
         * 
         * @param pinPreviousBlockCount
         *            value of {@code pinPreviousBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinPreviousBlockCount(Integer pinPreviousBlockCount) {
            this.pinPreviousBlockCount = pinPreviousBlockCount;
            this.changedFields = changedFields.add("pinPreviousBlockCount");
            return this;
        }

        /**
         * <i>“Boolean value that enables a user to change their PIN by using the Windows Hello
         * for Business PIN recovery service.”</i>
         * 
         * @param pinRecoveryEnabled
         *            value of {@code pinRecoveryEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinRecoveryEnabled(Boolean pinRecoveryEnabled) {
            this.pinRecoveryEnabled = pinRecoveryEnabled;
            this.changedFields = changedFields.add("pinRecoveryEnabled");
            return this;
        }

        /**
         * <i>“Controls the ability to use special characters in the Windows Hello for Business
         * PIN.”</i>
         * 
         * @param pinSpecialCharactersUsage
         *            value of {@code pinSpecialCharactersUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinSpecialCharactersUsage(ConfigurationUsage pinSpecialCharactersUsage) {
            this.pinSpecialCharactersUsage = pinSpecialCharactersUsage;
            this.changedFields = changedFields.add("pinSpecialCharactersUsage");
            return this;
        }

        /**
         * <i>“This value configures the use of uppercase characters in the Windows Hello for
         * Business PIN.”</i>
         * 
         * @param pinUppercaseCharactersUsage
         *            value of {@code pinUppercaseCharactersUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinUppercaseCharactersUsage(ConfigurationUsage pinUppercaseCharactersUsage) {
            this.pinUppercaseCharactersUsage = pinUppercaseCharactersUsage;
            this.changedFields = changedFields.add("pinUppercaseCharactersUsage");
            return this;
        }

        /**
         * <i>“Controls whether to require a Trusted Platform Module (TPM) for provisioning
         * Windows Hello for Business. A TPM provides an additional security benefit in
         * that data stored on it cannot be used on other devices. If set to False, all
         * devices can provision Windows Hello for Business even if there is not a usable
         * TPM.”</i>
         * 
         * @param securityDeviceRequired
         *            value of {@code securityDeviceRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityDeviceRequired(Boolean securityDeviceRequired) {
            this.securityDeviceRequired = securityDeviceRequired;
            this.changedFields = changedFields.add("securityDeviceRequired");
            return this;
        }

        /**
         * <i>“Controls the use of biometric gestures, such as face and fingerprint, as an
         * alternative to the Windows Hello for Business PIN.  If set to False, biometric
         * gestures are not allowed. Users must still configure a PIN as a backup in case
         * of failures.”</i>
         * 
         * @param unlockWithBiometricsEnabled
         *            value of {@code unlockWithBiometricsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unlockWithBiometricsEnabled(Boolean unlockWithBiometricsEnabled) {
            this.unlockWithBiometricsEnabled = unlockWithBiometricsEnabled;
            this.changedFields = changedFields.add("unlockWithBiometricsEnabled");
            return this;
        }

        /**
         * <i>“Boolean value that enables Windows Hello for Business to use certificates to
         * authenticate on-premise resources.”</i>
         * 
         * @param useCertificatesForOnPremisesAuthEnabled
         *            value of {@code useCertificatesForOnPremisesAuthEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useCertificatesForOnPremisesAuthEnabled(Boolean useCertificatesForOnPremisesAuthEnabled) {
            this.useCertificatesForOnPremisesAuthEnabled = useCertificatesForOnPremisesAuthEnabled;
            this.changedFields = changedFields.add("useCertificatesForOnPremisesAuthEnabled");
            return this;
        }

        /**
         * <i>“Boolean value used to enable the Windows Hello security key as a logon
         * credential.”</i>
         * 
         * @param useSecurityKeyForSignin
         *            value of {@code useSecurityKeyForSignin} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useSecurityKeyForSignin(Boolean useSecurityKeyForSignin) {
            this.useSecurityKeyForSignin = useSecurityKeyForSignin;
            this.changedFields = changedFields.add("useSecurityKeyForSignin");
            return this;
        }

        /**
         * <i>“Boolean value that blocks Windows Hello for Business as a method for signing
         * into Windows.”</i>
         * 
         * @param windowsHelloForBusinessBlocked
         *            value of {@code windowsHelloForBusinessBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsHelloForBusinessBlocked(Boolean windowsHelloForBusinessBlocked) {
            this.windowsHelloForBusinessBlocked = windowsHelloForBusinessBlocked;
            this.changedFields = changedFields.add("windowsHelloForBusinessBlocked");
            return this;
        }

        public WindowsIdentityProtectionConfiguration build() {
            WindowsIdentityProtectionConfiguration _x = new WindowsIdentityProtectionConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsIdentityProtectionConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.enhancedAntiSpoofingForFacialFeaturesEnabled = enhancedAntiSpoofingForFacialFeaturesEnabled;
            _x.pinExpirationInDays = pinExpirationInDays;
            _x.pinLowercaseCharactersUsage = pinLowercaseCharactersUsage;
            _x.pinMaximumLength = pinMaximumLength;
            _x.pinMinimumLength = pinMinimumLength;
            _x.pinPreviousBlockCount = pinPreviousBlockCount;
            _x.pinRecoveryEnabled = pinRecoveryEnabled;
            _x.pinSpecialCharactersUsage = pinSpecialCharactersUsage;
            _x.pinUppercaseCharactersUsage = pinUppercaseCharactersUsage;
            _x.securityDeviceRequired = securityDeviceRequired;
            _x.unlockWithBiometricsEnabled = unlockWithBiometricsEnabled;
            _x.useCertificatesForOnPremisesAuthEnabled = useCertificatesForOnPremisesAuthEnabled;
            _x.useSecurityKeyForSignin = useSecurityKeyForSignin;
            _x.windowsHelloForBusinessBlocked = windowsHelloForBusinessBlocked;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Boolean value used to enable enhanced anti-spoofing for facial feature
     * recognition on Windows Hello face authentication.”</i>
     * 
     * @return property enhancedAntiSpoofingForFacialFeaturesEnabled
     */
    @Property(name="enhancedAntiSpoofingForFacialFeaturesEnabled")
    @JsonIgnore
    public Optional<Boolean> getEnhancedAntiSpoofingForFacialFeaturesEnabled() {
        return Optional.ofNullable(enhancedAntiSpoofingForFacialFeaturesEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enhancedAntiSpoofingForFacialFeaturesEnabled} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Boolean value used to enable enhanced anti-spoofing for facial feature
     * recognition on Windows Hello face authentication.”</i>
     * 
     * @param enhancedAntiSpoofingForFacialFeaturesEnabled
     *            new value of {@code enhancedAntiSpoofingForFacialFeaturesEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enhancedAntiSpoofingForFacialFeaturesEnabled} field changed
     */
    public WindowsIdentityProtectionConfiguration withEnhancedAntiSpoofingForFacialFeaturesEnabled(Boolean enhancedAntiSpoofingForFacialFeaturesEnabled) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enhancedAntiSpoofingForFacialFeaturesEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.enhancedAntiSpoofingForFacialFeaturesEnabled = enhancedAntiSpoofingForFacialFeaturesEnabled;
        return _x;
    }

    /**
     * <i>“Integer value specifies the period (in days) that a PIN can be used before the
     * system requires the user to change it. Valid values are 0 to 730 inclusive.
     * Valid values 0 to 730”</i>
     * 
     * @return property pinExpirationInDays
     */
    @Property(name="pinExpirationInDays")
    @JsonIgnore
    public Optional<Integer> getPinExpirationInDays() {
        return Optional.ofNullable(pinExpirationInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinExpirationInDays} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Integer value specifies the period (in days) that a PIN can be used before the
     * system requires the user to change it. Valid values are 0 to 730 inclusive.
     * Valid values 0 to 730”</i>
     * 
     * @param pinExpirationInDays
     *            new value of {@code pinExpirationInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinExpirationInDays} field changed
     */
    public WindowsIdentityProtectionConfiguration withPinExpirationInDays(Integer pinExpirationInDays) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinExpirationInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.pinExpirationInDays = pinExpirationInDays;
        return _x;
    }

    /**
     * <i>“This value configures the use of lowercase characters in the Windows Hello for
     * Business PIN.”</i>
     * 
     * @return property pinLowercaseCharactersUsage
     */
    @Property(name="pinLowercaseCharactersUsage")
    @JsonIgnore
    public Optional<ConfigurationUsage> getPinLowercaseCharactersUsage() {
        return Optional.ofNullable(pinLowercaseCharactersUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinLowercaseCharactersUsage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This value configures the use of lowercase characters in the Windows Hello for
     * Business PIN.”</i>
     * 
     * @param pinLowercaseCharactersUsage
     *            new value of {@code pinLowercaseCharactersUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinLowercaseCharactersUsage} field changed
     */
    public WindowsIdentityProtectionConfiguration withPinLowercaseCharactersUsage(ConfigurationUsage pinLowercaseCharactersUsage) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinLowercaseCharactersUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.pinLowercaseCharactersUsage = pinLowercaseCharactersUsage;
        return _x;
    }

    /**
     * <i>“Integer value that sets the maximum number of characters allowed for the work
     * PIN. Valid values are 4 to 127 inclusive and greater than or equal to the value
     * set for the minimum PIN. Valid values 4 to 127”</i>
     * 
     * @return property pinMaximumLength
     */
    @Property(name="pinMaximumLength")
    @JsonIgnore
    public Optional<Integer> getPinMaximumLength() {
        return Optional.ofNullable(pinMaximumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pinMaximumLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Integer value that sets the maximum number of characters allowed for the work
     * PIN. Valid values are 4 to 127 inclusive and greater than or equal to the value
     * set for the minimum PIN. Valid values 4 to 127”</i>
     * 
     * @param pinMaximumLength
     *            new value of {@code pinMaximumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinMaximumLength} field changed
     */
    public WindowsIdentityProtectionConfiguration withPinMaximumLength(Integer pinMaximumLength) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinMaximumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.pinMaximumLength = pinMaximumLength;
        return _x;
    }

    /**
     * <i>“Integer value that sets the minimum number of characters required for the
     * Windows Hello for Business PIN. Valid values are 4 to 127 inclusive and less
     * than or equal to the value set for the maximum PIN. Valid values 4 to 127”</i>
     * 
     * @return property pinMinimumLength
     */
    @Property(name="pinMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPinMinimumLength() {
        return Optional.ofNullable(pinMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pinMinimumLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Integer value that sets the minimum number of characters required for the
     * Windows Hello for Business PIN. Valid values are 4 to 127 inclusive and less
     * than or equal to the value set for the maximum PIN. Valid values 4 to 127”</i>
     * 
     * @param pinMinimumLength
     *            new value of {@code pinMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinMinimumLength} field changed
     */
    public WindowsIdentityProtectionConfiguration withPinMinimumLength(Integer pinMinimumLength) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.pinMinimumLength = pinMinimumLength;
        return _x;
    }

    /**
     * <i>“Controls the ability to prevent users from using past PINs. This must be set
     * between 0 and 50, inclusive, and the current PIN of the user is included in that
     * count. If set to 0, previous PINs are not stored. PIN history is not preserved
     * through a PIN reset. Valid values 0 to 50”</i>
     * 
     * @return property pinPreviousBlockCount
     */
    @Property(name="pinPreviousBlockCount")
    @JsonIgnore
    public Optional<Integer> getPinPreviousBlockCount() {
        return Optional.ofNullable(pinPreviousBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinPreviousBlockCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Controls the ability to prevent users from using past PINs. This must be set
     * between 0 and 50, inclusive, and the current PIN of the user is included in that
     * count. If set to 0, previous PINs are not stored. PIN history is not preserved
     * through a PIN reset. Valid values 0 to 50”</i>
     * 
     * @param pinPreviousBlockCount
     *            new value of {@code pinPreviousBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinPreviousBlockCount} field changed
     */
    public WindowsIdentityProtectionConfiguration withPinPreviousBlockCount(Integer pinPreviousBlockCount) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinPreviousBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.pinPreviousBlockCount = pinPreviousBlockCount;
        return _x;
    }

    /**
     * <i>“Boolean value that enables a user to change their PIN by using the Windows Hello
     * for Business PIN recovery service.”</i>
     * 
     * @return property pinRecoveryEnabled
     */
    @Property(name="pinRecoveryEnabled")
    @JsonIgnore
    public Optional<Boolean> getPinRecoveryEnabled() {
        return Optional.ofNullable(pinRecoveryEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinRecoveryEnabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Boolean value that enables a user to change their PIN by using the Windows Hello
     * for Business PIN recovery service.”</i>
     * 
     * @param pinRecoveryEnabled
     *            new value of {@code pinRecoveryEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinRecoveryEnabled} field changed
     */
    public WindowsIdentityProtectionConfiguration withPinRecoveryEnabled(Boolean pinRecoveryEnabled) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinRecoveryEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.pinRecoveryEnabled = pinRecoveryEnabled;
        return _x;
    }

    /**
     * <i>“Controls the ability to use special characters in the Windows Hello for Business
     * PIN.”</i>
     * 
     * @return property pinSpecialCharactersUsage
     */
    @Property(name="pinSpecialCharactersUsage")
    @JsonIgnore
    public Optional<ConfigurationUsage> getPinSpecialCharactersUsage() {
        return Optional.ofNullable(pinSpecialCharactersUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinSpecialCharactersUsage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls the ability to use special characters in the Windows Hello for Business
     * PIN.”</i>
     * 
     * @param pinSpecialCharactersUsage
     *            new value of {@code pinSpecialCharactersUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinSpecialCharactersUsage} field changed
     */
    public WindowsIdentityProtectionConfiguration withPinSpecialCharactersUsage(ConfigurationUsage pinSpecialCharactersUsage) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinSpecialCharactersUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.pinSpecialCharactersUsage = pinSpecialCharactersUsage;
        return _x;
    }

    /**
     * <i>“This value configures the use of uppercase characters in the Windows Hello for
     * Business PIN.”</i>
     * 
     * @return property pinUppercaseCharactersUsage
     */
    @Property(name="pinUppercaseCharactersUsage")
    @JsonIgnore
    public Optional<ConfigurationUsage> getPinUppercaseCharactersUsage() {
        return Optional.ofNullable(pinUppercaseCharactersUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinUppercaseCharactersUsage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This value configures the use of uppercase characters in the Windows Hello for
     * Business PIN.”</i>
     * 
     * @param pinUppercaseCharactersUsage
     *            new value of {@code pinUppercaseCharactersUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinUppercaseCharactersUsage} field changed
     */
    public WindowsIdentityProtectionConfiguration withPinUppercaseCharactersUsage(ConfigurationUsage pinUppercaseCharactersUsage) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pinUppercaseCharactersUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.pinUppercaseCharactersUsage = pinUppercaseCharactersUsage;
        return _x;
    }

    /**
     * <i>“Controls whether to require a Trusted Platform Module (TPM) for provisioning
     * Windows Hello for Business. A TPM provides an additional security benefit in
     * that data stored on it cannot be used on other devices. If set to False, all
     * devices can provision Windows Hello for Business even if there is not a usable
     * TPM.”</i>
     * 
     * @return property securityDeviceRequired
     */
    @Property(name="securityDeviceRequired")
    @JsonIgnore
    public Optional<Boolean> getSecurityDeviceRequired() {
        return Optional.ofNullable(securityDeviceRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityDeviceRequired} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls whether to require a Trusted Platform Module (TPM) for provisioning
     * Windows Hello for Business. A TPM provides an additional security benefit in
     * that data stored on it cannot be used on other devices. If set to False, all
     * devices can provision Windows Hello for Business even if there is not a usable
     * TPM.”</i>
     * 
     * @param securityDeviceRequired
     *            new value of {@code securityDeviceRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityDeviceRequired} field changed
     */
    public WindowsIdentityProtectionConfiguration withSecurityDeviceRequired(Boolean securityDeviceRequired) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("securityDeviceRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.securityDeviceRequired = securityDeviceRequired;
        return _x;
    }

    /**
     * <i>“Controls the use of biometric gestures, such as face and fingerprint, as an
     * alternative to the Windows Hello for Business PIN.  If set to False, biometric
     * gestures are not allowed. Users must still configure a PIN as a backup in case
     * of failures.”</i>
     * 
     * @return property unlockWithBiometricsEnabled
     */
    @Property(name="unlockWithBiometricsEnabled")
    @JsonIgnore
    public Optional<Boolean> getUnlockWithBiometricsEnabled() {
        return Optional.ofNullable(unlockWithBiometricsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unlockWithBiometricsEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls the use of biometric gestures, such as face and fingerprint, as an
     * alternative to the Windows Hello for Business PIN.  If set to False, biometric
     * gestures are not allowed. Users must still configure a PIN as a backup in case
     * of failures.”</i>
     * 
     * @param unlockWithBiometricsEnabled
     *            new value of {@code unlockWithBiometricsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unlockWithBiometricsEnabled} field changed
     */
    public WindowsIdentityProtectionConfiguration withUnlockWithBiometricsEnabled(Boolean unlockWithBiometricsEnabled) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("unlockWithBiometricsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.unlockWithBiometricsEnabled = unlockWithBiometricsEnabled;
        return _x;
    }

    /**
     * <i>“Boolean value that enables Windows Hello for Business to use certificates to
     * authenticate on-premise resources.”</i>
     * 
     * @return property useCertificatesForOnPremisesAuthEnabled
     */
    @Property(name="useCertificatesForOnPremisesAuthEnabled")
    @JsonIgnore
    public Optional<Boolean> getUseCertificatesForOnPremisesAuthEnabled() {
        return Optional.ofNullable(useCertificatesForOnPremisesAuthEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * useCertificatesForOnPremisesAuthEnabled} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Boolean value that enables Windows Hello for Business to use certificates to
     * authenticate on-premise resources.”</i>
     * 
     * @param useCertificatesForOnPremisesAuthEnabled
     *            new value of {@code useCertificatesForOnPremisesAuthEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useCertificatesForOnPremisesAuthEnabled} field changed
     */
    public WindowsIdentityProtectionConfiguration withUseCertificatesForOnPremisesAuthEnabled(Boolean useCertificatesForOnPremisesAuthEnabled) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("useCertificatesForOnPremisesAuthEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.useCertificatesForOnPremisesAuthEnabled = useCertificatesForOnPremisesAuthEnabled;
        return _x;
    }

    /**
     * <i>“Boolean value used to enable the Windows Hello security key as a logon
     * credential.”</i>
     * 
     * @return property useSecurityKeyForSignin
     */
    @Property(name="useSecurityKeyForSignin")
    @JsonIgnore
    public Optional<Boolean> getUseSecurityKeyForSignin() {
        return Optional.ofNullable(useSecurityKeyForSignin);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * useSecurityKeyForSignin} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Boolean value used to enable the Windows Hello security key as a logon
     * credential.”</i>
     * 
     * @param useSecurityKeyForSignin
     *            new value of {@code useSecurityKeyForSignin} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useSecurityKeyForSignin} field changed
     */
    public WindowsIdentityProtectionConfiguration withUseSecurityKeyForSignin(Boolean useSecurityKeyForSignin) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("useSecurityKeyForSignin");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.useSecurityKeyForSignin = useSecurityKeyForSignin;
        return _x;
    }

    /**
     * <i>“Boolean value that blocks Windows Hello for Business as a method for signing
     * into Windows.”</i>
     * 
     * @return property windowsHelloForBusinessBlocked
     */
    @Property(name="windowsHelloForBusinessBlocked")
    @JsonIgnore
    public Optional<Boolean> getWindowsHelloForBusinessBlocked() {
        return Optional.ofNullable(windowsHelloForBusinessBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsHelloForBusinessBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Boolean value that blocks Windows Hello for Business as a method for signing
     * into Windows.”</i>
     * 
     * @param windowsHelloForBusinessBlocked
     *            new value of {@code windowsHelloForBusinessBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsHelloForBusinessBlocked} field changed
     */
    public WindowsIdentityProtectionConfiguration withWindowsHelloForBusinessBlocked(Boolean windowsHelloForBusinessBlocked) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsHelloForBusinessBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsIdentityProtectionConfiguration");
        _x.windowsHelloForBusinessBlocked = windowsHelloForBusinessBlocked;
        return _x;
    }

    public WindowsIdentityProtectionConfiguration withUnmappedField(String name, Object value) {
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsIdentityProtectionConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsIdentityProtectionConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsIdentityProtectionConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsIdentityProtectionConfiguration _copy() {
        WindowsIdentityProtectionConfiguration _x = new WindowsIdentityProtectionConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.enhancedAntiSpoofingForFacialFeaturesEnabled = enhancedAntiSpoofingForFacialFeaturesEnabled;
        _x.pinExpirationInDays = pinExpirationInDays;
        _x.pinLowercaseCharactersUsage = pinLowercaseCharactersUsage;
        _x.pinMaximumLength = pinMaximumLength;
        _x.pinMinimumLength = pinMinimumLength;
        _x.pinPreviousBlockCount = pinPreviousBlockCount;
        _x.pinRecoveryEnabled = pinRecoveryEnabled;
        _x.pinSpecialCharactersUsage = pinSpecialCharactersUsage;
        _x.pinUppercaseCharactersUsage = pinUppercaseCharactersUsage;
        _x.securityDeviceRequired = securityDeviceRequired;
        _x.unlockWithBiometricsEnabled = unlockWithBiometricsEnabled;
        _x.useCertificatesForOnPremisesAuthEnabled = useCertificatesForOnPremisesAuthEnabled;
        _x.useSecurityKeyForSignin = useSecurityKeyForSignin;
        _x.windowsHelloForBusinessBlocked = windowsHelloForBusinessBlocked;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsIdentityProtectionConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("enhancedAntiSpoofingForFacialFeaturesEnabled=");
        b.append(this.enhancedAntiSpoofingForFacialFeaturesEnabled);
        b.append(", ");
        b.append("pinExpirationInDays=");
        b.append(this.pinExpirationInDays);
        b.append(", ");
        b.append("pinLowercaseCharactersUsage=");
        b.append(this.pinLowercaseCharactersUsage);
        b.append(", ");
        b.append("pinMaximumLength=");
        b.append(this.pinMaximumLength);
        b.append(", ");
        b.append("pinMinimumLength=");
        b.append(this.pinMinimumLength);
        b.append(", ");
        b.append("pinPreviousBlockCount=");
        b.append(this.pinPreviousBlockCount);
        b.append(", ");
        b.append("pinRecoveryEnabled=");
        b.append(this.pinRecoveryEnabled);
        b.append(", ");
        b.append("pinSpecialCharactersUsage=");
        b.append(this.pinSpecialCharactersUsage);
        b.append(", ");
        b.append("pinUppercaseCharactersUsage=");
        b.append(this.pinUppercaseCharactersUsage);
        b.append(", ");
        b.append("securityDeviceRequired=");
        b.append(this.securityDeviceRequired);
        b.append(", ");
        b.append("unlockWithBiometricsEnabled=");
        b.append(this.unlockWithBiometricsEnabled);
        b.append(", ");
        b.append("useCertificatesForOnPremisesAuthEnabled=");
        b.append(this.useCertificatesForOnPremisesAuthEnabled);
        b.append(", ");
        b.append("useSecurityKeyForSignin=");
        b.append(this.useSecurityKeyForSignin);
        b.append(", ");
        b.append("windowsHelloForBusinessBlocked=");
        b.append(this.windowsHelloForBusinessBlocked);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
