package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.WindowsUpdateRolloutSettings;
import odata.msgraph.client.beta.entity.collection.request.WindowsFeatureUpdateProfileAssignmentCollectionRequest;


/**
 * <i>“Windows Feature Update Profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "deployableContentDisplayName", 
    "description", 
    "displayName", 
    "endOfSupportDate", 
    "featureUpdateVersion", 
    "lastModifiedDateTime", 
    "roleScopeTagIds", 
    "rolloutSettings", 
    "assignments"})
@JsonInclude(Include.NON_NULL)
public class WindowsFeatureUpdateProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsFeatureUpdateProfile";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deployableContentDisplayName")
    protected String deployableContentDisplayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("endOfSupportDate")
    protected OffsetDateTime endOfSupportDate;

    @JsonProperty("featureUpdateVersion")
    protected String featureUpdateVersion;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("rolloutSettings")
    protected WindowsUpdateRolloutSettings rolloutSettings;

    @JsonProperty("assignments")
    protected List<WindowsFeatureUpdateProfileAssignment> assignments;

    protected WindowsFeatureUpdateProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsFeatureUpdateProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String deployableContentDisplayName;
        private String description;
        private String displayName;
        private OffsetDateTime endOfSupportDate;
        private String featureUpdateVersion;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private WindowsUpdateRolloutSettings rolloutSettings;
        private List<WindowsFeatureUpdateProfileAssignment> assignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The date time that the profile was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Friendly display name of the quality update profile deployable content”</i>
         * 
         * @param deployableContentDisplayName
         *            value of {@code deployableContentDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deployableContentDisplayName(String deployableContentDisplayName) {
            this.deployableContentDisplayName = deployableContentDisplayName;
            this.changedFields = changedFields.add("deployableContentDisplayName");
            return this;
        }

        /**
         * <i>“The description of the profile which is specified by the user.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The display name of the profile.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The last supported date for a feature update”</i>
         * 
         * @param endOfSupportDate
         *            value of {@code endOfSupportDate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endOfSupportDate(OffsetDateTime endOfSupportDate) {
            this.endOfSupportDate = endOfSupportDate;
            this.changedFields = changedFields.add("endOfSupportDate");
            return this;
        }

        /**
         * <i>“The feature update version that will be deployed to the devices targeted by this
         * profile. The version could be any supported version for example 1709, 1803 or
         * 1809 and so on.”</i>
         * 
         * @param featureUpdateVersion
         *            value of {@code featureUpdateVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureUpdateVersion(String featureUpdateVersion) {
            this.featureUpdateVersion = featureUpdateVersion;
            this.changedFields = changedFields.add("featureUpdateVersion");
            return this;
        }

        /**
         * <i>“The date time that the profile was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Feature Update entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Feature Update entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Feature Update entity.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“The windows update rollout settings, including offer start date time, offer end
         * date time, and days between each set of offers.”</i>
         * 
         * @param rolloutSettings
         *            value of {@code rolloutSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rolloutSettings(WindowsUpdateRolloutSettings rolloutSettings) {
            this.rolloutSettings = rolloutSettings;
            this.changedFields = changedFields.add("rolloutSettings");
            return this;
        }

        /**
         * <i>“The list of group assignments of the profile.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<WindowsFeatureUpdateProfileAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“The list of group assignments of the profile.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(WindowsFeatureUpdateProfileAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public WindowsFeatureUpdateProfile build() {
            WindowsFeatureUpdateProfile _x = new WindowsFeatureUpdateProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsFeatureUpdateProfile";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.deployableContentDisplayName = deployableContentDisplayName;
            _x.description = description;
            _x.displayName = displayName;
            _x.endOfSupportDate = endOfSupportDate;
            _x.featureUpdateVersion = featureUpdateVersion;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.rolloutSettings = rolloutSettings;
            _x.assignments = assignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The date time that the profile was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date time that the profile was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public WindowsFeatureUpdateProfile withCreatedDateTime(OffsetDateTime createdDateTime) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Friendly display name of the quality update profile deployable content”</i>
     * 
     * @return property deployableContentDisplayName
     */
    @Property(name="deployableContentDisplayName")
    @JsonIgnore
    public Optional<String> getDeployableContentDisplayName() {
        return Optional.ofNullable(deployableContentDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deployableContentDisplayName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Friendly display name of the quality update profile deployable content”</i>
     * 
     * @param deployableContentDisplayName
     *            new value of {@code deployableContentDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deployableContentDisplayName} field changed
     */
    public WindowsFeatureUpdateProfile withDeployableContentDisplayName(String deployableContentDisplayName) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("deployableContentDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.deployableContentDisplayName = deployableContentDisplayName;
        return _x;
    }

    /**
     * <i>“The description of the profile which is specified by the user.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of the profile which is specified by the user.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public WindowsFeatureUpdateProfile withDescription(String description) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The display name of the profile.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name of the profile.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsFeatureUpdateProfile withDisplayName(String displayName) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The last supported date for a feature update”</i>
     * 
     * @return property endOfSupportDate
     */
    @Property(name="endOfSupportDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndOfSupportDate() {
        return Optional.ofNullable(endOfSupportDate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endOfSupportDate}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The last supported date for a feature update”</i>
     * 
     * @param endOfSupportDate
     *            new value of {@code endOfSupportDate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endOfSupportDate} field changed
     */
    public WindowsFeatureUpdateProfile withEndOfSupportDate(OffsetDateTime endOfSupportDate) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("endOfSupportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.endOfSupportDate = endOfSupportDate;
        return _x;
    }

    /**
     * <i>“The feature update version that will be deployed to the devices targeted by this
     * profile. The version could be any supported version for example 1709, 1803 or
     * 1809 and so on.”</i>
     * 
     * @return property featureUpdateVersion
     */
    @Property(name="featureUpdateVersion")
    @JsonIgnore
    public Optional<String> getFeatureUpdateVersion() {
        return Optional.ofNullable(featureUpdateVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureUpdateVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The feature update version that will be deployed to the devices targeted by this
     * profile. The version could be any supported version for example 1709, 1803 or
     * 1809 and so on.”</i>
     * 
     * @param featureUpdateVersion
     *            new value of {@code featureUpdateVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureUpdateVersion} field changed
     */
    public WindowsFeatureUpdateProfile withFeatureUpdateVersion(String featureUpdateVersion) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("featureUpdateVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.featureUpdateVersion = featureUpdateVersion;
        return _x;
    }

    /**
     * <i>“The date time that the profile was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date time that the profile was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public WindowsFeatureUpdateProfile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Feature Update entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Feature Update entity.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public WindowsFeatureUpdateProfile withRoleScopeTagIds(List<String> roleScopeTagIds) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Feature Update entity.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The windows update rollout settings, including offer start date time, offer end
     * date time, and days between each set of offers.”</i>
     * 
     * @return property rolloutSettings
     */
    @Property(name="rolloutSettings")
    @JsonIgnore
    public Optional<WindowsUpdateRolloutSettings> getRolloutSettings() {
        return Optional.ofNullable(rolloutSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rolloutSettings}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The windows update rollout settings, including offer start date time, offer end
     * date time, and days between each set of offers.”</i>
     * 
     * @param rolloutSettings
     *            new value of {@code rolloutSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rolloutSettings} field changed
     */
    public WindowsFeatureUpdateProfile withRolloutSettings(WindowsUpdateRolloutSettings rolloutSettings) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("rolloutSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.rolloutSettings = rolloutSettings;
        return _x;
    }

    public WindowsFeatureUpdateProfile withUnmappedField(String name, Object value) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of group assignments of the profile.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public WindowsFeatureUpdateProfileAssignmentCollectionRequest getAssignments() {
        return new WindowsFeatureUpdateProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of group assignments of the profile.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public WindowsFeatureUpdateProfile withAssignments(List<WindowsFeatureUpdateProfileAssignment> assignments) {
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsFeatureUpdateProfile");
        _x.assignments = assignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsFeatureUpdateProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsFeatureUpdateProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsFeatureUpdateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsFeatureUpdateProfile _copy() {
        WindowsFeatureUpdateProfile _x = new WindowsFeatureUpdateProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.deployableContentDisplayName = deployableContentDisplayName;
        _x.description = description;
        _x.displayName = displayName;
        _x.endOfSupportDate = endOfSupportDate;
        _x.featureUpdateVersion = featureUpdateVersion;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.rolloutSettings = rolloutSettings;
        _x.assignments = assignments;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<WindowsFeatureUpdateProfileAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.windowsFeatureUpdateProfileAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsFeatureUpdateProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deployableContentDisplayName=");
        b.append(this.deployableContentDisplayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("endOfSupportDate=");
        b.append(this.endOfSupportDate);
        b.append(", ");
        b.append("featureUpdateVersion=");
        b.append(this.featureUpdateVersion);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("rolloutSettings=");
        b.append(this.rolloutSettings);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
