package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.BulkDriverActionResult;
import odata.msgraph.client.beta.entity.collection.request.WindowsDriverUpdateInventoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsDriverUpdateProfileAssignmentCollectionRequest;
import odata.msgraph.client.beta.enums.DriverApprovalAction;
import odata.msgraph.client.beta.enums.DriverUpdateProfileApprovalType;


/**
 * <i>“Windows Driver Update Profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "approvalType", 
    "createdDateTime", 
    "deploymentDeferralInDays", 
    "description", 
    "deviceReporting", 
    "displayName", 
    "lastModifiedDateTime", 
    "newUpdates", 
    "roleScopeTagIds", 
    "assignments", 
    "driverInventories"})
@JsonInclude(Include.NON_NULL)
public class WindowsDriverUpdateProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDriverUpdateProfile";
    }

    @JsonProperty("approvalType")
    protected DriverUpdateProfileApprovalType approvalType;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deploymentDeferralInDays")
    protected Integer deploymentDeferralInDays;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("deviceReporting")
    protected Integer deviceReporting;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("newUpdates")
    protected Integer newUpdates;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("assignments")
    protected List<WindowsDriverUpdateProfileAssignment> assignments;

    @JsonProperty("driverInventories")
    protected List<WindowsDriverUpdateInventory> driverInventories;

    protected WindowsDriverUpdateProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDriverUpdateProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DriverUpdateProfileApprovalType approvalType;
        private OffsetDateTime createdDateTime;
        private Integer deploymentDeferralInDays;
        private String description;
        private Integer deviceReporting;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private Integer newUpdates;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private List<WindowsDriverUpdateProfileAssignment> assignments;
        private List<WindowsDriverUpdateInventory> driverInventories;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Driver update profile approval type. For example, manual or automatic approval.”</i>
         * 
         * @param approvalType
         *            value of {@code approvalType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder approvalType(DriverUpdateProfileApprovalType approvalType) {
            this.approvalType = approvalType;
            this.changedFields = changedFields.add("approvalType");
            return this;
        }

        /**
         * <i>“The date time that the profile was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Deployment deferral settings in days, only applicable when ApprovalType is set
         * to automatic approval.”</i>
         * 
         * @param deploymentDeferralInDays
         *            value of {@code deploymentDeferralInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentDeferralInDays(Integer deploymentDeferralInDays) {
            this.deploymentDeferralInDays = deploymentDeferralInDays;
            this.changedFields = changedFields.add("deploymentDeferralInDays");
            return this;
        }

        /**
         * <i>“The description of the profile which is specified by the user.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Number of devices reporting for this profile”</i>
         * 
         * @param deviceReporting
         *            value of {@code deviceReporting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceReporting(Integer deviceReporting) {
            this.deviceReporting = deviceReporting;
            this.changedFields = changedFields.add("deviceReporting");
            return this;
        }

        /**
         * <i>“The display name for the profile.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The date time that the profile was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Number of new driver updates available for this profile.”</i>
         * 
         * @param newUpdates
         *            value of {@code newUpdates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder newUpdates(Integer newUpdates) {
            this.newUpdates = newUpdates;
            this.changedFields = changedFields.add("newUpdates");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Driver Update entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Driver Update entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Driver Update entity.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“The list of group assignments of the profile.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<WindowsDriverUpdateProfileAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“The list of group assignments of the profile.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(WindowsDriverUpdateProfileAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“Driver inventories for this profile.”</i>
         * 
         * @param driverInventories
         *            value of {@code driverInventories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder driverInventories(List<WindowsDriverUpdateInventory> driverInventories) {
            this.driverInventories = driverInventories;
            this.changedFields = changedFields.add("driverInventories");
            return this;
        }

        /**
         * <i>“Driver inventories for this profile.”</i>
         * 
         * @param driverInventories
         *            value of {@code driverInventories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder driverInventories(WindowsDriverUpdateInventory... driverInventories) {
            return driverInventories(Arrays.asList(driverInventories));
        }

        public WindowsDriverUpdateProfile build() {
            WindowsDriverUpdateProfile _x = new WindowsDriverUpdateProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsDriverUpdateProfile";
            _x.id = id;
            _x.approvalType = approvalType;
            _x.createdDateTime = createdDateTime;
            _x.deploymentDeferralInDays = deploymentDeferralInDays;
            _x.description = description;
            _x.deviceReporting = deviceReporting;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.newUpdates = newUpdates;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.assignments = assignments;
            _x.driverInventories = driverInventories;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Driver update profile approval type. For example, manual or automatic approval.”</i>
     * 
     * @return property approvalType
     */
    @Property(name="approvalType")
    @JsonIgnore
    public Optional<DriverUpdateProfileApprovalType> getApprovalType() {
        return Optional.ofNullable(approvalType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code approvalType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Driver update profile approval type. For example, manual or automatic approval.”</i>
     * 
     * @param approvalType
     *            new value of {@code approvalType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code approvalType} field changed
     */
    public WindowsDriverUpdateProfile withApprovalType(DriverUpdateProfileApprovalType approvalType) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("approvalType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.approvalType = approvalType;
        return _x;
    }

    /**
     * <i>“The date time that the profile was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date time that the profile was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public WindowsDriverUpdateProfile withCreatedDateTime(OffsetDateTime createdDateTime) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Deployment deferral settings in days, only applicable when ApprovalType is set
     * to automatic approval.”</i>
     * 
     * @return property deploymentDeferralInDays
     */
    @Property(name="deploymentDeferralInDays")
    @JsonIgnore
    public Optional<Integer> getDeploymentDeferralInDays() {
        return Optional.ofNullable(deploymentDeferralInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deploymentDeferralInDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Deployment deferral settings in days, only applicable when ApprovalType is set
     * to automatic approval.”</i>
     * 
     * @param deploymentDeferralInDays
     *            new value of {@code deploymentDeferralInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentDeferralInDays} field changed
     */
    public WindowsDriverUpdateProfile withDeploymentDeferralInDays(Integer deploymentDeferralInDays) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("deploymentDeferralInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.deploymentDeferralInDays = deploymentDeferralInDays;
        return _x;
    }

    /**
     * <i>“The description of the profile which is specified by the user.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of the profile which is specified by the user.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public WindowsDriverUpdateProfile withDescription(String description) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Number of devices reporting for this profile”</i>
     * 
     * @return property deviceReporting
     */
    @Property(name="deviceReporting")
    @JsonIgnore
    public Optional<Integer> getDeviceReporting() {
        return Optional.ofNullable(deviceReporting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceReporting}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of devices reporting for this profile”</i>
     * 
     * @param deviceReporting
     *            new value of {@code deviceReporting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceReporting} field changed
     */
    public WindowsDriverUpdateProfile withDeviceReporting(Integer deviceReporting) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("deviceReporting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.deviceReporting = deviceReporting;
        return _x;
    }

    /**
     * <i>“The display name for the profile.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name for the profile.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsDriverUpdateProfile withDisplayName(String displayName) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The date time that the profile was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date time that the profile was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public WindowsDriverUpdateProfile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Number of new driver updates available for this profile.”</i>
     * 
     * @return property newUpdates
     */
    @Property(name="newUpdates")
    @JsonIgnore
    public Optional<Integer> getNewUpdates() {
        return Optional.ofNullable(newUpdates);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code newUpdates} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of new driver updates available for this profile.”</i>
     * 
     * @param newUpdates
     *            new value of {@code newUpdates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code newUpdates} field changed
     */
    public WindowsDriverUpdateProfile withNewUpdates(Integer newUpdates) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("newUpdates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.newUpdates = newUpdates;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Driver Update entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Driver Update entity.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public WindowsDriverUpdateProfile withRoleScopeTagIds(List<String> roleScopeTagIds) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Driver Update entity.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    public WindowsDriverUpdateProfile withUnmappedField(String name, Object value) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of group assignments of the profile.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public WindowsDriverUpdateProfileAssignmentCollectionRequest getAssignments() {
        return new WindowsDriverUpdateProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“Driver inventories for this profile.”</i>
     * 
     * @return navigational property driverInventories
     */
    @NavigationProperty(name="driverInventories")
    @JsonIgnore
    public WindowsDriverUpdateInventoryCollectionRequest getDriverInventories() {
        return new WindowsDriverUpdateInventoryCollectionRequest(
                        contextPath.addSegment("driverInventories"), Optional.ofNullable(driverInventories));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of group assignments of the profile.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public WindowsDriverUpdateProfile withAssignments(List<WindowsDriverUpdateProfileAssignment> assignments) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code driverInventories
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Driver inventories for this profile.”</i>
     * 
     * @param driverInventories
     *            new value of {@code driverInventories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code driverInventories} field changed
     */
    public WindowsDriverUpdateProfile withDriverInventories(List<WindowsDriverUpdateInventory> driverInventories) {
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = changedFields.add("driverInventories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateProfile");
        _x.driverInventories = driverInventories;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDriverUpdateProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDriverUpdateProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDriverUpdateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDriverUpdateProfile _copy() {
        WindowsDriverUpdateProfile _x = new WindowsDriverUpdateProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.approvalType = approvalType;
        _x.createdDateTime = createdDateTime;
        _x.deploymentDeferralInDays = deploymentDeferralInDays;
        _x.description = description;
        _x.deviceReporting = deviceReporting;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.newUpdates = newUpdates;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.assignments = assignments;
        _x.driverInventories = driverInventories;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<WindowsDriverUpdateProfileAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.windowsDriverUpdateProfileAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "executeAction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BulkDriverActionResult> executeAction(DriverApprovalAction actionName, List<String> driverIds, OffsetDateTime deploymentDate) {
        Preconditions.checkNotNull(actionName, "actionName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("actionName", "microsoft.graph.driverApprovalAction", actionName)
            .put("driverIds", "Collection(Edm.String)", Checks.checkIsAscii(driverIds))
            .put("deploymentDate", "Edm.DateTimeOffset", deploymentDate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BulkDriverActionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.executeAction"), BulkDriverActionResult.class, _parameters);
    }

    @Action(name = "syncInventory")
    @JsonIgnore
    public ActionRequestNoReturn syncInventory() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncInventory"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDriverUpdateProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("approvalType=");
        b.append(this.approvalType);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deploymentDeferralInDays=");
        b.append(this.deploymentDeferralInDays);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceReporting=");
        b.append(this.deviceReporting);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("newUpdates=");
        b.append(this.newUpdates);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("driverInventories=");
        b.append(this.driverInventories);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
