package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DriverApprovalStatus;
import odata.msgraph.client.beta.enums.DriverCategory;


/**
 * <i>“A new entity to represent driver inventories.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicableDeviceCount", 
    "approvalStatus", 
    "category", 
    "deployDateTime", 
    "driverClass", 
    "manufacturer", 
    "name", 
    "releaseDateTime", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class WindowsDriverUpdateInventory extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDriverUpdateInventory";
    }

    @JsonProperty("applicableDeviceCount")
    protected Integer applicableDeviceCount;

    @JsonProperty("approvalStatus")
    protected DriverApprovalStatus approvalStatus;

    @JsonProperty("category")
    protected DriverCategory category;

    @JsonProperty("deployDateTime")
    protected OffsetDateTime deployDateTime;

    @JsonProperty("driverClass")
    protected String driverClass;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("releaseDateTime")
    protected OffsetDateTime releaseDateTime;

    @JsonProperty("version")
    protected String version;

    protected WindowsDriverUpdateInventory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDriverUpdateInventory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer applicableDeviceCount;
        private DriverApprovalStatus approvalStatus;
        private DriverCategory category;
        private OffsetDateTime deployDateTime;
        private String driverClass;
        private String manufacturer;
        private String name;
        private OffsetDateTime releaseDateTime;
        private String version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The number of devices for which this driver is applicable.”</i>
         * 
         * @param applicableDeviceCount
         *            value of {@code applicableDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicableDeviceCount(Integer applicableDeviceCount) {
            this.applicableDeviceCount = applicableDeviceCount;
            this.changedFields = changedFields.add("applicableDeviceCount");
            return this;
        }

        /**
         * <i>“The approval status for this driver.”</i>
         * 
         * @param approvalStatus
         *            value of {@code approvalStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder approvalStatus(DriverApprovalStatus approvalStatus) {
            this.approvalStatus = approvalStatus;
            this.changedFields = changedFields.add("approvalStatus");
            return this;
        }

        /**
         * <i>“The category for this driver.”</i>
         * 
         * @param category
         *            value of {@code category} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder category(DriverCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        /**
         * <i>“The date time when a driver should be deployed if approvalStatus is approved.”</i>
         * 
         * @param deployDateTime
         *            value of {@code deployDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deployDateTime(OffsetDateTime deployDateTime) {
            this.deployDateTime = deployDateTime;
            this.changedFields = changedFields.add("deployDateTime");
            return this;
        }

        /**
         * <i>“The class of the driver.”</i>
         * 
         * @param driverClass
         *            value of {@code driverClass} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder driverClass(String driverClass) {
            this.driverClass = driverClass;
            this.changedFields = changedFields.add("driverClass");
            return this;
        }

        /**
         * <i>“The manufacturer of the driver.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“The name of the driver.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“The release date time of the driver.”</i>
         * 
         * @param releaseDateTime
         *            value of {@code releaseDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder releaseDateTime(OffsetDateTime releaseDateTime) {
            this.releaseDateTime = releaseDateTime;
            this.changedFields = changedFields.add("releaseDateTime");
            return this;
        }

        /**
         * <i>“The version of the driver.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public WindowsDriverUpdateInventory build() {
            WindowsDriverUpdateInventory _x = new WindowsDriverUpdateInventory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsDriverUpdateInventory";
            _x.id = id;
            _x.applicableDeviceCount = applicableDeviceCount;
            _x.approvalStatus = approvalStatus;
            _x.category = category;
            _x.deployDateTime = deployDateTime;
            _x.driverClass = driverClass;
            _x.manufacturer = manufacturer;
            _x.name = name;
            _x.releaseDateTime = releaseDateTime;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The number of devices for which this driver is applicable.”</i>
     * 
     * @return property applicableDeviceCount
     */
    @Property(name="applicableDeviceCount")
    @JsonIgnore
    public Optional<Integer> getApplicableDeviceCount() {
        return Optional.ofNullable(applicableDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicableDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of devices for which this driver is applicable.”</i>
     * 
     * @param applicableDeviceCount
     *            new value of {@code applicableDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicableDeviceCount} field changed
     */
    public WindowsDriverUpdateInventory withApplicableDeviceCount(Integer applicableDeviceCount) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = changedFields.add("applicableDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateInventory");
        _x.applicableDeviceCount = applicableDeviceCount;
        return _x;
    }

    /**
     * <i>“The approval status for this driver.”</i>
     * 
     * @return property approvalStatus
     */
    @Property(name="approvalStatus")
    @JsonIgnore
    public Optional<DriverApprovalStatus> getApprovalStatus() {
        return Optional.ofNullable(approvalStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code approvalStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The approval status for this driver.”</i>
     * 
     * @param approvalStatus
     *            new value of {@code approvalStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code approvalStatus} field changed
     */
    public WindowsDriverUpdateInventory withApprovalStatus(DriverApprovalStatus approvalStatus) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = changedFields.add("approvalStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateInventory");
        _x.approvalStatus = approvalStatus;
        return _x;
    }

    /**
     * <i>“The category for this driver.”</i>
     * 
     * @return property category
     */
    @Property(name="category")
    @JsonIgnore
    public Optional<DriverCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code category} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The category for this driver.”</i>
     * 
     * @param category
     *            new value of {@code category} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code category} field changed
     */
    public WindowsDriverUpdateInventory withCategory(DriverCategory category) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateInventory");
        _x.category = category;
        return _x;
    }

    /**
     * <i>“The date time when a driver should be deployed if approvalStatus is approved.”</i>
     * 
     * @return property deployDateTime
     */
    @Property(name="deployDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeployDateTime() {
        return Optional.ofNullable(deployDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deployDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date time when a driver should be deployed if approvalStatus is approved.”</i>
     * 
     * @param deployDateTime
     *            new value of {@code deployDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deployDateTime} field changed
     */
    public WindowsDriverUpdateInventory withDeployDateTime(OffsetDateTime deployDateTime) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = changedFields.add("deployDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateInventory");
        _x.deployDateTime = deployDateTime;
        return _x;
    }

    /**
     * <i>“The class of the driver.”</i>
     * 
     * @return property driverClass
     */
    @Property(name="driverClass")
    @JsonIgnore
    public Optional<String> getDriverClass() {
        return Optional.ofNullable(driverClass);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code driverClass}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The class of the driver.”</i>
     * 
     * @param driverClass
     *            new value of {@code driverClass} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code driverClass} field changed
     */
    public WindowsDriverUpdateInventory withDriverClass(String driverClass) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = changedFields.add("driverClass");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateInventory");
        _x.driverClass = driverClass;
        return _x;
    }

    /**
     * <i>“The manufacturer of the driver.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The manufacturer of the driver.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public WindowsDriverUpdateInventory withManufacturer(String manufacturer) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateInventory");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“The name of the driver.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the driver.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public WindowsDriverUpdateInventory withName(String name) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateInventory");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“The release date time of the driver.”</i>
     * 
     * @return property releaseDateTime
     */
    @Property(name="releaseDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReleaseDateTime() {
        return Optional.ofNullable(releaseDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code releaseDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The release date time of the driver.”</i>
     * 
     * @param releaseDateTime
     *            new value of {@code releaseDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code releaseDateTime} field changed
     */
    public WindowsDriverUpdateInventory withReleaseDateTime(OffsetDateTime releaseDateTime) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = changedFields.add("releaseDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateInventory");
        _x.releaseDateTime = releaseDateTime;
        return _x;
    }

    /**
     * <i>“The version of the driver.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The version of the driver.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public WindowsDriverUpdateInventory withVersion(String version) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDriverUpdateInventory");
        _x.version = version;
        return _x;
    }

    public WindowsDriverUpdateInventory withUnmappedField(String name, Object value) {
        WindowsDriverUpdateInventory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDriverUpdateInventory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDriverUpdateInventory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDriverUpdateInventory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDriverUpdateInventory _copy() {
        WindowsDriverUpdateInventory _x = new WindowsDriverUpdateInventory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.applicableDeviceCount = applicableDeviceCount;
        _x.approvalStatus = approvalStatus;
        _x.category = category;
        _x.deployDateTime = deployDateTime;
        _x.driverClass = driverClass;
        _x.manufacturer = manufacturer;
        _x.name = name;
        _x.releaseDateTime = releaseDateTime;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDriverUpdateInventory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicableDeviceCount=");
        b.append(this.applicableDeviceCount);
        b.append(", ");
        b.append("approvalStatus=");
        b.append(this.approvalStatus);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("deployDateTime=");
        b.append(this.deployDateTime);
        b.append(", ");
        b.append("driverClass=");
        b.append(this.driverClass);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("releaseDateTime=");
        b.append(this.releaseDateTime);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
