package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OutOfBoxExperienceSettings;
import odata.msgraph.client.beta.complex.WindowsEnrollmentStatusScreenSettings;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeploymentProfileAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.enums.WindowsAutopilotDeviceType;


/**
 * <i>“Windows Autopilot Deployment Profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "deviceNameTemplate", 
    "deviceType", 
    "displayName", 
    "enableWhiteGlove", 
    "enrollmentStatusScreenSettings", 
    "extractHardwareHash", 
    "language", 
    "lastModifiedDateTime", 
    "managementServiceAppId", 
    "outOfBoxExperienceSettings", 
    "roleScopeTagIds", 
    "assignedDevices", 
    "assignments"})
@JsonInclude(Include.NON_NULL)
public class WindowsAutopilotDeploymentProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsAutopilotDeploymentProfile";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("deviceNameTemplate")
    protected String deviceNameTemplate;

    @JsonProperty("deviceType")
    protected WindowsAutopilotDeviceType deviceType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("enableWhiteGlove")
    protected Boolean enableWhiteGlove;

    @JsonProperty("enrollmentStatusScreenSettings")
    protected WindowsEnrollmentStatusScreenSettings enrollmentStatusScreenSettings;

    @JsonProperty("extractHardwareHash")
    protected Boolean extractHardwareHash;

    @JsonProperty("language")
    protected String language;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("managementServiceAppId")
    protected String managementServiceAppId;

    @JsonProperty("outOfBoxExperienceSettings")
    protected OutOfBoxExperienceSettings outOfBoxExperienceSettings;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("assignedDevices")
    protected List<WindowsAutopilotDeviceIdentity> assignedDevices;

    @JsonProperty("assignments")
    protected List<WindowsAutopilotDeploymentProfileAssignment> assignments;

    protected WindowsAutopilotDeploymentProfile() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Profile creation time”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Profile creation time”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public WindowsAutopilotDeploymentProfile withCreatedDateTime(OffsetDateTime createdDateTime) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Description of the profile”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the profile”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public WindowsAutopilotDeploymentProfile withDescription(String description) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The template used to name the AutoPilot Device. This can be a custom text and
     * can also contain either the serial number of the device, or a randomly generated
     * number. The total length of the text generated by the template can be no more
     * than 15 characters.”</i>
     * 
     * @return property deviceNameTemplate
     */
    @Property(name="deviceNameTemplate")
    @JsonIgnore
    public Optional<String> getDeviceNameTemplate() {
        return Optional.ofNullable(deviceNameTemplate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceNameTemplate} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The template used to name the AutoPilot Device. This can be a custom text and
     * can also contain either the serial number of the device, or a randomly generated
     * number. The total length of the text generated by the template can be no more
     * than 15 characters.”</i>
     * 
     * @param deviceNameTemplate
     *            new value of {@code deviceNameTemplate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceNameTemplate} field changed
     */
    public WindowsAutopilotDeploymentProfile withDeviceNameTemplate(String deviceNameTemplate) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("deviceNameTemplate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.deviceNameTemplate = deviceNameTemplate;
        return _x;
    }

    /**
     * <i>“The AutoPilot device type that this profile is applicable to.”</i>
     * 
     * @return property deviceType
     */
    @Property(name="deviceType")
    @JsonIgnore
    public Optional<WindowsAutopilotDeviceType> getDeviceType() {
        return Optional.ofNullable(deviceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The AutoPilot device type that this profile is applicable to.”</i>
     * 
     * @param deviceType
     *            new value of {@code deviceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceType} field changed
     */
    public WindowsAutopilotDeploymentProfile withDeviceType(WindowsAutopilotDeviceType deviceType) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("deviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.deviceType = deviceType;
        return _x;
    }

    /**
     * <i>“Name of the profile”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the profile”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsAutopilotDeploymentProfile withDisplayName(String displayName) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Enable Autopilot White Glove for the profile.”</i>
     * 
     * @return property enableWhiteGlove
     */
    @Property(name="enableWhiteGlove")
    @JsonIgnore
    public Optional<Boolean> getEnableWhiteGlove() {
        return Optional.ofNullable(enableWhiteGlove);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enableWhiteGlove}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Enable Autopilot White Glove for the profile.”</i>
     * 
     * @param enableWhiteGlove
     *            new value of {@code enableWhiteGlove} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableWhiteGlove} field changed
     */
    public WindowsAutopilotDeploymentProfile withEnableWhiteGlove(Boolean enableWhiteGlove) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("enableWhiteGlove");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.enableWhiteGlove = enableWhiteGlove;
        return _x;
    }

    /**
     * <i>“Enrollment status screen setting”</i>
     * 
     * @return property enrollmentStatusScreenSettings
     */
    @Property(name="enrollmentStatusScreenSettings")
    @JsonIgnore
    public Optional<WindowsEnrollmentStatusScreenSettings> getEnrollmentStatusScreenSettings() {
        return Optional.ofNullable(enrollmentStatusScreenSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enrollmentStatusScreenSettings} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enrollment status screen setting”</i>
     * 
     * @param enrollmentStatusScreenSettings
     *            new value of {@code enrollmentStatusScreenSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentStatusScreenSettings} field changed
     */
    public WindowsAutopilotDeploymentProfile withEnrollmentStatusScreenSettings(WindowsEnrollmentStatusScreenSettings enrollmentStatusScreenSettings) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("enrollmentStatusScreenSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.enrollmentStatusScreenSettings = enrollmentStatusScreenSettings;
        return _x;
    }

    /**
     * <i>“HardwareHash Extraction for the profile”</i>
     * 
     * @return property extractHardwareHash
     */
    @Property(name="extractHardwareHash")
    @JsonIgnore
    public Optional<Boolean> getExtractHardwareHash() {
        return Optional.ofNullable(extractHardwareHash);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * extractHardwareHash} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“HardwareHash Extraction for the profile”</i>
     * 
     * @param extractHardwareHash
     *            new value of {@code extractHardwareHash} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code extractHardwareHash} field changed
     */
    public WindowsAutopilotDeploymentProfile withExtractHardwareHash(Boolean extractHardwareHash) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("extractHardwareHash");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.extractHardwareHash = extractHardwareHash;
        return _x;
    }

    /**
     * <i>“Language configured on the device”</i>
     * 
     * @return property language
     */
    @Property(name="language")
    @JsonIgnore
    public Optional<String> getLanguage() {
        return Optional.ofNullable(language);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code language} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Language configured on the device”</i>
     * 
     * @param language
     *            new value of {@code language} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code language} field changed
     */
    public WindowsAutopilotDeploymentProfile withLanguage(String language) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("language");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.language = language;
        return _x;
    }

    /**
     * <i>“Profile last modified time”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Profile last modified time”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public WindowsAutopilotDeploymentProfile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“AzureAD management app ID used during client device-based enrollment discovery”</i>
     * 
     * @return property managementServiceAppId
     */
    @Property(name="managementServiceAppId")
    @JsonIgnore
    public Optional<String> getManagementServiceAppId() {
        return Optional.ofNullable(managementServiceAppId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managementServiceAppId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“AzureAD management app ID used during client device-based enrollment discovery”</i>
     * 
     * @param managementServiceAppId
     *            new value of {@code managementServiceAppId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementServiceAppId} field changed
     */
    public WindowsAutopilotDeploymentProfile withManagementServiceAppId(String managementServiceAppId) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("managementServiceAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.managementServiceAppId = managementServiceAppId;
        return _x;
    }

    /**
     * <i>“Out of box experience setting”</i>
     * 
     * @return property outOfBoxExperienceSettings
     */
    @Property(name="outOfBoxExperienceSettings")
    @JsonIgnore
    public Optional<OutOfBoxExperienceSettings> getOutOfBoxExperienceSettings() {
        return Optional.ofNullable(outOfBoxExperienceSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * outOfBoxExperienceSettings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Out of box experience setting”</i>
     * 
     * @param outOfBoxExperienceSettings
     *            new value of {@code outOfBoxExperienceSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outOfBoxExperienceSettings} field changed
     */
    public WindowsAutopilotDeploymentProfile withOutOfBoxExperienceSettings(OutOfBoxExperienceSettings outOfBoxExperienceSettings) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("outOfBoxExperienceSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.outOfBoxExperienceSettings = outOfBoxExperienceSettings;
        return _x;
    }

    /**
     * <i>“Scope tags for the profile.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Scope tags for the profile.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public WindowsAutopilotDeploymentProfile withRoleScopeTagIds(List<String> roleScopeTagIds) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“Scope tags for the profile.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    public WindowsAutopilotDeploymentProfile withUnmappedField(String name, Object value) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of assigned devices for the profile.”</i>
     * 
     * @return navigational property assignedDevices
     */
    @NavigationProperty(name="assignedDevices")
    @JsonIgnore
    public WindowsAutopilotDeviceIdentityCollectionRequest getAssignedDevices() {
        return new WindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("assignedDevices"), Optional.ofNullable(assignedDevices));
    }

    /**
     * <i>“The list of group assignments for the profile.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public WindowsAutopilotDeploymentProfileAssignmentCollectionRequest getAssignments() {
        return new WindowsAutopilotDeploymentProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignedDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of assigned devices for the profile.”</i>
     * 
     * @param assignedDevices
     *            new value of {@code assignedDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignedDevices} field changed
     */
    public WindowsAutopilotDeploymentProfile withAssignedDevices(List<WindowsAutopilotDeviceIdentity> assignedDevices) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("assignedDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.assignedDevices = assignedDevices;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of group assignments for the profile.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public WindowsAutopilotDeploymentProfile withAssignments(List<WindowsAutopilotDeploymentProfileAssignment> assignments) {
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeploymentProfile");
        _x.assignments = assignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsAutopilotDeploymentProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsAutopilotDeploymentProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsAutopilotDeploymentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsAutopilotDeploymentProfile _copy() {
        WindowsAutopilotDeploymentProfile _x = new WindowsAutopilotDeploymentProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceNameTemplate = deviceNameTemplate;
        _x.deviceType = deviceType;
        _x.displayName = displayName;
        _x.enableWhiteGlove = enableWhiteGlove;
        _x.enrollmentStatusScreenSettings = enrollmentStatusScreenSettings;
        _x.extractHardwareHash = extractHardwareHash;
        _x.language = language;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.managementServiceAppId = managementServiceAppId;
        _x.outOfBoxExperienceSettings = outOfBoxExperienceSettings;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.assignedDevices = assignedDevices;
        _x.assignments = assignments;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<String> deviceIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceIds", "Collection(Edm.String)", Checks.checkIsAscii(deviceIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsAutopilotDeploymentProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceNameTemplate=");
        b.append(this.deviceNameTemplate);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enableWhiteGlove=");
        b.append(this.enableWhiteGlove);
        b.append(", ");
        b.append("enrollmentStatusScreenSettings=");
        b.append(this.enrollmentStatusScreenSettings);
        b.append(", ");
        b.append("extractHardwareHash=");
        b.append(this.extractHardwareHash);
        b.append(", ");
        b.append("language=");
        b.append(this.language);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("managementServiceAppId=");
        b.append(this.managementServiceAppId);
        b.append(", ");
        b.append("outOfBoxExperienceSettings=");
        b.append(this.outOfBoxExperienceSettings);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("assignedDevices=");
        b.append(this.assignedDevices);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
