package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;


/**
 * <i>“Windows X VPN configuration profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "authenticationCertificateId", 
    "customXml", 
    "customXmlFileName"})
@JsonInclude(Include.NON_NULL)
public class Windows10XVpnConfiguration extends DeviceManagementResourceAccessProfileBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10XVpnConfiguration";
    }

    @JsonProperty("authenticationCertificateId")
    protected UUID authenticationCertificateId;

    @JsonProperty("customXml")
    protected byte[] customXml;

    @JsonProperty("customXmlFileName")
    protected String customXmlFileName;

    protected Windows10XVpnConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10XVpnConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime creationDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer version;
        private List<DeviceManagementResourceAccessProfileAssignment> assignments;
        private UUID authenticationCertificateId;
        private byte[] customXml;
        private String customXmlFileName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceManagementResourceAccessProfileAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceManagementResourceAccessProfileAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“ID to the Authentication Certificate”</i>
         * 
         * @param authenticationCertificateId
         *            value of {@code authenticationCertificateId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationCertificateId(UUID authenticationCertificateId) {
            this.authenticationCertificateId = authenticationCertificateId;
            this.changedFields = changedFields.add("authenticationCertificateId");
            return this;
        }

        /**
         * <i>“Custom XML commands that configures the VPN connection. (UTF8 byte encoding)”</i>
         * 
         * @param customXml
         *            value of {@code customXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customXml(byte[] customXml) {
            this.customXml = customXml;
            this.changedFields = changedFields.add("customXml");
            return this;
        }

        /**
         * <i>“Custom Xml file name.”</i>
         * 
         * @param customXmlFileName
         *            value of {@code customXmlFileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customXmlFileName(String customXmlFileName) {
            this.customXmlFileName = customXmlFileName;
            this.changedFields = changedFields.add("customXmlFileName");
            return this;
        }

        public Windows10XVpnConfiguration build() {
            Windows10XVpnConfiguration _x = new Windows10XVpnConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windows10XVpnConfiguration";
            _x.id = id;
            _x.creationDateTime = creationDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.authenticationCertificateId = authenticationCertificateId;
            _x.customXml = customXml;
            _x.customXmlFileName = customXmlFileName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“ID to the Authentication Certificate”</i>
     * 
     * @return property authenticationCertificateId
     */
    @Property(name="authenticationCertificateId")
    @JsonIgnore
    public Optional<UUID> getAuthenticationCertificateId() {
        return Optional.ofNullable(authenticationCertificateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationCertificateId} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“ID to the Authentication Certificate”</i>
     * 
     * @param authenticationCertificateId
     *            new value of {@code authenticationCertificateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationCertificateId} field changed
     */
    public Windows10XVpnConfiguration withAuthenticationCertificateId(UUID authenticationCertificateId) {
        Windows10XVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationCertificateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XVpnConfiguration");
        _x.authenticationCertificateId = authenticationCertificateId;
        return _x;
    }

    /**
     * <i>“Custom XML commands that configures the VPN connection. (UTF8 byte encoding)”</i>
     * 
     * @return property customXml
     */
    @Property(name="customXml")
    @JsonIgnore
    public Optional<byte[]> getCustomXml() {
        return Optional.ofNullable(customXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customXml} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Custom XML commands that configures the VPN connection. (UTF8 byte encoding)”</i>
     * 
     * @param customXml
     *            new value of {@code customXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customXml} field changed
     */
    public Windows10XVpnConfiguration withCustomXml(byte[] customXml) {
        Windows10XVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("customXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XVpnConfiguration");
        _x.customXml = customXml;
        return _x;
    }

    /**
     * <i>“Custom Xml file name.”</i>
     * 
     * @return property customXmlFileName
     */
    @Property(name="customXmlFileName")
    @JsonIgnore
    public Optional<String> getCustomXmlFileName() {
        return Optional.ofNullable(customXmlFileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customXmlFileName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Custom Xml file name.”</i>
     * 
     * @param customXmlFileName
     *            new value of {@code customXmlFileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customXmlFileName} field changed
     */
    public Windows10XVpnConfiguration withCustomXmlFileName(String customXmlFileName) {
        Windows10XVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("customXmlFileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XVpnConfiguration");
        _x.customXmlFileName = customXmlFileName;
        return _x;
    }

    public Windows10XVpnConfiguration withUnmappedField(String name, Object value) {
        Windows10XVpnConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10XVpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10XVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10XVpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10XVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10XVpnConfiguration _copy() {
        Windows10XVpnConfiguration _x = new Windows10XVpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.creationDateTime = creationDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.assignments = assignments;
        _x.authenticationCertificateId = authenticationCertificateId;
        _x.customXml = customXml;
        _x.customXmlFileName = customXmlFileName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10XVpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("authenticationCertificateId=");
        b.append(this.authenticationCertificateId);
        b.append(", ");
        b.append("customXml=");
        b.append(this.customXml);
        b.append(", ");
        b.append("customXmlFileName=");
        b.append(this.customXmlFileName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
