package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.complex.Win32LobAppDetection;
import odata.msgraph.client.beta.complex.Win32LobAppInstallExperience;
import odata.msgraph.client.beta.complex.Win32LobAppMsiInformation;
import odata.msgraph.client.beta.complex.Win32LobAppRequirement;
import odata.msgraph.client.beta.complex.Win32LobAppReturnCode;
import odata.msgraph.client.beta.complex.Win32LobAppRule;
import odata.msgraph.client.beta.complex.WindowsMinimumOperatingSystem;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;
import odata.msgraph.client.beta.enums.WindowsArchitecture;


/**
 * <i>“Contains properties and inherited properties for Win32 apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicableArchitectures", 
    "detectionRules", 
    "displayVersion", 
    "installCommandLine", 
    "installExperience", 
    "minimumCpuSpeedInMHz", 
    "minimumFreeDiskSpaceInMB", 
    "minimumMemoryInMB", 
    "minimumNumberOfProcessors", 
    "minimumSupportedOperatingSystem", 
    "minimumSupportedWindowsRelease", 
    "msiInformation", 
    "requirementRules", 
    "returnCodes", 
    "rules", 
    "setupFilePath", 
    "uninstallCommandLine"})
@JsonInclude(Include.NON_NULL)
public class Win32LobApp extends MobileLobApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobApp";
    }

    @JsonProperty("applicableArchitectures")
    protected WindowsArchitecture applicableArchitectures;

    @JsonProperty("detectionRules")
    protected List<Win32LobAppDetection> detectionRules;

    @JsonProperty("detectionRules@nextLink")
    protected String detectionRulesNextLink;

    @JsonProperty("displayVersion")
    protected String displayVersion;

    @JsonProperty("installCommandLine")
    protected String installCommandLine;

    @JsonProperty("installExperience")
    protected Win32LobAppInstallExperience installExperience;

    @JsonProperty("minimumCpuSpeedInMHz")
    protected Integer minimumCpuSpeedInMHz;

    @JsonProperty("minimumFreeDiskSpaceInMB")
    protected Integer minimumFreeDiskSpaceInMB;

    @JsonProperty("minimumMemoryInMB")
    protected Integer minimumMemoryInMB;

    @JsonProperty("minimumNumberOfProcessors")
    protected Integer minimumNumberOfProcessors;

    @JsonProperty("minimumSupportedOperatingSystem")
    protected WindowsMinimumOperatingSystem minimumSupportedOperatingSystem;

    @JsonProperty("minimumSupportedWindowsRelease")
    protected String minimumSupportedWindowsRelease;

    @JsonProperty("msiInformation")
    protected Win32LobAppMsiInformation msiInformation;

    @JsonProperty("requirementRules")
    protected List<Win32LobAppRequirement> requirementRules;

    @JsonProperty("requirementRules@nextLink")
    protected String requirementRulesNextLink;

    @JsonProperty("returnCodes")
    protected List<Win32LobAppReturnCode> returnCodes;

    @JsonProperty("returnCodes@nextLink")
    protected String returnCodesNextLink;

    @JsonProperty("rules")
    protected List<Win32LobAppRule> rules;

    @JsonProperty("rules@nextLink")
    protected String rulesNextLink;

    @JsonProperty("setupFilePath")
    protected String setupFilePath;

    @JsonProperty("uninstallCommandLine")
    protected String uninstallCommandLine;

    protected Win32LobApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWin32LobApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private String committedContentVersion;
        private String fileName;
        private Long size;
        private List<MobileAppContent> contentVersions;
        private WindowsArchitecture applicableArchitectures;
        private List<Win32LobAppDetection> detectionRules;
        private String detectionRulesNextLink;
        private String displayVersion;
        private String installCommandLine;
        private Win32LobAppInstallExperience installExperience;
        private Integer minimumCpuSpeedInMHz;
        private Integer minimumFreeDiskSpaceInMB;
        private Integer minimumMemoryInMB;
        private Integer minimumNumberOfProcessors;
        private WindowsMinimumOperatingSystem minimumSupportedOperatingSystem;
        private String minimumSupportedWindowsRelease;
        private Win32LobAppMsiInformation msiInformation;
        private List<Win32LobAppRequirement> requirementRules;
        private String requirementRulesNextLink;
        private List<Win32LobAppReturnCode> returnCodes;
        private String returnCodesNextLink;
        private List<Win32LobAppRule> rules;
        private String rulesNextLink;
        private String setupFilePath;
        private String uninstallCommandLine;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder committedContentVersion(String committedContentVersion) {
            this.committedContentVersion = committedContentVersion;
            this.changedFields = changedFields.add("committedContentVersion");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder contentVersions(List<MobileAppContent> contentVersions) {
            this.contentVersions = contentVersions;
            this.changedFields = changedFields.add("contentVersions");
            return this;
        }

        public Builder contentVersions(MobileAppContent... contentVersions) {
            return contentVersions(Arrays.asList(contentVersions));
        }

        /**
         * <i>“The Windows architecture(s) for which this app can run on.”</i>
         * 
         * @param applicableArchitectures
         *            value of {@code applicableArchitectures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicableArchitectures(WindowsArchitecture applicableArchitectures) {
            this.applicableArchitectures = applicableArchitectures;
            this.changedFields = changedFields.add("applicableArchitectures");
            return this;
        }

        /**
         * <i>“The detection rules to detect Win32 Line of Business (LoB) app.”</i>
         * 
         * @param detectionRules
         *            value of {@code detectionRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionRules(List<Win32LobAppDetection> detectionRules) {
            this.detectionRules = detectionRules;
            this.changedFields = changedFields.add("detectionRules");
            return this;
        }

        /**
         * <i>“The detection rules to detect Win32 Line of Business (LoB) app.”</i>
         * 
         * @param detectionRules
         *            value of {@code detectionRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionRules(Win32LobAppDetection... detectionRules) {
            return detectionRules(Arrays.asList(detectionRules));
        }

        /**
         * <i>“The detection rules to detect Win32 Line of Business (LoB) app.”</i>
         * 
         * @param detectionRulesNextLink
         *            value of {@code detectionRules@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionRulesNextLink(String detectionRulesNextLink) {
            this.detectionRulesNextLink = detectionRulesNextLink;
            this.changedFields = changedFields.add("detectionRules");
            return this;
        }

        /**
         * <i>“The version displayed in the UX for this app.”</i>
         * 
         * @param displayVersion
         *            value of {@code displayVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayVersion(String displayVersion) {
            this.displayVersion = displayVersion;
            this.changedFields = changedFields.add("displayVersion");
            return this;
        }

        /**
         * <i>“The command line to install this app”</i>
         * 
         * @param installCommandLine
         *            value of {@code installCommandLine} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installCommandLine(String installCommandLine) {
            this.installCommandLine = installCommandLine;
            this.changedFields = changedFields.add("installCommandLine");
            return this;
        }

        /**
         * <i>“The install experience for this app.”</i>
         * 
         * @param installExperience
         *            value of {@code installExperience} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installExperience(Win32LobAppInstallExperience installExperience) {
            this.installExperience = installExperience;
            this.changedFields = changedFields.add("installExperience");
            return this;
        }

        /**
         * <i>“The value for the minimum CPU speed which is required to install this app.”</i>
         * 
         * @param minimumCpuSpeedInMHz
         *            value of {@code minimumCpuSpeedInMHz} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumCpuSpeedInMHz(Integer minimumCpuSpeedInMHz) {
            this.minimumCpuSpeedInMHz = minimumCpuSpeedInMHz;
            this.changedFields = changedFields.add("minimumCpuSpeedInMHz");
            return this;
        }

        /**
         * <i>“The value for the minimum free disk space which is required to install this app.”</i>
         * 
         * @param minimumFreeDiskSpaceInMB
         *            value of {@code minimumFreeDiskSpaceInMB} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumFreeDiskSpaceInMB(Integer minimumFreeDiskSpaceInMB) {
            this.minimumFreeDiskSpaceInMB = minimumFreeDiskSpaceInMB;
            this.changedFields = changedFields.add("minimumFreeDiskSpaceInMB");
            return this;
        }

        /**
         * <i>“The value for the minimum physical memory which is required to install this app.”</i>
         * 
         * @param minimumMemoryInMB
         *            value of {@code minimumMemoryInMB} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumMemoryInMB(Integer minimumMemoryInMB) {
            this.minimumMemoryInMB = minimumMemoryInMB;
            this.changedFields = changedFields.add("minimumMemoryInMB");
            return this;
        }

        /**
         * <i>“The value for the minimum number of processors which is required to install this
         * app.”</i>
         * 
         * @param minimumNumberOfProcessors
         *            value of {@code minimumNumberOfProcessors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumNumberOfProcessors(Integer minimumNumberOfProcessors) {
            this.minimumNumberOfProcessors = minimumNumberOfProcessors;
            this.changedFields = changedFields.add("minimumNumberOfProcessors");
            return this;
        }

        /**
         * <i>“The value for the minimum applicable operating system.”</i>
         * 
         * @param minimumSupportedOperatingSystem
         *            value of {@code minimumSupportedOperatingSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumSupportedOperatingSystem(WindowsMinimumOperatingSystem minimumSupportedOperatingSystem) {
            this.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            this.changedFields = changedFields.add("minimumSupportedOperatingSystem");
            return this;
        }

        /**
         * <i>“The value for the minimum supported windows release.”</i>
         * 
         * @param minimumSupportedWindowsRelease
         *            value of {@code minimumSupportedWindowsRelease} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumSupportedWindowsRelease(String minimumSupportedWindowsRelease) {
            this.minimumSupportedWindowsRelease = minimumSupportedWindowsRelease;
            this.changedFields = changedFields.add("minimumSupportedWindowsRelease");
            return this;
        }

        /**
         * <i>“The MSI details if this Win32 app is an MSI app.”</i>
         * 
         * @param msiInformation
         *            value of {@code msiInformation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder msiInformation(Win32LobAppMsiInformation msiInformation) {
            this.msiInformation = msiInformation;
            this.changedFields = changedFields.add("msiInformation");
            return this;
        }

        /**
         * <i>“The requirement rules to detect Win32 Line of Business (LoB) app.”</i>
         * 
         * @param requirementRules
         *            value of {@code requirementRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requirementRules(List<Win32LobAppRequirement> requirementRules) {
            this.requirementRules = requirementRules;
            this.changedFields = changedFields.add("requirementRules");
            return this;
        }

        /**
         * <i>“The requirement rules to detect Win32 Line of Business (LoB) app.”</i>
         * 
         * @param requirementRules
         *            value of {@code requirementRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requirementRules(Win32LobAppRequirement... requirementRules) {
            return requirementRules(Arrays.asList(requirementRules));
        }

        /**
         * <i>“The requirement rules to detect Win32 Line of Business (LoB) app.”</i>
         * 
         * @param requirementRulesNextLink
         *            value of {@code requirementRules@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requirementRulesNextLink(String requirementRulesNextLink) {
            this.requirementRulesNextLink = requirementRulesNextLink;
            this.changedFields = changedFields.add("requirementRules");
            return this;
        }

        /**
         * <i>“The return codes for post installation behavior.”</i>
         * 
         * @param returnCodes
         *            value of {@code returnCodes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder returnCodes(List<Win32LobAppReturnCode> returnCodes) {
            this.returnCodes = returnCodes;
            this.changedFields = changedFields.add("returnCodes");
            return this;
        }

        /**
         * <i>“The return codes for post installation behavior.”</i>
         * 
         * @param returnCodes
         *            value of {@code returnCodes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder returnCodes(Win32LobAppReturnCode... returnCodes) {
            return returnCodes(Arrays.asList(returnCodes));
        }

        /**
         * <i>“The return codes for post installation behavior.”</i>
         * 
         * @param returnCodesNextLink
         *            value of {@code returnCodes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder returnCodesNextLink(String returnCodesNextLink) {
            this.returnCodesNextLink = returnCodesNextLink;
            this.changedFields = changedFields.add("returnCodes");
            return this;
        }

        /**
         * <i>“The detection and requirement rules for this app.”</i>
         * 
         * @param rules
         *            value of {@code rules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rules(List<Win32LobAppRule> rules) {
            this.rules = rules;
            this.changedFields = changedFields.add("rules");
            return this;
        }

        /**
         * <i>“The detection and requirement rules for this app.”</i>
         * 
         * @param rules
         *            value of {@code rules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rules(Win32LobAppRule... rules) {
            return rules(Arrays.asList(rules));
        }

        /**
         * <i>“The detection and requirement rules for this app.”</i>
         * 
         * @param rulesNextLink
         *            value of {@code rules@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rulesNextLink(String rulesNextLink) {
            this.rulesNextLink = rulesNextLink;
            this.changedFields = changedFields.add("rules");
            return this;
        }

        /**
         * <i>“The relative path of the setup file in the encrypted Win32LobApp package.”</i>
         * 
         * @param setupFilePath
         *            value of {@code setupFilePath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder setupFilePath(String setupFilePath) {
            this.setupFilePath = setupFilePath;
            this.changedFields = changedFields.add("setupFilePath");
            return this;
        }

        /**
         * <i>“The command line to uninstall this app”</i>
         * 
         * @param uninstallCommandLine
         *            value of {@code uninstallCommandLine} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uninstallCommandLine(String uninstallCommandLine) {
            this.uninstallCommandLine = uninstallCommandLine;
            this.changedFields = changedFields.add("uninstallCommandLine");
            return this;
        }

        public Win32LobApp build() {
            Win32LobApp _x = new Win32LobApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.win32LobApp";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            _x.committedContentVersion = committedContentVersion;
            _x.fileName = fileName;
            _x.size = size;
            _x.contentVersions = contentVersions;
            _x.applicableArchitectures = applicableArchitectures;
            _x.detectionRules = detectionRules;
            _x.detectionRulesNextLink = detectionRulesNextLink;
            _x.displayVersion = displayVersion;
            _x.installCommandLine = installCommandLine;
            _x.installExperience = installExperience;
            _x.minimumCpuSpeedInMHz = minimumCpuSpeedInMHz;
            _x.minimumFreeDiskSpaceInMB = minimumFreeDiskSpaceInMB;
            _x.minimumMemoryInMB = minimumMemoryInMB;
            _x.minimumNumberOfProcessors = minimumNumberOfProcessors;
            _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            _x.minimumSupportedWindowsRelease = minimumSupportedWindowsRelease;
            _x.msiInformation = msiInformation;
            _x.requirementRules = requirementRules;
            _x.requirementRulesNextLink = requirementRulesNextLink;
            _x.returnCodes = returnCodes;
            _x.returnCodesNextLink = returnCodesNextLink;
            _x.rules = rules;
            _x.rulesNextLink = rulesNextLink;
            _x.setupFilePath = setupFilePath;
            _x.uninstallCommandLine = uninstallCommandLine;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The Windows architecture(s) for which this app can run on.”</i>
     * 
     * @return property applicableArchitectures
     */
    @Property(name="applicableArchitectures")
    @JsonIgnore
    public Optional<WindowsArchitecture> getApplicableArchitectures() {
        return Optional.ofNullable(applicableArchitectures);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicableArchitectures} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Windows architecture(s) for which this app can run on.”</i>
     * 
     * @param applicableArchitectures
     *            new value of {@code applicableArchitectures} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicableArchitectures} field changed
     */
    public Win32LobApp withApplicableArchitectures(WindowsArchitecture applicableArchitectures) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("applicableArchitectures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.applicableArchitectures = applicableArchitectures;
        return _x;
    }

    /**
     * <i>“The detection rules to detect Win32 Line of Business (LoB) app.”</i>
     * 
     * @return property detectionRules
     */
    @Property(name="detectionRules")
    @JsonIgnore
    public CollectionPage<Win32LobAppDetection> getDetectionRules() {
        return new CollectionPage<Win32LobAppDetection>(contextPath, Win32LobAppDetection.class, this.detectionRules, Optional.ofNullable(detectionRulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionRules}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The detection rules to detect Win32 Line of Business (LoB) app.”</i>
     * 
     * @param detectionRules
     *            new value of {@code detectionRules} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionRules} field changed
     */
    public Win32LobApp withDetectionRules(List<Win32LobAppDetection> detectionRules) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("detectionRules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.detectionRules = detectionRules;
        return _x;
    }

    /**
     * <i>“The detection rules to detect Win32 Line of Business (LoB) app.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property detectionRules
     */
    @Property(name="detectionRules")
    @JsonIgnore
    public CollectionPage<Win32LobAppDetection> getDetectionRules(HttpRequestOptions options) {
        return new CollectionPage<Win32LobAppDetection>(contextPath, Win32LobAppDetection.class, this.detectionRules, Optional.ofNullable(detectionRulesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The version displayed in the UX for this app.”</i>
     * 
     * @return property displayVersion
     */
    @Property(name="displayVersion")
    @JsonIgnore
    public Optional<String> getDisplayVersion() {
        return Optional.ofNullable(displayVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The version displayed in the UX for this app.”</i>
     * 
     * @param displayVersion
     *            new value of {@code displayVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayVersion} field changed
     */
    public Win32LobApp withDisplayVersion(String displayVersion) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("displayVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.displayVersion = displayVersion;
        return _x;
    }

    /**
     * <i>“The command line to install this app”</i>
     * 
     * @return property installCommandLine
     */
    @Property(name="installCommandLine")
    @JsonIgnore
    public Optional<String> getInstallCommandLine() {
        return Optional.ofNullable(installCommandLine);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installCommandLine} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The command line to install this app”</i>
     * 
     * @param installCommandLine
     *            new value of {@code installCommandLine} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installCommandLine} field changed
     */
    public Win32LobApp withInstallCommandLine(String installCommandLine) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("installCommandLine");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.installCommandLine = installCommandLine;
        return _x;
    }

    /**
     * <i>“The install experience for this app.”</i>
     * 
     * @return property installExperience
     */
    @Property(name="installExperience")
    @JsonIgnore
    public Optional<Win32LobAppInstallExperience> getInstallExperience() {
        return Optional.ofNullable(installExperience);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code installExperience
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The install experience for this app.”</i>
     * 
     * @param installExperience
     *            new value of {@code installExperience} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installExperience} field changed
     */
    public Win32LobApp withInstallExperience(Win32LobAppInstallExperience installExperience) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("installExperience");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.installExperience = installExperience;
        return _x;
    }

    /**
     * <i>“The value for the minimum CPU speed which is required to install this app.”</i>
     * 
     * @return property minimumCpuSpeedInMHz
     */
    @Property(name="minimumCpuSpeedInMHz")
    @JsonIgnore
    public Optional<Integer> getMinimumCpuSpeedInMHz() {
        return Optional.ofNullable(minimumCpuSpeedInMHz);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumCpuSpeedInMHz} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum CPU speed which is required to install this app.”</i>
     * 
     * @param minimumCpuSpeedInMHz
     *            new value of {@code minimumCpuSpeedInMHz} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumCpuSpeedInMHz} field changed
     */
    public Win32LobApp withMinimumCpuSpeedInMHz(Integer minimumCpuSpeedInMHz) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("minimumCpuSpeedInMHz");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.minimumCpuSpeedInMHz = minimumCpuSpeedInMHz;
        return _x;
    }

    /**
     * <i>“The value for the minimum free disk space which is required to install this app.”</i>
     * 
     * @return property minimumFreeDiskSpaceInMB
     */
    @Property(name="minimumFreeDiskSpaceInMB")
    @JsonIgnore
    public Optional<Integer> getMinimumFreeDiskSpaceInMB() {
        return Optional.ofNullable(minimumFreeDiskSpaceInMB);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumFreeDiskSpaceInMB} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum free disk space which is required to install this app.”</i>
     * 
     * @param minimumFreeDiskSpaceInMB
     *            new value of {@code minimumFreeDiskSpaceInMB} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumFreeDiskSpaceInMB} field changed
     */
    public Win32LobApp withMinimumFreeDiskSpaceInMB(Integer minimumFreeDiskSpaceInMB) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("minimumFreeDiskSpaceInMB");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.minimumFreeDiskSpaceInMB = minimumFreeDiskSpaceInMB;
        return _x;
    }

    /**
     * <i>“The value for the minimum physical memory which is required to install this app.”</i>
     * 
     * @return property minimumMemoryInMB
     */
    @Property(name="minimumMemoryInMB")
    @JsonIgnore
    public Optional<Integer> getMinimumMemoryInMB() {
        return Optional.ofNullable(minimumMemoryInMB);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minimumMemoryInMB
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The value for the minimum physical memory which is required to install this app.”</i>
     * 
     * @param minimumMemoryInMB
     *            new value of {@code minimumMemoryInMB} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumMemoryInMB} field changed
     */
    public Win32LobApp withMinimumMemoryInMB(Integer minimumMemoryInMB) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("minimumMemoryInMB");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.minimumMemoryInMB = minimumMemoryInMB;
        return _x;
    }

    /**
     * <i>“The value for the minimum number of processors which is required to install this
     * app.”</i>
     * 
     * @return property minimumNumberOfProcessors
     */
    @Property(name="minimumNumberOfProcessors")
    @JsonIgnore
    public Optional<Integer> getMinimumNumberOfProcessors() {
        return Optional.ofNullable(minimumNumberOfProcessors);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumNumberOfProcessors} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum number of processors which is required to install this
     * app.”</i>
     * 
     * @param minimumNumberOfProcessors
     *            new value of {@code minimumNumberOfProcessors} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumNumberOfProcessors} field changed
     */
    public Win32LobApp withMinimumNumberOfProcessors(Integer minimumNumberOfProcessors) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("minimumNumberOfProcessors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.minimumNumberOfProcessors = minimumNumberOfProcessors;
        return _x;
    }

    /**
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @return property minimumSupportedOperatingSystem
     */
    @Property(name="minimumSupportedOperatingSystem")
    @JsonIgnore
    public Optional<WindowsMinimumOperatingSystem> getMinimumSupportedOperatingSystem() {
        return Optional.ofNullable(minimumSupportedOperatingSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumSupportedOperatingSystem} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @param minimumSupportedOperatingSystem
     *            new value of {@code minimumSupportedOperatingSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumSupportedOperatingSystem} field changed
     */
    public Win32LobApp withMinimumSupportedOperatingSystem(WindowsMinimumOperatingSystem minimumSupportedOperatingSystem) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("minimumSupportedOperatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        return _x;
    }

    /**
     * <i>“The value for the minimum supported windows release.”</i>
     * 
     * @return property minimumSupportedWindowsRelease
     */
    @Property(name="minimumSupportedWindowsRelease")
    @JsonIgnore
    public Optional<String> getMinimumSupportedWindowsRelease() {
        return Optional.ofNullable(minimumSupportedWindowsRelease);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumSupportedWindowsRelease} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum supported windows release.”</i>
     * 
     * @param minimumSupportedWindowsRelease
     *            new value of {@code minimumSupportedWindowsRelease} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumSupportedWindowsRelease} field changed
     */
    public Win32LobApp withMinimumSupportedWindowsRelease(String minimumSupportedWindowsRelease) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("minimumSupportedWindowsRelease");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.minimumSupportedWindowsRelease = minimumSupportedWindowsRelease;
        return _x;
    }

    /**
     * <i>“The MSI details if this Win32 app is an MSI app.”</i>
     * 
     * @return property msiInformation
     */
    @Property(name="msiInformation")
    @JsonIgnore
    public Optional<Win32LobAppMsiInformation> getMsiInformation() {
        return Optional.ofNullable(msiInformation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code msiInformation}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MSI details if this Win32 app is an MSI app.”</i>
     * 
     * @param msiInformation
     *            new value of {@code msiInformation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code msiInformation} field changed
     */
    public Win32LobApp withMsiInformation(Win32LobAppMsiInformation msiInformation) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("msiInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.msiInformation = msiInformation;
        return _x;
    }

    /**
     * <i>“The requirement rules to detect Win32 Line of Business (LoB) app.”</i>
     * 
     * @return property requirementRules
     */
    @Property(name="requirementRules")
    @JsonIgnore
    public CollectionPage<Win32LobAppRequirement> getRequirementRules() {
        return new CollectionPage<Win32LobAppRequirement>(contextPath, Win32LobAppRequirement.class, this.requirementRules, Optional.ofNullable(requirementRulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requirementRules}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The requirement rules to detect Win32 Line of Business (LoB) app.”</i>
     * 
     * @param requirementRules
     *            new value of {@code requirementRules} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requirementRules} field changed
     */
    public Win32LobApp withRequirementRules(List<Win32LobAppRequirement> requirementRules) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("requirementRules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.requirementRules = requirementRules;
        return _x;
    }

    /**
     * <i>“The requirement rules to detect Win32 Line of Business (LoB) app.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property requirementRules
     */
    @Property(name="requirementRules")
    @JsonIgnore
    public CollectionPage<Win32LobAppRequirement> getRequirementRules(HttpRequestOptions options) {
        return new CollectionPage<Win32LobAppRequirement>(contextPath, Win32LobAppRequirement.class, this.requirementRules, Optional.ofNullable(requirementRulesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The return codes for post installation behavior.”</i>
     * 
     * @return property returnCodes
     */
    @Property(name="returnCodes")
    @JsonIgnore
    public CollectionPage<Win32LobAppReturnCode> getReturnCodes() {
        return new CollectionPage<Win32LobAppReturnCode>(contextPath, Win32LobAppReturnCode.class, this.returnCodes, Optional.ofNullable(returnCodesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code returnCodes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The return codes for post installation behavior.”</i>
     * 
     * @param returnCodes
     *            new value of {@code returnCodes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code returnCodes} field changed
     */
    public Win32LobApp withReturnCodes(List<Win32LobAppReturnCode> returnCodes) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("returnCodes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.returnCodes = returnCodes;
        return _x;
    }

    /**
     * <i>“The return codes for post installation behavior.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property returnCodes
     */
    @Property(name="returnCodes")
    @JsonIgnore
    public CollectionPage<Win32LobAppReturnCode> getReturnCodes(HttpRequestOptions options) {
        return new CollectionPage<Win32LobAppReturnCode>(contextPath, Win32LobAppReturnCode.class, this.returnCodes, Optional.ofNullable(returnCodesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The detection and requirement rules for this app.”</i>
     * 
     * @return property rules
     */
    @Property(name="rules")
    @JsonIgnore
    public CollectionPage<Win32LobAppRule> getRules() {
        return new CollectionPage<Win32LobAppRule>(contextPath, Win32LobAppRule.class, this.rules, Optional.ofNullable(rulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rules} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The detection and requirement rules for this app.”</i>
     * 
     * @param rules
     *            new value of {@code rules} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rules} field changed
     */
    public Win32LobApp withRules(List<Win32LobAppRule> rules) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("rules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.rules = rules;
        return _x;
    }

    /**
     * <i>“The detection and requirement rules for this app.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property rules
     */
    @Property(name="rules")
    @JsonIgnore
    public CollectionPage<Win32LobAppRule> getRules(HttpRequestOptions options) {
        return new CollectionPage<Win32LobAppRule>(contextPath, Win32LobAppRule.class, this.rules, Optional.ofNullable(rulesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The relative path of the setup file in the encrypted Win32LobApp package.”</i>
     * 
     * @return property setupFilePath
     */
    @Property(name="setupFilePath")
    @JsonIgnore
    public Optional<String> getSetupFilePath() {
        return Optional.ofNullable(setupFilePath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code setupFilePath}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The relative path of the setup file in the encrypted Win32LobApp package.”</i>
     * 
     * @param setupFilePath
     *            new value of {@code setupFilePath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code setupFilePath} field changed
     */
    public Win32LobApp withSetupFilePath(String setupFilePath) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("setupFilePath");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.setupFilePath = setupFilePath;
        return _x;
    }

    /**
     * <i>“The command line to uninstall this app”</i>
     * 
     * @return property uninstallCommandLine
     */
    @Property(name="uninstallCommandLine")
    @JsonIgnore
    public Optional<String> getUninstallCommandLine() {
        return Optional.ofNullable(uninstallCommandLine);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * uninstallCommandLine} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The command line to uninstall this app”</i>
     * 
     * @param uninstallCommandLine
     *            new value of {@code uninstallCommandLine} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uninstallCommandLine} field changed
     */
    public Win32LobApp withUninstallCommandLine(String uninstallCommandLine) {
        Win32LobApp _x = _copy();
        _x.changedFields = changedFields.add("uninstallCommandLine");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobApp");
        _x.uninstallCommandLine = uninstallCommandLine;
        return _x;
    }

    public Win32LobApp withUnmappedField(String name, Object value) {
        Win32LobApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Win32LobApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Win32LobApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Win32LobApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Win32LobApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Win32LobApp _copy() {
        Win32LobApp _x = new Win32LobApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        _x.committedContentVersion = committedContentVersion;
        _x.fileName = fileName;
        _x.size = size;
        _x.contentVersions = contentVersions;
        _x.applicableArchitectures = applicableArchitectures;
        _x.detectionRules = detectionRules;
        _x.displayVersion = displayVersion;
        _x.installCommandLine = installCommandLine;
        _x.installExperience = installExperience;
        _x.minimumCpuSpeedInMHz = minimumCpuSpeedInMHz;
        _x.minimumFreeDiskSpaceInMB = minimumFreeDiskSpaceInMB;
        _x.minimumMemoryInMB = minimumMemoryInMB;
        _x.minimumNumberOfProcessors = minimumNumberOfProcessors;
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        _x.minimumSupportedWindowsRelease = minimumSupportedWindowsRelease;
        _x.msiInformation = msiInformation;
        _x.requirementRules = requirementRules;
        _x.returnCodes = returnCodes;
        _x.rules = rules;
        _x.setupFilePath = setupFilePath;
        _x.uninstallCommandLine = uninstallCommandLine;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("committedContentVersion=");
        b.append(this.committedContentVersion);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("contentVersions=");
        b.append(this.contentVersions);
        b.append(", ");
        b.append("applicableArchitectures=");
        b.append(this.applicableArchitectures);
        b.append(", ");
        b.append("detectionRules=");
        b.append(this.detectionRules);
        b.append(", ");
        b.append("displayVersion=");
        b.append(this.displayVersion);
        b.append(", ");
        b.append("installCommandLine=");
        b.append(this.installCommandLine);
        b.append(", ");
        b.append("installExperience=");
        b.append(this.installExperience);
        b.append(", ");
        b.append("minimumCpuSpeedInMHz=");
        b.append(this.minimumCpuSpeedInMHz);
        b.append(", ");
        b.append("minimumFreeDiskSpaceInMB=");
        b.append(this.minimumFreeDiskSpaceInMB);
        b.append(", ");
        b.append("minimumMemoryInMB=");
        b.append(this.minimumMemoryInMB);
        b.append(", ");
        b.append("minimumNumberOfProcessors=");
        b.append(this.minimumNumberOfProcessors);
        b.append(", ");
        b.append("minimumSupportedOperatingSystem=");
        b.append(this.minimumSupportedOperatingSystem);
        b.append(", ");
        b.append("minimumSupportedWindowsRelease=");
        b.append(this.minimumSupportedWindowsRelease);
        b.append(", ");
        b.append("msiInformation=");
        b.append(this.msiInformation);
        b.append(", ");
        b.append("requirementRules=");
        b.append(this.requirementRules);
        b.append(", ");
        b.append("returnCodes=");
        b.append(this.returnCodes);
        b.append(", ");
        b.append("rules=");
        b.append(this.rules);
        b.append(", ");
        b.append("setupFilePath=");
        b.append(this.setupFilePath);
        b.append(", ");
        b.append("uninstallCommandLine=");
        b.append(this.uninstallCommandLine);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
