package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.VppTokenActionResult;
import odata.msgraph.client.beta.enums.VppTokenAccountType;
import odata.msgraph.client.beta.enums.VppTokenState;
import odata.msgraph.client.beta.enums.VppTokenSyncStatus;


/**
 * <i>“You purchase multiple licenses for iOS apps through the Apple Volume Purchase
 * Program for Business or Education. This involves setting up an Apple VPP account
 * from the Apple website and uploading the Apple VPP Business or Education token
 * to Intune. You can then synchronize your volume purchase information with Intune
 * and track your volume-purchased app use. You can upload multiple Apple VPP
 * Business or Education tokens.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appleId", 
    "automaticallyUpdateApps", 
    "claimTokenManagementFromExternalMdm", 
    "countryOrRegion", 
    "dataSharingConsentGranted", 
    "displayName", 
    "expirationDateTime", 
    "lastModifiedDateTime", 
    "lastSyncDateTime", 
    "lastSyncStatus", 
    "locationName", 
    "organizationName", 
    "roleScopeTagIds", 
    "state", 
    "token", 
    "tokenActionResults", 
    "vppTokenAccountType"})
@JsonInclude(Include.NON_NULL)
public class VppToken extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vppToken";
    }

    @JsonProperty("appleId")
    protected String appleId;

    @JsonProperty("automaticallyUpdateApps")
    protected Boolean automaticallyUpdateApps;

    @JsonProperty("claimTokenManagementFromExternalMdm")
    protected Boolean claimTokenManagementFromExternalMdm;

    @JsonProperty("countryOrRegion")
    protected String countryOrRegion;

    @JsonProperty("dataSharingConsentGranted")
    protected Boolean dataSharingConsentGranted;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("lastSyncStatus")
    protected VppTokenSyncStatus lastSyncStatus;

    @JsonProperty("locationName")
    protected String locationName;

    @JsonProperty("organizationName")
    protected String organizationName;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("state")
    protected VppTokenState state;

    @JsonProperty("token")
    protected String token;

    @JsonProperty("tokenActionResults")
    protected List<VppTokenActionResult> tokenActionResults;

    @JsonProperty("tokenActionResults@nextLink")
    protected String tokenActionResultsNextLink;

    @JsonProperty("vppTokenAccountType")
    protected VppTokenAccountType vppTokenAccountType;

    protected VppToken() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderVppToken() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appleId;
        private Boolean automaticallyUpdateApps;
        private Boolean claimTokenManagementFromExternalMdm;
        private String countryOrRegion;
        private Boolean dataSharingConsentGranted;
        private String displayName;
        private OffsetDateTime expirationDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime lastSyncDateTime;
        private VppTokenSyncStatus lastSyncStatus;
        private String locationName;
        private String organizationName;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private VppTokenState state;
        private String token;
        private List<VppTokenActionResult> tokenActionResults;
        private String tokenActionResultsNextLink;
        private VppTokenAccountType vppTokenAccountType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The apple Id associated with the given Apple Volume Purchase Program Token.”</i>
         * 
         * @param appleId
         *            value of {@code appleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleId(String appleId) {
            this.appleId = appleId;
            this.changedFields = changedFields.add("appleId");
            return this;
        }

        /**
         * <i>“Whether or not apps for the VPP token will be automatically updated.”</i>
         * 
         * @param automaticallyUpdateApps
         *            value of {@code automaticallyUpdateApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder automaticallyUpdateApps(Boolean automaticallyUpdateApps) {
            this.automaticallyUpdateApps = automaticallyUpdateApps;
            this.changedFields = changedFields.add("automaticallyUpdateApps");
            return this;
        }

        /**
         * <i>“Admin consent to allow claiming token management from external MDM.”</i>
         * 
         * @param claimTokenManagementFromExternalMdm
         *            value of {@code claimTokenManagementFromExternalMdm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder claimTokenManagementFromExternalMdm(Boolean claimTokenManagementFromExternalMdm) {
            this.claimTokenManagementFromExternalMdm = claimTokenManagementFromExternalMdm;
            this.changedFields = changedFields.add("claimTokenManagementFromExternalMdm");
            return this;
        }

        /**
         * <i>“Whether or not apps for the VPP token will be automatically updated.”</i>
         * 
         * @param countryOrRegion
         *            value of {@code countryOrRegion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder countryOrRegion(String countryOrRegion) {
            this.countryOrRegion = countryOrRegion;
            this.changedFields = changedFields.add("countryOrRegion");
            return this;
        }

        /**
         * <i>“Consent granted for data sharing with the Apple Volume Purchase Program.”</i>
         * 
         * @param dataSharingConsentGranted
         *            value of {@code dataSharingConsentGranted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataSharingConsentGranted(Boolean dataSharingConsentGranted) {
            this.dataSharingConsentGranted = dataSharingConsentGranted;
            this.changedFields = changedFields.add("dataSharingConsentGranted");
            return this;
        }

        /**
         * <i>“An admin specified token friendly name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The expiration date time of the Apple Volume Purchase Program Token.”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        /**
         * <i>“Last modification date time associated with the Apple Volume Purchase Program
         * Token.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The last time when an application sync was done with the Apple volume purchase
         * program service using the the Apple Volume Purchase Program Token.”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“Current sync status of the last application sync which was triggered using the
         * Apple Volume Purchase Program Token. Possible values are: `none`, `inProgress`,
         * `completed`, `failed`.”</i>
         * 
         * @param lastSyncStatus
         *            value of {@code lastSyncStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncStatus(VppTokenSyncStatus lastSyncStatus) {
            this.lastSyncStatus = lastSyncStatus;
            this.changedFields = changedFields.add("lastSyncStatus");
            return this;
        }

        /**
         * <i>“Token location returned from Apple VPP.”</i>
         * 
         * @param locationName
         *            value of {@code locationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder locationName(String locationName) {
            this.locationName = locationName;
            this.changedFields = changedFields.add("locationName");
            return this;
        }

        /**
         * <i>“The organization associated with the Apple Volume Purchase Program Token”</i>
         * 
         * @param organizationName
         *            value of {@code organizationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            this.changedFields = changedFields.add("organizationName");
            return this;
        }

        /**
         * <i>“Role Scope Tags IDs assigned to this entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Role Scope Tags IDs assigned to this entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“Role Scope Tags IDs assigned to this entity.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Current state of the Apple Volume Purchase Program Token. Possible values are: `
         * unknown`, `valid`, `expired`, `invalid`, `assignedToExternalMDM`.”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(VppTokenState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“The Apple Volume Purchase Program Token string downloaded from the Apple Volume
         * Purchase Program.”</i>
         * 
         * @param token
         *            value of {@code token} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder token(String token) {
            this.token = token;
            this.changedFields = changedFields.add("token");
            return this;
        }

        /**
         * <i>“The collection of statuses of the actions performed on the Apple Volume Purchase
         * Program Token.”</i>
         * 
         * @param tokenActionResults
         *            value of {@code tokenActionResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenActionResults(List<VppTokenActionResult> tokenActionResults) {
            this.tokenActionResults = tokenActionResults;
            this.changedFields = changedFields.add("tokenActionResults");
            return this;
        }

        /**
         * <i>“The collection of statuses of the actions performed on the Apple Volume Purchase
         * Program Token.”</i>
         * 
         * @param tokenActionResults
         *            value of {@code tokenActionResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenActionResults(VppTokenActionResult... tokenActionResults) {
            return tokenActionResults(Arrays.asList(tokenActionResults));
        }

        /**
         * <i>“The collection of statuses of the actions performed on the Apple Volume Purchase
         * Program Token.”</i>
         * 
         * @param tokenActionResultsNextLink
         *            value of {@code tokenActionResults@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenActionResultsNextLink(String tokenActionResultsNextLink) {
            this.tokenActionResultsNextLink = tokenActionResultsNextLink;
            this.changedFields = changedFields.add("tokenActionResults");
            return this;
        }

        /**
         * <i>“The type of volume purchase program which the given Apple Volume Purchase
         * Program Token is associated with. Possible values are: `business`, `education`.”</i>
         * 
         * @param vppTokenAccountType
         *            value of {@code vppTokenAccountType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppTokenAccountType(VppTokenAccountType vppTokenAccountType) {
            this.vppTokenAccountType = vppTokenAccountType;
            this.changedFields = changedFields.add("vppTokenAccountType");
            return this;
        }

        public VppToken build() {
            VppToken _x = new VppToken();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.vppToken";
            _x.id = id;
            _x.appleId = appleId;
            _x.automaticallyUpdateApps = automaticallyUpdateApps;
            _x.claimTokenManagementFromExternalMdm = claimTokenManagementFromExternalMdm;
            _x.countryOrRegion = countryOrRegion;
            _x.dataSharingConsentGranted = dataSharingConsentGranted;
            _x.displayName = displayName;
            _x.expirationDateTime = expirationDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.lastSyncStatus = lastSyncStatus;
            _x.locationName = locationName;
            _x.organizationName = organizationName;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.state = state;
            _x.token = token;
            _x.tokenActionResults = tokenActionResults;
            _x.tokenActionResultsNextLink = tokenActionResultsNextLink;
            _x.vppTokenAccountType = vppTokenAccountType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The apple Id associated with the given Apple Volume Purchase Program Token.”</i>
     * 
     * @return property appleId
     */
    @Property(name="appleId")
    @JsonIgnore
    public Optional<String> getAppleId() {
        return Optional.ofNullable(appleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The apple Id associated with the given Apple Volume Purchase Program Token.”</i>
     * 
     * @param appleId
     *            new value of {@code appleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleId} field changed
     */
    public VppToken withAppleId(String appleId) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("appleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.appleId = appleId;
        return _x;
    }

    /**
     * <i>“Whether or not apps for the VPP token will be automatically updated.”</i>
     * 
     * @return property automaticallyUpdateApps
     */
    @Property(name="automaticallyUpdateApps")
    @JsonIgnore
    public Optional<Boolean> getAutomaticallyUpdateApps() {
        return Optional.ofNullable(automaticallyUpdateApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * automaticallyUpdateApps} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not apps for the VPP token will be automatically updated.”</i>
     * 
     * @param automaticallyUpdateApps
     *            new value of {@code automaticallyUpdateApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code automaticallyUpdateApps} field changed
     */
    public VppToken withAutomaticallyUpdateApps(Boolean automaticallyUpdateApps) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("automaticallyUpdateApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.automaticallyUpdateApps = automaticallyUpdateApps;
        return _x;
    }

    /**
     * <i>“Admin consent to allow claiming token management from external MDM.”</i>
     * 
     * @return property claimTokenManagementFromExternalMdm
     */
    @Property(name="claimTokenManagementFromExternalMdm")
    @JsonIgnore
    public Optional<Boolean> getClaimTokenManagementFromExternalMdm() {
        return Optional.ofNullable(claimTokenManagementFromExternalMdm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * claimTokenManagementFromExternalMdm} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Admin consent to allow claiming token management from external MDM.”</i>
     * 
     * @param claimTokenManagementFromExternalMdm
     *            new value of {@code claimTokenManagementFromExternalMdm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code claimTokenManagementFromExternalMdm} field changed
     */
    public VppToken withClaimTokenManagementFromExternalMdm(Boolean claimTokenManagementFromExternalMdm) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("claimTokenManagementFromExternalMdm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.claimTokenManagementFromExternalMdm = claimTokenManagementFromExternalMdm;
        return _x;
    }

    /**
     * <i>“Whether or not apps for the VPP token will be automatically updated.”</i>
     * 
     * @return property countryOrRegion
     */
    @Property(name="countryOrRegion")
    @JsonIgnore
    public Optional<String> getCountryOrRegion() {
        return Optional.ofNullable(countryOrRegion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code countryOrRegion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not apps for the VPP token will be automatically updated.”</i>
     * 
     * @param countryOrRegion
     *            new value of {@code countryOrRegion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code countryOrRegion} field changed
     */
    public VppToken withCountryOrRegion(String countryOrRegion) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("countryOrRegion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.countryOrRegion = countryOrRegion;
        return _x;
    }

    /**
     * <i>“Consent granted for data sharing with the Apple Volume Purchase Program.”</i>
     * 
     * @return property dataSharingConsentGranted
     */
    @Property(name="dataSharingConsentGranted")
    @JsonIgnore
    public Optional<Boolean> getDataSharingConsentGranted() {
        return Optional.ofNullable(dataSharingConsentGranted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dataSharingConsentGranted} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Consent granted for data sharing with the Apple Volume Purchase Program.”</i>
     * 
     * @param dataSharingConsentGranted
     *            new value of {@code dataSharingConsentGranted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataSharingConsentGranted} field changed
     */
    public VppToken withDataSharingConsentGranted(Boolean dataSharingConsentGranted) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("dataSharingConsentGranted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.dataSharingConsentGranted = dataSharingConsentGranted;
        return _x;
    }

    /**
     * <i>“An admin specified token friendly name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“An admin specified token friendly name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public VppToken withDisplayName(String displayName) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The expiration date time of the Apple Volume Purchase Program Token.”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The expiration date time of the Apple Volume Purchase Program Token.”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public VppToken withExpirationDateTime(OffsetDateTime expirationDateTime) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    /**
     * <i>“Last modification date time associated with the Apple Volume Purchase Program
     * Token.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modification date time associated with the Apple Volume Purchase Program
     * Token.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public VppToken withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The last time when an application sync was done with the Apple volume purchase
     * program service using the the Apple Volume Purchase Program Token.”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The last time when an application sync was done with the Apple volume purchase
     * program service using the the Apple Volume Purchase Program Token.”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public VppToken withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“Current sync status of the last application sync which was triggered using the
     * Apple Volume Purchase Program Token. Possible values are: `none`, `inProgress`,
     * `completed`, `failed`.”</i>
     * 
     * @return property lastSyncStatus
     */
    @Property(name="lastSyncStatus")
    @JsonIgnore
    public Optional<VppTokenSyncStatus> getLastSyncStatus() {
        return Optional.ofNullable(lastSyncStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Current sync status of the last application sync which was triggered using the
     * Apple Volume Purchase Program Token. Possible values are: `none`, `inProgress`,
     * `completed`, `failed`.”</i>
     * 
     * @param lastSyncStatus
     *            new value of {@code lastSyncStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncStatus} field changed
     */
    public VppToken withLastSyncStatus(VppTokenSyncStatus lastSyncStatus) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("lastSyncStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.lastSyncStatus = lastSyncStatus;
        return _x;
    }

    /**
     * <i>“Token location returned from Apple VPP.”</i>
     * 
     * @return property locationName
     */
    @Property(name="locationName")
    @JsonIgnore
    public Optional<String> getLocationName() {
        return Optional.ofNullable(locationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code locationName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Token location returned from Apple VPP.”</i>
     * 
     * @param locationName
     *            new value of {@code locationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code locationName} field changed
     */
    public VppToken withLocationName(String locationName) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("locationName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.locationName = locationName;
        return _x;
    }

    /**
     * <i>“The organization associated with the Apple Volume Purchase Program Token”</i>
     * 
     * @return property organizationName
     */
    @Property(name="organizationName")
    @JsonIgnore
    public Optional<String> getOrganizationName() {
        return Optional.ofNullable(organizationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code organizationName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The organization associated with the Apple Volume Purchase Program Token”</i>
     * 
     * @param organizationName
     *            new value of {@code organizationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code organizationName} field changed
     */
    public VppToken withOrganizationName(String organizationName) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("organizationName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.organizationName = organizationName;
        return _x;
    }

    /**
     * <i>“Role Scope Tags IDs assigned to this entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Role Scope Tags IDs assigned to this entity.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public VppToken withRoleScopeTagIds(List<String> roleScopeTagIds) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“Role Scope Tags IDs assigned to this entity.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Current state of the Apple Volume Purchase Program Token. Possible values are: `
     * unknown`, `valid`, `expired`, `invalid`, `assignedToExternalMDM`.”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<VppTokenState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Current state of the Apple Volume Purchase Program Token. Possible values are: `
     * unknown`, `valid`, `expired`, `invalid`, `assignedToExternalMDM`.”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public VppToken withState(VppTokenState state) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“The Apple Volume Purchase Program Token string downloaded from the Apple Volume
     * Purchase Program.”</i>
     * 
     * @return property token
     */
    @Property(name="token")
    @JsonIgnore
    public Optional<String> getToken() {
        return Optional.ofNullable(token);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code token} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Apple Volume Purchase Program Token string downloaded from the Apple Volume
     * Purchase Program.”</i>
     * 
     * @param token
     *            new value of {@code token} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code token} field changed
     */
    public VppToken withToken(String token) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("token");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.token = token;
        return _x;
    }

    /**
     * <i>“The collection of statuses of the actions performed on the Apple Volume Purchase
     * Program Token.”</i>
     * 
     * @return property tokenActionResults
     */
    @Property(name="tokenActionResults")
    @JsonIgnore
    public CollectionPage<VppTokenActionResult> getTokenActionResults() {
        return new CollectionPage<VppTokenActionResult>(contextPath, VppTokenActionResult.class, this.tokenActionResults, Optional.ofNullable(tokenActionResultsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tokenActionResults} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The collection of statuses of the actions performed on the Apple Volume Purchase
     * Program Token.”</i>
     * 
     * @param tokenActionResults
     *            new value of {@code tokenActionResults} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tokenActionResults} field changed
     */
    public VppToken withTokenActionResults(List<VppTokenActionResult> tokenActionResults) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("tokenActionResults");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.tokenActionResults = tokenActionResults;
        return _x;
    }

    /**
     * <i>“The collection of statuses of the actions performed on the Apple Volume Purchase
     * Program Token.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property tokenActionResults
     */
    @Property(name="tokenActionResults")
    @JsonIgnore
    public CollectionPage<VppTokenActionResult> getTokenActionResults(HttpRequestOptions options) {
        return new CollectionPage<VppTokenActionResult>(contextPath, VppTokenActionResult.class, this.tokenActionResults, Optional.ofNullable(tokenActionResultsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The type of volume purchase program which the given Apple Volume Purchase
     * Program Token is associated with. Possible values are: `business`, `education`.”</i>
     * 
     * @return property vppTokenAccountType
     */
    @Property(name="vppTokenAccountType")
    @JsonIgnore
    public Optional<VppTokenAccountType> getVppTokenAccountType() {
        return Optional.ofNullable(vppTokenAccountType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * vppTokenAccountType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The type of volume purchase program which the given Apple Volume Purchase
     * Program Token is associated with. Possible values are: `business`, `education`.”</i>
     * 
     * @param vppTokenAccountType
     *            new value of {@code vppTokenAccountType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vppTokenAccountType} field changed
     */
    public VppToken withVppTokenAccountType(VppTokenAccountType vppTokenAccountType) {
        VppToken _x = _copy();
        _x.changedFields = changedFields.add("vppTokenAccountType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppToken");
        _x.vppTokenAccountType = vppTokenAccountType;
        return _x;
    }

    public VppToken withUnmappedField(String name, Object value) {
        VppToken _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public VppToken patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        VppToken _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public VppToken put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        VppToken _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private VppToken _copy() {
        VppToken _x = new VppToken();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appleId = appleId;
        _x.automaticallyUpdateApps = automaticallyUpdateApps;
        _x.claimTokenManagementFromExternalMdm = claimTokenManagementFromExternalMdm;
        _x.countryOrRegion = countryOrRegion;
        _x.dataSharingConsentGranted = dataSharingConsentGranted;
        _x.displayName = displayName;
        _x.expirationDateTime = expirationDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.lastSyncStatus = lastSyncStatus;
        _x.locationName = locationName;
        _x.organizationName = organizationName;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.state = state;
        _x.token = token;
        _x.tokenActionResults = tokenActionResults;
        _x.vppTokenAccountType = vppTokenAccountType;
        return _x;
    }

    @Action(name = "revokeLicenses")
    @JsonIgnore
    public ActionRequestNoReturn revokeLicenses(Boolean notifyManagedDevices, Boolean revokeUntrackedLicenses) {
        Preconditions.checkNotNull(notifyManagedDevices, "notifyManagedDevices cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notifyManagedDevices", "Edm.Boolean", notifyManagedDevices)
            .put("revokeUntrackedLicenses", "Edm.Boolean", revokeUntrackedLicenses)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeLicenses"), _parameters);
    }

    @Action(name = "syncLicenses")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<VppToken> syncLicenses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<VppToken>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncLicenses"), VppToken.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VppToken[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appleId=");
        b.append(this.appleId);
        b.append(", ");
        b.append("automaticallyUpdateApps=");
        b.append(this.automaticallyUpdateApps);
        b.append(", ");
        b.append("claimTokenManagementFromExternalMdm=");
        b.append(this.claimTokenManagementFromExternalMdm);
        b.append(", ");
        b.append("countryOrRegion=");
        b.append(this.countryOrRegion);
        b.append(", ");
        b.append("dataSharingConsentGranted=");
        b.append(this.dataSharingConsentGranted);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("lastSyncStatus=");
        b.append(this.lastSyncStatus);
        b.append(", ");
        b.append("locationName=");
        b.append(this.locationName);
        b.append(", ");
        b.append("organizationName=");
        b.append(this.organizationName);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("token=");
        b.append(this.token);
        b.append(", ");
        b.append("tokenActionResults=");
        b.append(this.tokenActionResults);
        b.append(", ");
        b.append("vppTokenAccountType=");
        b.append(this.vppTokenAccountType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
