package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.ContactMergeSuggestionsRequest;
import odata.msgraph.client.beta.entity.request.RegionalAndLanguageSettingsRequest;
import odata.msgraph.client.beta.entity.request.ShiftPreferencesRequest;
import odata.msgraph.client.beta.entity.request.UserInsightsSettingsRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "contributionToContentDiscoveryAsOrganizationDisabled", 
    "contributionToContentDiscoveryDisabled", 
    "itemInsights", 
    "contactMergeSuggestions", 
    "regionalAndLanguageSettings", 
    "shiftPreferences"})
@JsonInclude(Include.NON_NULL)
public class UserSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userSettings";
    }

    @JsonProperty("contributionToContentDiscoveryAsOrganizationDisabled")
    protected Boolean contributionToContentDiscoveryAsOrganizationDisabled;

    @JsonProperty("contributionToContentDiscoveryDisabled")
    protected Boolean contributionToContentDiscoveryDisabled;

    @JsonProperty("itemInsights")
    protected UserInsightsSettings itemInsights;

    @JsonProperty("contactMergeSuggestions")
    protected ContactMergeSuggestions contactMergeSuggestions;

    @JsonProperty("regionalAndLanguageSettings")
    protected RegionalAndLanguageSettings regionalAndLanguageSettings;

    @JsonProperty("shiftPreferences")
    protected ShiftPreferences shiftPreferences;

    protected UserSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean contributionToContentDiscoveryAsOrganizationDisabled;
        private Boolean contributionToContentDiscoveryDisabled;
        private UserInsightsSettings itemInsights;
        private ContactMergeSuggestions contactMergeSuggestions;
        private RegionalAndLanguageSettings regionalAndLanguageSettings;
        private ShiftPreferences shiftPreferences;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder contributionToContentDiscoveryAsOrganizationDisabled(Boolean contributionToContentDiscoveryAsOrganizationDisabled) {
            this.contributionToContentDiscoveryAsOrganizationDisabled = contributionToContentDiscoveryAsOrganizationDisabled;
            this.changedFields = changedFields.add("contributionToContentDiscoveryAsOrganizationDisabled");
            return this;
        }

        public Builder contributionToContentDiscoveryDisabled(Boolean contributionToContentDiscoveryDisabled) {
            this.contributionToContentDiscoveryDisabled = contributionToContentDiscoveryDisabled;
            this.changedFields = changedFields.add("contributionToContentDiscoveryDisabled");
            return this;
        }

        public Builder itemInsights(UserInsightsSettings itemInsights) {
            this.itemInsights = itemInsights;
            this.changedFields = changedFields.add("itemInsights");
            return this;
        }

        public Builder contactMergeSuggestions(ContactMergeSuggestions contactMergeSuggestions) {
            this.contactMergeSuggestions = contactMergeSuggestions;
            this.changedFields = changedFields.add("contactMergeSuggestions");
            return this;
        }

        public Builder regionalAndLanguageSettings(RegionalAndLanguageSettings regionalAndLanguageSettings) {
            this.regionalAndLanguageSettings = regionalAndLanguageSettings;
            this.changedFields = changedFields.add("regionalAndLanguageSettings");
            return this;
        }

        public Builder shiftPreferences(ShiftPreferences shiftPreferences) {
            this.shiftPreferences = shiftPreferences;
            this.changedFields = changedFields.add("shiftPreferences");
            return this;
        }

        public UserSettings build() {
            UserSettings _x = new UserSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userSettings";
            _x.id = id;
            _x.contributionToContentDiscoveryAsOrganizationDisabled = contributionToContentDiscoveryAsOrganizationDisabled;
            _x.contributionToContentDiscoveryDisabled = contributionToContentDiscoveryDisabled;
            _x.itemInsights = itemInsights;
            _x.contactMergeSuggestions = contactMergeSuggestions;
            _x.regionalAndLanguageSettings = regionalAndLanguageSettings;
            _x.shiftPreferences = shiftPreferences;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="contributionToContentDiscoveryAsOrganizationDisabled")
    @JsonIgnore
    public Optional<Boolean> getContributionToContentDiscoveryAsOrganizationDisabled() {
        return Optional.ofNullable(contributionToContentDiscoveryAsOrganizationDisabled);
    }

    public UserSettings withContributionToContentDiscoveryAsOrganizationDisabled(Boolean contributionToContentDiscoveryAsOrganizationDisabled) {
        UserSettings _x = _copy();
        _x.changedFields = changedFields.add("contributionToContentDiscoveryAsOrganizationDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSettings");
        _x.contributionToContentDiscoveryAsOrganizationDisabled = contributionToContentDiscoveryAsOrganizationDisabled;
        return _x;
    }

    @Property(name="contributionToContentDiscoveryDisabled")
    @JsonIgnore
    public Optional<Boolean> getContributionToContentDiscoveryDisabled() {
        return Optional.ofNullable(contributionToContentDiscoveryDisabled);
    }

    public UserSettings withContributionToContentDiscoveryDisabled(Boolean contributionToContentDiscoveryDisabled) {
        UserSettings _x = _copy();
        _x.changedFields = changedFields.add("contributionToContentDiscoveryDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSettings");
        _x.contributionToContentDiscoveryDisabled = contributionToContentDiscoveryDisabled;
        return _x;
    }

    public UserSettings withUnmappedField(String name, Object value) {
        UserSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="itemInsights")
    @JsonIgnore
    public UserInsightsSettingsRequest getItemInsights() {
        return new UserInsightsSettingsRequest(contextPath.addSegment("itemInsights"), Optional.ofNullable(itemInsights));
    }

    @NavigationProperty(name="contactMergeSuggestions")
    @JsonIgnore
    public ContactMergeSuggestionsRequest getContactMergeSuggestions() {
        return new ContactMergeSuggestionsRequest(contextPath.addSegment("contactMergeSuggestions"), Optional.ofNullable(contactMergeSuggestions));
    }

    @NavigationProperty(name="regionalAndLanguageSettings")
    @JsonIgnore
    public RegionalAndLanguageSettingsRequest getRegionalAndLanguageSettings() {
        return new RegionalAndLanguageSettingsRequest(contextPath.addSegment("regionalAndLanguageSettings"), Optional.ofNullable(regionalAndLanguageSettings));
    }

    @NavigationProperty(name="shiftPreferences")
    @JsonIgnore
    public ShiftPreferencesRequest getShiftPreferences() {
        return new ShiftPreferencesRequest(contextPath.addSegment("shiftPreferences"), Optional.ofNullable(shiftPreferences));
    }

    public UserSettings withItemInsights(UserInsightsSettings itemInsights) {
        UserSettings _x = _copy();
        _x.changedFields = changedFields.add("itemInsights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSettings");
        _x.itemInsights = itemInsights;
        return _x;
    }

    public UserSettings withContactMergeSuggestions(ContactMergeSuggestions contactMergeSuggestions) {
        UserSettings _x = _copy();
        _x.changedFields = changedFields.add("contactMergeSuggestions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSettings");
        _x.contactMergeSuggestions = contactMergeSuggestions;
        return _x;
    }

    public UserSettings withRegionalAndLanguageSettings(RegionalAndLanguageSettings regionalAndLanguageSettings) {
        UserSettings _x = _copy();
        _x.changedFields = changedFields.add("regionalAndLanguageSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSettings");
        _x.regionalAndLanguageSettings = regionalAndLanguageSettings;
        return _x;
    }

    public UserSettings withShiftPreferences(ShiftPreferences shiftPreferences) {
        UserSettings _x = _copy();
        _x.changedFields = changedFields.add("shiftPreferences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSettings");
        _x.shiftPreferences = shiftPreferences;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserSettings _copy() {
        UserSettings _x = new UserSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.contributionToContentDiscoveryAsOrganizationDisabled = contributionToContentDiscoveryAsOrganizationDisabled;
        _x.contributionToContentDiscoveryDisabled = contributionToContentDiscoveryDisabled;
        _x.itemInsights = itemInsights;
        _x.contactMergeSuggestions = contactMergeSuggestions;
        _x.regionalAndLanguageSettings = regionalAndLanguageSettings;
        _x.shiftPreferences = shiftPreferences;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("contributionToContentDiscoveryAsOrganizationDisabled=");
        b.append(this.contributionToContentDiscoveryAsOrganizationDisabled);
        b.append(", ");
        b.append("contributionToContentDiscoveryDisabled=");
        b.append(this.contributionToContentDiscoveryDisabled);
        b.append(", ");
        b.append("itemInsights=");
        b.append(this.itemInsights);
        b.append(", ");
        b.append("contactMergeSuggestions=");
        b.append(this.contactMergeSuggestions);
        b.append(", ");
        b.append("regionalAndLanguageSettings=");
        b.append(this.regionalAndLanguageSettings);
        b.append(", ");
        b.append("shiftPreferences=");
        b.append(this.shiftPreferences);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
