package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.UserExperienceAnalyticsHealthState;


/**
 * <i>“The user experience analytics work from anywhere model performance.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "cloudIdentityScore", 
    "cloudManagementScore", 
    "cloudProvisioningScore", 
    "healthStatus", 
    "manufacturer", 
    "model", 
    "modelDeviceCount", 
    "windowsScore", 
    "workFromAnywhereScore"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsWorkFromAnywhereModelPerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance";
    }

    @JsonProperty("cloudIdentityScore")
    protected Double cloudIdentityScore;

    @JsonProperty("cloudManagementScore")
    protected Double cloudManagementScore;

    @JsonProperty("cloudProvisioningScore")
    protected Double cloudProvisioningScore;

    @JsonProperty("healthStatus")
    protected UserExperienceAnalyticsHealthState healthStatus;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("modelDeviceCount")
    protected Integer modelDeviceCount;

    @JsonProperty("windowsScore")
    protected Double windowsScore;

    @JsonProperty("workFromAnywhereScore")
    protected Double workFromAnywhereScore;

    protected UserExperienceAnalyticsWorkFromAnywhereModelPerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsWorkFromAnywhereModelPerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Double cloudIdentityScore;
        private Double cloudManagementScore;
        private Double cloudProvisioningScore;
        private UserExperienceAnalyticsHealthState healthStatus;
        private String manufacturer;
        private String model;
        private Integer modelDeviceCount;
        private Double windowsScore;
        private Double workFromAnywhereScore;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere's cloud identity score for the model.
         * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param cloudIdentityScore
         *            value of {@code cloudIdentityScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudIdentityScore(Double cloudIdentityScore) {
            this.cloudIdentityScore = cloudIdentityScore;
            this.changedFields = changedFields.add("cloudIdentityScore");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere's cloud management score for the model.
         * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param cloudManagementScore
         *            value of {@code cloudManagementScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudManagementScore(Double cloudManagementScore) {
            this.cloudManagementScore = cloudManagementScore;
            this.changedFields = changedFields.add("cloudManagementScore");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere's cloud provisioning score for the model.
         * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param cloudProvisioningScore
         *            value of {@code cloudProvisioningScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudProvisioningScore(Double cloudProvisioningScore) {
            this.cloudProvisioningScore = cloudProvisioningScore;
            this.changedFields = changedFields.add("cloudProvisioningScore");
            return this;
        }

        /**
         * <i>“The health state of the user experience analytics work from anywhere model.”</i>
         * 
         * @param healthStatus
         *            value of {@code healthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthStatus(UserExperienceAnalyticsHealthState healthStatus) {
            this.healthStatus = healthStatus;
            this.changedFields = changedFields.add("healthStatus");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere's manufacturer name of the devices.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere's model name of the devices.”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere's devices count for the model. Valid
         * values -2147483648 to 2147483647”</i>
         * 
         * @param modelDeviceCount
         *            value of {@code modelDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modelDeviceCount(Integer modelDeviceCount) {
            this.modelDeviceCount = modelDeviceCount;
            this.changedFields = changedFields.add("modelDeviceCount");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere windows score for the model. Valid values
         * -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param windowsScore
         *            value of {@code windowsScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsScore(Double windowsScore) {
            this.windowsScore = windowsScore;
            this.changedFields = changedFields.add("windowsScore");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere overall score for the model. Valid values
         * -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param workFromAnywhereScore
         *            value of {@code workFromAnywhereScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder workFromAnywhereScore(Double workFromAnywhereScore) {
            this.workFromAnywhereScore = workFromAnywhereScore;
            this.changedFields = changedFields.add("workFromAnywhereScore");
            return this;
        }

        public UserExperienceAnalyticsWorkFromAnywhereModelPerformance build() {
            UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = new UserExperienceAnalyticsWorkFromAnywhereModelPerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance";
            _x.id = id;
            _x.cloudIdentityScore = cloudIdentityScore;
            _x.cloudManagementScore = cloudManagementScore;
            _x.cloudProvisioningScore = cloudProvisioningScore;
            _x.healthStatus = healthStatus;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.modelDeviceCount = modelDeviceCount;
            _x.windowsScore = windowsScore;
            _x.workFromAnywhereScore = workFromAnywhereScore;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The user experience work from anywhere's cloud identity score for the model.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property cloudIdentityScore
     */
    @Property(name="cloudIdentityScore")
    @JsonIgnore
    public Optional<Double> getCloudIdentityScore() {
        return Optional.ofNullable(cloudIdentityScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cloudIdentityScore} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere's cloud identity score for the model.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param cloudIdentityScore
     *            new value of {@code cloudIdentityScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cloudIdentityScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withCloudIdentityScore(Double cloudIdentityScore) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("cloudIdentityScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.cloudIdentityScore = cloudIdentityScore;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere's cloud management score for the model.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property cloudManagementScore
     */
    @Property(name="cloudManagementScore")
    @JsonIgnore
    public Optional<Double> getCloudManagementScore() {
        return Optional.ofNullable(cloudManagementScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cloudManagementScore} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere's cloud management score for the model.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param cloudManagementScore
     *            new value of {@code cloudManagementScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cloudManagementScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withCloudManagementScore(Double cloudManagementScore) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("cloudManagementScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.cloudManagementScore = cloudManagementScore;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere's cloud provisioning score for the model.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property cloudProvisioningScore
     */
    @Property(name="cloudProvisioningScore")
    @JsonIgnore
    public Optional<Double> getCloudProvisioningScore() {
        return Optional.ofNullable(cloudProvisioningScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cloudProvisioningScore} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere's cloud provisioning score for the model.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param cloudProvisioningScore
     *            new value of {@code cloudProvisioningScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cloudProvisioningScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withCloudProvisioningScore(Double cloudProvisioningScore) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("cloudProvisioningScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.cloudProvisioningScore = cloudProvisioningScore;
        return _x;
    }

    /**
     * <i>“The health state of the user experience analytics work from anywhere model.”</i>
     * 
     * @return property healthStatus
     */
    @Property(name="healthStatus")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsHealthState> getHealthStatus() {
        return Optional.ofNullable(healthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code healthStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The health state of the user experience analytics work from anywhere model.”</i>
     * 
     * @param healthStatus
     *            new value of {@code healthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthStatus} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withHealthStatus(UserExperienceAnalyticsHealthState healthStatus) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("healthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.healthStatus = healthStatus;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere's manufacturer name of the devices.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere's manufacturer name of the devices.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withManufacturer(String manufacturer) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere's model name of the devices.”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience work from anywhere's model name of the devices.”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withModel(String model) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere's devices count for the model. Valid
     * values -2147483648 to 2147483647”</i>
     * 
     * @return property modelDeviceCount
     */
    @Property(name="modelDeviceCount")
    @JsonIgnore
    public Optional<Integer> getModelDeviceCount() {
        return Optional.ofNullable(modelDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code modelDeviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere's devices count for the model. Valid
     * values -2147483648 to 2147483647”</i>
     * 
     * @param modelDeviceCount
     *            new value of {@code modelDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modelDeviceCount} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withModelDeviceCount(Integer modelDeviceCount) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("modelDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.modelDeviceCount = modelDeviceCount;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere windows score for the model. Valid values
     * -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property windowsScore
     */
    @Property(name="windowsScore")
    @JsonIgnore
    public Optional<Double> getWindowsScore() {
        return Optional.ofNullable(windowsScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code windowsScore}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere windows score for the model. Valid values
     * -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param windowsScore
     *            new value of {@code windowsScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withWindowsScore(Double windowsScore) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("windowsScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.windowsScore = windowsScore;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere overall score for the model. Valid values
     * -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property workFromAnywhereScore
     */
    @Property(name="workFromAnywhereScore")
    @JsonIgnore
    public Optional<Double> getWorkFromAnywhereScore() {
        return Optional.ofNullable(workFromAnywhereScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * workFromAnywhereScore} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere overall score for the model. Valid values
     * -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param workFromAnywhereScore
     *            new value of {@code workFromAnywhereScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code workFromAnywhereScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withWorkFromAnywhereScore(Double workFromAnywhereScore) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("workFromAnywhereScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.workFromAnywhereScore = workFromAnywhereScore;
        return _x;
    }

    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsWorkFromAnywhereModelPerformance _copy() {
        UserExperienceAnalyticsWorkFromAnywhereModelPerformance _x = new UserExperienceAnalyticsWorkFromAnywhereModelPerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.cloudIdentityScore = cloudIdentityScore;
        _x.cloudManagementScore = cloudManagementScore;
        _x.cloudProvisioningScore = cloudProvisioningScore;
        _x.healthStatus = healthStatus;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.modelDeviceCount = modelDeviceCount;
        _x.windowsScore = windowsScore;
        _x.workFromAnywhereScore = workFromAnywhereScore;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsWorkFromAnywhereModelPerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("cloudIdentityScore=");
        b.append(this.cloudIdentityScore);
        b.append(", ");
        b.append("cloudManagementScore=");
        b.append(this.cloudManagementScore);
        b.append(", ");
        b.append("cloudProvisioningScore=");
        b.append(this.cloudProvisioningScore);
        b.append(", ");
        b.append("healthStatus=");
        b.append(this.healthStatus);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("modelDeviceCount=");
        b.append(this.modelDeviceCount);
        b.append(", ");
        b.append("windowsScore=");
        b.append(this.windowsScore);
        b.append(", ");
        b.append("workFromAnywhereScore=");
        b.append(this.workFromAnywhereScore);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
