package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.OperatingSystemUpgradeEligibility;
import odata.msgraph.client.beta.enums.UserExperienceAnalyticsHealthState;


/**
 * <i>“The user experience analytics Device for work from anywhere report”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "autoPilotProfileAssigned", 
    "autoPilotRegistered", 
    "azureAdDeviceId", 
    "azureAdJoinType", 
    "azureAdRegistered", 
    "cloudIdentityScore", 
    "cloudManagementScore", 
    "cloudProvisioningScore", 
    "compliancePolicySetToIntune", 
    "deviceId", 
    "deviceName", 
    "healthStatus", 
    "isCloudManagedGatewayEnabled", 
    "managedBy", 
    "manufacturer", 
    "model", 
    "osCheckFailed", 
    "osDescription", 
    "osVersion", 
    "otherWorkloadsSetToIntune", 
    "ownership", 
    "processor64BitCheckFailed", 
    "processorCoreCountCheckFailed", 
    "processorFamilyCheckFailed", 
    "processorSpeedCheckFailed", 
    "ramCheckFailed", 
    "secureBootCheckFailed", 
    "serialNumber", 
    "storageCheckFailed", 
    "tenantAttached", 
    "tpmCheckFailed", 
    "upgradeEligibility", 
    "windowsScore", 
    "workFromAnywhereScore"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsWorkFromAnywhereDevice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice";
    }

    @JsonProperty("autoPilotProfileAssigned")
    protected Boolean autoPilotProfileAssigned;

    @JsonProperty("autoPilotRegistered")
    protected Boolean autoPilotRegistered;

    @JsonProperty("azureAdDeviceId")
    protected String azureAdDeviceId;

    @JsonProperty("azureAdJoinType")
    protected String azureAdJoinType;

    @JsonProperty("azureAdRegistered")
    protected Boolean azureAdRegistered;

    @JsonProperty("cloudIdentityScore")
    protected Double cloudIdentityScore;

    @JsonProperty("cloudManagementScore")
    protected Double cloudManagementScore;

    @JsonProperty("cloudProvisioningScore")
    protected Double cloudProvisioningScore;

    @JsonProperty("compliancePolicySetToIntune")
    protected Boolean compliancePolicySetToIntune;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("healthStatus")
    protected UserExperienceAnalyticsHealthState healthStatus;

    @JsonProperty("isCloudManagedGatewayEnabled")
    protected Boolean isCloudManagedGatewayEnabled;

    @JsonProperty("managedBy")
    protected String managedBy;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("osCheckFailed")
    protected Boolean osCheckFailed;

    @JsonProperty("osDescription")
    protected String osDescription;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("otherWorkloadsSetToIntune")
    protected Boolean otherWorkloadsSetToIntune;

    @JsonProperty("ownership")
    protected String ownership;

    @JsonProperty("processor64BitCheckFailed")
    protected Boolean processor64BitCheckFailed;

    @JsonProperty("processorCoreCountCheckFailed")
    protected Boolean processorCoreCountCheckFailed;

    @JsonProperty("processorFamilyCheckFailed")
    protected Boolean processorFamilyCheckFailed;

    @JsonProperty("processorSpeedCheckFailed")
    protected Boolean processorSpeedCheckFailed;

    @JsonProperty("ramCheckFailed")
    protected Boolean ramCheckFailed;

    @JsonProperty("secureBootCheckFailed")
    protected Boolean secureBootCheckFailed;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    @JsonProperty("storageCheckFailed")
    protected Boolean storageCheckFailed;

    @JsonProperty("tenantAttached")
    protected Boolean tenantAttached;

    @JsonProperty("tpmCheckFailed")
    protected Boolean tpmCheckFailed;

    @JsonProperty("upgradeEligibility")
    protected OperatingSystemUpgradeEligibility upgradeEligibility;

    @JsonProperty("windowsScore")
    protected Double windowsScore;

    @JsonProperty("workFromAnywhereScore")
    protected Double workFromAnywhereScore;

    protected UserExperienceAnalyticsWorkFromAnywhereDevice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsWorkFromAnywhereDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean autoPilotProfileAssigned;
        private Boolean autoPilotRegistered;
        private String azureAdDeviceId;
        private String azureAdJoinType;
        private Boolean azureAdRegistered;
        private Double cloudIdentityScore;
        private Double cloudManagementScore;
        private Double cloudProvisioningScore;
        private Boolean compliancePolicySetToIntune;
        private String deviceId;
        private String deviceName;
        private UserExperienceAnalyticsHealthState healthStatus;
        private Boolean isCloudManagedGatewayEnabled;
        private String managedBy;
        private String manufacturer;
        private String model;
        private Boolean osCheckFailed;
        private String osDescription;
        private String osVersion;
        private Boolean otherWorkloadsSetToIntune;
        private String ownership;
        private Boolean processor64BitCheckFailed;
        private Boolean processorCoreCountCheckFailed;
        private Boolean processorFamilyCheckFailed;
        private Boolean processorSpeedCheckFailed;
        private Boolean ramCheckFailed;
        private Boolean secureBootCheckFailed;
        private String serialNumber;
        private Boolean storageCheckFailed;
        private Boolean tenantAttached;
        private Boolean tpmCheckFailed;
        private OperatingSystemUpgradeEligibility upgradeEligibility;
        private Double windowsScore;
        private Double workFromAnywhereScore;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The user experience analytics work from anywhere intune device's
         * autopilotProfileAssigned.”</i>
         * 
         * @param autoPilotProfileAssigned
         *            value of {@code autoPilotProfileAssigned} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoPilotProfileAssigned(Boolean autoPilotProfileAssigned) {
            this.autoPilotProfileAssigned = autoPilotProfileAssigned;
            this.changedFields = changedFields.add("autoPilotProfileAssigned");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere intune device's autopilotRegistered.”</i>
         * 
         * @param autoPilotRegistered
         *            value of {@code autoPilotRegistered} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoPilotRegistered(Boolean autoPilotRegistered) {
            this.autoPilotRegistered = autoPilotRegistered;
            this.changedFields = changedFields.add("autoPilotRegistered");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere azure Ad device Id.”</i>
         * 
         * @param azureAdDeviceId
         *            value of {@code azureAdDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureAdDeviceId(String azureAdDeviceId) {
            this.azureAdDeviceId = azureAdDeviceId;
            this.changedFields = changedFields.add("azureAdDeviceId");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's azure Ad joinType.”</i>
         * 
         * @param azureAdJoinType
         *            value of {@code azureAdJoinType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureAdJoinType(String azureAdJoinType) {
            this.azureAdJoinType = azureAdJoinType;
            this.changedFields = changedFields.add("azureAdJoinType");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's azureAdRegistered.”</i>
         * 
         * @param azureAdRegistered
         *            value of {@code azureAdRegistered} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureAdRegistered(Boolean azureAdRegistered) {
            this.azureAdRegistered = azureAdRegistered;
            this.changedFields = changedFields.add("azureAdRegistered");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere per device cloud identity score. Valid
         * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param cloudIdentityScore
         *            value of {@code cloudIdentityScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudIdentityScore(Double cloudIdentityScore) {
            this.cloudIdentityScore = cloudIdentityScore;
            this.changedFields = changedFields.add("cloudIdentityScore");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere per device cloud management score. Valid
         * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param cloudManagementScore
         *            value of {@code cloudManagementScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudManagementScore(Double cloudManagementScore) {
            this.cloudManagementScore = cloudManagementScore;
            this.changedFields = changedFields.add("cloudManagementScore");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere per device cloud provisioning score.
         * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param cloudProvisioningScore
         *            value of {@code cloudProvisioningScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudProvisioningScore(Double cloudProvisioningScore) {
            this.cloudProvisioningScore = cloudProvisioningScore;
            this.changedFields = changedFields.add("cloudProvisioningScore");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's compliancePolicySetToIntune.”</i>
         * 
         * @param compliancePolicySetToIntune
         *            value of {@code compliancePolicySetToIntune} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliancePolicySetToIntune(Boolean compliancePolicySetToIntune) {
            this.compliancePolicySetToIntune = compliancePolicySetToIntune;
            this.changedFields = changedFields.add("compliancePolicySetToIntune");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device Id.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The work from anywhere device's name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere per device health status”</i>
         * 
         * @param healthStatus
         *            value of {@code healthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthStatus(UserExperienceAnalyticsHealthState healthStatus) {
            this.healthStatus = healthStatus;
            this.changedFields = changedFields.add("healthStatus");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's Cloud Management Gateway for
         * Configuration Manager is enabled.”</i>
         * 
         * @param isCloudManagedGatewayEnabled
         *            value of {@code isCloudManagedGatewayEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isCloudManagedGatewayEnabled(Boolean isCloudManagedGatewayEnabled) {
            this.isCloudManagedGatewayEnabled = isCloudManagedGatewayEnabled;
            this.changedFields = changedFields.add("isCloudManagedGatewayEnabled");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere management agent of the device.”</i>
         * 
         * @param managedBy
         *            value of {@code managedBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            this.changedFields = changedFields.add("managedBy");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's manufacturer.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's model.”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device, Is OS check failed for device to
         * upgrade to the latest version of windows.”</i>
         * 
         * @param osCheckFailed
         *            value of {@code osCheckFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osCheckFailed(Boolean osCheckFailed) {
            this.osCheckFailed = osCheckFailed;
            this.changedFields = changedFields.add("osCheckFailed");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's OS Description.”</i>
         * 
         * @param osDescription
         *            value of {@code osDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osDescription(String osDescription) {
            this.osDescription = osDescription;
            this.changedFields = changedFields.add("osDescription");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's OS Version.”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's otherWorkloadsSetToIntune.”</i>
         * 
         * @param otherWorkloadsSetToIntune
         *            value of {@code otherWorkloadsSetToIntune} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder otherWorkloadsSetToIntune(Boolean otherWorkloadsSetToIntune) {
            this.otherWorkloadsSetToIntune = otherWorkloadsSetToIntune;
            this.changedFields = changedFields.add("otherWorkloadsSetToIntune");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's ownership.”</i>
         * 
         * @param ownership
         *            value of {@code ownership} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownership(String ownership) {
            this.ownership = ownership;
            this.changedFields = changedFields.add("ownership");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device, Is processor hardware 64-bit
         * architecture check failed for device to upgrade to the latest version of windows
         * .”</i>
         * 
         * @param processor64BitCheckFailed
         *            value of {@code processor64BitCheckFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processor64BitCheckFailed(Boolean processor64BitCheckFailed) {
            this.processor64BitCheckFailed = processor64BitCheckFailed;
            this.changedFields = changedFields.add("processor64BitCheckFailed");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device, Is processor hardware core count
         * check failed for device to upgrade to the latest version of windows.”</i>
         * 
         * @param processorCoreCountCheckFailed
         *            value of {@code processorCoreCountCheckFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processorCoreCountCheckFailed(Boolean processorCoreCountCheckFailed) {
            this.processorCoreCountCheckFailed = processorCoreCountCheckFailed;
            this.changedFields = changedFields.add("processorCoreCountCheckFailed");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device, Is processor hardware family
         * check failed for device to upgrade to the latest version of windows.”</i>
         * 
         * @param processorFamilyCheckFailed
         *            value of {@code processorFamilyCheckFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processorFamilyCheckFailed(Boolean processorFamilyCheckFailed) {
            this.processorFamilyCheckFailed = processorFamilyCheckFailed;
            this.changedFields = changedFields.add("processorFamilyCheckFailed");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device, Is processor hardware speed check
         * failed for device to upgrade to the latest version of windows.”</i>
         * 
         * @param processorSpeedCheckFailed
         *            value of {@code processorSpeedCheckFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processorSpeedCheckFailed(Boolean processorSpeedCheckFailed) {
            this.processorSpeedCheckFailed = processorSpeedCheckFailed;
            this.changedFields = changedFields.add("processorSpeedCheckFailed");
            return this;
        }

        /**
         * <i>“Is the user experience analytics work from anywhere device RAM hardware check
         * failed for device to upgrade to the latest version of windows”</i>
         * 
         * @param ramCheckFailed
         *            value of {@code ramCheckFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ramCheckFailed(Boolean ramCheckFailed) {
            this.ramCheckFailed = ramCheckFailed;
            this.changedFields = changedFields.add("ramCheckFailed");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device, Is secure boot hardware check
         * failed for device to upgrade to the latest version of windows.”</i>
         * 
         * @param secureBootCheckFailed
         *            value of {@code secureBootCheckFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder secureBootCheckFailed(Boolean secureBootCheckFailed) {
            this.secureBootCheckFailed = secureBootCheckFailed;
            this.changedFields = changedFields.add("secureBootCheckFailed");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's serial number.”</i>
         * 
         * @param serialNumber
         *            value of {@code serialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device, Is storage hardware check failed
         * for device to upgrade to the latest version of windows.”</i>
         * 
         * @param storageCheckFailed
         *            value of {@code storageCheckFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageCheckFailed(Boolean storageCheckFailed) {
            this.storageCheckFailed = storageCheckFailed;
            this.changedFields = changedFields.add("storageCheckFailed");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device's tenantAttached.”</i>
         * 
         * @param tenantAttached
         *            value of {@code tenantAttached} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tenantAttached(Boolean tenantAttached) {
            this.tenantAttached = tenantAttached;
            this.changedFields = changedFields.add("tenantAttached");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere device, Is Trusted Platform Module (TPM)
         * hardware check failed for device to the latest version of upgrade to windows.”</i>
         * 
         * @param tpmCheckFailed
         *            value of {@code tpmCheckFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tpmCheckFailed(Boolean tpmCheckFailed) {
            this.tpmCheckFailed = tpmCheckFailed;
            this.changedFields = changedFields.add("tpmCheckFailed");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere windows upgrade eligibility status of
         * device.”</i>
         * 
         * @param upgradeEligibility
         *            value of {@code upgradeEligibility} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upgradeEligibility(OperatingSystemUpgradeEligibility upgradeEligibility) {
            this.upgradeEligibility = upgradeEligibility;
            this.changedFields = changedFields.add("upgradeEligibility");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere per device windows score. Valid values -1
         * .79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param windowsScore
         *            value of {@code windowsScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsScore(Double windowsScore) {
            this.windowsScore = windowsScore;
            this.changedFields = changedFields.add("windowsScore");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere per device overall score. Valid values -1
         * .79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param workFromAnywhereScore
         *            value of {@code workFromAnywhereScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder workFromAnywhereScore(Double workFromAnywhereScore) {
            this.workFromAnywhereScore = workFromAnywhereScore;
            this.changedFields = changedFields.add("workFromAnywhereScore");
            return this;
        }

        public UserExperienceAnalyticsWorkFromAnywhereDevice build() {
            UserExperienceAnalyticsWorkFromAnywhereDevice _x = new UserExperienceAnalyticsWorkFromAnywhereDevice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice";
            _x.id = id;
            _x.autoPilotProfileAssigned = autoPilotProfileAssigned;
            _x.autoPilotRegistered = autoPilotRegistered;
            _x.azureAdDeviceId = azureAdDeviceId;
            _x.azureAdJoinType = azureAdJoinType;
            _x.azureAdRegistered = azureAdRegistered;
            _x.cloudIdentityScore = cloudIdentityScore;
            _x.cloudManagementScore = cloudManagementScore;
            _x.cloudProvisioningScore = cloudProvisioningScore;
            _x.compliancePolicySetToIntune = compliancePolicySetToIntune;
            _x.deviceId = deviceId;
            _x.deviceName = deviceName;
            _x.healthStatus = healthStatus;
            _x.isCloudManagedGatewayEnabled = isCloudManagedGatewayEnabled;
            _x.managedBy = managedBy;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.osCheckFailed = osCheckFailed;
            _x.osDescription = osDescription;
            _x.osVersion = osVersion;
            _x.otherWorkloadsSetToIntune = otherWorkloadsSetToIntune;
            _x.ownership = ownership;
            _x.processor64BitCheckFailed = processor64BitCheckFailed;
            _x.processorCoreCountCheckFailed = processorCoreCountCheckFailed;
            _x.processorFamilyCheckFailed = processorFamilyCheckFailed;
            _x.processorSpeedCheckFailed = processorSpeedCheckFailed;
            _x.ramCheckFailed = ramCheckFailed;
            _x.secureBootCheckFailed = secureBootCheckFailed;
            _x.serialNumber = serialNumber;
            _x.storageCheckFailed = storageCheckFailed;
            _x.tenantAttached = tenantAttached;
            _x.tpmCheckFailed = tpmCheckFailed;
            _x.upgradeEligibility = upgradeEligibility;
            _x.windowsScore = windowsScore;
            _x.workFromAnywhereScore = workFromAnywhereScore;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The user experience analytics work from anywhere intune device's
     * autopilotProfileAssigned.”</i>
     * 
     * @return property autoPilotProfileAssigned
     */
    @Property(name="autoPilotProfileAssigned")
    @JsonIgnore
    public Optional<Boolean> getAutoPilotProfileAssigned() {
        return Optional.ofNullable(autoPilotProfileAssigned);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * autoPilotProfileAssigned} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics work from anywhere intune device's
     * autopilotProfileAssigned.”</i>
     * 
     * @param autoPilotProfileAssigned
     *            new value of {@code autoPilotProfileAssigned} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoPilotProfileAssigned} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withAutoPilotProfileAssigned(Boolean autoPilotProfileAssigned) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("autoPilotProfileAssigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.autoPilotProfileAssigned = autoPilotProfileAssigned;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere intune device's autopilotRegistered.”</i>
     * 
     * @return property autoPilotRegistered
     */
    @Property(name="autoPilotRegistered")
    @JsonIgnore
    public Optional<Boolean> getAutoPilotRegistered() {
        return Optional.ofNullable(autoPilotRegistered);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * autoPilotRegistered} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere intune device's autopilotRegistered.”</i>
     * 
     * @param autoPilotRegistered
     *            new value of {@code autoPilotRegistered} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoPilotRegistered} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withAutoPilotRegistered(Boolean autoPilotRegistered) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("autoPilotRegistered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.autoPilotRegistered = autoPilotRegistered;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere azure Ad device Id.”</i>
     * 
     * @return property azureAdDeviceId
     */
    @Property(name="azureAdDeviceId")
    @JsonIgnore
    public Optional<String> getAzureAdDeviceId() {
        return Optional.ofNullable(azureAdDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureAdDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere azure Ad device Id.”</i>
     * 
     * @param azureAdDeviceId
     *            new value of {@code azureAdDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureAdDeviceId} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withAzureAdDeviceId(String azureAdDeviceId) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("azureAdDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.azureAdDeviceId = azureAdDeviceId;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's azure Ad joinType.”</i>
     * 
     * @return property azureAdJoinType
     */
    @Property(name="azureAdJoinType")
    @JsonIgnore
    public Optional<String> getAzureAdJoinType() {
        return Optional.ofNullable(azureAdJoinType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureAdJoinType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere device's azure Ad joinType.”</i>
     * 
     * @param azureAdJoinType
     *            new value of {@code azureAdJoinType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureAdJoinType} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withAzureAdJoinType(String azureAdJoinType) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("azureAdJoinType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.azureAdJoinType = azureAdJoinType;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's azureAdRegistered.”</i>
     * 
     * @return property azureAdRegistered
     */
    @Property(name="azureAdRegistered")
    @JsonIgnore
    public Optional<Boolean> getAzureAdRegistered() {
        return Optional.ofNullable(azureAdRegistered);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureAdRegistered
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere device's azureAdRegistered.”</i>
     * 
     * @param azureAdRegistered
     *            new value of {@code azureAdRegistered} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureAdRegistered} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withAzureAdRegistered(Boolean azureAdRegistered) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("azureAdRegistered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.azureAdRegistered = azureAdRegistered;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere per device cloud identity score. Valid
     * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property cloudIdentityScore
     */
    @Property(name="cloudIdentityScore")
    @JsonIgnore
    public Optional<Double> getCloudIdentityScore() {
        return Optional.ofNullable(cloudIdentityScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cloudIdentityScore} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere per device cloud identity score. Valid
     * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param cloudIdentityScore
     *            new value of {@code cloudIdentityScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cloudIdentityScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withCloudIdentityScore(Double cloudIdentityScore) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("cloudIdentityScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.cloudIdentityScore = cloudIdentityScore;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere per device cloud management score. Valid
     * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property cloudManagementScore
     */
    @Property(name="cloudManagementScore")
    @JsonIgnore
    public Optional<Double> getCloudManagementScore() {
        return Optional.ofNullable(cloudManagementScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cloudManagementScore} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere per device cloud management score. Valid
     * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param cloudManagementScore
     *            new value of {@code cloudManagementScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cloudManagementScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withCloudManagementScore(Double cloudManagementScore) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("cloudManagementScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.cloudManagementScore = cloudManagementScore;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere per device cloud provisioning score.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property cloudProvisioningScore
     */
    @Property(name="cloudProvisioningScore")
    @JsonIgnore
    public Optional<Double> getCloudProvisioningScore() {
        return Optional.ofNullable(cloudProvisioningScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cloudProvisioningScore} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere per device cloud provisioning score.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param cloudProvisioningScore
     *            new value of {@code cloudProvisioningScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cloudProvisioningScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withCloudProvisioningScore(Double cloudProvisioningScore) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("cloudProvisioningScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.cloudProvisioningScore = cloudProvisioningScore;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's compliancePolicySetToIntune.”</i>
     * 
     * @return property compliancePolicySetToIntune
     */
    @Property(name="compliancePolicySetToIntune")
    @JsonIgnore
    public Optional<Boolean> getCompliancePolicySetToIntune() {
        return Optional.ofNullable(compliancePolicySetToIntune);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliancePolicySetToIntune} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere device's compliancePolicySetToIntune.”</i>
     * 
     * @param compliancePolicySetToIntune
     *            new value of {@code compliancePolicySetToIntune} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliancePolicySetToIntune} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withCompliancePolicySetToIntune(Boolean compliancePolicySetToIntune) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("compliancePolicySetToIntune");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.compliancePolicySetToIntune = compliancePolicySetToIntune;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device Id.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience work from anywhere device Id.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withDeviceId(String deviceId) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The work from anywhere device's name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The work from anywhere device's name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withDeviceName(String deviceName) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere per device health status”</i>
     * 
     * @return property healthStatus
     */
    @Property(name="healthStatus")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsHealthState> getHealthStatus() {
        return Optional.ofNullable(healthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code healthStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere per device health status”</i>
     * 
     * @param healthStatus
     *            new value of {@code healthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthStatus} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withHealthStatus(UserExperienceAnalyticsHealthState healthStatus) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("healthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.healthStatus = healthStatus;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's Cloud Management Gateway for
     * Configuration Manager is enabled.”</i>
     * 
     * @return property isCloudManagedGatewayEnabled
     */
    @Property(name="isCloudManagedGatewayEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsCloudManagedGatewayEnabled() {
        return Optional.ofNullable(isCloudManagedGatewayEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isCloudManagedGatewayEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere device's Cloud Management Gateway for
     * Configuration Manager is enabled.”</i>
     * 
     * @param isCloudManagedGatewayEnabled
     *            new value of {@code isCloudManagedGatewayEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isCloudManagedGatewayEnabled} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withIsCloudManagedGatewayEnabled(Boolean isCloudManagedGatewayEnabled) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("isCloudManagedGatewayEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.isCloudManagedGatewayEnabled = isCloudManagedGatewayEnabled;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere management agent of the device.”</i>
     * 
     * @return property managedBy
     */
    @Property(name="managedBy")
    @JsonIgnore
    public Optional<String> getManagedBy() {
        return Optional.ofNullable(managedBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedBy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience work from anywhere management agent of the device.”</i>
     * 
     * @param managedBy
     *            new value of {@code managedBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedBy} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withManagedBy(String managedBy) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("managedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.managedBy = managedBy;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's manufacturer.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere device's manufacturer.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withManufacturer(String manufacturer) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's model.”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience work from anywhere device's model.”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withModel(String model) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device, Is OS check failed for device to
     * upgrade to the latest version of windows.”</i>
     * 
     * @return property osCheckFailed
     */
    @Property(name="osCheckFailed")
    @JsonIgnore
    public Optional<Boolean> getOsCheckFailed() {
        return Optional.ofNullable(osCheckFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osCheckFailed}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere device, Is OS check failed for device to
     * upgrade to the latest version of windows.”</i>
     * 
     * @param osCheckFailed
     *            new value of {@code osCheckFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osCheckFailed} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withOsCheckFailed(Boolean osCheckFailed) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("osCheckFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.osCheckFailed = osCheckFailed;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's OS Description.”</i>
     * 
     * @return property osDescription
     */
    @Property(name="osDescription")
    @JsonIgnore
    public Optional<String> getOsDescription() {
        return Optional.ofNullable(osDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osDescription}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere device's OS Description.”</i>
     * 
     * @param osDescription
     *            new value of {@code osDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osDescription} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withOsDescription(String osDescription) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("osDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.osDescription = osDescription;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's OS Version.”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience work from anywhere device's OS Version.”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withOsVersion(String osVersion) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's otherWorkloadsSetToIntune.”</i>
     * 
     * @return property otherWorkloadsSetToIntune
     */
    @Property(name="otherWorkloadsSetToIntune")
    @JsonIgnore
    public Optional<Boolean> getOtherWorkloadsSetToIntune() {
        return Optional.ofNullable(otherWorkloadsSetToIntune);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * otherWorkloadsSetToIntune} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere device's otherWorkloadsSetToIntune.”</i>
     * 
     * @param otherWorkloadsSetToIntune
     *            new value of {@code otherWorkloadsSetToIntune} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code otherWorkloadsSetToIntune} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withOtherWorkloadsSetToIntune(Boolean otherWorkloadsSetToIntune) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("otherWorkloadsSetToIntune");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.otherWorkloadsSetToIntune = otherWorkloadsSetToIntune;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's ownership.”</i>
     * 
     * @return property ownership
     */
    @Property(name="ownership")
    @JsonIgnore
    public Optional<String> getOwnership() {
        return Optional.ofNullable(ownership);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ownership} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience work from anywhere device's ownership.”</i>
     * 
     * @param ownership
     *            new value of {@code ownership} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownership} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withOwnership(String ownership) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("ownership");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.ownership = ownership;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device, Is processor hardware 64-bit
     * architecture check failed for device to upgrade to the latest version of windows
     * .”</i>
     * 
     * @return property processor64BitCheckFailed
     */
    @Property(name="processor64BitCheckFailed")
    @JsonIgnore
    public Optional<Boolean> getProcessor64BitCheckFailed() {
        return Optional.ofNullable(processor64BitCheckFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * processor64BitCheckFailed} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere device, Is processor hardware 64-bit
     * architecture check failed for device to upgrade to the latest version of windows
     * .”</i>
     * 
     * @param processor64BitCheckFailed
     *            new value of {@code processor64BitCheckFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processor64BitCheckFailed} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withProcessor64BitCheckFailed(Boolean processor64BitCheckFailed) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("processor64BitCheckFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.processor64BitCheckFailed = processor64BitCheckFailed;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device, Is processor hardware core count
     * check failed for device to upgrade to the latest version of windows.”</i>
     * 
     * @return property processorCoreCountCheckFailed
     */
    @Property(name="processorCoreCountCheckFailed")
    @JsonIgnore
    public Optional<Boolean> getProcessorCoreCountCheckFailed() {
        return Optional.ofNullable(processorCoreCountCheckFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * processorCoreCountCheckFailed} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere device, Is processor hardware core count
     * check failed for device to upgrade to the latest version of windows.”</i>
     * 
     * @param processorCoreCountCheckFailed
     *            new value of {@code processorCoreCountCheckFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processorCoreCountCheckFailed} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withProcessorCoreCountCheckFailed(Boolean processorCoreCountCheckFailed) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("processorCoreCountCheckFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.processorCoreCountCheckFailed = processorCoreCountCheckFailed;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device, Is processor hardware family
     * check failed for device to upgrade to the latest version of windows.”</i>
     * 
     * @return property processorFamilyCheckFailed
     */
    @Property(name="processorFamilyCheckFailed")
    @JsonIgnore
    public Optional<Boolean> getProcessorFamilyCheckFailed() {
        return Optional.ofNullable(processorFamilyCheckFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * processorFamilyCheckFailed} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere device, Is processor hardware family
     * check failed for device to upgrade to the latest version of windows.”</i>
     * 
     * @param processorFamilyCheckFailed
     *            new value of {@code processorFamilyCheckFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processorFamilyCheckFailed} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withProcessorFamilyCheckFailed(Boolean processorFamilyCheckFailed) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("processorFamilyCheckFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.processorFamilyCheckFailed = processorFamilyCheckFailed;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device, Is processor hardware speed check
     * failed for device to upgrade to the latest version of windows.”</i>
     * 
     * @return property processorSpeedCheckFailed
     */
    @Property(name="processorSpeedCheckFailed")
    @JsonIgnore
    public Optional<Boolean> getProcessorSpeedCheckFailed() {
        return Optional.ofNullable(processorSpeedCheckFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * processorSpeedCheckFailed} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere device, Is processor hardware speed check
     * failed for device to upgrade to the latest version of windows.”</i>
     * 
     * @param processorSpeedCheckFailed
     *            new value of {@code processorSpeedCheckFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processorSpeedCheckFailed} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withProcessorSpeedCheckFailed(Boolean processorSpeedCheckFailed) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("processorSpeedCheckFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.processorSpeedCheckFailed = processorSpeedCheckFailed;
        return _x;
    }

    /**
     * <i>“Is the user experience analytics work from anywhere device RAM hardware check
     * failed for device to upgrade to the latest version of windows”</i>
     * 
     * @return property ramCheckFailed
     */
    @Property(name="ramCheckFailed")
    @JsonIgnore
    public Optional<Boolean> getRamCheckFailed() {
        return Optional.ofNullable(ramCheckFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ramCheckFailed}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Is the user experience analytics work from anywhere device RAM hardware check
     * failed for device to upgrade to the latest version of windows”</i>
     * 
     * @param ramCheckFailed
     *            new value of {@code ramCheckFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ramCheckFailed} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withRamCheckFailed(Boolean ramCheckFailed) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("ramCheckFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.ramCheckFailed = ramCheckFailed;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device, Is secure boot hardware check
     * failed for device to upgrade to the latest version of windows.”</i>
     * 
     * @return property secureBootCheckFailed
     */
    @Property(name="secureBootCheckFailed")
    @JsonIgnore
    public Optional<Boolean> getSecureBootCheckFailed() {
        return Optional.ofNullable(secureBootCheckFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * secureBootCheckFailed} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere device, Is secure boot hardware check
     * failed for device to upgrade to the latest version of windows.”</i>
     * 
     * @param secureBootCheckFailed
     *            new value of {@code secureBootCheckFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secureBootCheckFailed} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withSecureBootCheckFailed(Boolean secureBootCheckFailed) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("secureBootCheckFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.secureBootCheckFailed = secureBootCheckFailed;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's serial number.”</i>
     * 
     * @return property serialNumber
     */
    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serialNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere device's serial number.”</i>
     * 
     * @param serialNumber
     *            new value of {@code serialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serialNumber} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withSerialNumber(String serialNumber) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("serialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.serialNumber = serialNumber;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device, Is storage hardware check failed
     * for device to upgrade to the latest version of windows.”</i>
     * 
     * @return property storageCheckFailed
     */
    @Property(name="storageCheckFailed")
    @JsonIgnore
    public Optional<Boolean> getStorageCheckFailed() {
        return Optional.ofNullable(storageCheckFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageCheckFailed} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere device, Is storage hardware check failed
     * for device to upgrade to the latest version of windows.”</i>
     * 
     * @param storageCheckFailed
     *            new value of {@code storageCheckFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageCheckFailed} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withStorageCheckFailed(Boolean storageCheckFailed) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("storageCheckFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.storageCheckFailed = storageCheckFailed;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device's tenantAttached.”</i>
     * 
     * @return property tenantAttached
     */
    @Property(name="tenantAttached")
    @JsonIgnore
    public Optional<Boolean> getTenantAttached() {
        return Optional.ofNullable(tenantAttached);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tenantAttached}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere device's tenantAttached.”</i>
     * 
     * @param tenantAttached
     *            new value of {@code tenantAttached} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tenantAttached} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withTenantAttached(Boolean tenantAttached) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("tenantAttached");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.tenantAttached = tenantAttached;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere device, Is Trusted Platform Module (TPM)
     * hardware check failed for device to the latest version of upgrade to windows.”</i>
     * 
     * @return property tpmCheckFailed
     */
    @Property(name="tpmCheckFailed")
    @JsonIgnore
    public Optional<Boolean> getTpmCheckFailed() {
        return Optional.ofNullable(tpmCheckFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tpmCheckFailed}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere device, Is Trusted Platform Module (TPM)
     * hardware check failed for device to the latest version of upgrade to windows.”</i>
     * 
     * @param tpmCheckFailed
     *            new value of {@code tpmCheckFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tpmCheckFailed} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withTpmCheckFailed(Boolean tpmCheckFailed) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("tpmCheckFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.tpmCheckFailed = tpmCheckFailed;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere windows upgrade eligibility status of
     * device.”</i>
     * 
     * @return property upgradeEligibility
     */
    @Property(name="upgradeEligibility")
    @JsonIgnore
    public Optional<OperatingSystemUpgradeEligibility> getUpgradeEligibility() {
        return Optional.ofNullable(upgradeEligibility);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * upgradeEligibility} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere windows upgrade eligibility status of
     * device.”</i>
     * 
     * @param upgradeEligibility
     *            new value of {@code upgradeEligibility} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upgradeEligibility} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withUpgradeEligibility(OperatingSystemUpgradeEligibility upgradeEligibility) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("upgradeEligibility");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.upgradeEligibility = upgradeEligibility;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere per device windows score. Valid values -1
     * .79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property windowsScore
     */
    @Property(name="windowsScore")
    @JsonIgnore
    public Optional<Double> getWindowsScore() {
        return Optional.ofNullable(windowsScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code windowsScore}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience work from anywhere per device windows score. Valid values -1
     * .79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param windowsScore
     *            new value of {@code windowsScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withWindowsScore(Double windowsScore) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("windowsScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.windowsScore = windowsScore;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere per device overall score. Valid values -1
     * .79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property workFromAnywhereScore
     */
    @Property(name="workFromAnywhereScore")
    @JsonIgnore
    public Optional<Double> getWorkFromAnywhereScore() {
        return Optional.ofNullable(workFromAnywhereScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * workFromAnywhereScore} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere per device overall score. Valid values -1
     * .79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param workFromAnywhereScore
     *            new value of {@code workFromAnywhereScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code workFromAnywhereScore} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice withWorkFromAnywhereScore(Double workFromAnywhereScore) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = changedFields.add("workFromAnywhereScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevice");
        _x.workFromAnywhereScore = workFromAnywhereScore;
        return _x;
    }

    public UserExperienceAnalyticsWorkFromAnywhereDevice withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsWorkFromAnywhereDevice _copy() {
        UserExperienceAnalyticsWorkFromAnywhereDevice _x = new UserExperienceAnalyticsWorkFromAnywhereDevice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.autoPilotProfileAssigned = autoPilotProfileAssigned;
        _x.autoPilotRegistered = autoPilotRegistered;
        _x.azureAdDeviceId = azureAdDeviceId;
        _x.azureAdJoinType = azureAdJoinType;
        _x.azureAdRegistered = azureAdRegistered;
        _x.cloudIdentityScore = cloudIdentityScore;
        _x.cloudManagementScore = cloudManagementScore;
        _x.cloudProvisioningScore = cloudProvisioningScore;
        _x.compliancePolicySetToIntune = compliancePolicySetToIntune;
        _x.deviceId = deviceId;
        _x.deviceName = deviceName;
        _x.healthStatus = healthStatus;
        _x.isCloudManagedGatewayEnabled = isCloudManagedGatewayEnabled;
        _x.managedBy = managedBy;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.osCheckFailed = osCheckFailed;
        _x.osDescription = osDescription;
        _x.osVersion = osVersion;
        _x.otherWorkloadsSetToIntune = otherWorkloadsSetToIntune;
        _x.ownership = ownership;
        _x.processor64BitCheckFailed = processor64BitCheckFailed;
        _x.processorCoreCountCheckFailed = processorCoreCountCheckFailed;
        _x.processorFamilyCheckFailed = processorFamilyCheckFailed;
        _x.processorSpeedCheckFailed = processorSpeedCheckFailed;
        _x.ramCheckFailed = ramCheckFailed;
        _x.secureBootCheckFailed = secureBootCheckFailed;
        _x.serialNumber = serialNumber;
        _x.storageCheckFailed = storageCheckFailed;
        _x.tenantAttached = tenantAttached;
        _x.tpmCheckFailed = tpmCheckFailed;
        _x.upgradeEligibility = upgradeEligibility;
        _x.windowsScore = windowsScore;
        _x.workFromAnywhereScore = workFromAnywhereScore;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsWorkFromAnywhereDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("autoPilotProfileAssigned=");
        b.append(this.autoPilotProfileAssigned);
        b.append(", ");
        b.append("autoPilotRegistered=");
        b.append(this.autoPilotRegistered);
        b.append(", ");
        b.append("azureAdDeviceId=");
        b.append(this.azureAdDeviceId);
        b.append(", ");
        b.append("azureAdJoinType=");
        b.append(this.azureAdJoinType);
        b.append(", ");
        b.append("azureAdRegistered=");
        b.append(this.azureAdRegistered);
        b.append(", ");
        b.append("cloudIdentityScore=");
        b.append(this.cloudIdentityScore);
        b.append(", ");
        b.append("cloudManagementScore=");
        b.append(this.cloudManagementScore);
        b.append(", ");
        b.append("cloudProvisioningScore=");
        b.append(this.cloudProvisioningScore);
        b.append(", ");
        b.append("compliancePolicySetToIntune=");
        b.append(this.compliancePolicySetToIntune);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("healthStatus=");
        b.append(this.healthStatus);
        b.append(", ");
        b.append("isCloudManagedGatewayEnabled=");
        b.append(this.isCloudManagedGatewayEnabled);
        b.append(", ");
        b.append("managedBy=");
        b.append(this.managedBy);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("osCheckFailed=");
        b.append(this.osCheckFailed);
        b.append(", ");
        b.append("osDescription=");
        b.append(this.osDescription);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("otherWorkloadsSetToIntune=");
        b.append(this.otherWorkloadsSetToIntune);
        b.append(", ");
        b.append("ownership=");
        b.append(this.ownership);
        b.append(", ");
        b.append("processor64BitCheckFailed=");
        b.append(this.processor64BitCheckFailed);
        b.append(", ");
        b.append("processorCoreCountCheckFailed=");
        b.append(this.processorCoreCountCheckFailed);
        b.append(", ");
        b.append("processorFamilyCheckFailed=");
        b.append(this.processorFamilyCheckFailed);
        b.append(", ");
        b.append("processorSpeedCheckFailed=");
        b.append(this.processorSpeedCheckFailed);
        b.append(", ");
        b.append("ramCheckFailed=");
        b.append(this.ramCheckFailed);
        b.append(", ");
        b.append("secureBootCheckFailed=");
        b.append(this.secureBootCheckFailed);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("storageCheckFailed=");
        b.append(this.storageCheckFailed);
        b.append(", ");
        b.append("tenantAttached=");
        b.append(this.tenantAttached);
        b.append(", ");
        b.append("tpmCheckFailed=");
        b.append(this.tpmCheckFailed);
        b.append(", ");
        b.append("upgradeEligibility=");
        b.append(this.upgradeEligibility);
        b.append(", ");
        b.append("windowsScore=");
        b.append(this.windowsScore);
        b.append(", ");
        b.append("workFromAnywhereScore=");
        b.append(this.workFromAnywhereScore);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
