package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsMetricCollectionRequest;
import odata.msgraph.client.beta.enums.UserExperienceAnalyticsSummarizedBy;


/**
 * <i>“The user experience analytics Regression Summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "manufacturerRegression", 
    "modelRegression", 
    "operatingSystemRegression"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsRegressionSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsRegressionSummary";
    }

    @JsonProperty("manufacturerRegression")
    protected List<UserExperienceAnalyticsMetric> manufacturerRegression;

    @JsonProperty("modelRegression")
    protected List<UserExperienceAnalyticsMetric> modelRegression;

    @JsonProperty("operatingSystemRegression")
    protected List<UserExperienceAnalyticsMetric> operatingSystemRegression;

    protected UserExperienceAnalyticsRegressionSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsRegressionSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<UserExperienceAnalyticsMetric> manufacturerRegression;
        private List<UserExperienceAnalyticsMetric> modelRegression;
        private List<UserExperienceAnalyticsMetric> operatingSystemRegression;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The metric values for the user experience analytics Manufacturer regression.”</i>
         * 
         * @param manufacturerRegression
         *            value of {@code manufacturerRegression} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturerRegression(List<UserExperienceAnalyticsMetric> manufacturerRegression) {
            this.manufacturerRegression = manufacturerRegression;
            this.changedFields = changedFields.add("manufacturerRegression");
            return this;
        }

        /**
         * <i>“The metric values for the user experience analytics Manufacturer regression.”</i>
         * 
         * @param manufacturerRegression
         *            value of {@code manufacturerRegression} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturerRegression(UserExperienceAnalyticsMetric... manufacturerRegression) {
            return manufacturerRegression(Arrays.asList(manufacturerRegression));
        }

        /**
         * <i>“The metric values for the user experience analytics model regression.”</i>
         * 
         * @param modelRegression
         *            value of {@code modelRegression} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modelRegression(List<UserExperienceAnalyticsMetric> modelRegression) {
            this.modelRegression = modelRegression;
            this.changedFields = changedFields.add("modelRegression");
            return this;
        }

        /**
         * <i>“The metric values for the user experience analytics model regression.”</i>
         * 
         * @param modelRegression
         *            value of {@code modelRegression} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modelRegression(UserExperienceAnalyticsMetric... modelRegression) {
            return modelRegression(Arrays.asList(modelRegression));
        }

        /**
         * <i>“The metric values for the user experience analytics operating system regression.”</i>
         * 
         * @param operatingSystemRegression
         *            value of {@code operatingSystemRegression} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemRegression(List<UserExperienceAnalyticsMetric> operatingSystemRegression) {
            this.operatingSystemRegression = operatingSystemRegression;
            this.changedFields = changedFields.add("operatingSystemRegression");
            return this;
        }

        /**
         * <i>“The metric values for the user experience analytics operating system regression.”</i>
         * 
         * @param operatingSystemRegression
         *            value of {@code operatingSystemRegression} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemRegression(UserExperienceAnalyticsMetric... operatingSystemRegression) {
            return operatingSystemRegression(Arrays.asList(operatingSystemRegression));
        }

        public UserExperienceAnalyticsRegressionSummary build() {
            UserExperienceAnalyticsRegressionSummary _x = new UserExperienceAnalyticsRegressionSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsRegressionSummary";
            _x.id = id;
            _x.manufacturerRegression = manufacturerRegression;
            _x.modelRegression = modelRegression;
            _x.operatingSystemRegression = operatingSystemRegression;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public UserExperienceAnalyticsRegressionSummary withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsRegressionSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The metric values for the user experience analytics Manufacturer regression.”</i>
     * 
     * @return navigational property manufacturerRegression
     */
    @NavigationProperty(name="manufacturerRegression")
    @JsonIgnore
    public UserExperienceAnalyticsMetricCollectionRequest getManufacturerRegression() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("manufacturerRegression"), Optional.ofNullable(manufacturerRegression));
    }

    /**
     * <i>“The metric values for the user experience analytics model regression.”</i>
     * 
     * @return navigational property modelRegression
     */
    @NavigationProperty(name="modelRegression")
    @JsonIgnore
    public UserExperienceAnalyticsMetricCollectionRequest getModelRegression() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("modelRegression"), Optional.ofNullable(modelRegression));
    }

    /**
     * <i>“The metric values for the user experience analytics operating system regression.”</i>
     * 
     * @return navigational property operatingSystemRegression
     */
    @NavigationProperty(name="operatingSystemRegression")
    @JsonIgnore
    public UserExperienceAnalyticsMetricCollectionRequest getOperatingSystemRegression() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("operatingSystemRegression"), Optional.ofNullable(operatingSystemRegression));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * manufacturerRegression} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The metric values for the user experience analytics Manufacturer regression.”</i>
     * 
     * @param manufacturerRegression
     *            new value of {@code manufacturerRegression} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturerRegression} field changed
     */
    public UserExperienceAnalyticsRegressionSummary withManufacturerRegression(List<UserExperienceAnalyticsMetric> manufacturerRegression) {
        UserExperienceAnalyticsRegressionSummary _x = _copy();
        _x.changedFields = changedFields.add("manufacturerRegression");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsRegressionSummary");
        _x.manufacturerRegression = manufacturerRegression;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code modelRegression}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The metric values for the user experience analytics model regression.”</i>
     * 
     * @param modelRegression
     *            new value of {@code modelRegression} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modelRegression} field changed
     */
    public UserExperienceAnalyticsRegressionSummary withModelRegression(List<UserExperienceAnalyticsMetric> modelRegression) {
        UserExperienceAnalyticsRegressionSummary _x = _copy();
        _x.changedFields = changedFields.add("modelRegression");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsRegressionSummary");
        _x.modelRegression = modelRegression;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemRegression} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The metric values for the user experience analytics operating system regression.”</i>
     * 
     * @param operatingSystemRegression
     *            new value of {@code operatingSystemRegression} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemRegression} field changed
     */
    public UserExperienceAnalyticsRegressionSummary withOperatingSystemRegression(List<UserExperienceAnalyticsMetric> operatingSystemRegression) {
        UserExperienceAnalyticsRegressionSummary _x = _copy();
        _x.changedFields = changedFields.add("operatingSystemRegression");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsRegressionSummary");
        _x.operatingSystemRegression = operatingSystemRegression;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsRegressionSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsRegressionSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsRegressionSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsRegressionSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsRegressionSummary _copy() {
        UserExperienceAnalyticsRegressionSummary _x = new UserExperienceAnalyticsRegressionSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.manufacturerRegression = manufacturerRegression;
        _x.modelRegression = modelRegression;
        _x.operatingSystemRegression = operatingSystemRegression;
        return _x;
    }

    @Function(name = "summarizeDeviceRegressionPerformance")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsRegressionSummary> summarizeDeviceRegressionPerformance(UserExperienceAnalyticsSummarizedBy summarizeBy) {
        Preconditions.checkNotNull(summarizeBy, "summarizeBy cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("summarizeBy", "microsoft.graph.userExperienceAnalyticsSummarizedBy", summarizeBy)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsRegressionSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.summarizeDeviceRegressionPerformance"), UserExperienceAnalyticsRegressionSummary.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsRegressionSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("manufacturerRegression=");
        b.append(this.manufacturerRegression);
        b.append(", ");
        b.append("modelRegression=");
        b.append(this.modelRegression);
        b.append(", ");
        b.append("operatingSystemRegression=");
        b.append(this.operatingSystemRegression);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
