package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics Device not windows autopilot ready.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "autoPilotProfileAssigned", 
    "autoPilotRegistered", 
    "azureAdJoinType", 
    "azureAdRegistered", 
    "deviceName", 
    "managedBy", 
    "manufacturer", 
    "model", 
    "serialNumber"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsNotAutopilotReadyDevice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice";
    }

    @JsonProperty("autoPilotProfileAssigned")
    protected Boolean autoPilotProfileAssigned;

    @JsonProperty("autoPilotRegistered")
    protected Boolean autoPilotRegistered;

    @JsonProperty("azureAdJoinType")
    protected String azureAdJoinType;

    @JsonProperty("azureAdRegistered")
    protected Boolean azureAdRegistered;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("managedBy")
    protected String managedBy;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    protected UserExperienceAnalyticsNotAutopilotReadyDevice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsNotAutopilotReadyDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean autoPilotProfileAssigned;
        private Boolean autoPilotRegistered;
        private String azureAdJoinType;
        private Boolean azureAdRegistered;
        private String deviceName;
        private String managedBy;
        private String manufacturer;
        private String model;
        private String serialNumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The intune device's autopilotProfileAssigned.”</i>
         * 
         * @param autoPilotProfileAssigned
         *            value of {@code autoPilotProfileAssigned} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoPilotProfileAssigned(Boolean autoPilotProfileAssigned) {
            this.autoPilotProfileAssigned = autoPilotProfileAssigned;
            this.changedFields = changedFields.add("autoPilotProfileAssigned");
            return this;
        }

        /**
         * <i>“The intune device's autopilotRegistered.”</i>
         * 
         * @param autoPilotRegistered
         *            value of {@code autoPilotRegistered} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoPilotRegistered(Boolean autoPilotRegistered) {
            this.autoPilotRegistered = autoPilotRegistered;
            this.changedFields = changedFields.add("autoPilotRegistered");
            return this;
        }

        /**
         * <i>“The intune device's azure Ad joinType.”</i>
         * 
         * @param azureAdJoinType
         *            value of {@code azureAdJoinType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureAdJoinType(String azureAdJoinType) {
            this.azureAdJoinType = azureAdJoinType;
            this.changedFields = changedFields.add("azureAdJoinType");
            return this;
        }

        /**
         * <i>“The intune device's azureAdRegistered.”</i>
         * 
         * @param azureAdRegistered
         *            value of {@code azureAdRegistered} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureAdRegistered(Boolean azureAdRegistered) {
            this.azureAdRegistered = azureAdRegistered;
            this.changedFields = changedFields.add("azureAdRegistered");
            return this;
        }

        /**
         * <i>“The intune device's name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“The intune device's managed by.”</i>
         * 
         * @param managedBy
         *            value of {@code managedBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            this.changedFields = changedFields.add("managedBy");
            return this;
        }

        /**
         * <i>“The intune device's manufacturer.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“The intune device's model.”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“The intune device's serial number.”</i>
         * 
         * @param serialNumber
         *            value of {@code serialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        public UserExperienceAnalyticsNotAutopilotReadyDevice build() {
            UserExperienceAnalyticsNotAutopilotReadyDevice _x = new UserExperienceAnalyticsNotAutopilotReadyDevice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice";
            _x.id = id;
            _x.autoPilotProfileAssigned = autoPilotProfileAssigned;
            _x.autoPilotRegistered = autoPilotRegistered;
            _x.azureAdJoinType = azureAdJoinType;
            _x.azureAdRegistered = azureAdRegistered;
            _x.deviceName = deviceName;
            _x.managedBy = managedBy;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.serialNumber = serialNumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The intune device's autopilotProfileAssigned.”</i>
     * 
     * @return property autoPilotProfileAssigned
     */
    @Property(name="autoPilotProfileAssigned")
    @JsonIgnore
    public Optional<Boolean> getAutoPilotProfileAssigned() {
        return Optional.ofNullable(autoPilotProfileAssigned);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * autoPilotProfileAssigned} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The intune device's autopilotProfileAssigned.”</i>
     * 
     * @param autoPilotProfileAssigned
     *            new value of {@code autoPilotProfileAssigned} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoPilotProfileAssigned} field changed
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice withAutoPilotProfileAssigned(Boolean autoPilotProfileAssigned) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = changedFields.add("autoPilotProfileAssigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.autoPilotProfileAssigned = autoPilotProfileAssigned;
        return _x;
    }

    /**
     * <i>“The intune device's autopilotRegistered.”</i>
     * 
     * @return property autoPilotRegistered
     */
    @Property(name="autoPilotRegistered")
    @JsonIgnore
    public Optional<Boolean> getAutoPilotRegistered() {
        return Optional.ofNullable(autoPilotRegistered);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * autoPilotRegistered} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The intune device's autopilotRegistered.”</i>
     * 
     * @param autoPilotRegistered
     *            new value of {@code autoPilotRegistered} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoPilotRegistered} field changed
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice withAutoPilotRegistered(Boolean autoPilotRegistered) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = changedFields.add("autoPilotRegistered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.autoPilotRegistered = autoPilotRegistered;
        return _x;
    }

    /**
     * <i>“The intune device's azure Ad joinType.”</i>
     * 
     * @return property azureAdJoinType
     */
    @Property(name="azureAdJoinType")
    @JsonIgnore
    public Optional<String> getAzureAdJoinType() {
        return Optional.ofNullable(azureAdJoinType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureAdJoinType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The intune device's azure Ad joinType.”</i>
     * 
     * @param azureAdJoinType
     *            new value of {@code azureAdJoinType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureAdJoinType} field changed
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice withAzureAdJoinType(String azureAdJoinType) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = changedFields.add("azureAdJoinType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.azureAdJoinType = azureAdJoinType;
        return _x;
    }

    /**
     * <i>“The intune device's azureAdRegistered.”</i>
     * 
     * @return property azureAdRegistered
     */
    @Property(name="azureAdRegistered")
    @JsonIgnore
    public Optional<Boolean> getAzureAdRegistered() {
        return Optional.ofNullable(azureAdRegistered);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureAdRegistered
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The intune device's azureAdRegistered.”</i>
     * 
     * @param azureAdRegistered
     *            new value of {@code azureAdRegistered} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureAdRegistered} field changed
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice withAzureAdRegistered(Boolean azureAdRegistered) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = changedFields.add("azureAdRegistered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.azureAdRegistered = azureAdRegistered;
        return _x;
    }

    /**
     * <i>“The intune device's name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The intune device's name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice withDeviceName(String deviceName) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“The intune device's managed by.”</i>
     * 
     * @return property managedBy
     */
    @Property(name="managedBy")
    @JsonIgnore
    public Optional<String> getManagedBy() {
        return Optional.ofNullable(managedBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedBy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The intune device's managed by.”</i>
     * 
     * @param managedBy
     *            new value of {@code managedBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedBy} field changed
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice withManagedBy(String managedBy) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = changedFields.add("managedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.managedBy = managedBy;
        return _x;
    }

    /**
     * <i>“The intune device's manufacturer.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The intune device's manufacturer.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice withManufacturer(String manufacturer) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“The intune device's model.”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The intune device's model.”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice withModel(String model) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“The intune device's serial number.”</i>
     * 
     * @return property serialNumber
     */
    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serialNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The intune device's serial number.”</i>
     * 
     * @param serialNumber
     *            new value of {@code serialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serialNumber} field changed
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice withSerialNumber(String serialNumber) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = changedFields.add("serialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.serialNumber = serialNumber;
        return _x;
    }

    public UserExperienceAnalyticsNotAutopilotReadyDevice withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsNotAutopilotReadyDevice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsNotAutopilotReadyDevice _copy() {
        UserExperienceAnalyticsNotAutopilotReadyDevice _x = new UserExperienceAnalyticsNotAutopilotReadyDevice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.autoPilotProfileAssigned = autoPilotProfileAssigned;
        _x.autoPilotRegistered = autoPilotRegistered;
        _x.azureAdJoinType = azureAdJoinType;
        _x.azureAdRegistered = azureAdRegistered;
        _x.deviceName = deviceName;
        _x.managedBy = managedBy;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.serialNumber = serialNumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsNotAutopilotReadyDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("autoPilotProfileAssigned=");
        b.append(this.autoPilotProfileAssigned);
        b.append(", ");
        b.append("autoPilotRegistered=");
        b.append(this.autoPilotRegistered);
        b.append(", ");
        b.append("azureAdJoinType=");
        b.append(this.azureAdJoinType);
        b.append(", ");
        b.append("azureAdRegistered=");
        b.append(this.azureAdRegistered);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("managedBy=");
        b.append(this.managedBy);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
