package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“The user experience analytics battery health runtime entity contains count of
 * devices broken down into 3 categories - devices with runtime &amp;gt; 5 hours, devices
 * with runtime 3-5 hours and devices with runtime &amp;lt; 3 hours.This API provides the
 * count of devices in these 3 categories.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeDevices", 
    "batteryRuntimeFair", 
    "batteryRuntimeGood", 
    "batteryRuntimePoor", 
    "lastRefreshedDateTime"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsBatteryHealthRuntimeDetails extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsBatteryHealthRuntimeDetails";
    }

    @JsonProperty("activeDevices")
    protected Integer activeDevices;

    @JsonProperty("batteryRuntimeFair")
    protected Integer batteryRuntimeFair;

    @JsonProperty("batteryRuntimeGood")
    protected Integer batteryRuntimeGood;

    @JsonProperty("batteryRuntimePoor")
    protected Integer batteryRuntimePoor;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    protected UserExperienceAnalyticsBatteryHealthRuntimeDetails() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsBatteryHealthRuntimeDetails() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer activeDevices;
        private Integer batteryRuntimeFair;
        private Integer batteryRuntimeGood;
        private Integer batteryRuntimePoor;
        private OffsetDateTime lastRefreshedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of active devices within the tenant. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param activeDevices
         *            value of {@code activeDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeDevices(Integer activeDevices) {
            this.activeDevices = activeDevices;
            this.changedFields = changedFields.add("activeDevices");
            return this;
        }

        /**
         * <i>“Number of devices whose active runtime is greater than 3 hours but lesser than 5
         * hours. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param batteryRuntimeFair
         *            value of {@code batteryRuntimeFair} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryRuntimeFair(Integer batteryRuntimeFair) {
            this.batteryRuntimeFair = batteryRuntimeFair;
            this.changedFields = changedFields.add("batteryRuntimeFair");
            return this;
        }

        /**
         * <i>“Number of devices  whose active runtime is greater than 5 hours. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param batteryRuntimeGood
         *            value of {@code batteryRuntimeGood} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryRuntimeGood(Integer batteryRuntimeGood) {
            this.batteryRuntimeGood = batteryRuntimeGood;
            this.changedFields = changedFields.add("batteryRuntimeGood");
            return this;
        }

        /**
         * <i>“Number of devices whose active runtime is lesser than 3 hours. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param batteryRuntimePoor
         *            value of {@code batteryRuntimePoor} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryRuntimePoor(Integer batteryRuntimePoor) {
            this.batteryRuntimePoor = batteryRuntimePoor;
            this.changedFields = changedFields.add("batteryRuntimePoor");
            return this;
        }

        /**
         * <i>“Recorded date time of this runtime details instance.”</i>
         * 
         * @param lastRefreshedDateTime
         *            value of {@code lastRefreshedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public UserExperienceAnalyticsBatteryHealthRuntimeDetails build() {
            UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = new UserExperienceAnalyticsBatteryHealthRuntimeDetails();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsBatteryHealthRuntimeDetails";
            _x.id = id;
            _x.activeDevices = activeDevices;
            _x.batteryRuntimeFair = batteryRuntimeFair;
            _x.batteryRuntimeGood = batteryRuntimeGood;
            _x.batteryRuntimePoor = batteryRuntimePoor;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of active devices within the tenant. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property activeDevices
     */
    @Property(name="activeDevices")
    @JsonIgnore
    public Optional<Integer> getActiveDevices() {
        return Optional.ofNullable(activeDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of active devices within the tenant. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param activeDevices
     *            new value of {@code activeDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDevices} field changed
     */
    public UserExperienceAnalyticsBatteryHealthRuntimeDetails withActiveDevices(Integer activeDevices) {
        UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = _copy();
        _x.changedFields = changedFields.add("activeDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthRuntimeDetails");
        _x.activeDevices = activeDevices;
        return _x;
    }

    /**
     * <i>“Number of devices whose active runtime is greater than 3 hours but lesser than 5
     * hours. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property batteryRuntimeFair
     */
    @Property(name="batteryRuntimeFair")
    @JsonIgnore
    public Optional<Integer> getBatteryRuntimeFair() {
        return Optional.ofNullable(batteryRuntimeFair);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batteryRuntimeFair} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices whose active runtime is greater than 3 hours but lesser than 5
     * hours. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param batteryRuntimeFair
     *            new value of {@code batteryRuntimeFair} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryRuntimeFair} field changed
     */
    public UserExperienceAnalyticsBatteryHealthRuntimeDetails withBatteryRuntimeFair(Integer batteryRuntimeFair) {
        UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = _copy();
        _x.changedFields = changedFields.add("batteryRuntimeFair");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthRuntimeDetails");
        _x.batteryRuntimeFair = batteryRuntimeFair;
        return _x;
    }

    /**
     * <i>“Number of devices  whose active runtime is greater than 5 hours. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property batteryRuntimeGood
     */
    @Property(name="batteryRuntimeGood")
    @JsonIgnore
    public Optional<Integer> getBatteryRuntimeGood() {
        return Optional.ofNullable(batteryRuntimeGood);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batteryRuntimeGood} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices  whose active runtime is greater than 5 hours. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param batteryRuntimeGood
     *            new value of {@code batteryRuntimeGood} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryRuntimeGood} field changed
     */
    public UserExperienceAnalyticsBatteryHealthRuntimeDetails withBatteryRuntimeGood(Integer batteryRuntimeGood) {
        UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = _copy();
        _x.changedFields = changedFields.add("batteryRuntimeGood");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthRuntimeDetails");
        _x.batteryRuntimeGood = batteryRuntimeGood;
        return _x;
    }

    /**
     * <i>“Number of devices whose active runtime is lesser than 3 hours. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property batteryRuntimePoor
     */
    @Property(name="batteryRuntimePoor")
    @JsonIgnore
    public Optional<Integer> getBatteryRuntimePoor() {
        return Optional.ofNullable(batteryRuntimePoor);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batteryRuntimePoor} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices whose active runtime is lesser than 3 hours. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param batteryRuntimePoor
     *            new value of {@code batteryRuntimePoor} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryRuntimePoor} field changed
     */
    public UserExperienceAnalyticsBatteryHealthRuntimeDetails withBatteryRuntimePoor(Integer batteryRuntimePoor) {
        UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = _copy();
        _x.changedFields = changedFields.add("batteryRuntimePoor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthRuntimeDetails");
        _x.batteryRuntimePoor = batteryRuntimePoor;
        return _x;
    }

    /**
     * <i>“Recorded date time of this runtime details instance.”</i>
     * 
     * @return property lastRefreshedDateTime
     */
    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastRefreshedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Recorded date time of this runtime details instance.”</i>
     * 
     * @param lastRefreshedDateTime
     *            new value of {@code lastRefreshedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastRefreshedDateTime} field changed
     */
    public UserExperienceAnalyticsBatteryHealthRuntimeDetails withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthRuntimeDetails");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    public UserExperienceAnalyticsBatteryHealthRuntimeDetails withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthRuntimeDetails patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthRuntimeDetails put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsBatteryHealthRuntimeDetails _copy() {
        UserExperienceAnalyticsBatteryHealthRuntimeDetails _x = new UserExperienceAnalyticsBatteryHealthRuntimeDetails();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activeDevices = activeDevices;
        _x.batteryRuntimeFair = batteryRuntimeFair;
        _x.batteryRuntimeGood = batteryRuntimeGood;
        _x.batteryRuntimePoor = batteryRuntimePoor;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsBatteryHealthRuntimeDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activeDevices=");
        b.append(this.activeDevices);
        b.append(", ");
        b.append("batteryRuntimeFair=");
        b.append(this.batteryRuntimeFair);
        b.append(", ");
        b.append("batteryRuntimeGood=");
        b.append(this.batteryRuntimeGood);
        b.append(", ");
        b.append("batteryRuntimePoor=");
        b.append(this.batteryRuntimePoor);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
