package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics battery health model performance entity contains
 * battery related information for all unique device models in their organization.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeDevices", 
    "averageBatteryAgeInDays", 
    "averageEstimatedRuntimeInMinutes", 
    "averageMaxCapacityPercentage", 
    "manufacturer", 
    "model"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsBatteryHealthModelPerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsBatteryHealthModelPerformance";
    }

    @JsonProperty("activeDevices")
    protected Integer activeDevices;

    @JsonProperty("averageBatteryAgeInDays")
    protected Integer averageBatteryAgeInDays;

    @JsonProperty("averageEstimatedRuntimeInMinutes")
    protected Integer averageEstimatedRuntimeInMinutes;

    @JsonProperty("averageMaxCapacityPercentage")
    protected Integer averageMaxCapacityPercentage;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    protected UserExperienceAnalyticsBatteryHealthModelPerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsBatteryHealthModelPerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer activeDevices;
        private Integer averageBatteryAgeInDays;
        private Integer averageEstimatedRuntimeInMinutes;
        private Integer averageMaxCapacityPercentage;
        private String manufacturer;
        private String model;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of active devices for that model. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param activeDevices
         *            value of {@code activeDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeDevices(Integer activeDevices) {
            this.activeDevices = activeDevices;
            this.changedFields = changedFields.add("activeDevices");
            return this;
        }

        /**
         * <i>“The mean of the battery age for all devices of a given model in a tenant. Unit
         * in days. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param averageBatteryAgeInDays
         *            value of {@code averageBatteryAgeInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder averageBatteryAgeInDays(Integer averageBatteryAgeInDays) {
            this.averageBatteryAgeInDays = averageBatteryAgeInDays;
            this.changedFields = changedFields.add("averageBatteryAgeInDays");
            return this;
        }

        /**
         * <i>“The mean of the estimated runtimes on full charge for all devices of a given
         * model. Unit in minutes. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param averageEstimatedRuntimeInMinutes
         *            value of {@code averageEstimatedRuntimeInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder averageEstimatedRuntimeInMinutes(Integer averageEstimatedRuntimeInMinutes) {
            this.averageEstimatedRuntimeInMinutes = averageEstimatedRuntimeInMinutes;
            this.changedFields = changedFields.add("averageEstimatedRuntimeInMinutes");
            return this;
        }

        /**
         * <i>“The mean of the maximum capacity for all devices of a given model. Maximum
         * capacity measures the full charge vs. design capacity for a device’s batteries..
         * Valid values -2147483648 to 2147483647”</i>
         * 
         * @param averageMaxCapacityPercentage
         *            value of {@code averageMaxCapacityPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder averageMaxCapacityPercentage(Integer averageMaxCapacityPercentage) {
            this.averageMaxCapacityPercentage = averageMaxCapacityPercentage;
            this.changedFields = changedFields.add("averageMaxCapacityPercentage");
            return this;
        }

        /**
         * <i>“Name of the device manufacturer.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“The model name of the device.”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public UserExperienceAnalyticsBatteryHealthModelPerformance build() {
            UserExperienceAnalyticsBatteryHealthModelPerformance _x = new UserExperienceAnalyticsBatteryHealthModelPerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsBatteryHealthModelPerformance";
            _x.id = id;
            _x.activeDevices = activeDevices;
            _x.averageBatteryAgeInDays = averageBatteryAgeInDays;
            _x.averageEstimatedRuntimeInMinutes = averageEstimatedRuntimeInMinutes;
            _x.averageMaxCapacityPercentage = averageMaxCapacityPercentage;
            _x.manufacturer = manufacturer;
            _x.model = model;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of active devices for that model. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property activeDevices
     */
    @Property(name="activeDevices")
    @JsonIgnore
    public Optional<Integer> getActiveDevices() {
        return Optional.ofNullable(activeDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of active devices for that model. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param activeDevices
     *            new value of {@code activeDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDevices} field changed
     */
    public UserExperienceAnalyticsBatteryHealthModelPerformance withActiveDevices(Integer activeDevices) {
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("activeDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthModelPerformance");
        _x.activeDevices = activeDevices;
        return _x;
    }

    /**
     * <i>“The mean of the battery age for all devices of a given model in a tenant. Unit
     * in days. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property averageBatteryAgeInDays
     */
    @Property(name="averageBatteryAgeInDays")
    @JsonIgnore
    public Optional<Integer> getAverageBatteryAgeInDays() {
        return Optional.ofNullable(averageBatteryAgeInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * averageBatteryAgeInDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The mean of the battery age for all devices of a given model in a tenant. Unit
     * in days. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param averageBatteryAgeInDays
     *            new value of {@code averageBatteryAgeInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code averageBatteryAgeInDays} field changed
     */
    public UserExperienceAnalyticsBatteryHealthModelPerformance withAverageBatteryAgeInDays(Integer averageBatteryAgeInDays) {
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("averageBatteryAgeInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthModelPerformance");
        _x.averageBatteryAgeInDays = averageBatteryAgeInDays;
        return _x;
    }

    /**
     * <i>“The mean of the estimated runtimes on full charge for all devices of a given
     * model. Unit in minutes. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property averageEstimatedRuntimeInMinutes
     */
    @Property(name="averageEstimatedRuntimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getAverageEstimatedRuntimeInMinutes() {
        return Optional.ofNullable(averageEstimatedRuntimeInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * averageEstimatedRuntimeInMinutes} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The mean of the estimated runtimes on full charge for all devices of a given
     * model. Unit in minutes. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param averageEstimatedRuntimeInMinutes
     *            new value of {@code averageEstimatedRuntimeInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code averageEstimatedRuntimeInMinutes} field changed
     */
    public UserExperienceAnalyticsBatteryHealthModelPerformance withAverageEstimatedRuntimeInMinutes(Integer averageEstimatedRuntimeInMinutes) {
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("averageEstimatedRuntimeInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthModelPerformance");
        _x.averageEstimatedRuntimeInMinutes = averageEstimatedRuntimeInMinutes;
        return _x;
    }

    /**
     * <i>“The mean of the maximum capacity for all devices of a given model. Maximum
     * capacity measures the full charge vs. design capacity for a device’s batteries..
     * Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property averageMaxCapacityPercentage
     */
    @Property(name="averageMaxCapacityPercentage")
    @JsonIgnore
    public Optional<Integer> getAverageMaxCapacityPercentage() {
        return Optional.ofNullable(averageMaxCapacityPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * averageMaxCapacityPercentage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The mean of the maximum capacity for all devices of a given model. Maximum
     * capacity measures the full charge vs. design capacity for a device’s batteries..
     * Valid values -2147483648 to 2147483647”</i>
     * 
     * @param averageMaxCapacityPercentage
     *            new value of {@code averageMaxCapacityPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code averageMaxCapacityPercentage} field changed
     */
    public UserExperienceAnalyticsBatteryHealthModelPerformance withAverageMaxCapacityPercentage(Integer averageMaxCapacityPercentage) {
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("averageMaxCapacityPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthModelPerformance");
        _x.averageMaxCapacityPercentage = averageMaxCapacityPercentage;
        return _x;
    }

    /**
     * <i>“Name of the device manufacturer.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the device manufacturer.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public UserExperienceAnalyticsBatteryHealthModelPerformance withManufacturer(String manufacturer) {
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthModelPerformance");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“The model name of the device.”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The model name of the device.”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public UserExperienceAnalyticsBatteryHealthModelPerformance withModel(String model) {
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthModelPerformance");
        _x.model = model;
        return _x;
    }

    public UserExperienceAnalyticsBatteryHealthModelPerformance withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthModelPerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthModelPerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsBatteryHealthModelPerformance _copy() {
        UserExperienceAnalyticsBatteryHealthModelPerformance _x = new UserExperienceAnalyticsBatteryHealthModelPerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activeDevices = activeDevices;
        _x.averageBatteryAgeInDays = averageBatteryAgeInDays;
        _x.averageEstimatedRuntimeInMinutes = averageEstimatedRuntimeInMinutes;
        _x.averageMaxCapacityPercentage = averageMaxCapacityPercentage;
        _x.manufacturer = manufacturer;
        _x.model = model;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsBatteryHealthModelPerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activeDevices=");
        b.append(this.activeDevices);
        b.append(", ");
        b.append("averageBatteryAgeInDays=");
        b.append(this.averageBatteryAgeInDays);
        b.append(", ");
        b.append("averageEstimatedRuntimeInMinutes=");
        b.append(this.averageEstimatedRuntimeInMinutes);
        b.append(", ");
        b.append("averageMaxCapacityPercentage=");
        b.append(this.averageMaxCapacityPercentage);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
