package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.UserExperienceAnalyticsHealthState;


/**
 * <i>“The user experience analytics battery health device performance entity contains
 * device level battery information.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "batteryAgeInDays", 
    "deviceBatteryHealthScore", 
    "deviceId", 
    "deviceName", 
    "estimatedRuntimeInMinutes", 
    "healthStatus", 
    "manufacturer", 
    "maxCapacityPercentage", 
    "model"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsBatteryHealthDevicePerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance";
    }

    @JsonProperty("batteryAgeInDays")
    protected Integer batteryAgeInDays;

    @JsonProperty("deviceBatteryHealthScore")
    protected Integer deviceBatteryHealthScore;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("estimatedRuntimeInMinutes")
    protected Integer estimatedRuntimeInMinutes;

    @JsonProperty("healthStatus")
    protected UserExperienceAnalyticsHealthState healthStatus;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("maxCapacityPercentage")
    protected Integer maxCapacityPercentage;

    @JsonProperty("model")
    protected String model;

    protected UserExperienceAnalyticsBatteryHealthDevicePerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsBatteryHealthDevicePerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer batteryAgeInDays;
        private Integer deviceBatteryHealthScore;
        private String deviceId;
        private String deviceName;
        private Integer estimatedRuntimeInMinutes;
        private UserExperienceAnalyticsHealthState healthStatus;
        private String manufacturer;
        private Integer maxCapacityPercentage;
        private String model;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Estimated battery age. Unit in days. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param batteryAgeInDays
         *            value of {@code batteryAgeInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryAgeInDays(Integer batteryAgeInDays) {
            this.batteryAgeInDays = batteryAgeInDays;
            this.changedFields = changedFields.add("batteryAgeInDays");
            return this;
        }

        /**
         * <i>“A weighted average of a device’s maximum capacity score and runtime estimate
         * score. Values range from 0-100. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param deviceBatteryHealthScore
         *            value of {@code deviceBatteryHealthScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceBatteryHealthScore(Integer deviceBatteryHealthScore) {
            this.deviceBatteryHealthScore = deviceBatteryHealthScore;
            this.changedFields = changedFields.add("deviceBatteryHealthScore");
            return this;
        }

        /**
         * <i>“The unique identifier of the device, Intune DeviceID.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“Device friendly name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“The estimated runtime of the device when the battery is fully charged. Unit in
         * minutes. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param estimatedRuntimeInMinutes
         *            value of {@code estimatedRuntimeInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder estimatedRuntimeInMinutes(Integer estimatedRuntimeInMinutes) {
            this.estimatedRuntimeInMinutes = estimatedRuntimeInMinutes;
            this.changedFields = changedFields.add("estimatedRuntimeInMinutes");
            return this;
        }

        /**
         * <i>“The overall battery health status of the device.”</i>
         * 
         * @param healthStatus
         *            value of {@code healthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthStatus(UserExperienceAnalyticsHealthState healthStatus) {
            this.healthStatus = healthStatus;
            this.changedFields = changedFields.add("healthStatus");
            return this;
        }

        /**
         * <i>“The manufacturer name of the device.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“Ratio of current capacity and design capacity of the battery with the lowest
         * capacity. Unit in percentage and values range from 0-100. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param maxCapacityPercentage
         *            value of {@code maxCapacityPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maxCapacityPercentage(Integer maxCapacityPercentage) {
            this.maxCapacityPercentage = maxCapacityPercentage;
            this.changedFields = changedFields.add("maxCapacityPercentage");
            return this;
        }

        /**
         * <i>“The model name of the device.”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public UserExperienceAnalyticsBatteryHealthDevicePerformance build() {
            UserExperienceAnalyticsBatteryHealthDevicePerformance _x = new UserExperienceAnalyticsBatteryHealthDevicePerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance";
            _x.id = id;
            _x.batteryAgeInDays = batteryAgeInDays;
            _x.deviceBatteryHealthScore = deviceBatteryHealthScore;
            _x.deviceId = deviceId;
            _x.deviceName = deviceName;
            _x.estimatedRuntimeInMinutes = estimatedRuntimeInMinutes;
            _x.healthStatus = healthStatus;
            _x.manufacturer = manufacturer;
            _x.maxCapacityPercentage = maxCapacityPercentage;
            _x.model = model;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Estimated battery age. Unit in days. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property batteryAgeInDays
     */
    @Property(name="batteryAgeInDays")
    @JsonIgnore
    public Optional<Integer> getBatteryAgeInDays() {
        return Optional.ofNullable(batteryAgeInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code batteryAgeInDays}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Estimated battery age. Unit in days. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param batteryAgeInDays
     *            new value of {@code batteryAgeInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryAgeInDays} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance withBatteryAgeInDays(Integer batteryAgeInDays) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("batteryAgeInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.batteryAgeInDays = batteryAgeInDays;
        return _x;
    }

    /**
     * <i>“A weighted average of a device’s maximum capacity score and runtime estimate
     * score. Values range from 0-100. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property deviceBatteryHealthScore
     */
    @Property(name="deviceBatteryHealthScore")
    @JsonIgnore
    public Optional<Integer> getDeviceBatteryHealthScore() {
        return Optional.ofNullable(deviceBatteryHealthScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceBatteryHealthScore} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A weighted average of a device’s maximum capacity score and runtime estimate
     * score. Values range from 0-100. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param deviceBatteryHealthScore
     *            new value of {@code deviceBatteryHealthScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceBatteryHealthScore} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance withDeviceBatteryHealthScore(Integer deviceBatteryHealthScore) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceBatteryHealthScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.deviceBatteryHealthScore = deviceBatteryHealthScore;
        return _x;
    }

    /**
     * <i>“The unique identifier of the device, Intune DeviceID.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The unique identifier of the device, Intune DeviceID.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance withDeviceId(String deviceId) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“Device friendly name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device friendly name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance withDeviceName(String deviceName) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“The estimated runtime of the device when the battery is fully charged. Unit in
     * minutes. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property estimatedRuntimeInMinutes
     */
    @Property(name="estimatedRuntimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getEstimatedRuntimeInMinutes() {
        return Optional.ofNullable(estimatedRuntimeInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * estimatedRuntimeInMinutes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The estimated runtime of the device when the battery is fully charged. Unit in
     * minutes. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param estimatedRuntimeInMinutes
     *            new value of {@code estimatedRuntimeInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code estimatedRuntimeInMinutes} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance withEstimatedRuntimeInMinutes(Integer estimatedRuntimeInMinutes) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("estimatedRuntimeInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.estimatedRuntimeInMinutes = estimatedRuntimeInMinutes;
        return _x;
    }

    /**
     * <i>“The overall battery health status of the device.”</i>
     * 
     * @return property healthStatus
     */
    @Property(name="healthStatus")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsHealthState> getHealthStatus() {
        return Optional.ofNullable(healthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code healthStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The overall battery health status of the device.”</i>
     * 
     * @param healthStatus
     *            new value of {@code healthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthStatus} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance withHealthStatus(UserExperienceAnalyticsHealthState healthStatus) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("healthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.healthStatus = healthStatus;
        return _x;
    }

    /**
     * <i>“The manufacturer name of the device.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The manufacturer name of the device.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance withManufacturer(String manufacturer) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“Ratio of current capacity and design capacity of the battery with the lowest
     * capacity. Unit in percentage and values range from 0-100. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property maxCapacityPercentage
     */
    @Property(name="maxCapacityPercentage")
    @JsonIgnore
    public Optional<Integer> getMaxCapacityPercentage() {
        return Optional.ofNullable(maxCapacityPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maxCapacityPercentage} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Ratio of current capacity and design capacity of the battery with the lowest
     * capacity. Unit in percentage and values range from 0-100. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param maxCapacityPercentage
     *            new value of {@code maxCapacityPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maxCapacityPercentage} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance withMaxCapacityPercentage(Integer maxCapacityPercentage) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("maxCapacityPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.maxCapacityPercentage = maxCapacityPercentage;
        return _x;
    }

    /**
     * <i>“The model name of the device.”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The model name of the device.”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance withModel(String model) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.model = model;
        return _x;
    }

    public UserExperienceAnalyticsBatteryHealthDevicePerformance withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthDevicePerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsBatteryHealthDevicePerformance _copy() {
        UserExperienceAnalyticsBatteryHealthDevicePerformance _x = new UserExperienceAnalyticsBatteryHealthDevicePerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.batteryAgeInDays = batteryAgeInDays;
        _x.deviceBatteryHealthScore = deviceBatteryHealthScore;
        _x.deviceId = deviceId;
        _x.deviceName = deviceName;
        _x.estimatedRuntimeInMinutes = estimatedRuntimeInMinutes;
        _x.healthStatus = healthStatus;
        _x.manufacturer = manufacturer;
        _x.maxCapacityPercentage = maxCapacityPercentage;
        _x.model = model;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsBatteryHealthDevicePerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("batteryAgeInDays=");
        b.append(this.batteryAgeInDays);
        b.append(", ");
        b.append("deviceBatteryHealthScore=");
        b.append(this.deviceBatteryHealthScore);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("estimatedRuntimeInMinutes=");
        b.append(this.estimatedRuntimeInMinutes);
        b.append(", ");
        b.append("healthStatus=");
        b.append(this.healthStatus);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("maxCapacityPercentage=");
        b.append(this.maxCapacityPercentage);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
