package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“The user experience analytics battery health capacity entity contains count of
 * devices broken down into 3 categories - devices with capacity &amp;gt; 80%, devices
 * with capacity 50-80% and devices with capacity &amp;lt; 50 %.This API provides the
 * count of devices in these 3 categories..”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeDevices", 
    "batteryCapacityFair", 
    "batteryCapacityGood", 
    "batteryCapacityPoor", 
    "lastRefreshedDateTime"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsBatteryHealthCapacityDetails extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsBatteryHealthCapacityDetails";
    }

    @JsonProperty("activeDevices")
    protected Integer activeDevices;

    @JsonProperty("batteryCapacityFair")
    protected Integer batteryCapacityFair;

    @JsonProperty("batteryCapacityGood")
    protected Integer batteryCapacityGood;

    @JsonProperty("batteryCapacityPoor")
    protected Integer batteryCapacityPoor;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    protected UserExperienceAnalyticsBatteryHealthCapacityDetails() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsBatteryHealthCapacityDetails() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer activeDevices;
        private Integer batteryCapacityFair;
        private Integer batteryCapacityGood;
        private Integer batteryCapacityPoor;
        private OffsetDateTime lastRefreshedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of active devices within the tenant. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param activeDevices
         *            value of {@code activeDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeDevices(Integer activeDevices) {
            this.activeDevices = activeDevices;
            this.changedFields = changedFields.add("activeDevices");
            return this;
        }

        /**
         * <i>“Number of devices whose battery maximum capacity is greater than 50% but lesser
         * than 80%. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param batteryCapacityFair
         *            value of {@code batteryCapacityFair} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryCapacityFair(Integer batteryCapacityFair) {
            this.batteryCapacityFair = batteryCapacityFair;
            this.changedFields = changedFields.add("batteryCapacityFair");
            return this;
        }

        /**
         * <i>“Number of devices whose battery maximum capacity is greater than 80%. Valid
         * values -2147483648 to 2147483647”</i>
         * 
         * @param batteryCapacityGood
         *            value of {@code batteryCapacityGood} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryCapacityGood(Integer batteryCapacityGood) {
            this.batteryCapacityGood = batteryCapacityGood;
            this.changedFields = changedFields.add("batteryCapacityGood");
            return this;
        }

        /**
         * <i>“Number of devices whose battery maximum capacity is lesser than 50%. Valid
         * values -2147483648 to 2147483647”</i>
         * 
         * @param batteryCapacityPoor
         *            value of {@code batteryCapacityPoor} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryCapacityPoor(Integer batteryCapacityPoor) {
            this.batteryCapacityPoor = batteryCapacityPoor;
            this.changedFields = changedFields.add("batteryCapacityPoor");
            return this;
        }

        /**
         * <i>“Recorded date time of this capacity details instance.”</i>
         * 
         * @param lastRefreshedDateTime
         *            value of {@code lastRefreshedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public UserExperienceAnalyticsBatteryHealthCapacityDetails build() {
            UserExperienceAnalyticsBatteryHealthCapacityDetails _x = new UserExperienceAnalyticsBatteryHealthCapacityDetails();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsBatteryHealthCapacityDetails";
            _x.id = id;
            _x.activeDevices = activeDevices;
            _x.batteryCapacityFair = batteryCapacityFair;
            _x.batteryCapacityGood = batteryCapacityGood;
            _x.batteryCapacityPoor = batteryCapacityPoor;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of active devices within the tenant. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property activeDevices
     */
    @Property(name="activeDevices")
    @JsonIgnore
    public Optional<Integer> getActiveDevices() {
        return Optional.ofNullable(activeDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of active devices within the tenant. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param activeDevices
     *            new value of {@code activeDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDevices} field changed
     */
    public UserExperienceAnalyticsBatteryHealthCapacityDetails withActiveDevices(Integer activeDevices) {
        UserExperienceAnalyticsBatteryHealthCapacityDetails _x = _copy();
        _x.changedFields = changedFields.add("activeDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthCapacityDetails");
        _x.activeDevices = activeDevices;
        return _x;
    }

    /**
     * <i>“Number of devices whose battery maximum capacity is greater than 50% but lesser
     * than 80%. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property batteryCapacityFair
     */
    @Property(name="batteryCapacityFair")
    @JsonIgnore
    public Optional<Integer> getBatteryCapacityFair() {
        return Optional.ofNullable(batteryCapacityFair);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batteryCapacityFair} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices whose battery maximum capacity is greater than 50% but lesser
     * than 80%. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param batteryCapacityFair
     *            new value of {@code batteryCapacityFair} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryCapacityFair} field changed
     */
    public UserExperienceAnalyticsBatteryHealthCapacityDetails withBatteryCapacityFair(Integer batteryCapacityFair) {
        UserExperienceAnalyticsBatteryHealthCapacityDetails _x = _copy();
        _x.changedFields = changedFields.add("batteryCapacityFair");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthCapacityDetails");
        _x.batteryCapacityFair = batteryCapacityFair;
        return _x;
    }

    /**
     * <i>“Number of devices whose battery maximum capacity is greater than 80%. Valid
     * values -2147483648 to 2147483647”</i>
     * 
     * @return property batteryCapacityGood
     */
    @Property(name="batteryCapacityGood")
    @JsonIgnore
    public Optional<Integer> getBatteryCapacityGood() {
        return Optional.ofNullable(batteryCapacityGood);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batteryCapacityGood} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices whose battery maximum capacity is greater than 80%. Valid
     * values -2147483648 to 2147483647”</i>
     * 
     * @param batteryCapacityGood
     *            new value of {@code batteryCapacityGood} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryCapacityGood} field changed
     */
    public UserExperienceAnalyticsBatteryHealthCapacityDetails withBatteryCapacityGood(Integer batteryCapacityGood) {
        UserExperienceAnalyticsBatteryHealthCapacityDetails _x = _copy();
        _x.changedFields = changedFields.add("batteryCapacityGood");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthCapacityDetails");
        _x.batteryCapacityGood = batteryCapacityGood;
        return _x;
    }

    /**
     * <i>“Number of devices whose battery maximum capacity is lesser than 50%. Valid
     * values -2147483648 to 2147483647”</i>
     * 
     * @return property batteryCapacityPoor
     */
    @Property(name="batteryCapacityPoor")
    @JsonIgnore
    public Optional<Integer> getBatteryCapacityPoor() {
        return Optional.ofNullable(batteryCapacityPoor);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batteryCapacityPoor} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices whose battery maximum capacity is lesser than 50%. Valid
     * values -2147483648 to 2147483647”</i>
     * 
     * @param batteryCapacityPoor
     *            new value of {@code batteryCapacityPoor} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryCapacityPoor} field changed
     */
    public UserExperienceAnalyticsBatteryHealthCapacityDetails withBatteryCapacityPoor(Integer batteryCapacityPoor) {
        UserExperienceAnalyticsBatteryHealthCapacityDetails _x = _copy();
        _x.changedFields = changedFields.add("batteryCapacityPoor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthCapacityDetails");
        _x.batteryCapacityPoor = batteryCapacityPoor;
        return _x;
    }

    /**
     * <i>“Recorded date time of this capacity details instance.”</i>
     * 
     * @return property lastRefreshedDateTime
     */
    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastRefreshedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Recorded date time of this capacity details instance.”</i>
     * 
     * @param lastRefreshedDateTime
     *            new value of {@code lastRefreshedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastRefreshedDateTime} field changed
     */
    public UserExperienceAnalyticsBatteryHealthCapacityDetails withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        UserExperienceAnalyticsBatteryHealthCapacityDetails _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBatteryHealthCapacityDetails");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    public UserExperienceAnalyticsBatteryHealthCapacityDetails withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsBatteryHealthCapacityDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthCapacityDetails patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthCapacityDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBatteryHealthCapacityDetails put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBatteryHealthCapacityDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsBatteryHealthCapacityDetails _copy() {
        UserExperienceAnalyticsBatteryHealthCapacityDetails _x = new UserExperienceAnalyticsBatteryHealthCapacityDetails();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activeDevices = activeDevices;
        _x.batteryCapacityFair = batteryCapacityFair;
        _x.batteryCapacityGood = batteryCapacityGood;
        _x.batteryCapacityPoor = batteryCapacityPoor;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsBatteryHealthCapacityDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activeDevices=");
        b.append(this.activeDevices);
        b.append(", ");
        b.append("batteryCapacityFair=");
        b.append(this.batteryCapacityFair);
        b.append(", ");
        b.append("batteryCapacityGood=");
        b.append(this.batteryCapacityGood);
        b.append(", ");
        b.append("batteryCapacityPoor=");
        b.append(this.batteryCapacityPoor);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
