package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsCategoryRequest;


/**
 * <i>“The user experience analytics baseline entity contains baseline values against
 * which to compare the user experience analytics scores.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "displayName", 
    "isBuiltIn"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsBaseline extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsBaseline";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isBuiltIn")
    protected Boolean isBuiltIn;

    protected UserExperienceAnalyticsBaseline() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsBaseline() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private Boolean isBuiltIn;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The date the custom baseline was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The name of the user experience analytics baseline.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Signifies if the current baseline is the commercial median baseline or a custom
         * baseline.”</i>
         * 
         * @param isBuiltIn
         *            value of {@code isBuiltIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isBuiltIn(Boolean isBuiltIn) {
            this.isBuiltIn = isBuiltIn;
            this.changedFields = changedFields.add("isBuiltIn");
            return this;
        }

        public UserExperienceAnalyticsBaseline build() {
            UserExperienceAnalyticsBaseline _x = new UserExperienceAnalyticsBaseline();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsBaseline";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.isBuiltIn = isBuiltIn;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The date the custom baseline was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date the custom baseline was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public UserExperienceAnalyticsBaseline withCreatedDateTime(OffsetDateTime createdDateTime) {
        UserExperienceAnalyticsBaseline _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBaseline");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The name of the user experience analytics baseline.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of the user experience analytics baseline.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public UserExperienceAnalyticsBaseline withDisplayName(String displayName) {
        UserExperienceAnalyticsBaseline _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBaseline");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Signifies if the current baseline is the commercial median baseline or a custom
     * baseline.”</i>
     * 
     * @return property isBuiltIn
     */
    @Property(name="isBuiltIn")
    @JsonIgnore
    public Optional<Boolean> getIsBuiltIn() {
        return Optional.ofNullable(isBuiltIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isBuiltIn} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Signifies if the current baseline is the commercial median baseline or a custom
     * baseline.”</i>
     * 
     * @param isBuiltIn
     *            new value of {@code isBuiltIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isBuiltIn} field changed
     */
    public UserExperienceAnalyticsBaseline withIsBuiltIn(Boolean isBuiltIn) {
        UserExperienceAnalyticsBaseline _x = _copy();
        _x.changedFields = changedFields.add("isBuiltIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsBaseline");
        _x.isBuiltIn = isBuiltIn;
        return _x;
    }

    public UserExperienceAnalyticsBaseline withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsBaseline _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The user experience analytics app health metrics.”</i>
     * 
     * @return navigational property appHealthMetrics
     */
    @NavigationProperty(name="appHealthMetrics")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryRequest getAppHealthMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("appHealthMetrics"), RequestHelper.getValue(unmappedFields, "appHealthMetrics"));
    }

    /**
     * <i>“The user experience analytics battery health metrics.”</i>
     * 
     * @return navigational property batteryHealthMetrics
     */
    @NavigationProperty(name="batteryHealthMetrics")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryRequest getBatteryHealthMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("batteryHealthMetrics"), RequestHelper.getValue(unmappedFields, "batteryHealthMetrics"));
    }

    /**
     * <i>“The user experience analytics best practices metrics.”</i>
     * 
     * @return navigational property bestPracticesMetrics
     */
    @NavigationProperty(name="bestPracticesMetrics")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryRequest getBestPracticesMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("bestPracticesMetrics"), RequestHelper.getValue(unmappedFields, "bestPracticesMetrics"));
    }

    /**
     * <i>“The user experience analytics device boot performance metrics.”</i>
     * 
     * @return navigational property deviceBootPerformanceMetrics
     */
    @NavigationProperty(name="deviceBootPerformanceMetrics")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryRequest getDeviceBootPerformanceMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("deviceBootPerformanceMetrics"), RequestHelper.getValue(unmappedFields, "deviceBootPerformanceMetrics"));
    }

    /**
     * <i>“The user experience analytics reboot analytics metrics.”</i>
     * 
     * @return navigational property rebootAnalyticsMetrics
     */
    @NavigationProperty(name="rebootAnalyticsMetrics")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryRequest getRebootAnalyticsMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("rebootAnalyticsMetrics"), RequestHelper.getValue(unmappedFields, "rebootAnalyticsMetrics"));
    }

    /**
     * <i>“The user experience analytics resource performance metrics.”</i>
     * 
     * @return navigational property resourcePerformanceMetrics
     */
    @NavigationProperty(name="resourcePerformanceMetrics")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryRequest getResourcePerformanceMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("resourcePerformanceMetrics"), RequestHelper.getValue(unmappedFields, "resourcePerformanceMetrics"));
    }

    /**
     * <i>“The user experience analytics work from anywhere metrics.”</i>
     * 
     * @return navigational property workFromAnywhereMetrics
     */
    @NavigationProperty(name="workFromAnywhereMetrics")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryRequest getWorkFromAnywhereMetrics() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("workFromAnywhereMetrics"), RequestHelper.getValue(unmappedFields, "workFromAnywhereMetrics"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBaseline patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBaseline _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsBaseline put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsBaseline _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsBaseline _copy() {
        UserExperienceAnalyticsBaseline _x = new UserExperienceAnalyticsBaseline();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.isBuiltIn = isBuiltIn;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsBaseline[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isBuiltIn=");
        b.append(this.isBuiltIn);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
