package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“The user experience analytics device performance entity contains device
 * performance details.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appDisplayName", 
    "appPublisher", 
    "appVersion", 
    "deviceDisplayName", 
    "deviceId", 
    "eventDateTime", 
    "eventType"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsAppHealthDevicePerformanceDetails extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformanceDetails";
    }

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appPublisher")
    protected String appPublisher;

    @JsonProperty("appVersion")
    protected String appVersion;

    @JsonProperty("deviceDisplayName")
    protected String deviceDisplayName;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("eventDateTime")
    protected OffsetDateTime eventDateTime;

    @JsonProperty("eventType")
    protected String eventType;

    protected UserExperienceAnalyticsAppHealthDevicePerformanceDetails() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsAppHealthDevicePerformanceDetails() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appDisplayName;
        private String appPublisher;
        private String appVersion;
        private String deviceDisplayName;
        private String deviceId;
        private OffsetDateTime eventDateTime;
        private String eventType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The friendly name of the application for which the event occurred.”</i>
         * 
         * @param appDisplayName
         *            value of {@code appDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        /**
         * <i>“The publisher of the application.”</i>
         * 
         * @param appPublisher
         *            value of {@code appPublisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appPublisher(String appPublisher) {
            this.appPublisher = appPublisher;
            this.changedFields = changedFields.add("appPublisher");
            return this;
        }

        /**
         * <i>“The version of the application.”</i>
         * 
         * @param appVersion
         *            value of {@code appVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            this.changedFields = changedFields.add("appVersion");
            return this;
        }

        /**
         * <i>“The name of the device.”</i>
         * 
         * @param deviceDisplayName
         *            value of {@code deviceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceDisplayName(String deviceDisplayName) {
            this.deviceDisplayName = deviceDisplayName;
            this.changedFields = changedFields.add("deviceDisplayName");
            return this;
        }

        /**
         * <i>“The id of the device.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The time the event occurred.”</i>
         * 
         * @param eventDateTime
         *            value of {@code eventDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eventDateTime(OffsetDateTime eventDateTime) {
            this.eventDateTime = eventDateTime;
            this.changedFields = changedFields.add("eventDateTime");
            return this;
        }

        /**
         * <i>“The type of the event.”</i>
         * 
         * @param eventType
         *            value of {@code eventType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eventType(String eventType) {
            this.eventType = eventType;
            this.changedFields = changedFields.add("eventType");
            return this;
        }

        public UserExperienceAnalyticsAppHealthDevicePerformanceDetails build() {
            UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = new UserExperienceAnalyticsAppHealthDevicePerformanceDetails();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformanceDetails";
            _x.id = id;
            _x.appDisplayName = appDisplayName;
            _x.appPublisher = appPublisher;
            _x.appVersion = appVersion;
            _x.deviceDisplayName = deviceDisplayName;
            _x.deviceId = deviceId;
            _x.eventDateTime = eventDateTime;
            _x.eventType = eventType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The friendly name of the application for which the event occurred.”</i>
     * 
     * @return property appDisplayName
     */
    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The friendly name of the application for which the event occurred.”</i>
     * 
     * @param appDisplayName
     *            new value of {@code appDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appDisplayName} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails withAppDisplayName(String appDisplayName) {
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformanceDetails");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    /**
     * <i>“The publisher of the application.”</i>
     * 
     * @return property appPublisher
     */
    @Property(name="appPublisher")
    @JsonIgnore
    public Optional<String> getAppPublisher() {
        return Optional.ofNullable(appPublisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appPublisher}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The publisher of the application.”</i>
     * 
     * @param appPublisher
     *            new value of {@code appPublisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appPublisher} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails withAppPublisher(String appPublisher) {
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.changedFields = changedFields.add("appPublisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformanceDetails");
        _x.appPublisher = appPublisher;
        return _x;
    }

    /**
     * <i>“The version of the application.”</i>
     * 
     * @return property appVersion
     */
    @Property(name="appVersion")
    @JsonIgnore
    public Optional<String> getAppVersion() {
        return Optional.ofNullable(appVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The version of the application.”</i>
     * 
     * @param appVersion
     *            new value of {@code appVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appVersion} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails withAppVersion(String appVersion) {
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.changedFields = changedFields.add("appVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformanceDetails");
        _x.appVersion = appVersion;
        return _x;
    }

    /**
     * <i>“The name of the device.”</i>
     * 
     * @return property deviceDisplayName
     */
    @Property(name="deviceDisplayName")
    @JsonIgnore
    public Optional<String> getDeviceDisplayName() {
        return Optional.ofNullable(deviceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of the device.”</i>
     * 
     * @param deviceDisplayName
     *            new value of {@code deviceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceDisplayName} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails withDeviceDisplayName(String deviceDisplayName) {
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.changedFields = changedFields.add("deviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformanceDetails");
        _x.deviceDisplayName = deviceDisplayName;
        return _x;
    }

    /**
     * <i>“The id of the device.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The id of the device.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails withDeviceId(String deviceId) {
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformanceDetails");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The time the event occurred.”</i>
     * 
     * @return property eventDateTime
     */
    @Property(name="eventDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEventDateTime() {
        return Optional.ofNullable(eventDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eventDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the event occurred.”</i>
     * 
     * @param eventDateTime
     *            new value of {@code eventDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eventDateTime} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails withEventDateTime(OffsetDateTime eventDateTime) {
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.changedFields = changedFields.add("eventDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformanceDetails");
        _x.eventDateTime = eventDateTime;
        return _x;
    }

    /**
     * <i>“The type of the event.”</i>
     * 
     * @return property eventType
     */
    @Property(name="eventType")
    @JsonIgnore
    public Optional<String> getEventType() {
        return Optional.ofNullable(eventType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eventType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The type of the event.”</i>
     * 
     * @param eventType
     *            new value of {@code eventType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eventType} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails withEventType(String eventType) {
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.changedFields = changedFields.add("eventType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformanceDetails");
        _x.eventType = eventType;
        return _x;
    }

    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetails put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsAppHealthDevicePerformanceDetails _copy() {
        UserExperienceAnalyticsAppHealthDevicePerformanceDetails _x = new UserExperienceAnalyticsAppHealthDevicePerformanceDetails();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appDisplayName = appDisplayName;
        _x.appPublisher = appPublisher;
        _x.appVersion = appVersion;
        _x.deviceDisplayName = deviceDisplayName;
        _x.deviceId = deviceId;
        _x.eventDateTime = eventDateTime;
        _x.eventType = eventType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsAppHealthDevicePerformanceDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appPublisher=");
        b.append(this.appPublisher);
        b.append(", ");
        b.append("appVersion=");
        b.append(this.appVersion);
        b.append(", ");
        b.append("deviceDisplayName=");
        b.append(this.deviceDisplayName);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("eventDateTime=");
        b.append(this.eventDateTime);
        b.append(", ");
        b.append("eventType=");
        b.append(this.eventType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
