package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.UserExperienceAnalyticsHealthState;


/**
 * <i>“The user experience analytics device performance entity contains device
 * performance details.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appCrashCount", 
    "appHangCount", 
    "crashedAppCount", 
    "deviceAppHealthScore", 
    "deviceAppHealthStatus", 
    "deviceDisplayName", 
    "deviceId", 
    "deviceManufacturer", 
    "deviceModel", 
    "healthStatus", 
    "meanTimeToFailureInMinutes", 
    "processedDateTime"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsAppHealthDevicePerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance";
    }

    @JsonProperty("appCrashCount")
    protected Integer appCrashCount;

    @JsonProperty("appHangCount")
    protected Integer appHangCount;

    @JsonProperty("crashedAppCount")
    protected Integer crashedAppCount;

    @JsonProperty("deviceAppHealthScore")
    protected Double deviceAppHealthScore;

    @JsonProperty("deviceAppHealthStatus")
    protected String deviceAppHealthStatus;

    @JsonProperty("deviceDisplayName")
    protected String deviceDisplayName;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceManufacturer")
    protected String deviceManufacturer;

    @JsonProperty("deviceModel")
    protected String deviceModel;

    @JsonProperty("healthStatus")
    protected UserExperienceAnalyticsHealthState healthStatus;

    @JsonProperty("meanTimeToFailureInMinutes")
    protected Integer meanTimeToFailureInMinutes;

    @JsonProperty("processedDateTime")
    protected OffsetDateTime processedDateTime;

    protected UserExperienceAnalyticsAppHealthDevicePerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsAppHealthDevicePerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer appCrashCount;
        private Integer appHangCount;
        private Integer crashedAppCount;
        private Double deviceAppHealthScore;
        private String deviceAppHealthStatus;
        private String deviceDisplayName;
        private String deviceId;
        private String deviceManufacturer;
        private String deviceModel;
        private UserExperienceAnalyticsHealthState healthStatus;
        private Integer meanTimeToFailureInMinutes;
        private OffsetDateTime processedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The number of app crashes for the device. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param appCrashCount
         *            value of {@code appCrashCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appCrashCount(Integer appCrashCount) {
            this.appCrashCount = appCrashCount;
            this.changedFields = changedFields.add("appCrashCount");
            return this;
        }

        /**
         * <i>“The number of app hangs for the device. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param appHangCount
         *            value of {@code appHangCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appHangCount(Integer appHangCount) {
            this.appHangCount = appHangCount;
            this.changedFields = changedFields.add("appHangCount");
            return this;
        }

        /**
         * <i>“The number of distinct app crashes for the device. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param crashedAppCount
         *            value of {@code crashedAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder crashedAppCount(Integer crashedAppCount) {
            this.crashedAppCount = crashedAppCount;
            this.changedFields = changedFields.add("crashedAppCount");
            return this;
        }

        /**
         * <i>“The app health score of the device. Valid values -1.79769313486232E+308 to 1.
         * 79769313486232E+308”</i>
         * 
         * @param deviceAppHealthScore
         *            value of {@code deviceAppHealthScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceAppHealthScore(Double deviceAppHealthScore) {
            this.deviceAppHealthScore = deviceAppHealthScore;
            this.changedFields = changedFields.add("deviceAppHealthScore");
            return this;
        }

        /**
         * <i>“The overall app health status of the device.”</i>
         * 
         * @param deviceAppHealthStatus
         *            value of {@code deviceAppHealthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceAppHealthStatus(String deviceAppHealthStatus) {
            this.deviceAppHealthStatus = deviceAppHealthStatus;
            this.changedFields = changedFields.add("deviceAppHealthStatus");
            return this;
        }

        /**
         * <i>“The name of the device.”</i>
         * 
         * @param deviceDisplayName
         *            value of {@code deviceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceDisplayName(String deviceDisplayName) {
            this.deviceDisplayName = deviceDisplayName;
            this.changedFields = changedFields.add("deviceDisplayName");
            return this;
        }

        /**
         * <i>“The id of the device.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The manufacturer name of the device.”</i>
         * 
         * @param deviceManufacturer
         *            value of {@code deviceManufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManufacturer(String deviceManufacturer) {
            this.deviceManufacturer = deviceManufacturer;
            this.changedFields = changedFields.add("deviceManufacturer");
            return this;
        }

        /**
         * <i>“The model name of the device.”</i>
         * 
         * @param deviceModel
         *            value of {@code deviceModel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
            this.changedFields = changedFields.add("deviceModel");
            return this;
        }

        /**
         * <i>“The health state of the user experience analytics device.”</i>
         * 
         * @param healthStatus
         *            value of {@code healthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthStatus(UserExperienceAnalyticsHealthState healthStatus) {
            this.healthStatus = healthStatus;
            this.changedFields = changedFields.add("healthStatus");
            return this;
        }

        /**
         * <i>“The mean time to failure for the device in minutes. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param meanTimeToFailureInMinutes
         *            value of {@code meanTimeToFailureInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder meanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
            this.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            this.changedFields = changedFields.add("meanTimeToFailureInMinutes");
            return this;
        }

        /**
         * <i>“The date and time when the statistics were last computed.”</i>
         * 
         * @param processedDateTime
         *            value of {@code processedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processedDateTime(OffsetDateTime processedDateTime) {
            this.processedDateTime = processedDateTime;
            this.changedFields = changedFields.add("processedDateTime");
            return this;
        }

        public UserExperienceAnalyticsAppHealthDevicePerformance build() {
            UserExperienceAnalyticsAppHealthDevicePerformance _x = new UserExperienceAnalyticsAppHealthDevicePerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance";
            _x.id = id;
            _x.appCrashCount = appCrashCount;
            _x.appHangCount = appHangCount;
            _x.crashedAppCount = crashedAppCount;
            _x.deviceAppHealthScore = deviceAppHealthScore;
            _x.deviceAppHealthStatus = deviceAppHealthStatus;
            _x.deviceDisplayName = deviceDisplayName;
            _x.deviceId = deviceId;
            _x.deviceManufacturer = deviceManufacturer;
            _x.deviceModel = deviceModel;
            _x.healthStatus = healthStatus;
            _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            _x.processedDateTime = processedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The number of app crashes for the device. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property appCrashCount
     */
    @Property(name="appCrashCount")
    @JsonIgnore
    public Optional<Integer> getAppCrashCount() {
        return Optional.ofNullable(appCrashCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appCrashCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of app crashes for the device. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param appCrashCount
     *            new value of {@code appCrashCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appCrashCount} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withAppCrashCount(Integer appCrashCount) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("appCrashCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.appCrashCount = appCrashCount;
        return _x;
    }

    /**
     * <i>“The number of app hangs for the device. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property appHangCount
     */
    @Property(name="appHangCount")
    @JsonIgnore
    public Optional<Integer> getAppHangCount() {
        return Optional.ofNullable(appHangCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appHangCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of app hangs for the device. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param appHangCount
     *            new value of {@code appHangCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appHangCount} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withAppHangCount(Integer appHangCount) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("appHangCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.appHangCount = appHangCount;
        return _x;
    }

    /**
     * <i>“The number of distinct app crashes for the device. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property crashedAppCount
     */
    @Property(name="crashedAppCount")
    @JsonIgnore
    public Optional<Integer> getCrashedAppCount() {
        return Optional.ofNullable(crashedAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code crashedAppCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of distinct app crashes for the device. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param crashedAppCount
     *            new value of {@code crashedAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code crashedAppCount} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withCrashedAppCount(Integer crashedAppCount) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("crashedAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.crashedAppCount = crashedAppCount;
        return _x;
    }

    /**
     * <i>“The app health score of the device. Valid values -1.79769313486232E+308 to 1.
     * 79769313486232E+308”</i>
     * 
     * @return property deviceAppHealthScore
     */
    @Property(name="deviceAppHealthScore")
    @JsonIgnore
    public Optional<Double> getDeviceAppHealthScore() {
        return Optional.ofNullable(deviceAppHealthScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceAppHealthScore} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The app health score of the device. Valid values -1.79769313486232E+308 to 1.
     * 79769313486232E+308”</i>
     * 
     * @param deviceAppHealthScore
     *            new value of {@code deviceAppHealthScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceAppHealthScore} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withDeviceAppHealthScore(Double deviceAppHealthScore) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceAppHealthScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.deviceAppHealthScore = deviceAppHealthScore;
        return _x;
    }

    /**
     * <i>“The overall app health status of the device.”</i>
     * 
     * @return property deviceAppHealthStatus
     */
    @Property(name="deviceAppHealthStatus")
    @JsonIgnore
    public Optional<String> getDeviceAppHealthStatus() {
        return Optional.ofNullable(deviceAppHealthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceAppHealthStatus} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The overall app health status of the device.”</i>
     * 
     * @param deviceAppHealthStatus
     *            new value of {@code deviceAppHealthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceAppHealthStatus} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withDeviceAppHealthStatus(String deviceAppHealthStatus) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceAppHealthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.deviceAppHealthStatus = deviceAppHealthStatus;
        return _x;
    }

    /**
     * <i>“The name of the device.”</i>
     * 
     * @return property deviceDisplayName
     */
    @Property(name="deviceDisplayName")
    @JsonIgnore
    public Optional<String> getDeviceDisplayName() {
        return Optional.ofNullable(deviceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of the device.”</i>
     * 
     * @param deviceDisplayName
     *            new value of {@code deviceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceDisplayName} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withDeviceDisplayName(String deviceDisplayName) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.deviceDisplayName = deviceDisplayName;
        return _x;
    }

    /**
     * <i>“The id of the device.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The id of the device.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withDeviceId(String deviceId) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The manufacturer name of the device.”</i>
     * 
     * @return property deviceManufacturer
     */
    @Property(name="deviceManufacturer")
    @JsonIgnore
    public Optional<String> getDeviceManufacturer() {
        return Optional.ofNullable(deviceManufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManufacturer} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The manufacturer name of the device.”</i>
     * 
     * @param deviceManufacturer
     *            new value of {@code deviceManufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManufacturer} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withDeviceManufacturer(String deviceManufacturer) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceManufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.deviceManufacturer = deviceManufacturer;
        return _x;
    }

    /**
     * <i>“The model name of the device.”</i>
     * 
     * @return property deviceModel
     */
    @Property(name="deviceModel")
    @JsonIgnore
    public Optional<String> getDeviceModel() {
        return Optional.ofNullable(deviceModel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceModel}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The model name of the device.”</i>
     * 
     * @param deviceModel
     *            new value of {@code deviceModel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceModel} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withDeviceModel(String deviceModel) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceModel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.deviceModel = deviceModel;
        return _x;
    }

    /**
     * <i>“The health state of the user experience analytics device.”</i>
     * 
     * @return property healthStatus
     */
    @Property(name="healthStatus")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsHealthState> getHealthStatus() {
        return Optional.ofNullable(healthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code healthStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The health state of the user experience analytics device.”</i>
     * 
     * @param healthStatus
     *            new value of {@code healthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthStatus} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withHealthStatus(UserExperienceAnalyticsHealthState healthStatus) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("healthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.healthStatus = healthStatus;
        return _x;
    }

    /**
     * <i>“The mean time to failure for the device in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property meanTimeToFailureInMinutes
     */
    @Property(name="meanTimeToFailureInMinutes")
    @JsonIgnore
    public Optional<Integer> getMeanTimeToFailureInMinutes() {
        return Optional.ofNullable(meanTimeToFailureInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * meanTimeToFailureInMinutes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The mean time to failure for the device in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param meanTimeToFailureInMinutes
     *            new value of {@code meanTimeToFailureInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code meanTimeToFailureInMinutes} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withMeanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("meanTimeToFailureInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        return _x;
    }

    /**
     * <i>“The date and time when the statistics were last computed.”</i>
     * 
     * @return property processedDateTime
     */
    @Property(name="processedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getProcessedDateTime() {
        return Optional.ofNullable(processedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code processedDateTime
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time when the statistics were last computed.”</i>
     * 
     * @param processedDateTime
     *            new value of {@code processedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processedDateTime} field changed
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance withProcessedDateTime(OffsetDateTime processedDateTime) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("processedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDevicePerformance");
        _x.processedDateTime = processedDateTime;
        return _x;
    }

    public UserExperienceAnalyticsAppHealthDevicePerformance withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthDevicePerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthDevicePerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsAppHealthDevicePerformance _copy() {
        UserExperienceAnalyticsAppHealthDevicePerformance _x = new UserExperienceAnalyticsAppHealthDevicePerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appCrashCount = appCrashCount;
        _x.appHangCount = appHangCount;
        _x.crashedAppCount = crashedAppCount;
        _x.deviceAppHealthScore = deviceAppHealthScore;
        _x.deviceAppHealthStatus = deviceAppHealthStatus;
        _x.deviceDisplayName = deviceDisplayName;
        _x.deviceId = deviceId;
        _x.deviceManufacturer = deviceManufacturer;
        _x.deviceModel = deviceModel;
        _x.healthStatus = healthStatus;
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        _x.processedDateTime = processedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsAppHealthDevicePerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appCrashCount=");
        b.append(this.appCrashCount);
        b.append(", ");
        b.append("appHangCount=");
        b.append(this.appHangCount);
        b.append(", ");
        b.append("crashedAppCount=");
        b.append(this.crashedAppCount);
        b.append(", ");
        b.append("deviceAppHealthScore=");
        b.append(this.deviceAppHealthScore);
        b.append(", ");
        b.append("deviceAppHealthStatus=");
        b.append(this.deviceAppHealthStatus);
        b.append(", ");
        b.append("deviceDisplayName=");
        b.append(this.deviceDisplayName);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceManufacturer=");
        b.append(this.deviceManufacturer);
        b.append(", ");
        b.append("deviceModel=");
        b.append(this.deviceModel);
        b.append(", ");
        b.append("healthStatus=");
        b.append(this.healthStatus);
        b.append(", ");
        b.append("meanTimeToFailureInMinutes=");
        b.append(this.meanTimeToFailureInMinutes);
        b.append(", ");
        b.append("processedDateTime=");
        b.append(this.processedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
