package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.UserExperienceAnalyticsHealthState;


/**
 * <i>“The user experience analytics device model performance entity contains device
 * model performance details.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeDeviceCount", 
    "deviceManufacturer", 
    "deviceModel", 
    "healthStatus", 
    "meanTimeToFailureInMinutes", 
    "modelAppHealthScore", 
    "modelAppHealthStatus"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsAppHealthDeviceModelPerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsAppHealthDeviceModelPerformance";
    }

    @JsonProperty("activeDeviceCount")
    protected Integer activeDeviceCount;

    @JsonProperty("deviceManufacturer")
    protected String deviceManufacturer;

    @JsonProperty("deviceModel")
    protected String deviceModel;

    @JsonProperty("healthStatus")
    protected UserExperienceAnalyticsHealthState healthStatus;

    @JsonProperty("meanTimeToFailureInMinutes")
    protected Integer meanTimeToFailureInMinutes;

    @JsonProperty("modelAppHealthScore")
    protected Double modelAppHealthScore;

    @JsonProperty("modelAppHealthStatus")
    protected String modelAppHealthStatus;

    protected UserExperienceAnalyticsAppHealthDeviceModelPerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsAppHealthDeviceModelPerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer activeDeviceCount;
        private String deviceManufacturer;
        private String deviceModel;
        private UserExperienceAnalyticsHealthState healthStatus;
        private Integer meanTimeToFailureInMinutes;
        private Double modelAppHealthScore;
        private String modelAppHealthStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The number of active devices for the model. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param activeDeviceCount
         *            value of {@code activeDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeDeviceCount(Integer activeDeviceCount) {
            this.activeDeviceCount = activeDeviceCount;
            this.changedFields = changedFields.add("activeDeviceCount");
            return this;
        }

        /**
         * <i>“The manufacturer name of the device.”</i>
         * 
         * @param deviceManufacturer
         *            value of {@code deviceManufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManufacturer(String deviceManufacturer) {
            this.deviceManufacturer = deviceManufacturer;
            this.changedFields = changedFields.add("deviceManufacturer");
            return this;
        }

        /**
         * <i>“The model name of the device.”</i>
         * 
         * @param deviceModel
         *            value of {@code deviceModel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
            this.changedFields = changedFields.add("deviceModel");
            return this;
        }

        /**
         * <i>“The health state of the user experience analytics model.”</i>
         * 
         * @param healthStatus
         *            value of {@code healthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthStatus(UserExperienceAnalyticsHealthState healthStatus) {
            this.healthStatus = healthStatus;
            this.changedFields = changedFields.add("healthStatus");
            return this;
        }

        /**
         * <i>“The mean time to failure for the model device in minutes. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param meanTimeToFailureInMinutes
         *            value of {@code meanTimeToFailureInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder meanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
            this.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            this.changedFields = changedFields.add("meanTimeToFailureInMinutes");
            return this;
        }

        /**
         * <i>“The app health score of the device model. Valid values -1.79769313486232E+308 to
         * 1.79769313486232E+308”</i>
         * 
         * @param modelAppHealthScore
         *            value of {@code modelAppHealthScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modelAppHealthScore(Double modelAppHealthScore) {
            this.modelAppHealthScore = modelAppHealthScore;
            this.changedFields = changedFields.add("modelAppHealthScore");
            return this;
        }

        /**
         * <i>“The overall app health status of the device model.”</i>
         * 
         * @param modelAppHealthStatus
         *            value of {@code modelAppHealthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modelAppHealthStatus(String modelAppHealthStatus) {
            this.modelAppHealthStatus = modelAppHealthStatus;
            this.changedFields = changedFields.add("modelAppHealthStatus");
            return this;
        }

        public UserExperienceAnalyticsAppHealthDeviceModelPerformance build() {
            UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = new UserExperienceAnalyticsAppHealthDeviceModelPerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsAppHealthDeviceModelPerformance";
            _x.id = id;
            _x.activeDeviceCount = activeDeviceCount;
            _x.deviceManufacturer = deviceManufacturer;
            _x.deviceModel = deviceModel;
            _x.healthStatus = healthStatus;
            _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            _x.modelAppHealthScore = modelAppHealthScore;
            _x.modelAppHealthStatus = modelAppHealthStatus;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The number of active devices for the model. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property activeDeviceCount
     */
    @Property(name="activeDeviceCount")
    @JsonIgnore
    public Optional<Integer> getActiveDeviceCount() {
        return Optional.ofNullable(activeDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of active devices for the model. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param activeDeviceCount
     *            new value of {@code activeDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDeviceCount} field changed
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance withActiveDeviceCount(Integer activeDeviceCount) {
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("activeDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDeviceModelPerformance");
        _x.activeDeviceCount = activeDeviceCount;
        return _x;
    }

    /**
     * <i>“The manufacturer name of the device.”</i>
     * 
     * @return property deviceManufacturer
     */
    @Property(name="deviceManufacturer")
    @JsonIgnore
    public Optional<String> getDeviceManufacturer() {
        return Optional.ofNullable(deviceManufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManufacturer} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The manufacturer name of the device.”</i>
     * 
     * @param deviceManufacturer
     *            new value of {@code deviceManufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManufacturer} field changed
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance withDeviceManufacturer(String deviceManufacturer) {
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceManufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDeviceModelPerformance");
        _x.deviceManufacturer = deviceManufacturer;
        return _x;
    }

    /**
     * <i>“The model name of the device.”</i>
     * 
     * @return property deviceModel
     */
    @Property(name="deviceModel")
    @JsonIgnore
    public Optional<String> getDeviceModel() {
        return Optional.ofNullable(deviceModel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceModel}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The model name of the device.”</i>
     * 
     * @param deviceModel
     *            new value of {@code deviceModel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceModel} field changed
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance withDeviceModel(String deviceModel) {
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceModel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDeviceModelPerformance");
        _x.deviceModel = deviceModel;
        return _x;
    }

    /**
     * <i>“The health state of the user experience analytics model.”</i>
     * 
     * @return property healthStatus
     */
    @Property(name="healthStatus")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsHealthState> getHealthStatus() {
        return Optional.ofNullable(healthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code healthStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The health state of the user experience analytics model.”</i>
     * 
     * @param healthStatus
     *            new value of {@code healthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthStatus} field changed
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance withHealthStatus(UserExperienceAnalyticsHealthState healthStatus) {
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("healthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDeviceModelPerformance");
        _x.healthStatus = healthStatus;
        return _x;
    }

    /**
     * <i>“The mean time to failure for the model device in minutes. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property meanTimeToFailureInMinutes
     */
    @Property(name="meanTimeToFailureInMinutes")
    @JsonIgnore
    public Optional<Integer> getMeanTimeToFailureInMinutes() {
        return Optional.ofNullable(meanTimeToFailureInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * meanTimeToFailureInMinutes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The mean time to failure for the model device in minutes. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param meanTimeToFailureInMinutes
     *            new value of {@code meanTimeToFailureInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code meanTimeToFailureInMinutes} field changed
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance withMeanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("meanTimeToFailureInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDeviceModelPerformance");
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        return _x;
    }

    /**
     * <i>“The app health score of the device model. Valid values -1.79769313486232E+308 to
     * 1.79769313486232E+308”</i>
     * 
     * @return property modelAppHealthScore
     */
    @Property(name="modelAppHealthScore")
    @JsonIgnore
    public Optional<Double> getModelAppHealthScore() {
        return Optional.ofNullable(modelAppHealthScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * modelAppHealthScore} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The app health score of the device model. Valid values -1.79769313486232E+308 to
     * 1.79769313486232E+308”</i>
     * 
     * @param modelAppHealthScore
     *            new value of {@code modelAppHealthScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modelAppHealthScore} field changed
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance withModelAppHealthScore(Double modelAppHealthScore) {
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("modelAppHealthScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDeviceModelPerformance");
        _x.modelAppHealthScore = modelAppHealthScore;
        return _x;
    }

    /**
     * <i>“The overall app health status of the device model.”</i>
     * 
     * @return property modelAppHealthStatus
     */
    @Property(name="modelAppHealthStatus")
    @JsonIgnore
    public Optional<String> getModelAppHealthStatus() {
        return Optional.ofNullable(modelAppHealthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * modelAppHealthStatus} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The overall app health status of the device model.”</i>
     * 
     * @param modelAppHealthStatus
     *            new value of {@code modelAppHealthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modelAppHealthStatus} field changed
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance withModelAppHealthStatus(String modelAppHealthStatus) {
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.changedFields = changedFields.add("modelAppHealthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthDeviceModelPerformance");
        _x.modelAppHealthStatus = modelAppHealthStatus;
        return _x;
    }

    public UserExperienceAnalyticsAppHealthDeviceModelPerformance withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthDeviceModelPerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsAppHealthDeviceModelPerformance _copy() {
        UserExperienceAnalyticsAppHealthDeviceModelPerformance _x = new UserExperienceAnalyticsAppHealthDeviceModelPerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activeDeviceCount = activeDeviceCount;
        _x.deviceManufacturer = deviceManufacturer;
        _x.deviceModel = deviceModel;
        _x.healthStatus = healthStatus;
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        _x.modelAppHealthScore = modelAppHealthScore;
        _x.modelAppHealthStatus = modelAppHealthStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsAppHealthDeviceModelPerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activeDeviceCount=");
        b.append(this.activeDeviceCount);
        b.append(", ");
        b.append("deviceManufacturer=");
        b.append(this.deviceManufacturer);
        b.append(", ");
        b.append("deviceModel=");
        b.append(this.deviceModel);
        b.append(", ");
        b.append("healthStatus=");
        b.append(this.healthStatus);
        b.append(", ");
        b.append("meanTimeToFailureInMinutes=");
        b.append(this.meanTimeToFailureInMinutes);
        b.append(", ");
        b.append("modelAppHealthScore=");
        b.append(this.modelAppHealthScore);
        b.append(", ");
        b.append("modelAppHealthStatus=");
        b.append(this.modelAppHealthStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
