package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics application performance entity contains app
 * performance details.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeDeviceCount", 
    "appCrashCount", 
    "appDisplayName", 
    "appHangCount", 
    "appHealthScore", 
    "appHealthStatus", 
    "appName", 
    "appPublisher", 
    "appUsageDuration", 
    "meanTimeToFailureInMinutes"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsAppHealthApplicationPerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance";
    }

    @JsonProperty("activeDeviceCount")
    protected Integer activeDeviceCount;

    @JsonProperty("appCrashCount")
    protected Integer appCrashCount;

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appHangCount")
    protected Integer appHangCount;

    @JsonProperty("appHealthScore")
    protected Double appHealthScore;

    @JsonProperty("appHealthStatus")
    protected String appHealthStatus;

    @JsonProperty("appName")
    protected String appName;

    @JsonProperty("appPublisher")
    protected String appPublisher;

    @JsonProperty("appUsageDuration")
    protected Integer appUsageDuration;

    @JsonProperty("meanTimeToFailureInMinutes")
    protected Integer meanTimeToFailureInMinutes;

    protected UserExperienceAnalyticsAppHealthApplicationPerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsAppHealthApplicationPerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer activeDeviceCount;
        private Integer appCrashCount;
        private String appDisplayName;
        private Integer appHangCount;
        private Double appHealthScore;
        private String appHealthStatus;
        private String appName;
        private String appPublisher;
        private Integer appUsageDuration;
        private Integer meanTimeToFailureInMinutes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The number of devices where the app has been active. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param activeDeviceCount
         *            value of {@code activeDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeDeviceCount(Integer activeDeviceCount) {
            this.activeDeviceCount = activeDeviceCount;
            this.changedFields = changedFields.add("activeDeviceCount");
            return this;
        }

        /**
         * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param appCrashCount
         *            value of {@code appCrashCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appCrashCount(Integer appCrashCount) {
            this.appCrashCount = appCrashCount;
            this.changedFields = changedFields.add("appCrashCount");
            return this;
        }

        /**
         * <i>“The friendly name of the application.”</i>
         * 
         * @param appDisplayName
         *            value of {@code appDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        /**
         * <i>“The number of hangs for the app. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param appHangCount
         *            value of {@code appHangCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appHangCount(Integer appHangCount) {
            this.appHangCount = appHangCount;
            this.changedFields = changedFields.add("appHangCount");
            return this;
        }

        /**
         * <i>“The health score of the app. Valid values -1.79769313486232E+308 to 1.
         * 79769313486232E+308”</i>
         * 
         * @param appHealthScore
         *            value of {@code appHealthScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appHealthScore(Double appHealthScore) {
            this.appHealthScore = appHealthScore;
            this.changedFields = changedFields.add("appHealthScore");
            return this;
        }

        /**
         * <i>“The overall health status of the app.”</i>
         * 
         * @param appHealthStatus
         *            value of {@code appHealthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appHealthStatus(String appHealthStatus) {
            this.appHealthStatus = appHealthStatus;
            this.changedFields = changedFields.add("appHealthStatus");
            return this;
        }

        /**
         * <i>“The name of the application.”</i>
         * 
         * @param appName
         *            value of {@code appName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appName(String appName) {
            this.appName = appName;
            this.changedFields = changedFields.add("appName");
            return this;
        }

        /**
         * <i>“The publisher of the application.”</i>
         * 
         * @param appPublisher
         *            value of {@code appPublisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appPublisher(String appPublisher) {
            this.appPublisher = appPublisher;
            this.changedFields = changedFields.add("appPublisher");
            return this;
        }

        /**
         * <i>“The total usage time of the application in minutes. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param appUsageDuration
         *            value of {@code appUsageDuration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appUsageDuration(Integer appUsageDuration) {
            this.appUsageDuration = appUsageDuration;
            this.changedFields = changedFields.add("appUsageDuration");
            return this;
        }

        /**
         * <i>“The mean time to failure for the app in minutes. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param meanTimeToFailureInMinutes
         *            value of {@code meanTimeToFailureInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder meanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
            this.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            this.changedFields = changedFields.add("meanTimeToFailureInMinutes");
            return this;
        }

        public UserExperienceAnalyticsAppHealthApplicationPerformance build() {
            UserExperienceAnalyticsAppHealthApplicationPerformance _x = new UserExperienceAnalyticsAppHealthApplicationPerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance";
            _x.id = id;
            _x.activeDeviceCount = activeDeviceCount;
            _x.appCrashCount = appCrashCount;
            _x.appDisplayName = appDisplayName;
            _x.appHangCount = appHangCount;
            _x.appHealthScore = appHealthScore;
            _x.appHealthStatus = appHealthStatus;
            _x.appName = appName;
            _x.appPublisher = appPublisher;
            _x.appUsageDuration = appUsageDuration;
            _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The number of devices where the app has been active. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property activeDeviceCount
     */
    @Property(name="activeDeviceCount")
    @JsonIgnore
    public Optional<Integer> getActiveDeviceCount() {
        return Optional.ofNullable(activeDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of devices where the app has been active. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param activeDeviceCount
     *            new value of {@code activeDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDeviceCount} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withActiveDeviceCount(Integer activeDeviceCount) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("activeDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.activeDeviceCount = activeDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property appCrashCount
     */
    @Property(name="appCrashCount")
    @JsonIgnore
    public Optional<Integer> getAppCrashCount() {
        return Optional.ofNullable(appCrashCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appCrashCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param appCrashCount
     *            new value of {@code appCrashCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appCrashCount} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withAppCrashCount(Integer appCrashCount) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("appCrashCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.appCrashCount = appCrashCount;
        return _x;
    }

    /**
     * <i>“The friendly name of the application.”</i>
     * 
     * @return property appDisplayName
     */
    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The friendly name of the application.”</i>
     * 
     * @param appDisplayName
     *            new value of {@code appDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appDisplayName} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withAppDisplayName(String appDisplayName) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    /**
     * <i>“The number of hangs for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property appHangCount
     */
    @Property(name="appHangCount")
    @JsonIgnore
    public Optional<Integer> getAppHangCount() {
        return Optional.ofNullable(appHangCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appHangCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of hangs for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param appHangCount
     *            new value of {@code appHangCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appHangCount} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withAppHangCount(Integer appHangCount) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("appHangCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.appHangCount = appHangCount;
        return _x;
    }

    /**
     * <i>“The health score of the app. Valid values -1.79769313486232E+308 to 1.
     * 79769313486232E+308”</i>
     * 
     * @return property appHealthScore
     */
    @Property(name="appHealthScore")
    @JsonIgnore
    public Optional<Double> getAppHealthScore() {
        return Optional.ofNullable(appHealthScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appHealthScore}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The health score of the app. Valid values -1.79769313486232E+308 to 1.
     * 79769313486232E+308”</i>
     * 
     * @param appHealthScore
     *            new value of {@code appHealthScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appHealthScore} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withAppHealthScore(Double appHealthScore) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("appHealthScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.appHealthScore = appHealthScore;
        return _x;
    }

    /**
     * <i>“The overall health status of the app.”</i>
     * 
     * @return property appHealthStatus
     */
    @Property(name="appHealthStatus")
    @JsonIgnore
    public Optional<String> getAppHealthStatus() {
        return Optional.ofNullable(appHealthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appHealthStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The overall health status of the app.”</i>
     * 
     * @param appHealthStatus
     *            new value of {@code appHealthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appHealthStatus} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withAppHealthStatus(String appHealthStatus) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("appHealthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.appHealthStatus = appHealthStatus;
        return _x;
    }

    /**
     * <i>“The name of the application.”</i>
     * 
     * @return property appName
     */
    @Property(name="appName")
    @JsonIgnore
    public Optional<String> getAppName() {
        return Optional.ofNullable(appName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the application.”</i>
     * 
     * @param appName
     *            new value of {@code appName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appName} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withAppName(String appName) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("appName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.appName = appName;
        return _x;
    }

    /**
     * <i>“The publisher of the application.”</i>
     * 
     * @return property appPublisher
     */
    @Property(name="appPublisher")
    @JsonIgnore
    public Optional<String> getAppPublisher() {
        return Optional.ofNullable(appPublisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appPublisher}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The publisher of the application.”</i>
     * 
     * @param appPublisher
     *            new value of {@code appPublisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appPublisher} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withAppPublisher(String appPublisher) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("appPublisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.appPublisher = appPublisher;
        return _x;
    }

    /**
     * <i>“The total usage time of the application in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property appUsageDuration
     */
    @Property(name="appUsageDuration")
    @JsonIgnore
    public Optional<Integer> getAppUsageDuration() {
        return Optional.ofNullable(appUsageDuration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appUsageDuration}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total usage time of the application in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param appUsageDuration
     *            new value of {@code appUsageDuration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appUsageDuration} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withAppUsageDuration(Integer appUsageDuration) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("appUsageDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.appUsageDuration = appUsageDuration;
        return _x;
    }

    /**
     * <i>“The mean time to failure for the app in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property meanTimeToFailureInMinutes
     */
    @Property(name="meanTimeToFailureInMinutes")
    @JsonIgnore
    public Optional<Integer> getMeanTimeToFailureInMinutes() {
        return Optional.ofNullable(meanTimeToFailureInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * meanTimeToFailureInMinutes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The mean time to failure for the app in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param meanTimeToFailureInMinutes
     *            new value of {@code meanTimeToFailureInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code meanTimeToFailureInMinutes} field changed
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance withMeanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = changedFields.add("meanTimeToFailureInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        return _x;
    }

    public UserExperienceAnalyticsAppHealthApplicationPerformance withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthApplicationPerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsAppHealthApplicationPerformance _copy() {
        UserExperienceAnalyticsAppHealthApplicationPerformance _x = new UserExperienceAnalyticsAppHealthApplicationPerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activeDeviceCount = activeDeviceCount;
        _x.appCrashCount = appCrashCount;
        _x.appDisplayName = appDisplayName;
        _x.appHangCount = appHangCount;
        _x.appHealthScore = appHealthScore;
        _x.appHealthStatus = appHealthStatus;
        _x.appName = appName;
        _x.appPublisher = appPublisher;
        _x.appUsageDuration = appUsageDuration;
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsAppHealthApplicationPerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activeDeviceCount=");
        b.append(this.activeDeviceCount);
        b.append(", ");
        b.append("appCrashCount=");
        b.append(this.appCrashCount);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appHangCount=");
        b.append(this.appHangCount);
        b.append(", ");
        b.append("appHealthScore=");
        b.append(this.appHealthScore);
        b.append(", ");
        b.append("appHealthStatus=");
        b.append(this.appHealthStatus);
        b.append(", ");
        b.append("appName=");
        b.append(this.appName);
        b.append(", ");
        b.append("appPublisher=");
        b.append(this.appPublisher);
        b.append(", ");
        b.append("appUsageDuration=");
        b.append(this.appUsageDuration);
        b.append(", ");
        b.append("meanTimeToFailureInMinutes=");
        b.append(this.meanTimeToFailureInMinutes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
