package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics application performance entity contains app
 * performance details by OS version.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeDeviceCount", 
    "appCrashCount", 
    "appDisplayName", 
    "appName", 
    "appPublisher", 
    "appUsageDuration", 
    "meanTimeToFailureInMinutes", 
    "osBuildNumber", 
    "osVersion"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion";
    }

    @JsonProperty("activeDeviceCount")
    protected Integer activeDeviceCount;

    @JsonProperty("appCrashCount")
    protected Integer appCrashCount;

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appName")
    protected String appName;

    @JsonProperty("appPublisher")
    protected String appPublisher;

    @JsonProperty("appUsageDuration")
    protected Integer appUsageDuration;

    @JsonProperty("meanTimeToFailureInMinutes")
    protected Integer meanTimeToFailureInMinutes;

    @JsonProperty("osBuildNumber")
    protected String osBuildNumber;

    @JsonProperty("osVersion")
    protected String osVersion;

    protected UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer activeDeviceCount;
        private Integer appCrashCount;
        private String appDisplayName;
        private String appName;
        private String appPublisher;
        private Integer appUsageDuration;
        private Integer meanTimeToFailureInMinutes;
        private String osBuildNumber;
        private String osVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The number of devices where the app has been active. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param activeDeviceCount
         *            value of {@code activeDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeDeviceCount(Integer activeDeviceCount) {
            this.activeDeviceCount = activeDeviceCount;
            this.changedFields = changedFields.add("activeDeviceCount");
            return this;
        }

        /**
         * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param appCrashCount
         *            value of {@code appCrashCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appCrashCount(Integer appCrashCount) {
            this.appCrashCount = appCrashCount;
            this.changedFields = changedFields.add("appCrashCount");
            return this;
        }

        /**
         * <i>“The friendly name of the application.”</i>
         * 
         * @param appDisplayName
         *            value of {@code appDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        /**
         * <i>“The name of the application.”</i>
         * 
         * @param appName
         *            value of {@code appName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appName(String appName) {
            this.appName = appName;
            this.changedFields = changedFields.add("appName");
            return this;
        }

        /**
         * <i>“The publisher of the application.”</i>
         * 
         * @param appPublisher
         *            value of {@code appPublisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appPublisher(String appPublisher) {
            this.appPublisher = appPublisher;
            this.changedFields = changedFields.add("appPublisher");
            return this;
        }

        /**
         * <i>“The total usage time of the application in minutes. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param appUsageDuration
         *            value of {@code appUsageDuration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appUsageDuration(Integer appUsageDuration) {
            this.appUsageDuration = appUsageDuration;
            this.changedFields = changedFields.add("appUsageDuration");
            return this;
        }

        /**
         * <i>“The mean time to failure for the app in minutes. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param meanTimeToFailureInMinutes
         *            value of {@code meanTimeToFailureInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder meanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
            this.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            this.changedFields = changedFields.add("meanTimeToFailureInMinutes");
            return this;
        }

        /**
         * <i>“The os build number of the application.”</i>
         * 
         * @param osBuildNumber
         *            value of {@code osBuildNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osBuildNumber(String osBuildNumber) {
            this.osBuildNumber = osBuildNumber;
            this.changedFields = changedFields.add("osBuildNumber");
            return this;
        }

        /**
         * <i>“The os version of the application.”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion build() {
            UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = new UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion";
            _x.id = id;
            _x.activeDeviceCount = activeDeviceCount;
            _x.appCrashCount = appCrashCount;
            _x.appDisplayName = appDisplayName;
            _x.appName = appName;
            _x.appPublisher = appPublisher;
            _x.appUsageDuration = appUsageDuration;
            _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
            _x.osBuildNumber = osBuildNumber;
            _x.osVersion = osVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The number of devices where the app has been active. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property activeDeviceCount
     */
    @Property(name="activeDeviceCount")
    @JsonIgnore
    public Optional<Integer> getActiveDeviceCount() {
        return Optional.ofNullable(activeDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of devices where the app has been active. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param activeDeviceCount
     *            new value of {@code activeDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDeviceCount} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withActiveDeviceCount(Integer activeDeviceCount) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = changedFields.add("activeDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion");
        _x.activeDeviceCount = activeDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property appCrashCount
     */
    @Property(name="appCrashCount")
    @JsonIgnore
    public Optional<Integer> getAppCrashCount() {
        return Optional.ofNullable(appCrashCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appCrashCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param appCrashCount
     *            new value of {@code appCrashCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appCrashCount} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withAppCrashCount(Integer appCrashCount) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = changedFields.add("appCrashCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion");
        _x.appCrashCount = appCrashCount;
        return _x;
    }

    /**
     * <i>“The friendly name of the application.”</i>
     * 
     * @return property appDisplayName
     */
    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The friendly name of the application.”</i>
     * 
     * @param appDisplayName
     *            new value of {@code appDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appDisplayName} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withAppDisplayName(String appDisplayName) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    /**
     * <i>“The name of the application.”</i>
     * 
     * @return property appName
     */
    @Property(name="appName")
    @JsonIgnore
    public Optional<String> getAppName() {
        return Optional.ofNullable(appName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the application.”</i>
     * 
     * @param appName
     *            new value of {@code appName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appName} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withAppName(String appName) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = changedFields.add("appName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion");
        _x.appName = appName;
        return _x;
    }

    /**
     * <i>“The publisher of the application.”</i>
     * 
     * @return property appPublisher
     */
    @Property(name="appPublisher")
    @JsonIgnore
    public Optional<String> getAppPublisher() {
        return Optional.ofNullable(appPublisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appPublisher}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The publisher of the application.”</i>
     * 
     * @param appPublisher
     *            new value of {@code appPublisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appPublisher} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withAppPublisher(String appPublisher) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = changedFields.add("appPublisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion");
        _x.appPublisher = appPublisher;
        return _x;
    }

    /**
     * <i>“The total usage time of the application in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property appUsageDuration
     */
    @Property(name="appUsageDuration")
    @JsonIgnore
    public Optional<Integer> getAppUsageDuration() {
        return Optional.ofNullable(appUsageDuration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appUsageDuration}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total usage time of the application in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param appUsageDuration
     *            new value of {@code appUsageDuration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appUsageDuration} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withAppUsageDuration(Integer appUsageDuration) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = changedFields.add("appUsageDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion");
        _x.appUsageDuration = appUsageDuration;
        return _x;
    }

    /**
     * <i>“The mean time to failure for the app in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property meanTimeToFailureInMinutes
     */
    @Property(name="meanTimeToFailureInMinutes")
    @JsonIgnore
    public Optional<Integer> getMeanTimeToFailureInMinutes() {
        return Optional.ofNullable(meanTimeToFailureInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * meanTimeToFailureInMinutes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The mean time to failure for the app in minutes. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param meanTimeToFailureInMinutes
     *            new value of {@code meanTimeToFailureInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code meanTimeToFailureInMinutes} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withMeanTimeToFailureInMinutes(Integer meanTimeToFailureInMinutes) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = changedFields.add("meanTimeToFailureInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion");
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        return _x;
    }

    /**
     * <i>“The os build number of the application.”</i>
     * 
     * @return property osBuildNumber
     */
    @Property(name="osBuildNumber")
    @JsonIgnore
    public Optional<String> getOsBuildNumber() {
        return Optional.ofNullable(osBuildNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osBuildNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The os build number of the application.”</i>
     * 
     * @param osBuildNumber
     *            new value of {@code osBuildNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osBuildNumber} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withOsBuildNumber(String osBuildNumber) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = changedFields.add("osBuildNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion");
        _x.osBuildNumber = osBuildNumber;
        return _x;
    }

    /**
     * <i>“The os version of the application.”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The os version of the application.”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withOsVersion(String osVersion) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByOSVersion");
        _x.osVersion = osVersion;
        return _x;
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _copy() {
        UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion _x = new UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activeDeviceCount = activeDeviceCount;
        _x.appCrashCount = appCrashCount;
        _x.appDisplayName = appDisplayName;
        _x.appName = appName;
        _x.appPublisher = appPublisher;
        _x.appUsageDuration = appUsageDuration;
        _x.meanTimeToFailureInMinutes = meanTimeToFailureInMinutes;
        _x.osBuildNumber = osBuildNumber;
        _x.osVersion = osVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activeDeviceCount=");
        b.append(this.activeDeviceCount);
        b.append(", ");
        b.append("appCrashCount=");
        b.append(this.appCrashCount);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appName=");
        b.append(this.appName);
        b.append(", ");
        b.append("appPublisher=");
        b.append(this.appPublisher);
        b.append(", ");
        b.append("appUsageDuration=");
        b.append(this.appUsageDuration);
        b.append(", ");
        b.append("meanTimeToFailureInMinutes=");
        b.append(this.meanTimeToFailureInMinutes);
        b.append(", ");
        b.append("osBuildNumber=");
        b.append(this.osBuildNumber);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
