package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics application performance entity contains app
 * performance by app version details.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appCrashCount", 
    "appDisplayName", 
    "appName", 
    "appPublisher", 
    "appVersion", 
    "deviceCountWithCrashes", 
    "isLatestUsedVersion", 
    "isMostUsedVersion"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails";
    }

    @JsonProperty("appCrashCount")
    protected Integer appCrashCount;

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appName")
    protected String appName;

    @JsonProperty("appPublisher")
    protected String appPublisher;

    @JsonProperty("appVersion")
    protected String appVersion;

    @JsonProperty("deviceCountWithCrashes")
    protected Integer deviceCountWithCrashes;

    @JsonProperty("isLatestUsedVersion")
    protected Boolean isLatestUsedVersion;

    @JsonProperty("isMostUsedVersion")
    protected Boolean isMostUsedVersion;

    protected UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer appCrashCount;
        private String appDisplayName;
        private String appName;
        private String appPublisher;
        private String appVersion;
        private Integer deviceCountWithCrashes;
        private Boolean isLatestUsedVersion;
        private Boolean isMostUsedVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param appCrashCount
         *            value of {@code appCrashCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appCrashCount(Integer appCrashCount) {
            this.appCrashCount = appCrashCount;
            this.changedFields = changedFields.add("appCrashCount");
            return this;
        }

        /**
         * <i>“The friendly name of the application.”</i>
         * 
         * @param appDisplayName
         *            value of {@code appDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        /**
         * <i>“The name of the application.”</i>
         * 
         * @param appName
         *            value of {@code appName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appName(String appName) {
            this.appName = appName;
            this.changedFields = changedFields.add("appName");
            return this;
        }

        /**
         * <i>“The publisher of the application.”</i>
         * 
         * @param appPublisher
         *            value of {@code appPublisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appPublisher(String appPublisher) {
            this.appPublisher = appPublisher;
            this.changedFields = changedFields.add("appPublisher");
            return this;
        }

        /**
         * <i>“The version of the application.”</i>
         * 
         * @param appVersion
         *            value of {@code appVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            this.changedFields = changedFields.add("appVersion");
            return this;
        }

        /**
         * <i>“The total number of devices that have reported one or more application crashes
         * for this application and version. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param deviceCountWithCrashes
         *            value of {@code deviceCountWithCrashes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCountWithCrashes(Integer deviceCountWithCrashes) {
            this.deviceCountWithCrashes = deviceCountWithCrashes;
            this.changedFields = changedFields.add("deviceCountWithCrashes");
            return this;
        }

        /**
         * <i>“Is the version of application the latest version for that app that is in use.”</i>
         * 
         * @param isLatestUsedVersion
         *            value of {@code isLatestUsedVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isLatestUsedVersion(Boolean isLatestUsedVersion) {
            this.isLatestUsedVersion = isLatestUsedVersion;
            this.changedFields = changedFields.add("isLatestUsedVersion");
            return this;
        }

        /**
         * <i>“Is the version of application the most used version for that app.”</i>
         * 
         * @param isMostUsedVersion
         *            value of {@code isMostUsedVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isMostUsedVersion(Boolean isMostUsedVersion) {
            this.isMostUsedVersion = isMostUsedVersion;
            this.changedFields = changedFields.add("isMostUsedVersion");
            return this;
        }

        public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails build() {
            UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails";
            _x.id = id;
            _x.appCrashCount = appCrashCount;
            _x.appDisplayName = appDisplayName;
            _x.appName = appName;
            _x.appPublisher = appPublisher;
            _x.appVersion = appVersion;
            _x.deviceCountWithCrashes = deviceCountWithCrashes;
            _x.isLatestUsedVersion = isLatestUsedVersion;
            _x.isMostUsedVersion = isMostUsedVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property appCrashCount
     */
    @Property(name="appCrashCount")
    @JsonIgnore
    public Optional<Integer> getAppCrashCount() {
        return Optional.ofNullable(appCrashCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appCrashCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of crashes for the app. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param appCrashCount
     *            new value of {@code appCrashCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appCrashCount} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails withAppCrashCount(Integer appCrashCount) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = changedFields.add("appCrashCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails");
        _x.appCrashCount = appCrashCount;
        return _x;
    }

    /**
     * <i>“The friendly name of the application.”</i>
     * 
     * @return property appDisplayName
     */
    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The friendly name of the application.”</i>
     * 
     * @param appDisplayName
     *            new value of {@code appDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appDisplayName} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails withAppDisplayName(String appDisplayName) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    /**
     * <i>“The name of the application.”</i>
     * 
     * @return property appName
     */
    @Property(name="appName")
    @JsonIgnore
    public Optional<String> getAppName() {
        return Optional.ofNullable(appName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the application.”</i>
     * 
     * @param appName
     *            new value of {@code appName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appName} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails withAppName(String appName) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = changedFields.add("appName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails");
        _x.appName = appName;
        return _x;
    }

    /**
     * <i>“The publisher of the application.”</i>
     * 
     * @return property appPublisher
     */
    @Property(name="appPublisher")
    @JsonIgnore
    public Optional<String> getAppPublisher() {
        return Optional.ofNullable(appPublisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appPublisher}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The publisher of the application.”</i>
     * 
     * @param appPublisher
     *            new value of {@code appPublisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appPublisher} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails withAppPublisher(String appPublisher) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = changedFields.add("appPublisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails");
        _x.appPublisher = appPublisher;
        return _x;
    }

    /**
     * <i>“The version of the application.”</i>
     * 
     * @return property appVersion
     */
    @Property(name="appVersion")
    @JsonIgnore
    public Optional<String> getAppVersion() {
        return Optional.ofNullable(appVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The version of the application.”</i>
     * 
     * @param appVersion
     *            new value of {@code appVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appVersion} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails withAppVersion(String appVersion) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = changedFields.add("appVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails");
        _x.appVersion = appVersion;
        return _x;
    }

    /**
     * <i>“The total number of devices that have reported one or more application crashes
     * for this application and version. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property deviceCountWithCrashes
     */
    @Property(name="deviceCountWithCrashes")
    @JsonIgnore
    public Optional<Integer> getDeviceCountWithCrashes() {
        return Optional.ofNullable(deviceCountWithCrashes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceCountWithCrashes} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The total number of devices that have reported one or more application crashes
     * for this application and version. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param deviceCountWithCrashes
     *            new value of {@code deviceCountWithCrashes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCountWithCrashes} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails withDeviceCountWithCrashes(Integer deviceCountWithCrashes) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = changedFields.add("deviceCountWithCrashes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails");
        _x.deviceCountWithCrashes = deviceCountWithCrashes;
        return _x;
    }

    /**
     * <i>“Is the version of application the latest version for that app that is in use.”</i>
     * 
     * @return property isLatestUsedVersion
     */
    @Property(name="isLatestUsedVersion")
    @JsonIgnore
    public Optional<Boolean> getIsLatestUsedVersion() {
        return Optional.ofNullable(isLatestUsedVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isLatestUsedVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Is the version of application the latest version for that app that is in use.”</i>
     * 
     * @param isLatestUsedVersion
     *            new value of {@code isLatestUsedVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isLatestUsedVersion} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails withIsLatestUsedVersion(Boolean isLatestUsedVersion) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = changedFields.add("isLatestUsedVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails");
        _x.isLatestUsedVersion = isLatestUsedVersion;
        return _x;
    }

    /**
     * <i>“Is the version of application the most used version for that app.”</i>
     * 
     * @return property isMostUsedVersion
     */
    @Property(name="isMostUsedVersion")
    @JsonIgnore
    public Optional<Boolean> getIsMostUsedVersion() {
        return Optional.ofNullable(isMostUsedVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isMostUsedVersion
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Is the version of application the most used version for that app.”</i>
     * 
     * @param isMostUsedVersion
     *            new value of {@code isMostUsedVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isMostUsedVersion} field changed
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails withIsMostUsedVersion(Boolean isMostUsedVersion) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = changedFields.add("isMostUsedVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails");
        _x.isMostUsedVersion = isMostUsedVersion;
        return _x;
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _copy() {
        UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails _x = new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appCrashCount = appCrashCount;
        _x.appDisplayName = appDisplayName;
        _x.appName = appName;
        _x.appPublisher = appPublisher;
        _x.appVersion = appVersion;
        _x.deviceCountWithCrashes = deviceCountWithCrashes;
        _x.isLatestUsedVersion = isLatestUsedVersion;
        _x.isMostUsedVersion = isMostUsedVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appCrashCount=");
        b.append(this.appCrashCount);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appName=");
        b.append(this.appName);
        b.append(", ");
        b.append("appPublisher=");
        b.append(this.appPublisher);
        b.append(", ");
        b.append("appVersion=");
        b.append(this.appVersion);
        b.append(", ");
        b.append("deviceCountWithCrashes=");
        b.append(this.deviceCountWithCrashes);
        b.append(", ");
        b.append("isLatestUsedVersion=");
        b.append(this.isLatestUsedVersion);
        b.append(", ");
        b.append("isMostUsedVersion=");
        b.append(this.isMostUsedVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
