package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Settings;
import odata.msgraph.client.beta.entity.collection.request.ActivityStatisticsCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "settings", 
    "activityStatistics"})
@JsonInclude(Include.NON_NULL)
public class UserAnalytics extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userAnalytics";
    }

    @JsonProperty("settings")
    protected Settings settings;

    @JsonProperty("activityStatistics")
    protected List<ActivityStatistics> activityStatistics;

    protected UserAnalytics() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserAnalytics() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Settings settings;
        private List<ActivityStatistics> activityStatistics;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder activityStatistics(List<ActivityStatistics> activityStatistics) {
            this.activityStatistics = activityStatistics;
            this.changedFields = changedFields.add("activityStatistics");
            return this;
        }

        public Builder activityStatistics(ActivityStatistics... activityStatistics) {
            return activityStatistics(Arrays.asList(activityStatistics));
        }

        public UserAnalytics build() {
            UserAnalytics _x = new UserAnalytics();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userAnalytics";
            _x.id = id;
            _x.settings = settings;
            _x.activityStatistics = activityStatistics;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<Settings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public UserAnalytics withSettings(Settings settings) {
        UserAnalytics _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAnalytics");
        _x.settings = settings;
        return _x;
    }

    public UserAnalytics withUnmappedField(String name, Object value) {
        UserAnalytics _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="activityStatistics")
    @JsonIgnore
    public ActivityStatisticsCollectionRequest getActivityStatistics() {
        return new ActivityStatisticsCollectionRequest(
                        contextPath.addSegment("activityStatistics"), Optional.ofNullable(activityStatistics));
    }

    public UserAnalytics withActivityStatistics(List<ActivityStatistics> activityStatistics) {
        UserAnalytics _x = _copy();
        _x.changedFields = changedFields.add("activityStatistics");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAnalytics");
        _x.activityStatistics = activityStatistics;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserAnalytics patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserAnalytics _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserAnalytics put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserAnalytics _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserAnalytics _copy() {
        UserAnalytics _x = new UserAnalytics();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.settings = settings;
        _x.activityStatistics = activityStatistics;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserAnalytics[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("activityStatistics=");
        b.append(this.activityStatistics);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
