package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.UsageRightState;

@JsonPropertyOrder({
    "@odata.type", 
    "catalogId", 
    "serviceIdentifier", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class UsageRight extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.usageRight";
    }

    @JsonProperty("catalogId")
    protected String catalogId;

    @JsonProperty("serviceIdentifier")
    protected String serviceIdentifier;

    @JsonProperty("state")
    protected UsageRightState state;

    protected UsageRight() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUsageRight() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String catalogId;
        private String serviceIdentifier;
        private UsageRightState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            this.changedFields = changedFields.add("catalogId");
            return this;
        }

        public Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            this.changedFields = changedFields.add("serviceIdentifier");
            return this;
        }

        public Builder state(UsageRightState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public UsageRight build() {
            UsageRight _x = new UsageRight();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.usageRight";
            _x.id = id;
            _x.catalogId = catalogId;
            _x.serviceIdentifier = serviceIdentifier;
            _x.state = state;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="catalogId")
    @JsonIgnore
    public Optional<String> getCatalogId() {
        return Optional.ofNullable(catalogId);
    }

    public UsageRight withCatalogId(String catalogId) {
        UsageRight _x = _copy();
        _x.changedFields = changedFields.add("catalogId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.usageRight");
        _x.catalogId = catalogId;
        return _x;
    }

    @Property(name="serviceIdentifier")
    @JsonIgnore
    public Optional<String> getServiceIdentifier() {
        return Optional.ofNullable(serviceIdentifier);
    }

    public UsageRight withServiceIdentifier(String serviceIdentifier) {
        UsageRight _x = _copy();
        _x.changedFields = changedFields.add("serviceIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.usageRight");
        _x.serviceIdentifier = serviceIdentifier;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<UsageRightState> getState() {
        return Optional.ofNullable(state);
    }

    public UsageRight withState(UsageRightState state) {
        UsageRight _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.usageRight");
        _x.state = state;
        return _x;
    }

    public UsageRight withUnmappedField(String name, Object value) {
        UsageRight _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UsageRight patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UsageRight _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UsageRight put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UsageRight _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UsageRight _copy() {
        UsageRight _x = new UsageRight();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.catalogId = catalogId;
        _x.serviceIdentifier = serviceIdentifier;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UsageRight[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("catalogId=");
        b.append(this.catalogId);
        b.append(", ");
        b.append("serviceIdentifier=");
        b.append(this.serviceIdentifier);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
