package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "displayName", 
    "internationalStandardCode", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class UnitOfMeasure extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unitOfMeasure";
    }

    @JsonProperty("code")
    protected String code;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("internationalStandardCode")
    protected String internationalStandardCode;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected UnitOfMeasure() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnitOfMeasure() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String code;
        private String displayName;
        private String internationalStandardCode;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder internationalStandardCode(String internationalStandardCode) {
            this.internationalStandardCode = internationalStandardCode;
            this.changedFields = changedFields.add("internationalStandardCode");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public UnitOfMeasure build() {
            UnitOfMeasure _x = new UnitOfMeasure();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unitOfMeasure";
            _x.id = id;
            _x.code = code;
            _x.displayName = displayName;
            _x.internationalStandardCode = internationalStandardCode;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public UnitOfMeasure withCode(String code) {
        UnitOfMeasure _x = _copy();
        _x.changedFields = changedFields.add("code");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unitOfMeasure");
        _x.code = code;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public UnitOfMeasure withDisplayName(String displayName) {
        UnitOfMeasure _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unitOfMeasure");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="internationalStandardCode")
    @JsonIgnore
    public Optional<String> getInternationalStandardCode() {
        return Optional.ofNullable(internationalStandardCode);
    }

    public UnitOfMeasure withInternationalStandardCode(String internationalStandardCode) {
        UnitOfMeasure _x = _copy();
        _x.changedFields = changedFields.add("internationalStandardCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unitOfMeasure");
        _x.internationalStandardCode = internationalStandardCode;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public UnitOfMeasure withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        UnitOfMeasure _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unitOfMeasure");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    public UnitOfMeasure withUnmappedField(String name, Object value) {
        UnitOfMeasure _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnitOfMeasure patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnitOfMeasure _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnitOfMeasure put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnitOfMeasure _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnitOfMeasure _copy() {
        UnitOfMeasure _x = new UnitOfMeasure();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.code = code;
        _x.displayName = displayName;
        _x.internationalStandardCode = internationalStandardCode;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnitOfMeasure[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("internationalStandardCode=");
        b.append(this.internationalStandardCode);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
