package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AppScopeRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleDefinitionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "appScopeId", 
    "createdDateTime", 
    "createdUsing", 
    "directoryScopeId", 
    "modifiedDateTime", 
    "principalId", 
    "roleDefinitionId", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleScheduleBase extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleScheduleBase";
    }

    @JsonProperty("appScopeId")
    protected String appScopeId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("createdUsing")
    protected String createdUsing;

    @JsonProperty("directoryScopeId")
    protected String directoryScopeId;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("principalId")
    protected String principalId;

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("status")
    protected String status;

    protected UnifiedRoleScheduleBase() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleScheduleBase() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appScopeId;
        private OffsetDateTime createdDateTime;
        private String createdUsing;
        private String directoryScopeId;
        private OffsetDateTime modifiedDateTime;
        private String principalId;
        private String roleDefinitionId;
        private String status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appScopeId(String appScopeId) {
            this.appScopeId = appScopeId;
            this.changedFields = changedFields.add("appScopeId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdUsing(String createdUsing) {
            this.createdUsing = createdUsing;
            this.changedFields = changedFields.add("createdUsing");
            return this;
        }

        public Builder directoryScopeId(String directoryScopeId) {
            this.directoryScopeId = directoryScopeId;
            this.changedFields = changedFields.add("directoryScopeId");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.changedFields = changedFields.add("principalId");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public UnifiedRoleScheduleBase build() {
            UnifiedRoleScheduleBase _x = new UnifiedRoleScheduleBase();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleScheduleBase";
            _x.id = id;
            _x.appScopeId = appScopeId;
            _x.createdDateTime = createdDateTime;
            _x.createdUsing = createdUsing;
            _x.directoryScopeId = directoryScopeId;
            _x.modifiedDateTime = modifiedDateTime;
            _x.principalId = principalId;
            _x.roleDefinitionId = roleDefinitionId;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="appScopeId")
    @JsonIgnore
    public Optional<String> getAppScopeId() {
        return Optional.ofNullable(appScopeId);
    }

    public UnifiedRoleScheduleBase withAppScopeId(String appScopeId) {
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = changedFields.add("appScopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleScheduleBase");
        _x.appScopeId = appScopeId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public UnifiedRoleScheduleBase withCreatedDateTime(OffsetDateTime createdDateTime) {
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleScheduleBase");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="createdUsing")
    @JsonIgnore
    public Optional<String> getCreatedUsing() {
        return Optional.ofNullable(createdUsing);
    }

    public UnifiedRoleScheduleBase withCreatedUsing(String createdUsing) {
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = changedFields.add("createdUsing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleScheduleBase");
        _x.createdUsing = createdUsing;
        return _x;
    }

    @Property(name="directoryScopeId")
    @JsonIgnore
    public Optional<String> getDirectoryScopeId() {
        return Optional.ofNullable(directoryScopeId);
    }

    public UnifiedRoleScheduleBase withDirectoryScopeId(String directoryScopeId) {
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = changedFields.add("directoryScopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleScheduleBase");
        _x.directoryScopeId = directoryScopeId;
        return _x;
    }

    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    public UnifiedRoleScheduleBase withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleScheduleBase");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    @Property(name="principalId")
    @JsonIgnore
    public Optional<String> getPrincipalId() {
        return Optional.ofNullable(principalId);
    }

    public UnifiedRoleScheduleBase withPrincipalId(String principalId) {
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = changedFields.add("principalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleScheduleBase");
        _x.principalId = principalId;
        return _x;
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public UnifiedRoleScheduleBase withRoleDefinitionId(String roleDefinitionId) {
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleScheduleBase");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public UnifiedRoleScheduleBase withStatus(String status) {
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleScheduleBase");
        _x.status = status;
        return _x;
    }

    public UnifiedRoleScheduleBase withUnmappedField(String name, Object value) {
        UnifiedRoleScheduleBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appScope")
    @JsonIgnore
    public AppScopeRequest getAppScope() {
        return new AppScopeRequest(contextPath.addSegment("appScope"), RequestHelper.getValue(unmappedFields, "appScope"));
    }

    @NavigationProperty(name="directoryScope")
    @JsonIgnore
    public DirectoryObjectRequest getDirectoryScope() {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScope"), RequestHelper.getValue(unmappedFields, "directoryScope"));
    }

    @NavigationProperty(name="principal")
    @JsonIgnore
    public DirectoryObjectRequest getPrincipal() {
        return new DirectoryObjectRequest(contextPath.addSegment("principal"), RequestHelper.getValue(unmappedFields, "principal"));
    }

    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public UnifiedRoleDefinitionRequest getRoleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), RequestHelper.getValue(unmappedFields, "roleDefinition"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleScheduleBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleScheduleBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleScheduleBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleScheduleBase _copy() {
        UnifiedRoleScheduleBase _x = new UnifiedRoleScheduleBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appScopeId = appScopeId;
        _x.createdDateTime = createdDateTime;
        _x.createdUsing = createdUsing;
        _x.directoryScopeId = directoryScopeId;
        _x.modifiedDateTime = modifiedDateTime;
        _x.principalId = principalId;
        _x.roleDefinitionId = roleDefinitionId;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleScheduleBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appScopeId=");
        b.append(this.appScopeId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdUsing=");
        b.append(this.createdUsing);
        b.append(", ");
        b.append("directoryScopeId=");
        b.append(this.directoryScopeId);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("principalId=");
        b.append(this.principalId);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
