package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UnifiedRoleManagementPolicyRuleTarget;

@JsonPropertyOrder({
    "@odata.type", 
    "isExpirationRequired", 
    "maximumDuration"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleManagementPolicyExpirationRule extends UnifiedRoleManagementPolicyRule implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleManagementPolicyExpirationRule";
    }

    @JsonProperty("isExpirationRequired")
    protected Boolean isExpirationRequired;

    @JsonProperty("maximumDuration")
    protected Duration maximumDuration;

    protected UnifiedRoleManagementPolicyExpirationRule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleManagementPolicyExpirationRule() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UnifiedRoleManagementPolicyRuleTarget target;
        private Boolean isExpirationRequired;
        private Duration maximumDuration;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder target(UnifiedRoleManagementPolicyRuleTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public Builder isExpirationRequired(Boolean isExpirationRequired) {
            this.isExpirationRequired = isExpirationRequired;
            this.changedFields = changedFields.add("isExpirationRequired");
            return this;
        }

        public Builder maximumDuration(Duration maximumDuration) {
            this.maximumDuration = maximumDuration;
            this.changedFields = changedFields.add("maximumDuration");
            return this;
        }

        public UnifiedRoleManagementPolicyExpirationRule build() {
            UnifiedRoleManagementPolicyExpirationRule _x = new UnifiedRoleManagementPolicyExpirationRule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleManagementPolicyExpirationRule";
            _x.id = id;
            _x.target = target;
            _x.isExpirationRequired = isExpirationRequired;
            _x.maximumDuration = maximumDuration;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isExpirationRequired")
    @JsonIgnore
    public Optional<Boolean> getIsExpirationRequired() {
        return Optional.ofNullable(isExpirationRequired);
    }

    public UnifiedRoleManagementPolicyExpirationRule withIsExpirationRequired(Boolean isExpirationRequired) {
        UnifiedRoleManagementPolicyExpirationRule _x = _copy();
        _x.changedFields = changedFields.add("isExpirationRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyExpirationRule");
        _x.isExpirationRequired = isExpirationRequired;
        return _x;
    }

    @Property(name="maximumDuration")
    @JsonIgnore
    public Optional<Duration> getMaximumDuration() {
        return Optional.ofNullable(maximumDuration);
    }

    public UnifiedRoleManagementPolicyExpirationRule withMaximumDuration(Duration maximumDuration) {
        UnifiedRoleManagementPolicyExpirationRule _x = _copy();
        _x.changedFields = changedFields.add("maximumDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyExpirationRule");
        _x.maximumDuration = maximumDuration;
        return _x;
    }

    public UnifiedRoleManagementPolicyExpirationRule withUnmappedField(String name, Object value) {
        UnifiedRoleManagementPolicyExpirationRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicyExpirationRule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicyExpirationRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicyExpirationRule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicyExpirationRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleManagementPolicyExpirationRule _copy() {
        UnifiedRoleManagementPolicyExpirationRule _x = new UnifiedRoleManagementPolicyExpirationRule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.target = target;
        _x.isExpirationRequired = isExpirationRequired;
        _x.maximumDuration = maximumDuration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleManagementPolicyExpirationRule[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("isExpirationRequired=");
        b.append(this.isExpirationRequired);
        b.append(", ");
        b.append("maximumDuration=");
        b.append(this.maximumDuration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
