package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.UnifiedRoleManagementPolicyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "policyId", 
    "roleDefinitionId", 
    "scopeId", 
    "scopeType"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleManagementPolicyAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleManagementPolicyAssignment";
    }

    @JsonProperty("policyId")
    protected String policyId;

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("scopeId")
    protected String scopeId;

    @JsonProperty("scopeType")
    protected String scopeType;

    protected UnifiedRoleManagementPolicyAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleManagementPolicyAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String policyId;
        private String roleDefinitionId;
        private String scopeId;
        private String scopeType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            this.changedFields = changedFields.add("policyId");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            this.changedFields = changedFields.add("scopeId");
            return this;
        }

        public Builder scopeType(String scopeType) {
            this.scopeType = scopeType;
            this.changedFields = changedFields.add("scopeType");
            return this;
        }

        public UnifiedRoleManagementPolicyAssignment build() {
            UnifiedRoleManagementPolicyAssignment _x = new UnifiedRoleManagementPolicyAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleManagementPolicyAssignment";
            _x.id = id;
            _x.policyId = policyId;
            _x.roleDefinitionId = roleDefinitionId;
            _x.scopeId = scopeId;
            _x.scopeType = scopeType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="policyId")
    @JsonIgnore
    public Optional<String> getPolicyId() {
        return Optional.ofNullable(policyId);
    }

    public UnifiedRoleManagementPolicyAssignment withPolicyId(String policyId) {
        UnifiedRoleManagementPolicyAssignment _x = _copy();
        _x.changedFields = changedFields.add("policyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyAssignment");
        _x.policyId = policyId;
        return _x;
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public UnifiedRoleManagementPolicyAssignment withRoleDefinitionId(String roleDefinitionId) {
        UnifiedRoleManagementPolicyAssignment _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyAssignment");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    @Property(name="scopeId")
    @JsonIgnore
    public Optional<String> getScopeId() {
        return Optional.ofNullable(scopeId);
    }

    public UnifiedRoleManagementPolicyAssignment withScopeId(String scopeId) {
        UnifiedRoleManagementPolicyAssignment _x = _copy();
        _x.changedFields = changedFields.add("scopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyAssignment");
        _x.scopeId = scopeId;
        return _x;
    }

    @Property(name="scopeType")
    @JsonIgnore
    public Optional<String> getScopeType() {
        return Optional.ofNullable(scopeType);
    }

    public UnifiedRoleManagementPolicyAssignment withScopeType(String scopeType) {
        UnifiedRoleManagementPolicyAssignment _x = _copy();
        _x.changedFields = changedFields.add("scopeType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicyAssignment");
        _x.scopeType = scopeType;
        return _x;
    }

    public UnifiedRoleManagementPolicyAssignment withUnmappedField(String name, Object value) {
        UnifiedRoleManagementPolicyAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="policy")
    @JsonIgnore
    public UnifiedRoleManagementPolicyRequest getPolicy() {
        return new UnifiedRoleManagementPolicyRequest(contextPath.addSegment("policy"), RequestHelper.getValue(unmappedFields, "policy"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicyAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicyAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicyAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicyAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleManagementPolicyAssignment _copy() {
        UnifiedRoleManagementPolicyAssignment _x = new UnifiedRoleManagementPolicyAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.policyId = policyId;
        _x.roleDefinitionId = roleDefinitionId;
        _x.scopeId = scopeId;
        _x.scopeType = scopeType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleManagementPolicyAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("policyId=");
        b.append(this.policyId);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("scopeId=");
        b.append(this.scopeId);
        b.append(", ");
        b.append("scopeType=");
        b.append(this.scopeType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
