package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Identity;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleManagementPolicyRuleCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "isOrganizationDefault", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "scopeId", 
    "scopeType", 
    "effectiveRules", 
    "rules"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleManagementPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleManagementPolicy";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isOrganizationDefault")
    protected Boolean isOrganizationDefault;

    @JsonProperty("lastModifiedBy")
    protected Identity lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("scopeId")
    protected String scopeId;

    @JsonProperty("scopeType")
    protected String scopeType;

    @JsonProperty("effectiveRules")
    protected List<UnifiedRoleManagementPolicyRule> effectiveRules;

    @JsonProperty("rules")
    protected List<UnifiedRoleManagementPolicyRule> rules;

    protected UnifiedRoleManagementPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleManagementPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private Boolean isOrganizationDefault;
        private Identity lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String scopeId;
        private String scopeType;
        private List<UnifiedRoleManagementPolicyRule> effectiveRules;
        private List<UnifiedRoleManagementPolicyRule> rules;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isOrganizationDefault(Boolean isOrganizationDefault) {
            this.isOrganizationDefault = isOrganizationDefault;
            this.changedFields = changedFields.add("isOrganizationDefault");
            return this;
        }

        public Builder lastModifiedBy(Identity lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            this.changedFields = changedFields.add("scopeId");
            return this;
        }

        public Builder scopeType(String scopeType) {
            this.scopeType = scopeType;
            this.changedFields = changedFields.add("scopeType");
            return this;
        }

        public Builder effectiveRules(List<UnifiedRoleManagementPolicyRule> effectiveRules) {
            this.effectiveRules = effectiveRules;
            this.changedFields = changedFields.add("effectiveRules");
            return this;
        }

        public Builder effectiveRules(UnifiedRoleManagementPolicyRule... effectiveRules) {
            return effectiveRules(Arrays.asList(effectiveRules));
        }

        public Builder rules(List<UnifiedRoleManagementPolicyRule> rules) {
            this.rules = rules;
            this.changedFields = changedFields.add("rules");
            return this;
        }

        public Builder rules(UnifiedRoleManagementPolicyRule... rules) {
            return rules(Arrays.asList(rules));
        }

        public UnifiedRoleManagementPolicy build() {
            UnifiedRoleManagementPolicy _x = new UnifiedRoleManagementPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleManagementPolicy";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.isOrganizationDefault = isOrganizationDefault;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.scopeId = scopeId;
            _x.scopeType = scopeType;
            _x.effectiveRules = effectiveRules;
            _x.rules = rules;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public UnifiedRoleManagementPolicy withDescription(String description) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicy");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public UnifiedRoleManagementPolicy withDisplayName(String displayName) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isOrganizationDefault")
    @JsonIgnore
    public Optional<Boolean> getIsOrganizationDefault() {
        return Optional.ofNullable(isOrganizationDefault);
    }

    public UnifiedRoleManagementPolicy withIsOrganizationDefault(Boolean isOrganizationDefault) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("isOrganizationDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicy");
        _x.isOrganizationDefault = isOrganizationDefault;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<Identity> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public UnifiedRoleManagementPolicy withLastModifiedBy(Identity lastModifiedBy) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicy");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public UnifiedRoleManagementPolicy withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicy");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="scopeId")
    @JsonIgnore
    public Optional<String> getScopeId() {
        return Optional.ofNullable(scopeId);
    }

    public UnifiedRoleManagementPolicy withScopeId(String scopeId) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("scopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicy");
        _x.scopeId = scopeId;
        return _x;
    }

    @Property(name="scopeType")
    @JsonIgnore
    public Optional<String> getScopeType() {
        return Optional.ofNullable(scopeType);
    }

    public UnifiedRoleManagementPolicy withScopeType(String scopeType) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("scopeType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicy");
        _x.scopeType = scopeType;
        return _x;
    }

    public UnifiedRoleManagementPolicy withUnmappedField(String name, Object value) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="effectiveRules")
    @JsonIgnore
    public UnifiedRoleManagementPolicyRuleCollectionRequest getEffectiveRules() {
        return new UnifiedRoleManagementPolicyRuleCollectionRequest(
                        contextPath.addSegment("effectiveRules"), Optional.ofNullable(effectiveRules));
    }

    @NavigationProperty(name="rules")
    @JsonIgnore
    public UnifiedRoleManagementPolicyRuleCollectionRequest getRules() {
        return new UnifiedRoleManagementPolicyRuleCollectionRequest(
                        contextPath.addSegment("rules"), Optional.ofNullable(rules));
    }

    public UnifiedRoleManagementPolicy withEffectiveRules(List<UnifiedRoleManagementPolicyRule> effectiveRules) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("effectiveRules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicy");
        _x.effectiveRules = effectiveRules;
        return _x;
    }

    public UnifiedRoleManagementPolicy withRules(List<UnifiedRoleManagementPolicyRule> rules) {
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = changedFields.add("rules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleManagementPolicy");
        _x.rules = rules;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleManagementPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleManagementPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleManagementPolicy _copy() {
        UnifiedRoleManagementPolicy _x = new UnifiedRoleManagementPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.isOrganizationDefault = isOrganizationDefault;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.scopeId = scopeId;
        _x.scopeType = scopeType;
        _x.effectiveRules = effectiveRules;
        _x.rules = rules;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleManagementPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isOrganizationDefault=");
        b.append(this.isOrganizationDefault);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("scopeId=");
        b.append(this.scopeId);
        b.append(", ");
        b.append("scopeType=");
        b.append(this.scopeType);
        b.append(", ");
        b.append("effectiveRules=");
        b.append(this.effectiveRules);
        b.append(", ");
        b.append("rules=");
        b.append(this.rules);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
