package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.UnifiedRoleEligibilityScheduleInstanceRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "assignmentType", 
    "endDateTime", 
    "memberType", 
    "roleAssignmentOriginId", 
    "roleAssignmentScheduleId", 
    "startDateTime"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleAssignmentScheduleInstance extends UnifiedRoleScheduleInstanceBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleAssignmentScheduleInstance";
    }

    @JsonProperty("assignmentType")
    protected String assignmentType;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("memberType")
    protected String memberType;

    @JsonProperty("roleAssignmentOriginId")
    protected String roleAssignmentOriginId;

    @JsonProperty("roleAssignmentScheduleId")
    protected String roleAssignmentScheduleId;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    protected UnifiedRoleAssignmentScheduleInstance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleAssignmentScheduleInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appScopeId;
        private String directoryScopeId;
        private String principalId;
        private String roleDefinitionId;
        private String assignmentType;
        private OffsetDateTime endDateTime;
        private String memberType;
        private String roleAssignmentOriginId;
        private String roleAssignmentScheduleId;
        private OffsetDateTime startDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appScopeId(String appScopeId) {
            this.appScopeId = appScopeId;
            this.changedFields = changedFields.add("appScopeId");
            return this;
        }

        public Builder directoryScopeId(String directoryScopeId) {
            this.directoryScopeId = directoryScopeId;
            this.changedFields = changedFields.add("directoryScopeId");
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.changedFields = changedFields.add("principalId");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder assignmentType(String assignmentType) {
            this.assignmentType = assignmentType;
            this.changedFields = changedFields.add("assignmentType");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder memberType(String memberType) {
            this.memberType = memberType;
            this.changedFields = changedFields.add("memberType");
            return this;
        }

        public Builder roleAssignmentOriginId(String roleAssignmentOriginId) {
            this.roleAssignmentOriginId = roleAssignmentOriginId;
            this.changedFields = changedFields.add("roleAssignmentOriginId");
            return this;
        }

        public Builder roleAssignmentScheduleId(String roleAssignmentScheduleId) {
            this.roleAssignmentScheduleId = roleAssignmentScheduleId;
            this.changedFields = changedFields.add("roleAssignmentScheduleId");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public UnifiedRoleAssignmentScheduleInstance build() {
            UnifiedRoleAssignmentScheduleInstance _x = new UnifiedRoleAssignmentScheduleInstance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleAssignmentScheduleInstance";
            _x.id = id;
            _x.appScopeId = appScopeId;
            _x.directoryScopeId = directoryScopeId;
            _x.principalId = principalId;
            _x.roleDefinitionId = roleDefinitionId;
            _x.assignmentType = assignmentType;
            _x.endDateTime = endDateTime;
            _x.memberType = memberType;
            _x.roleAssignmentOriginId = roleAssignmentOriginId;
            _x.roleAssignmentScheduleId = roleAssignmentScheduleId;
            _x.startDateTime = startDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="assignmentType")
    @JsonIgnore
    public Optional<String> getAssignmentType() {
        return Optional.ofNullable(assignmentType);
    }

    public UnifiedRoleAssignmentScheduleInstance withAssignmentType(String assignmentType) {
        UnifiedRoleAssignmentScheduleInstance _x = _copy();
        _x.changedFields = changedFields.add("assignmentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleInstance");
        _x.assignmentType = assignmentType;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public UnifiedRoleAssignmentScheduleInstance withEndDateTime(OffsetDateTime endDateTime) {
        UnifiedRoleAssignmentScheduleInstance _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleInstance");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="memberType")
    @JsonIgnore
    public Optional<String> getMemberType() {
        return Optional.ofNullable(memberType);
    }

    public UnifiedRoleAssignmentScheduleInstance withMemberType(String memberType) {
        UnifiedRoleAssignmentScheduleInstance _x = _copy();
        _x.changedFields = changedFields.add("memberType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleInstance");
        _x.memberType = memberType;
        return _x;
    }

    @Property(name="roleAssignmentOriginId")
    @JsonIgnore
    public Optional<String> getRoleAssignmentOriginId() {
        return Optional.ofNullable(roleAssignmentOriginId);
    }

    public UnifiedRoleAssignmentScheduleInstance withRoleAssignmentOriginId(String roleAssignmentOriginId) {
        UnifiedRoleAssignmentScheduleInstance _x = _copy();
        _x.changedFields = changedFields.add("roleAssignmentOriginId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleInstance");
        _x.roleAssignmentOriginId = roleAssignmentOriginId;
        return _x;
    }

    @Property(name="roleAssignmentScheduleId")
    @JsonIgnore
    public Optional<String> getRoleAssignmentScheduleId() {
        return Optional.ofNullable(roleAssignmentScheduleId);
    }

    public UnifiedRoleAssignmentScheduleInstance withRoleAssignmentScheduleId(String roleAssignmentScheduleId) {
        UnifiedRoleAssignmentScheduleInstance _x = _copy();
        _x.changedFields = changedFields.add("roleAssignmentScheduleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleInstance");
        _x.roleAssignmentScheduleId = roleAssignmentScheduleId;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public UnifiedRoleAssignmentScheduleInstance withStartDateTime(OffsetDateTime startDateTime) {
        UnifiedRoleAssignmentScheduleInstance _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentScheduleInstance");
        _x.startDateTime = startDateTime;
        return _x;
    }

    public UnifiedRoleAssignmentScheduleInstance withUnmappedField(String name, Object value) {
        UnifiedRoleAssignmentScheduleInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="activatedUsing")
    @JsonIgnore
    public UnifiedRoleEligibilityScheduleInstanceRequest getActivatedUsing() {
        return new UnifiedRoleEligibilityScheduleInstanceRequest(contextPath.addSegment("activatedUsing"), RequestHelper.getValue(unmappedFields, "activatedUsing"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentScheduleInstance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentScheduleInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentScheduleInstance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentScheduleInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleAssignmentScheduleInstance _copy() {
        UnifiedRoleAssignmentScheduleInstance _x = new UnifiedRoleAssignmentScheduleInstance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appScopeId = appScopeId;
        _x.directoryScopeId = directoryScopeId;
        _x.principalId = principalId;
        _x.roleDefinitionId = roleDefinitionId;
        _x.assignmentType = assignmentType;
        _x.endDateTime = endDateTime;
        _x.memberType = memberType;
        _x.roleAssignmentOriginId = roleAssignmentOriginId;
        _x.roleAssignmentScheduleId = roleAssignmentScheduleId;
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleAssignmentScheduleInstance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appScopeId=");
        b.append(this.appScopeId);
        b.append(", ");
        b.append("directoryScopeId=");
        b.append(this.directoryScopeId);
        b.append(", ");
        b.append("principalId=");
        b.append(this.principalId);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("assignmentType=");
        b.append(this.assignmentType);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("memberType=");
        b.append(this.memberType);
        b.append(", ");
        b.append("roleAssignmentOriginId=");
        b.append(this.roleAssignmentOriginId);
        b.append(", ");
        b.append("roleAssignmentScheduleId=");
        b.append(this.roleAssignmentScheduleId);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
