package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.RequestSchedule;
import odata.msgraph.client.beta.entity.request.UnifiedRoleEligibilityScheduleRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "assignmentType", 
    "memberType", 
    "scheduleInfo"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleAssignmentSchedule extends UnifiedRoleScheduleBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleAssignmentSchedule";
    }

    @JsonProperty("assignmentType")
    protected String assignmentType;

    @JsonProperty("memberType")
    protected String memberType;

    @JsonProperty("scheduleInfo")
    protected RequestSchedule scheduleInfo;

    protected UnifiedRoleAssignmentSchedule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleAssignmentSchedule() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appScopeId;
        private OffsetDateTime createdDateTime;
        private String createdUsing;
        private String directoryScopeId;
        private OffsetDateTime modifiedDateTime;
        private String principalId;
        private String roleDefinitionId;
        private String status;
        private String assignmentType;
        private String memberType;
        private RequestSchedule scheduleInfo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appScopeId(String appScopeId) {
            this.appScopeId = appScopeId;
            this.changedFields = changedFields.add("appScopeId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdUsing(String createdUsing) {
            this.createdUsing = createdUsing;
            this.changedFields = changedFields.add("createdUsing");
            return this;
        }

        public Builder directoryScopeId(String directoryScopeId) {
            this.directoryScopeId = directoryScopeId;
            this.changedFields = changedFields.add("directoryScopeId");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.changedFields = changedFields.add("principalId");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder assignmentType(String assignmentType) {
            this.assignmentType = assignmentType;
            this.changedFields = changedFields.add("assignmentType");
            return this;
        }

        public Builder memberType(String memberType) {
            this.memberType = memberType;
            this.changedFields = changedFields.add("memberType");
            return this;
        }

        public Builder scheduleInfo(RequestSchedule scheduleInfo) {
            this.scheduleInfo = scheduleInfo;
            this.changedFields = changedFields.add("scheduleInfo");
            return this;
        }

        public UnifiedRoleAssignmentSchedule build() {
            UnifiedRoleAssignmentSchedule _x = new UnifiedRoleAssignmentSchedule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleAssignmentSchedule";
            _x.id = id;
            _x.appScopeId = appScopeId;
            _x.createdDateTime = createdDateTime;
            _x.createdUsing = createdUsing;
            _x.directoryScopeId = directoryScopeId;
            _x.modifiedDateTime = modifiedDateTime;
            _x.principalId = principalId;
            _x.roleDefinitionId = roleDefinitionId;
            _x.status = status;
            _x.assignmentType = assignmentType;
            _x.memberType = memberType;
            _x.scheduleInfo = scheduleInfo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="assignmentType")
    @JsonIgnore
    public Optional<String> getAssignmentType() {
        return Optional.ofNullable(assignmentType);
    }

    public UnifiedRoleAssignmentSchedule withAssignmentType(String assignmentType) {
        UnifiedRoleAssignmentSchedule _x = _copy();
        _x.changedFields = changedFields.add("assignmentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentSchedule");
        _x.assignmentType = assignmentType;
        return _x;
    }

    @Property(name="memberType")
    @JsonIgnore
    public Optional<String> getMemberType() {
        return Optional.ofNullable(memberType);
    }

    public UnifiedRoleAssignmentSchedule withMemberType(String memberType) {
        UnifiedRoleAssignmentSchedule _x = _copy();
        _x.changedFields = changedFields.add("memberType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentSchedule");
        _x.memberType = memberType;
        return _x;
    }

    @Property(name="scheduleInfo")
    @JsonIgnore
    public Optional<RequestSchedule> getScheduleInfo() {
        return Optional.ofNullable(scheduleInfo);
    }

    public UnifiedRoleAssignmentSchedule withScheduleInfo(RequestSchedule scheduleInfo) {
        UnifiedRoleAssignmentSchedule _x = _copy();
        _x.changedFields = changedFields.add("scheduleInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentSchedule");
        _x.scheduleInfo = scheduleInfo;
        return _x;
    }

    public UnifiedRoleAssignmentSchedule withUnmappedField(String name, Object value) {
        UnifiedRoleAssignmentSchedule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="activatedUsing")
    @JsonIgnore
    public UnifiedRoleEligibilityScheduleRequest getActivatedUsing() {
        return new UnifiedRoleEligibilityScheduleRequest(contextPath.addSegment("activatedUsing"), RequestHelper.getValue(unmappedFields, "activatedUsing"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentSchedule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentSchedule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentSchedule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentSchedule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleAssignmentSchedule _copy() {
        UnifiedRoleAssignmentSchedule _x = new UnifiedRoleAssignmentSchedule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appScopeId = appScopeId;
        _x.createdDateTime = createdDateTime;
        _x.createdUsing = createdUsing;
        _x.directoryScopeId = directoryScopeId;
        _x.modifiedDateTime = modifiedDateTime;
        _x.principalId = principalId;
        _x.roleDefinitionId = roleDefinitionId;
        _x.status = status;
        _x.assignmentType = assignmentType;
        _x.memberType = memberType;
        _x.scheduleInfo = scheduleInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleAssignmentSchedule[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appScopeId=");
        b.append(this.appScopeId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdUsing=");
        b.append(this.createdUsing);
        b.append(", ");
        b.append("directoryScopeId=");
        b.append(this.directoryScopeId);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("principalId=");
        b.append(this.principalId);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("assignmentType=");
        b.append(this.assignmentType);
        b.append(", ");
        b.append("memberType=");
        b.append(this.memberType);
        b.append(", ");
        b.append("scheduleInfo=");
        b.append(this.scheduleInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
