package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AppScopeRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleDefinitionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "appScopeId", 
    "condition", 
    "directoryScopeId", 
    "principalId", 
    "principalOrganizationId", 
    "resourceScope", 
    "roleDefinitionId", 
    "appScope"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleAssignment";
    }

    @JsonProperty("appScopeId")
    protected String appScopeId;

    @JsonProperty("condition")
    protected String condition;

    @JsonProperty("directoryScopeId")
    protected String directoryScopeId;

    @JsonProperty("principalId")
    protected String principalId;

    @JsonProperty("principalOrganizationId")
    protected String principalOrganizationId;

    @JsonProperty("resourceScope")
    protected String resourceScope;

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("appScope")
    protected AppScope appScope;

    protected UnifiedRoleAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appScopeId;
        private String condition;
        private String directoryScopeId;
        private String principalId;
        private String principalOrganizationId;
        private String resourceScope;
        private String roleDefinitionId;
        private AppScope appScope;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appScopeId(String appScopeId) {
            this.appScopeId = appScopeId;
            this.changedFields = changedFields.add("appScopeId");
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            this.changedFields = changedFields.add("condition");
            return this;
        }

        public Builder directoryScopeId(String directoryScopeId) {
            this.directoryScopeId = directoryScopeId;
            this.changedFields = changedFields.add("directoryScopeId");
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.changedFields = changedFields.add("principalId");
            return this;
        }

        public Builder principalOrganizationId(String principalOrganizationId) {
            this.principalOrganizationId = principalOrganizationId;
            this.changedFields = changedFields.add("principalOrganizationId");
            return this;
        }

        public Builder resourceScope(String resourceScope) {
            this.resourceScope = resourceScope;
            this.changedFields = changedFields.add("resourceScope");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder appScope(AppScope appScope) {
            this.appScope = appScope;
            this.changedFields = changedFields.add("appScope");
            return this;
        }

        public UnifiedRoleAssignment build() {
            UnifiedRoleAssignment _x = new UnifiedRoleAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.unifiedRoleAssignment";
            _x.id = id;
            _x.appScopeId = appScopeId;
            _x.condition = condition;
            _x.directoryScopeId = directoryScopeId;
            _x.principalId = principalId;
            _x.principalOrganizationId = principalOrganizationId;
            _x.resourceScope = resourceScope;
            _x.roleDefinitionId = roleDefinitionId;
            _x.appScope = appScope;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="appScopeId")
    @JsonIgnore
    public Optional<String> getAppScopeId() {
        return Optional.ofNullable(appScopeId);
    }

    public UnifiedRoleAssignment withAppScopeId(String appScopeId) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("appScopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.appScopeId = appScopeId;
        return _x;
    }

    @Property(name="condition")
    @JsonIgnore
    public Optional<String> getCondition() {
        return Optional.ofNullable(condition);
    }

    public UnifiedRoleAssignment withCondition(String condition) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("condition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.condition = condition;
        return _x;
    }

    @Property(name="directoryScopeId")
    @JsonIgnore
    public Optional<String> getDirectoryScopeId() {
        return Optional.ofNullable(directoryScopeId);
    }

    public UnifiedRoleAssignment withDirectoryScopeId(String directoryScopeId) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("directoryScopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.directoryScopeId = directoryScopeId;
        return _x;
    }

    @Property(name="principalId")
    @JsonIgnore
    public Optional<String> getPrincipalId() {
        return Optional.ofNullable(principalId);
    }

    public UnifiedRoleAssignment withPrincipalId(String principalId) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("principalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.principalId = principalId;
        return _x;
    }

    @Property(name="principalOrganizationId")
    @JsonIgnore
    public Optional<String> getPrincipalOrganizationId() {
        return Optional.ofNullable(principalOrganizationId);
    }

    public UnifiedRoleAssignment withPrincipalOrganizationId(String principalOrganizationId) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("principalOrganizationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.principalOrganizationId = principalOrganizationId;
        return _x;
    }

    @Property(name="resourceScope")
    @JsonIgnore
    public Optional<String> getResourceScope() {
        return Optional.ofNullable(resourceScope);
    }

    public UnifiedRoleAssignment withResourceScope(String resourceScope) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("resourceScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.resourceScope = resourceScope;
        return _x;
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public UnifiedRoleAssignment withRoleDefinitionId(String roleDefinitionId) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    public UnifiedRoleAssignment withUnmappedField(String name, Object value) {
        UnifiedRoleAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appScope")
    @JsonIgnore
    public AppScopeRequest getAppScope() {
        return new AppScopeRequest(contextPath.addSegment("appScope"), Optional.ofNullable(appScope));
    }

    @NavigationProperty(name="directoryScope")
    @JsonIgnore
    public DirectoryObjectRequest getDirectoryScope() {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScope"), RequestHelper.getValue(unmappedFields, "directoryScope"));
    }

    @NavigationProperty(name="principal")
    @JsonIgnore
    public DirectoryObjectRequest getPrincipal() {
        return new DirectoryObjectRequest(contextPath.addSegment("principal"), RequestHelper.getValue(unmappedFields, "principal"));
    }

    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public UnifiedRoleDefinitionRequest getRoleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), RequestHelper.getValue(unmappedFields, "roleDefinition"));
    }

    public UnifiedRoleAssignment withAppScope(AppScope appScope) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("appScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.appScope = appScope;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleAssignment _copy() {
        UnifiedRoleAssignment _x = new UnifiedRoleAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appScopeId = appScopeId;
        _x.condition = condition;
        _x.directoryScopeId = directoryScopeId;
        _x.principalId = principalId;
        _x.principalOrganizationId = principalOrganizationId;
        _x.resourceScope = resourceScope;
        _x.roleDefinitionId = roleDefinitionId;
        _x.appScope = appScope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appScopeId=");
        b.append(this.appScopeId);
        b.append(", ");
        b.append("condition=");
        b.append(this.condition);
        b.append(", ");
        b.append("directoryScopeId=");
        b.append(this.directoryScopeId);
        b.append(", ");
        b.append("principalId=");
        b.append(this.principalId);
        b.append(", ");
        b.append("principalOrganizationId=");
        b.append(this.principalOrganizationId);
        b.append(", ");
        b.append("resourceScope=");
        b.append(this.resourceScope);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("appScope=");
        b.append(this.appScope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
