package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TodoTaskCollectionRequest;
import odata.msgraph.client.beta.enums.WellknownListName;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "isOwner", 
    "isShared", 
    "wellknownListName", 
    "extensions", 
    "tasks"})
@JsonInclude(Include.NON_NULL)
public class TodoTaskList extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.todoTaskList";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isOwner")
    protected Boolean isOwner;

    @JsonProperty("isShared")
    protected Boolean isShared;

    @JsonProperty("wellknownListName")
    protected WellknownListName wellknownListName;

    @JsonProperty("extensions")
    protected List<Extension> extensions;

    @JsonProperty("tasks")
    protected List<TodoTask> tasks;

    protected TodoTaskList() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTodoTaskList() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Boolean isOwner;
        private Boolean isShared;
        private WellknownListName wellknownListName;
        private List<Extension> extensions;
        private List<TodoTask> tasks;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isOwner(Boolean isOwner) {
            this.isOwner = isOwner;
            this.changedFields = changedFields.add("isOwner");
            return this;
        }

        public Builder isShared(Boolean isShared) {
            this.isShared = isShared;
            this.changedFields = changedFields.add("isShared");
            return this;
        }

        public Builder wellknownListName(WellknownListName wellknownListName) {
            this.wellknownListName = wellknownListName;
            this.changedFields = changedFields.add("wellknownListName");
            return this;
        }

        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder extensions(Extension... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param tasks
         *            value of {@code tasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tasks(List<TodoTask> tasks) {
            this.tasks = tasks;
            this.changedFields = changedFields.add("tasks");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param tasks
         *            value of {@code tasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tasks(TodoTask... tasks) {
            return tasks(Arrays.asList(tasks));
        }

        public TodoTaskList build() {
            TodoTaskList _x = new TodoTaskList();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.todoTaskList";
            _x.id = id;
            _x.displayName = displayName;
            _x.isOwner = isOwner;
            _x.isShared = isShared;
            _x.wellknownListName = wellknownListName;
            _x.extensions = extensions;
            _x.tasks = tasks;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TodoTaskList withDisplayName(String displayName) {
        TodoTaskList _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTaskList");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isOwner")
    @JsonIgnore
    public Optional<Boolean> getIsOwner() {
        return Optional.ofNullable(isOwner);
    }

    public TodoTaskList withIsOwner(Boolean isOwner) {
        TodoTaskList _x = _copy();
        _x.changedFields = changedFields.add("isOwner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTaskList");
        _x.isOwner = isOwner;
        return _x;
    }

    @Property(name="isShared")
    @JsonIgnore
    public Optional<Boolean> getIsShared() {
        return Optional.ofNullable(isShared);
    }

    public TodoTaskList withIsShared(Boolean isShared) {
        TodoTaskList _x = _copy();
        _x.changedFields = changedFields.add("isShared");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTaskList");
        _x.isShared = isShared;
        return _x;
    }

    @Property(name="wellknownListName")
    @JsonIgnore
    public Optional<WellknownListName> getWellknownListName() {
        return Optional.ofNullable(wellknownListName);
    }

    public TodoTaskList withWellknownListName(WellknownListName wellknownListName) {
        TodoTaskList _x = _copy();
        _x.changedFields = changedFields.add("wellknownListName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTaskList");
        _x.wellknownListName = wellknownListName;
        return _x;
    }

    public TodoTaskList withUnmappedField(String name, Object value) {
        TodoTaskList _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.ofNullable(extensions));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property tasks
     */
    @NavigationProperty(name="tasks")
    @JsonIgnore
    public TodoTaskCollectionRequest getTasks() {
        return new TodoTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.ofNullable(tasks));
    }

    public TodoTaskList withExtensions(List<Extension> extensions) {
        TodoTaskList _x = _copy();
        _x.changedFields = changedFields.add("extensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTaskList");
        _x.extensions = extensions;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tasks} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param tasks
     *            new value of {@code tasks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tasks} field changed
     */
    public TodoTaskList withTasks(List<TodoTask> tasks) {
        TodoTaskList _x = _copy();
        _x.changedFields = changedFields.add("tasks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.todoTaskList");
        _x.tasks = tasks;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TodoTaskList patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TodoTaskList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TodoTaskList put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TodoTaskList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TodoTaskList _copy() {
        TodoTaskList _x = new TodoTaskList();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.isOwner = isOwner;
        _x.isShared = isShared;
        _x.wellknownListName = wellknownListName;
        _x.extensions = extensions;
        _x.tasks = tasks;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TodoTaskList[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isOwner=");
        b.append(this.isOwner);
        b.append(", ");
        b.append("isShared=");
        b.append(this.isShared);
        b.append(", ");
        b.append("wellknownListName=");
        b.append(this.wellknownListName);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("tasks=");
        b.append(this.tasks);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
