package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsAcceptanceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsGroupAssignmentCollectionRequest;


/**
 * <i>“A termsAndConditions entity represents the metadata and contents of a given
 * Terms and Conditions (T&amp;C) policy. T&amp;C policies’ contents are presented to users
 * upon their first attempt to enroll into Intune and subsequently upon edits where
 * an administrator has required re-acceptance. They enable administrators to
 * communicate the provisions to which a user must agree in order to have devices
 * enrolled into Intune.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "acceptanceStatement", 
    "bodyText", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "modifiedDateTime", 
    "roleScopeTagIds", 
    "title", 
    "version", 
    "acceptanceStatuses", 
    "assignments", 
    "groupAssignments"})
@JsonInclude(Include.NON_NULL)
public class TermsAndConditions extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termsAndConditions";
    }

    @JsonProperty("acceptanceStatement")
    protected String acceptanceStatement;

    @JsonProperty("bodyText")
    protected String bodyText;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("acceptanceStatuses")
    protected List<TermsAndConditionsAcceptanceStatus> acceptanceStatuses;

    @JsonProperty("assignments")
    protected List<TermsAndConditionsAssignment> assignments;

    @JsonProperty("groupAssignments")
    protected List<TermsAndConditionsGroupAssignment> groupAssignments;

    protected TermsAndConditions() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTermsAndConditions() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String acceptanceStatement;
        private String bodyText;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime modifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String title;
        private Integer version;
        private List<TermsAndConditionsAcceptanceStatus> acceptanceStatuses;
        private List<TermsAndConditionsAssignment> assignments;
        private List<TermsAndConditionsGroupAssignment> groupAssignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Administrator-supplied explanation of the terms and conditions, typically
         * describing what it means to accept the terms and conditions set out in the T&amp;C
         * policy. This is shown to the user on prompts to accept the T&amp;C policy.”</i>
         * 
         * @param acceptanceStatement
         *            value of {@code acceptanceStatement} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder acceptanceStatement(String acceptanceStatement) {
            this.acceptanceStatement = acceptanceStatement;
            this.changedFields = changedFields.add("acceptanceStatement");
            return this;
        }

        /**
         * <i>“Administrator-supplied body text of the terms and conditions, typically the
         * terms themselves. This is shown to the user on prompts to accept the T&amp;C policy.”</i>
         * 
         * @param bodyText
         *            value of {@code bodyText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bodyText(String bodyText) {
            this.bodyText = bodyText;
            this.changedFields = changedFields.add("bodyText");
            return this;
        }

        /**
         * <i>“DateTime the object was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Administrator-supplied description of the T&amp;C policy.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Administrator-supplied name for the T&amp;C policy.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“DateTime the object was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“DateTime the object was last modified.”</i>
         * 
         * @param modifiedDateTime
         *            value of {@code modifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Administrator-supplied title of the terms and conditions. This is shown to the
         * user on prompts to accept the T&amp;C policy.”</i>
         * 
         * @param title
         *            value of {@code title} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        /**
         * <i>“Integer indicating the current version of the terms. Incremented when an
         * administrator makes a change to the terms and wishes to require users to re-
         * accept the modified T&amp;C policy.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“The list of acceptance statuses for this T&amp;C policy.”</i>
         * 
         * @param acceptanceStatuses
         *            value of {@code acceptanceStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder acceptanceStatuses(List<TermsAndConditionsAcceptanceStatus> acceptanceStatuses) {
            this.acceptanceStatuses = acceptanceStatuses;
            this.changedFields = changedFields.add("acceptanceStatuses");
            return this;
        }

        /**
         * <i>“The list of acceptance statuses for this T&amp;C policy.”</i>
         * 
         * @param acceptanceStatuses
         *            value of {@code acceptanceStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder acceptanceStatuses(TermsAndConditionsAcceptanceStatus... acceptanceStatuses) {
            return acceptanceStatuses(Arrays.asList(acceptanceStatuses));
        }

        /**
         * <i>“The list of assignments for this T&amp;C policy.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<TermsAndConditionsAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“The list of assignments for this T&amp;C policy.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(TermsAndConditionsAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“The list of group assignments for this T&amp;C policy.”</i>
         * 
         * @param groupAssignments
         *            value of {@code groupAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupAssignments(List<TermsAndConditionsGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        /**
         * <i>“The list of group assignments for this T&amp;C policy.”</i>
         * 
         * @param groupAssignments
         *            value of {@code groupAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupAssignments(TermsAndConditionsGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public TermsAndConditions build() {
            TermsAndConditions _x = new TermsAndConditions();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.termsAndConditions";
            _x.id = id;
            _x.acceptanceStatement = acceptanceStatement;
            _x.bodyText = bodyText;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.modifiedDateTime = modifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.title = title;
            _x.version = version;
            _x.acceptanceStatuses = acceptanceStatuses;
            _x.assignments = assignments;
            _x.groupAssignments = groupAssignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Administrator-supplied explanation of the terms and conditions, typically
     * describing what it means to accept the terms and conditions set out in the T&amp;C
     * policy. This is shown to the user on prompts to accept the T&amp;C policy.”</i>
     * 
     * @return property acceptanceStatement
     */
    @Property(name="acceptanceStatement")
    @JsonIgnore
    public Optional<String> getAcceptanceStatement() {
        return Optional.ofNullable(acceptanceStatement);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * acceptanceStatement} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Administrator-supplied explanation of the terms and conditions, typically
     * describing what it means to accept the terms and conditions set out in the T&amp;C
     * policy. This is shown to the user on prompts to accept the T&amp;C policy.”</i>
     * 
     * @param acceptanceStatement
     *            new value of {@code acceptanceStatement} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code acceptanceStatement} field changed
     */
    public TermsAndConditions withAcceptanceStatement(String acceptanceStatement) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("acceptanceStatement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.acceptanceStatement = acceptanceStatement;
        return _x;
    }

    /**
     * <i>“Administrator-supplied body text of the terms and conditions, typically the
     * terms themselves. This is shown to the user on prompts to accept the T&amp;C policy.”</i>
     * 
     * @return property bodyText
     */
    @Property(name="bodyText")
    @JsonIgnore
    public Optional<String> getBodyText() {
        return Optional.ofNullable(bodyText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bodyText} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Administrator-supplied body text of the terms and conditions, typically the
     * terms themselves. This is shown to the user on prompts to accept the T&amp;C policy.”</i>
     * 
     * @param bodyText
     *            new value of {@code bodyText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bodyText} field changed
     */
    public TermsAndConditions withBodyText(String bodyText) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("bodyText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.bodyText = bodyText;
        return _x;
    }

    /**
     * <i>“DateTime the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public TermsAndConditions withCreatedDateTime(OffsetDateTime createdDateTime) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Administrator-supplied description of the T&amp;C policy.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Administrator-supplied description of the T&amp;C policy.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public TermsAndConditions withDescription(String description) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Administrator-supplied name for the T&amp;C policy.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Administrator-supplied name for the T&amp;C policy.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public TermsAndConditions withDisplayName(String displayName) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public TermsAndConditions withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property modifiedDateTime
     */
    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code modifiedDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param modifiedDateTime
     *            new value of {@code modifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modifiedDateTime} field changed
     */
    public TermsAndConditions withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public TermsAndConditions withRoleScopeTagIds(List<String> roleScopeTagIds) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Administrator-supplied title of the terms and conditions. This is shown to the
     * user on prompts to accept the T&amp;C policy.”</i>
     * 
     * @return property title
     */
    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code title} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Administrator-supplied title of the terms and conditions. This is shown to the
     * user on prompts to accept the T&amp;C policy.”</i>
     * 
     * @param title
     *            new value of {@code title} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code title} field changed
     */
    public TermsAndConditions withTitle(String title) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.title = title;
        return _x;
    }

    /**
     * <i>“Integer indicating the current version of the terms. Incremented when an
     * administrator makes a change to the terms and wishes to require users to re-
     * accept the modified T&amp;C policy.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Integer indicating the current version of the terms. Incremented when an
     * administrator makes a change to the terms and wishes to require users to re-
     * accept the modified T&amp;C policy.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public TermsAndConditions withVersion(Integer version) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.version = version;
        return _x;
    }

    public TermsAndConditions withUnmappedField(String name, Object value) {
        TermsAndConditions _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of acceptance statuses for this T&amp;C policy.”</i>
     * 
     * @return navigational property acceptanceStatuses
     */
    @NavigationProperty(name="acceptanceStatuses")
    @JsonIgnore
    public TermsAndConditionsAcceptanceStatusCollectionRequest getAcceptanceStatuses() {
        return new TermsAndConditionsAcceptanceStatusCollectionRequest(
                        contextPath.addSegment("acceptanceStatuses"), Optional.ofNullable(acceptanceStatuses));
    }

    /**
     * <i>“The list of assignments for this T&amp;C policy.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public TermsAndConditionsAssignmentCollectionRequest getAssignments() {
        return new TermsAndConditionsAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“The list of group assignments for this T&amp;C policy.”</i>
     * 
     * @return navigational property groupAssignments
     */
    @NavigationProperty(name="groupAssignments")
    @JsonIgnore
    public TermsAndConditionsGroupAssignmentCollectionRequest getGroupAssignments() {
        return new TermsAndConditionsGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"), Optional.ofNullable(groupAssignments));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * acceptanceStatuses} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The list of acceptance statuses for this T&amp;C policy.”</i>
     * 
     * @param acceptanceStatuses
     *            new value of {@code acceptanceStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code acceptanceStatuses} field changed
     */
    public TermsAndConditions withAcceptanceStatuses(List<TermsAndConditionsAcceptanceStatus> acceptanceStatuses) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("acceptanceStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.acceptanceStatuses = acceptanceStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of assignments for this T&amp;C policy.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public TermsAndConditions withAssignments(List<TermsAndConditionsAssignment> assignments) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupAssignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of group assignments for this T&amp;C policy.”</i>
     * 
     * @param groupAssignments
     *            new value of {@code groupAssignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupAssignments} field changed
     */
    public TermsAndConditions withGroupAssignments(List<TermsAndConditionsGroupAssignment> groupAssignments) {
        TermsAndConditions _x = _copy();
        _x.changedFields = changedFields.add("groupAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditions");
        _x.groupAssignments = groupAssignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TermsAndConditions patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TermsAndConditions _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TermsAndConditions put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TermsAndConditions _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TermsAndConditions _copy() {
        TermsAndConditions _x = new TermsAndConditions();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.acceptanceStatement = acceptanceStatement;
        _x.bodyText = bodyText;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.modifiedDateTime = modifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.title = title;
        _x.version = version;
        _x.acceptanceStatuses = acceptanceStatuses;
        _x.assignments = assignments;
        _x.groupAssignments = groupAssignments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TermsAndConditions[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("acceptanceStatement=");
        b.append(this.acceptanceStatement);
        b.append(", ");
        b.append("bodyText=");
        b.append(this.bodyText);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("acceptanceStatuses=");
        b.append(this.acceptanceStatuses);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
