package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.PrivilegedRoleSettingsRequest;
import odata.msgraph.client.beta.enums.SetupStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "firstTimeSetup", 
    "relevantRolesSettings", 
    "setupStatus", 
    "skipSetup", 
    "userRolesActions"})
@JsonInclude(Include.NON_NULL)
public class TenantSetupInfo extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.tenantSetupInfo";
    }

    @JsonProperty("firstTimeSetup")
    protected Boolean firstTimeSetup;

    @JsonProperty("relevantRolesSettings")
    protected List<String> relevantRolesSettings;

    @JsonProperty("relevantRolesSettings@nextLink")
    protected String relevantRolesSettingsNextLink;

    @JsonProperty("setupStatus")
    protected SetupStatus setupStatus;

    @JsonProperty("skipSetup")
    protected Boolean skipSetup;

    @JsonProperty("userRolesActions")
    protected String userRolesActions;

    protected TenantSetupInfo() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTenantSetupInfo() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean firstTimeSetup;
        private List<String> relevantRolesSettings;
        private String relevantRolesSettingsNextLink;
        private SetupStatus setupStatus;
        private Boolean skipSetup;
        private String userRolesActions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder firstTimeSetup(Boolean firstTimeSetup) {
            this.firstTimeSetup = firstTimeSetup;
            this.changedFields = changedFields.add("firstTimeSetup");
            return this;
        }

        public Builder relevantRolesSettings(List<String> relevantRolesSettings) {
            this.relevantRolesSettings = relevantRolesSettings;
            this.changedFields = changedFields.add("relevantRolesSettings");
            return this;
        }

        public Builder relevantRolesSettings(String... relevantRolesSettings) {
            return relevantRolesSettings(Arrays.asList(relevantRolesSettings));
        }

        public Builder relevantRolesSettingsNextLink(String relevantRolesSettingsNextLink) {
            this.relevantRolesSettingsNextLink = relevantRolesSettingsNextLink;
            this.changedFields = changedFields.add("relevantRolesSettings");
            return this;
        }

        public Builder setupStatus(SetupStatus setupStatus) {
            this.setupStatus = setupStatus;
            this.changedFields = changedFields.add("setupStatus");
            return this;
        }

        public Builder skipSetup(Boolean skipSetup) {
            this.skipSetup = skipSetup;
            this.changedFields = changedFields.add("skipSetup");
            return this;
        }

        public Builder userRolesActions(String userRolesActions) {
            this.userRolesActions = userRolesActions;
            this.changedFields = changedFields.add("userRolesActions");
            return this;
        }

        public TenantSetupInfo build() {
            TenantSetupInfo _x = new TenantSetupInfo();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.tenantSetupInfo";
            _x.id = id;
            _x.firstTimeSetup = firstTimeSetup;
            _x.relevantRolesSettings = relevantRolesSettings;
            _x.relevantRolesSettingsNextLink = relevantRolesSettingsNextLink;
            _x.setupStatus = setupStatus;
            _x.skipSetup = skipSetup;
            _x.userRolesActions = userRolesActions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="firstTimeSetup")
    @JsonIgnore
    public Optional<Boolean> getFirstTimeSetup() {
        return Optional.ofNullable(firstTimeSetup);
    }

    public TenantSetupInfo withFirstTimeSetup(Boolean firstTimeSetup) {
        TenantSetupInfo _x = _copy();
        _x.changedFields = changedFields.add("firstTimeSetup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tenantSetupInfo");
        _x.firstTimeSetup = firstTimeSetup;
        return _x;
    }

    @Property(name="relevantRolesSettings")
    @JsonIgnore
    public CollectionPage<String> getRelevantRolesSettings() {
        return new CollectionPage<String>(contextPath, String.class, this.relevantRolesSettings, Optional.ofNullable(relevantRolesSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TenantSetupInfo withRelevantRolesSettings(List<String> relevantRolesSettings) {
        TenantSetupInfo _x = _copy();
        _x.changedFields = changedFields.add("relevantRolesSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tenantSetupInfo");
        _x.relevantRolesSettings = relevantRolesSettings;
        return _x;
    }

    @Property(name="relevantRolesSettings")
    @JsonIgnore
    public CollectionPage<String> getRelevantRolesSettings(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.relevantRolesSettings, Optional.ofNullable(relevantRolesSettingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="setupStatus")
    @JsonIgnore
    public Optional<SetupStatus> getSetupStatus() {
        return Optional.ofNullable(setupStatus);
    }

    public TenantSetupInfo withSetupStatus(SetupStatus setupStatus) {
        TenantSetupInfo _x = _copy();
        _x.changedFields = changedFields.add("setupStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tenantSetupInfo");
        _x.setupStatus = setupStatus;
        return _x;
    }

    @Property(name="skipSetup")
    @JsonIgnore
    public Optional<Boolean> getSkipSetup() {
        return Optional.ofNullable(skipSetup);
    }

    public TenantSetupInfo withSkipSetup(Boolean skipSetup) {
        TenantSetupInfo _x = _copy();
        _x.changedFields = changedFields.add("skipSetup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tenantSetupInfo");
        _x.skipSetup = skipSetup;
        return _x;
    }

    @Property(name="userRolesActions")
    @JsonIgnore
    public Optional<String> getUserRolesActions() {
        return Optional.ofNullable(userRolesActions);
    }

    public TenantSetupInfo withUserRolesActions(String userRolesActions) {
        TenantSetupInfo _x = _copy();
        _x.changedFields = changedFields.add("userRolesActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tenantSetupInfo");
        _x.userRolesActions = userRolesActions;
        return _x;
    }

    public TenantSetupInfo withUnmappedField(String name, Object value) {
        TenantSetupInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="defaultRolesSettings")
    @JsonIgnore
    public PrivilegedRoleSettingsRequest getDefaultRolesSettings() {
        return new PrivilegedRoleSettingsRequest(contextPath.addSegment("defaultRolesSettings"), RequestHelper.getValue(unmappedFields, "defaultRolesSettings"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantSetupInfo patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TenantSetupInfo _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantSetupInfo put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TenantSetupInfo _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TenantSetupInfo _copy() {
        TenantSetupInfo _x = new TenantSetupInfo();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.firstTimeSetup = firstTimeSetup;
        _x.relevantRolesSettings = relevantRolesSettings;
        _x.setupStatus = setupStatus;
        _x.skipSetup = skipSetup;
        _x.userRolesActions = userRolesActions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantSetupInfo[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("firstTimeSetup=");
        b.append(this.firstTimeSetup);
        b.append(", ");
        b.append("relevantRolesSettings=");
        b.append(this.relevantRolesSettings);
        b.append(", ");
        b.append("setupStatus=");
        b.append(this.setupStatus);
        b.append(", ");
        b.append("skipSetup=");
        b.append(this.skipSetup);
        b.append(", ");
        b.append("userRolesActions=");
        b.append(this.userRolesActions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
