package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "definition"})
@JsonInclude(Include.NON_NULL)
public class TenantRelationshipAccessPolicyBase extends PolicyBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.tenantRelationshipAccessPolicyBase";
    }

    @JsonProperty("definition")
    protected List<String> definition;

    @JsonProperty("definition@nextLink")
    protected String definitionNextLink;

    protected TenantRelationshipAccessPolicyBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="definition")
    @JsonIgnore
    public CollectionPage<String> getDefinition() {
        return new CollectionPage<String>(contextPath, String.class, this.definition, Optional.ofNullable(definitionNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TenantRelationshipAccessPolicyBase withDefinition(List<String> definition) {
        TenantRelationshipAccessPolicyBase _x = _copy();
        _x.changedFields = changedFields.add("definition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tenantRelationshipAccessPolicyBase");
        _x.definition = definition;
        return _x;
    }

    @Property(name="definition")
    @JsonIgnore
    public CollectionPage<String> getDefinition(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.definition, Optional.ofNullable(definitionNextLink), Collections.emptyList(), options);
    }

    public TenantRelationshipAccessPolicyBase withUnmappedField(String name, Object value) {
        TenantRelationshipAccessPolicyBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantRelationshipAccessPolicyBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TenantRelationshipAccessPolicyBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantRelationshipAccessPolicyBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TenantRelationshipAccessPolicyBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TenantRelationshipAccessPolicyBase _copy() {
        TenantRelationshipAccessPolicyBase _x = new TenantRelationshipAccessPolicyBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.definition = definition;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantRelationshipAccessPolicyBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("definition=");
        b.append(this.definition);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
