package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "isUsable", 
    "isUsableOnce", 
    "lifetimeInMinutes", 
    "methodUsabilityReason", 
    "startDateTime", 
    "temporaryAccessPass"})
@JsonInclude(Include.NON_NULL)
public class TemporaryAccessPassAuthenticationMethod extends AuthenticationMethod implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.temporaryAccessPassAuthenticationMethod";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("isUsable")
    protected Boolean isUsable;

    @JsonProperty("isUsableOnce")
    protected Boolean isUsableOnce;

    @JsonProperty("lifetimeInMinutes")
    protected Integer lifetimeInMinutes;

    @JsonProperty("methodUsabilityReason")
    protected String methodUsabilityReason;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("temporaryAccessPass")
    protected String temporaryAccessPass;

    protected TemporaryAccessPassAuthenticationMethod() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTemporaryAccessPassAuthenticationMethod() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Boolean isUsable;
        private Boolean isUsableOnce;
        private Integer lifetimeInMinutes;
        private String methodUsabilityReason;
        private OffsetDateTime startDateTime;
        private String temporaryAccessPass;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder isUsable(Boolean isUsable) {
            this.isUsable = isUsable;
            this.changedFields = changedFields.add("isUsable");
            return this;
        }

        public Builder isUsableOnce(Boolean isUsableOnce) {
            this.isUsableOnce = isUsableOnce;
            this.changedFields = changedFields.add("isUsableOnce");
            return this;
        }

        public Builder lifetimeInMinutes(Integer lifetimeInMinutes) {
            this.lifetimeInMinutes = lifetimeInMinutes;
            this.changedFields = changedFields.add("lifetimeInMinutes");
            return this;
        }

        public Builder methodUsabilityReason(String methodUsabilityReason) {
            this.methodUsabilityReason = methodUsabilityReason;
            this.changedFields = changedFields.add("methodUsabilityReason");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder temporaryAccessPass(String temporaryAccessPass) {
            this.temporaryAccessPass = temporaryAccessPass;
            this.changedFields = changedFields.add("temporaryAccessPass");
            return this;
        }

        public TemporaryAccessPassAuthenticationMethod build() {
            TemporaryAccessPassAuthenticationMethod _x = new TemporaryAccessPassAuthenticationMethod();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.temporaryAccessPassAuthenticationMethod";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.isUsable = isUsable;
            _x.isUsableOnce = isUsableOnce;
            _x.lifetimeInMinutes = lifetimeInMinutes;
            _x.methodUsabilityReason = methodUsabilityReason;
            _x.startDateTime = startDateTime;
            _x.temporaryAccessPass = temporaryAccessPass;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public TemporaryAccessPassAuthenticationMethod withCreatedDateTime(OffsetDateTime createdDateTime) {
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethod");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="isUsable")
    @JsonIgnore
    public Optional<Boolean> getIsUsable() {
        return Optional.ofNullable(isUsable);
    }

    public TemporaryAccessPassAuthenticationMethod withIsUsable(Boolean isUsable) {
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("isUsable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethod");
        _x.isUsable = isUsable;
        return _x;
    }

    @Property(name="isUsableOnce")
    @JsonIgnore
    public Optional<Boolean> getIsUsableOnce() {
        return Optional.ofNullable(isUsableOnce);
    }

    public TemporaryAccessPassAuthenticationMethod withIsUsableOnce(Boolean isUsableOnce) {
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("isUsableOnce");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethod");
        _x.isUsableOnce = isUsableOnce;
        return _x;
    }

    @Property(name="lifetimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getLifetimeInMinutes() {
        return Optional.ofNullable(lifetimeInMinutes);
    }

    public TemporaryAccessPassAuthenticationMethod withLifetimeInMinutes(Integer lifetimeInMinutes) {
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("lifetimeInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethod");
        _x.lifetimeInMinutes = lifetimeInMinutes;
        return _x;
    }

    @Property(name="methodUsabilityReason")
    @JsonIgnore
    public Optional<String> getMethodUsabilityReason() {
        return Optional.ofNullable(methodUsabilityReason);
    }

    public TemporaryAccessPassAuthenticationMethod withMethodUsabilityReason(String methodUsabilityReason) {
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("methodUsabilityReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethod");
        _x.methodUsabilityReason = methodUsabilityReason;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public TemporaryAccessPassAuthenticationMethod withStartDateTime(OffsetDateTime startDateTime) {
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethod");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="temporaryAccessPass")
    @JsonIgnore
    public Optional<String> getTemporaryAccessPass() {
        return Optional.ofNullable(temporaryAccessPass);
    }

    public TemporaryAccessPassAuthenticationMethod withTemporaryAccessPass(String temporaryAccessPass) {
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("temporaryAccessPass");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.temporaryAccessPassAuthenticationMethod");
        _x.temporaryAccessPass = temporaryAccessPass;
        return _x;
    }

    public TemporaryAccessPassAuthenticationMethod withUnmappedField(String name, Object value) {
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TemporaryAccessPassAuthenticationMethod patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TemporaryAccessPassAuthenticationMethod put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TemporaryAccessPassAuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TemporaryAccessPassAuthenticationMethod _copy() {
        TemporaryAccessPassAuthenticationMethod _x = new TemporaryAccessPassAuthenticationMethod();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.isUsable = isUsable;
        _x.isUsableOnce = isUsableOnce;
        _x.lifetimeInMinutes = lifetimeInMinutes;
        _x.methodUsabilityReason = methodUsabilityReason;
        _x.startDateTime = startDateTime;
        _x.temporaryAccessPass = temporaryAccessPass;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TemporaryAccessPassAuthenticationMethod[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("isUsable=");
        b.append(this.isUsable);
        b.append(", ");
        b.append("isUsableOnce=");
        b.append(this.isUsableOnce);
        b.append(", ");
        b.append("lifetimeInMinutes=");
        b.append(this.lifetimeInMinutes);
        b.append(", ");
        b.append("methodUsabilityReason=");
        b.append(this.methodUsabilityReason);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("temporaryAccessPass=");
        b.append(this.temporaryAccessPass);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
