package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.TeamworkTagMemberCollectionRequest;
import odata.msgraph.client.beta.enums.TeamworkTagType;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "memberCount", 
    "tagType", 
    "teamId", 
    "members"})
@JsonInclude(Include.NON_NULL)
public class TeamworkTag extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkTag";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("memberCount")
    protected Integer memberCount;

    @JsonProperty("tagType")
    protected TeamworkTagType tagType;

    @JsonProperty("teamId")
    protected String teamId;

    @JsonProperty("members")
    protected List<TeamworkTagMember> members;

    protected TeamworkTag() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamworkTag() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private Integer memberCount;
        private TeamworkTagType tagType;
        private String teamId;
        private List<TeamworkTagMember> members;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder memberCount(Integer memberCount) {
            this.memberCount = memberCount;
            this.changedFields = changedFields.add("memberCount");
            return this;
        }

        public Builder tagType(TeamworkTagType tagType) {
            this.tagType = tagType;
            this.changedFields = changedFields.add("tagType");
            return this;
        }

        public Builder teamId(String teamId) {
            this.teamId = teamId;
            this.changedFields = changedFields.add("teamId");
            return this;
        }

        public Builder members(List<TeamworkTagMember> members) {
            this.members = members;
            this.changedFields = changedFields.add("members");
            return this;
        }

        public Builder members(TeamworkTagMember... members) {
            return members(Arrays.asList(members));
        }

        public TeamworkTag build() {
            TeamworkTag _x = new TeamworkTag();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkTag";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.memberCount = memberCount;
            _x.tagType = tagType;
            _x.teamId = teamId;
            _x.members = members;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public TeamworkTag withDescription(String description) {
        TeamworkTag _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkTag");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TeamworkTag withDisplayName(String displayName) {
        TeamworkTag _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkTag");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="memberCount")
    @JsonIgnore
    public Optional<Integer> getMemberCount() {
        return Optional.ofNullable(memberCount);
    }

    public TeamworkTag withMemberCount(Integer memberCount) {
        TeamworkTag _x = _copy();
        _x.changedFields = changedFields.add("memberCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkTag");
        _x.memberCount = memberCount;
        return _x;
    }

    @Property(name="tagType")
    @JsonIgnore
    public Optional<TeamworkTagType> getTagType() {
        return Optional.ofNullable(tagType);
    }

    public TeamworkTag withTagType(TeamworkTagType tagType) {
        TeamworkTag _x = _copy();
        _x.changedFields = changedFields.add("tagType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkTag");
        _x.tagType = tagType;
        return _x;
    }

    @Property(name="teamId")
    @JsonIgnore
    public Optional<String> getTeamId() {
        return Optional.ofNullable(teamId);
    }

    public TeamworkTag withTeamId(String teamId) {
        TeamworkTag _x = _copy();
        _x.changedFields = changedFields.add("teamId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkTag");
        _x.teamId = teamId;
        return _x;
    }

    public TeamworkTag withUnmappedField(String name, Object value) {
        TeamworkTag _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public TeamworkTagMemberCollectionRequest getMembers() {
        return new TeamworkTagMemberCollectionRequest(
                        contextPath.addSegment("members"), Optional.ofNullable(members));
    }

    public TeamworkTag withMembers(List<TeamworkTagMember> members) {
        TeamworkTag _x = _copy();
        _x.changedFields = changedFields.add("members");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkTag");
        _x.members = members;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkTag patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamworkTag _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkTag put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamworkTag _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamworkTag _copy() {
        TeamworkTag _x = new TeamworkTag();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.memberCount = memberCount;
        _x.tagType = tagType;
        _x.teamId = teamId;
        _x.members = members;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkTag[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("memberCount=");
        b.append(this.memberCount);
        b.append(", ");
        b.append("tagType=");
        b.append(this.tagType);
        b.append(", ");
        b.append("teamId=");
        b.append(this.teamId);
        b.append(", ");
        b.append("members=");
        b.append(this.members);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
