package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.TeamworkConnection;
import odata.msgraph.client.beta.complex.TeamworkHardwareHealth;
import odata.msgraph.client.beta.complex.TeamworkLoginStatus;
import odata.msgraph.client.beta.complex.TeamworkPeripheralsHealth;
import odata.msgraph.client.beta.complex.TeamworkSoftwareUpdateHealth;

@JsonPropertyOrder({
    "@odata.type", 
    "connection", 
    "createdBy", 
    "createdDateTime", 
    "hardwareHealth", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "loginStatus", 
    "peripheralsHealth", 
    "softwareUpdateHealth"})
@JsonInclude(Include.NON_NULL)
public class TeamworkDeviceHealth extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkDeviceHealth";
    }

    @JsonProperty("connection")
    protected TeamworkConnection connection;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("hardwareHealth")
    protected TeamworkHardwareHealth hardwareHealth;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("loginStatus")
    protected TeamworkLoginStatus loginStatus;

    @JsonProperty("peripheralsHealth")
    protected TeamworkPeripheralsHealth peripheralsHealth;

    @JsonProperty("softwareUpdateHealth")
    protected TeamworkSoftwareUpdateHealth softwareUpdateHealth;

    protected TeamworkDeviceHealth() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamworkDeviceHealth() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private TeamworkConnection connection;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private TeamworkHardwareHealth hardwareHealth;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private TeamworkLoginStatus loginStatus;
        private TeamworkPeripheralsHealth peripheralsHealth;
        private TeamworkSoftwareUpdateHealth softwareUpdateHealth;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder connection(TeamworkConnection connection) {
            this.connection = connection;
            this.changedFields = changedFields.add("connection");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder hardwareHealth(TeamworkHardwareHealth hardwareHealth) {
            this.hardwareHealth = hardwareHealth;
            this.changedFields = changedFields.add("hardwareHealth");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder loginStatus(TeamworkLoginStatus loginStatus) {
            this.loginStatus = loginStatus;
            this.changedFields = changedFields.add("loginStatus");
            return this;
        }

        public Builder peripheralsHealth(TeamworkPeripheralsHealth peripheralsHealth) {
            this.peripheralsHealth = peripheralsHealth;
            this.changedFields = changedFields.add("peripheralsHealth");
            return this;
        }

        public Builder softwareUpdateHealth(TeamworkSoftwareUpdateHealth softwareUpdateHealth) {
            this.softwareUpdateHealth = softwareUpdateHealth;
            this.changedFields = changedFields.add("softwareUpdateHealth");
            return this;
        }

        public TeamworkDeviceHealth build() {
            TeamworkDeviceHealth _x = new TeamworkDeviceHealth();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkDeviceHealth";
            _x.id = id;
            _x.connection = connection;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.hardwareHealth = hardwareHealth;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.loginStatus = loginStatus;
            _x.peripheralsHealth = peripheralsHealth;
            _x.softwareUpdateHealth = softwareUpdateHealth;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="connection")
    @JsonIgnore
    public Optional<TeamworkConnection> getConnection() {
        return Optional.ofNullable(connection);
    }

    public TeamworkDeviceHealth withConnection(TeamworkConnection connection) {
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = changedFields.add("connection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceHealth");
        _x.connection = connection;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public TeamworkDeviceHealth withCreatedBy(IdentitySet createdBy) {
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceHealth");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public TeamworkDeviceHealth withCreatedDateTime(OffsetDateTime createdDateTime) {
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceHealth");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="hardwareHealth")
    @JsonIgnore
    public Optional<TeamworkHardwareHealth> getHardwareHealth() {
        return Optional.ofNullable(hardwareHealth);
    }

    public TeamworkDeviceHealth withHardwareHealth(TeamworkHardwareHealth hardwareHealth) {
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = changedFields.add("hardwareHealth");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceHealth");
        _x.hardwareHealth = hardwareHealth;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public TeamworkDeviceHealth withLastModifiedBy(IdentitySet lastModifiedBy) {
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceHealth");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public TeamworkDeviceHealth withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceHealth");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="loginStatus")
    @JsonIgnore
    public Optional<TeamworkLoginStatus> getLoginStatus() {
        return Optional.ofNullable(loginStatus);
    }

    public TeamworkDeviceHealth withLoginStatus(TeamworkLoginStatus loginStatus) {
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = changedFields.add("loginStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceHealth");
        _x.loginStatus = loginStatus;
        return _x;
    }

    @Property(name="peripheralsHealth")
    @JsonIgnore
    public Optional<TeamworkPeripheralsHealth> getPeripheralsHealth() {
        return Optional.ofNullable(peripheralsHealth);
    }

    public TeamworkDeviceHealth withPeripheralsHealth(TeamworkPeripheralsHealth peripheralsHealth) {
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = changedFields.add("peripheralsHealth");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceHealth");
        _x.peripheralsHealth = peripheralsHealth;
        return _x;
    }

    @Property(name="softwareUpdateHealth")
    @JsonIgnore
    public Optional<TeamworkSoftwareUpdateHealth> getSoftwareUpdateHealth() {
        return Optional.ofNullable(softwareUpdateHealth);
    }

    public TeamworkDeviceHealth withSoftwareUpdateHealth(TeamworkSoftwareUpdateHealth softwareUpdateHealth) {
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = changedFields.add("softwareUpdateHealth");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceHealth");
        _x.softwareUpdateHealth = softwareUpdateHealth;
        return _x;
    }

    public TeamworkDeviceHealth withUnmappedField(String name, Object value) {
        TeamworkDeviceHealth _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDeviceHealth patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDeviceHealth put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamworkDeviceHealth _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamworkDeviceHealth _copy() {
        TeamworkDeviceHealth _x = new TeamworkDeviceHealth();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.connection = connection;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.hardwareHealth = hardwareHealth;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.loginStatus = loginStatus;
        _x.peripheralsHealth = peripheralsHealth;
        _x.softwareUpdateHealth = softwareUpdateHealth;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkDeviceHealth[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("connection=");
        b.append(this.connection);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("hardwareHealth=");
        b.append(this.hardwareHealth);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("loginStatus=");
        b.append(this.loginStatus);
        b.append(", ");
        b.append("peripheralsHealth=");
        b.append(this.peripheralsHealth);
        b.append(", ");
        b.append("softwareUpdateHealth=");
        b.append(this.softwareUpdateHealth);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
