package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.TeamworkHardwareDetail;
import odata.msgraph.client.beta.complex.TeamworkUserIdentity;
import odata.msgraph.client.beta.entity.collection.request.TeamworkDeviceOperationCollectionRequest;
import odata.msgraph.client.beta.entity.request.TeamworkDeviceActivityRequest;
import odata.msgraph.client.beta.entity.request.TeamworkDeviceConfigurationRequest;
import odata.msgraph.client.beta.entity.request.TeamworkDeviceHealthRequest;
import odata.msgraph.client.beta.enums.TeamworkDeviceActivityState;
import odata.msgraph.client.beta.enums.TeamworkDeviceHealthStatus;
import odata.msgraph.client.beta.enums.TeamworkDeviceType;
import odata.msgraph.client.beta.enums.TeamworkSoftwareType;

@JsonPropertyOrder({
    "@odata.type", 
    "activityState", 
    "companyAssetTag", 
    "createdBy", 
    "createdDateTime", 
    "currentUser", 
    "deviceType", 
    "hardwareDetail", 
    "healthStatus", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "notes", 
    "activity", 
    "configuration", 
    "health", 
    "operations"})
@JsonInclude(Include.NON_NULL)
public class TeamworkDevice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkDevice";
    }

    @JsonProperty("activityState")
    protected TeamworkDeviceActivityState activityState;

    @JsonProperty("companyAssetTag")
    protected String companyAssetTag;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("currentUser")
    protected TeamworkUserIdentity currentUser;

    @JsonProperty("deviceType")
    protected TeamworkDeviceType deviceType;

    @JsonProperty("hardwareDetail")
    protected TeamworkHardwareDetail hardwareDetail;

    @JsonProperty("healthStatus")
    protected TeamworkDeviceHealthStatus healthStatus;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("activity")
    protected TeamworkDeviceActivity activity;

    @JsonProperty("configuration")
    protected TeamworkDeviceConfiguration configuration;

    @JsonProperty("health")
    protected TeamworkDeviceHealth health;

    @JsonProperty("operations")
    protected List<TeamworkDeviceOperation> operations;

    protected TeamworkDevice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamworkDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private TeamworkDeviceActivityState activityState;
        private String companyAssetTag;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private TeamworkUserIdentity currentUser;
        private TeamworkDeviceType deviceType;
        private TeamworkHardwareDetail hardwareDetail;
        private TeamworkDeviceHealthStatus healthStatus;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private TeamworkDeviceActivity activity;
        private TeamworkDeviceConfiguration configuration;
        private TeamworkDeviceHealth health;
        private List<TeamworkDeviceOperation> operations;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activityState(TeamworkDeviceActivityState activityState) {
            this.activityState = activityState;
            this.changedFields = changedFields.add("activityState");
            return this;
        }

        public Builder companyAssetTag(String companyAssetTag) {
            this.companyAssetTag = companyAssetTag;
            this.changedFields = changedFields.add("companyAssetTag");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder currentUser(TeamworkUserIdentity currentUser) {
            this.currentUser = currentUser;
            this.changedFields = changedFields.add("currentUser");
            return this;
        }

        public Builder deviceType(TeamworkDeviceType deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        public Builder hardwareDetail(TeamworkHardwareDetail hardwareDetail) {
            this.hardwareDetail = hardwareDetail;
            this.changedFields = changedFields.add("hardwareDetail");
            return this;
        }

        public Builder healthStatus(TeamworkDeviceHealthStatus healthStatus) {
            this.healthStatus = healthStatus;
            this.changedFields = changedFields.add("healthStatus");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder activity(TeamworkDeviceActivity activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        public Builder configuration(TeamworkDeviceConfiguration configuration) {
            this.configuration = configuration;
            this.changedFields = changedFields.add("configuration");
            return this;
        }

        public Builder health(TeamworkDeviceHealth health) {
            this.health = health;
            this.changedFields = changedFields.add("health");
            return this;
        }

        public Builder operations(List<TeamworkDeviceOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(TeamworkDeviceOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public TeamworkDevice build() {
            TeamworkDevice _x = new TeamworkDevice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkDevice";
            _x.id = id;
            _x.activityState = activityState;
            _x.companyAssetTag = companyAssetTag;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.currentUser = currentUser;
            _x.deviceType = deviceType;
            _x.hardwareDetail = hardwareDetail;
            _x.healthStatus = healthStatus;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.activity = activity;
            _x.configuration = configuration;
            _x.health = health;
            _x.operations = operations;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activityState")
    @JsonIgnore
    public Optional<TeamworkDeviceActivityState> getActivityState() {
        return Optional.ofNullable(activityState);
    }

    public TeamworkDevice withActivityState(TeamworkDeviceActivityState activityState) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("activityState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.activityState = activityState;
        return _x;
    }

    @Property(name="companyAssetTag")
    @JsonIgnore
    public Optional<String> getCompanyAssetTag() {
        return Optional.ofNullable(companyAssetTag);
    }

    public TeamworkDevice withCompanyAssetTag(String companyAssetTag) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("companyAssetTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.companyAssetTag = companyAssetTag;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public TeamworkDevice withCreatedBy(IdentitySet createdBy) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public TeamworkDevice withCreatedDateTime(OffsetDateTime createdDateTime) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="currentUser")
    @JsonIgnore
    public Optional<TeamworkUserIdentity> getCurrentUser() {
        return Optional.ofNullable(currentUser);
    }

    public TeamworkDevice withCurrentUser(TeamworkUserIdentity currentUser) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("currentUser");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.currentUser = currentUser;
        return _x;
    }

    @Property(name="deviceType")
    @JsonIgnore
    public Optional<TeamworkDeviceType> getDeviceType() {
        return Optional.ofNullable(deviceType);
    }

    public TeamworkDevice withDeviceType(TeamworkDeviceType deviceType) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.deviceType = deviceType;
        return _x;
    }

    @Property(name="hardwareDetail")
    @JsonIgnore
    public Optional<TeamworkHardwareDetail> getHardwareDetail() {
        return Optional.ofNullable(hardwareDetail);
    }

    public TeamworkDevice withHardwareDetail(TeamworkHardwareDetail hardwareDetail) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("hardwareDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.hardwareDetail = hardwareDetail;
        return _x;
    }

    @Property(name="healthStatus")
    @JsonIgnore
    public Optional<TeamworkDeviceHealthStatus> getHealthStatus() {
        return Optional.ofNullable(healthStatus);
    }

    public TeamworkDevice withHealthStatus(TeamworkDeviceHealthStatus healthStatus) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("healthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.healthStatus = healthStatus;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public TeamworkDevice withLastModifiedBy(IdentitySet lastModifiedBy) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public TeamworkDevice withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    public TeamworkDevice withNotes(String notes) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("notes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.notes = notes;
        return _x;
    }

    public TeamworkDevice withUnmappedField(String name, Object value) {
        TeamworkDevice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="activity")
    @JsonIgnore
    public TeamworkDeviceActivityRequest getActivity() {
        return new TeamworkDeviceActivityRequest(contextPath.addSegment("activity"), Optional.ofNullable(activity));
    }

    @NavigationProperty(name="configuration")
    @JsonIgnore
    public TeamworkDeviceConfigurationRequest getConfiguration() {
        return new TeamworkDeviceConfigurationRequest(contextPath.addSegment("configuration"), Optional.ofNullable(configuration));
    }

    @NavigationProperty(name="health")
    @JsonIgnore
    public TeamworkDeviceHealthRequest getHealth() {
        return new TeamworkDeviceHealthRequest(contextPath.addSegment("health"), Optional.ofNullable(health));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public TeamworkDeviceOperationCollectionRequest getOperations() {
        return new TeamworkDeviceOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    public TeamworkDevice withActivity(TeamworkDeviceActivity activity) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("activity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.activity = activity;
        return _x;
    }

    public TeamworkDevice withConfiguration(TeamworkDeviceConfiguration configuration) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("configuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.configuration = configuration;
        return _x;
    }

    public TeamworkDevice withHealth(TeamworkDeviceHealth health) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("health");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.health = health;
        return _x;
    }

    public TeamworkDevice withOperations(List<TeamworkDeviceOperation> operations) {
        TeamworkDevice _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDevice");
        _x.operations = operations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDevice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamworkDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamworkDevice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamworkDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamworkDevice _copy() {
        TeamworkDevice _x = new TeamworkDevice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activityState = activityState;
        _x.companyAssetTag = companyAssetTag;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.currentUser = currentUser;
        _x.deviceType = deviceType;
        _x.hardwareDetail = hardwareDetail;
        _x.healthStatus = healthStatus;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.activity = activity;
        _x.configuration = configuration;
        _x.health = health;
        _x.operations = operations;
        return _x;
    }

    @Action(name = "restart")
    @JsonIgnore
    public ActionRequestNoReturn restart() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restart"), _parameters);
    }

    @Action(name = "runDiagnostics")
    @JsonIgnore
    public ActionRequestNoReturn runDiagnostics() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.runDiagnostics"), _parameters);
    }

    @Action(name = "updateSoftware")
    @JsonIgnore
    public ActionRequestNoReturn updateSoftware(TeamworkSoftwareType softwareType, String softwareVersion) {
        Preconditions.checkNotNull(softwareType, "softwareType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("softwareType", "microsoft.graph.teamworkSoftwareType", softwareType)
            .put("softwareVersion", "Edm.String", Checks.checkIsAscii(softwareVersion))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateSoftware"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activityState=");
        b.append(this.activityState);
        b.append(", ");
        b.append("companyAssetTag=");
        b.append(this.companyAssetTag);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("currentUser=");
        b.append(this.currentUser);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("hardwareDetail=");
        b.append(this.hardwareDetail);
        b.append(", ");
        b.append("healthStatus=");
        b.append(this.healthStatus);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("configuration=");
        b.append(this.configuration);
        b.append(", ");
        b.append("health=");
        b.append(this.health);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
