package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.TeamDiscoverySettings;
import odata.msgraph.client.beta.complex.TeamFunSettings;
import odata.msgraph.client.beta.complex.TeamGuestSettings;
import odata.msgraph.client.beta.complex.TeamMemberSettings;
import odata.msgraph.client.beta.complex.TeamMessagingSettings;
import odata.msgraph.client.beta.complex.TeamSummary;
import odata.msgraph.client.beta.complex.TeamworkActivityTopic;
import odata.msgraph.client.beta.complex.TeamworkNotificationRecipient;
import odata.msgraph.client.beta.entity.collection.request.ChannelCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceSpecificPermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppInstallationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAsyncOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamworkTagCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCollectionRequest;
import odata.msgraph.client.beta.entity.request.ChannelRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.entity.request.ProfilePhotoRequest;
import odata.msgraph.client.beta.entity.request.ScheduleRequest;
import odata.msgraph.client.beta.entity.request.TeamsTemplateRequest;
import odata.msgraph.client.beta.enums.ClonableTeamParts;
import odata.msgraph.client.beta.enums.TeamSpecialization;
import odata.msgraph.client.beta.enums.TeamVisibilityType;

@JsonPropertyOrder({
    "@odata.type", 
    "classification", 
    "createdDateTime", 
    "description", 
    "discoverySettings", 
    "displayName", 
    "funSettings", 
    "guestSettings", 
    "internalId", 
    "isArchived", 
    "isMembershipLimitedToOwners", 
    "memberSettings", 
    "messagingSettings", 
    "specialization", 
    "summary", 
    "visibility", 
    "webUrl", 
    "channels", 
    "installedApps", 
    "members", 
    "operations", 
    "permissionGrants", 
    "photo", 
    "primaryChannel", 
    "tags", 
    "schedule"})
@JsonInclude(Include.NON_NULL)
public class Team extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.team";
    }

    @JsonProperty("classification")
    protected String classification;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("discoverySettings")
    protected TeamDiscoverySettings discoverySettings;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("funSettings")
    protected TeamFunSettings funSettings;

    @JsonProperty("guestSettings")
    protected TeamGuestSettings guestSettings;

    @JsonProperty("internalId")
    protected String internalId;

    @JsonProperty("isArchived")
    protected Boolean isArchived;

    @JsonProperty("isMembershipLimitedToOwners")
    protected Boolean isMembershipLimitedToOwners;

    @JsonProperty("memberSettings")
    protected TeamMemberSettings memberSettings;

    @JsonProperty("messagingSettings")
    protected TeamMessagingSettings messagingSettings;

    @JsonProperty("specialization")
    protected TeamSpecialization specialization;

    @JsonProperty("summary")
    protected TeamSummary summary;

    @JsonProperty("visibility")
    protected TeamVisibilityType visibility;

    @JsonProperty("webUrl")
    protected String webUrl;

    @JsonProperty("channels")
    protected List<Channel> channels;

    @JsonProperty("installedApps")
    protected List<TeamsAppInstallation> installedApps;

    @JsonProperty("members")
    protected List<ConversationMember> members;

    @JsonProperty("operations")
    protected List<TeamsAsyncOperation> operations;

    @JsonProperty("permissionGrants")
    protected List<ResourceSpecificPermissionGrant> permissionGrants;

    @JsonProperty("photo")
    protected ProfilePhoto photo;

    @JsonProperty("primaryChannel")
    protected Channel primaryChannel;

    @JsonProperty("tags")
    protected List<TeamworkTag> tags;

    @JsonProperty("schedule")
    protected Schedule schedule;

    protected Team() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeam() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String classification;
        private OffsetDateTime createdDateTime;
        private String description;
        private TeamDiscoverySettings discoverySettings;
        private String displayName;
        private TeamFunSettings funSettings;
        private TeamGuestSettings guestSettings;
        private String internalId;
        private Boolean isArchived;
        private Boolean isMembershipLimitedToOwners;
        private TeamMemberSettings memberSettings;
        private TeamMessagingSettings messagingSettings;
        private TeamSpecialization specialization;
        private TeamSummary summary;
        private TeamVisibilityType visibility;
        private String webUrl;
        private List<Channel> channels;
        private List<TeamsAppInstallation> installedApps;
        private List<ConversationMember> members;
        private List<TeamsAsyncOperation> operations;
        private List<ResourceSpecificPermissionGrant> permissionGrants;
        private ProfilePhoto photo;
        private Channel primaryChannel;
        private List<TeamworkTag> tags;
        private Schedule schedule;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder classification(String classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder discoverySettings(TeamDiscoverySettings discoverySettings) {
            this.discoverySettings = discoverySettings;
            this.changedFields = changedFields.add("discoverySettings");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder funSettings(TeamFunSettings funSettings) {
            this.funSettings = funSettings;
            this.changedFields = changedFields.add("funSettings");
            return this;
        }

        public Builder guestSettings(TeamGuestSettings guestSettings) {
            this.guestSettings = guestSettings;
            this.changedFields = changedFields.add("guestSettings");
            return this;
        }

        public Builder internalId(String internalId) {
            this.internalId = internalId;
            this.changedFields = changedFields.add("internalId");
            return this;
        }

        public Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            this.changedFields = changedFields.add("isArchived");
            return this;
        }

        public Builder isMembershipLimitedToOwners(Boolean isMembershipLimitedToOwners) {
            this.isMembershipLimitedToOwners = isMembershipLimitedToOwners;
            this.changedFields = changedFields.add("isMembershipLimitedToOwners");
            return this;
        }

        public Builder memberSettings(TeamMemberSettings memberSettings) {
            this.memberSettings = memberSettings;
            this.changedFields = changedFields.add("memberSettings");
            return this;
        }

        public Builder messagingSettings(TeamMessagingSettings messagingSettings) {
            this.messagingSettings = messagingSettings;
            this.changedFields = changedFields.add("messagingSettings");
            return this;
        }

        public Builder specialization(TeamSpecialization specialization) {
            this.specialization = specialization;
            this.changedFields = changedFields.add("specialization");
            return this;
        }

        public Builder summary(TeamSummary summary) {
            this.summary = summary;
            this.changedFields = changedFields.add("summary");
            return this;
        }

        public Builder visibility(TeamVisibilityType visibility) {
            this.visibility = visibility;
            this.changedFields = changedFields.add("visibility");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder channels(List<Channel> channels) {
            this.channels = channels;
            this.changedFields = changedFields.add("channels");
            return this;
        }

        public Builder channels(Channel... channels) {
            return channels(Arrays.asList(channels));
        }

        public Builder installedApps(List<TeamsAppInstallation> installedApps) {
            this.installedApps = installedApps;
            this.changedFields = changedFields.add("installedApps");
            return this;
        }

        public Builder installedApps(TeamsAppInstallation... installedApps) {
            return installedApps(Arrays.asList(installedApps));
        }

        public Builder members(List<ConversationMember> members) {
            this.members = members;
            this.changedFields = changedFields.add("members");
            return this;
        }

        public Builder members(ConversationMember... members) {
            return members(Arrays.asList(members));
        }

        public Builder operations(List<TeamsAsyncOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(TeamsAsyncOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder permissionGrants(List<ResourceSpecificPermissionGrant> permissionGrants) {
            this.permissionGrants = permissionGrants;
            this.changedFields = changedFields.add("permissionGrants");
            return this;
        }

        public Builder permissionGrants(ResourceSpecificPermissionGrant... permissionGrants) {
            return permissionGrants(Arrays.asList(permissionGrants));
        }

        public Builder photo(ProfilePhoto photo) {
            this.photo = photo;
            this.changedFields = changedFields.add("photo");
            return this;
        }

        public Builder primaryChannel(Channel primaryChannel) {
            this.primaryChannel = primaryChannel;
            this.changedFields = changedFields.add("primaryChannel");
            return this;
        }

        public Builder tags(List<TeamworkTag> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(TeamworkTag... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            this.changedFields = changedFields.add("schedule");
            return this;
        }

        public Team build() {
            Team _x = new Team();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.team";
            _x.id = id;
            _x.classification = classification;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.discoverySettings = discoverySettings;
            _x.displayName = displayName;
            _x.funSettings = funSettings;
            _x.guestSettings = guestSettings;
            _x.internalId = internalId;
            _x.isArchived = isArchived;
            _x.isMembershipLimitedToOwners = isMembershipLimitedToOwners;
            _x.memberSettings = memberSettings;
            _x.messagingSettings = messagingSettings;
            _x.specialization = specialization;
            _x.summary = summary;
            _x.visibility = visibility;
            _x.webUrl = webUrl;
            _x.channels = channels;
            _x.installedApps = installedApps;
            _x.members = members;
            _x.operations = operations;
            _x.permissionGrants = permissionGrants;
            _x.photo = photo;
            _x.primaryChannel = primaryChannel;
            _x.tags = tags;
            _x.schedule = schedule;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="classification")
    @JsonIgnore
    public Optional<String> getClassification() {
        return Optional.ofNullable(classification);
    }

    public Team withClassification(String classification) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("classification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.classification = classification;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Team withCreatedDateTime(OffsetDateTime createdDateTime) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Team withDescription(String description) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.description = description;
        return _x;
    }

    @Property(name="discoverySettings")
    @JsonIgnore
    public Optional<TeamDiscoverySettings> getDiscoverySettings() {
        return Optional.ofNullable(discoverySettings);
    }

    public Team withDiscoverySettings(TeamDiscoverySettings discoverySettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("discoverySettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.discoverySettings = discoverySettings;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Team withDisplayName(String displayName) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="funSettings")
    @JsonIgnore
    public Optional<TeamFunSettings> getFunSettings() {
        return Optional.ofNullable(funSettings);
    }

    public Team withFunSettings(TeamFunSettings funSettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("funSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.funSettings = funSettings;
        return _x;
    }

    @Property(name="guestSettings")
    @JsonIgnore
    public Optional<TeamGuestSettings> getGuestSettings() {
        return Optional.ofNullable(guestSettings);
    }

    public Team withGuestSettings(TeamGuestSettings guestSettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("guestSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.guestSettings = guestSettings;
        return _x;
    }

    @Property(name="internalId")
    @JsonIgnore
    public Optional<String> getInternalId() {
        return Optional.ofNullable(internalId);
    }

    public Team withInternalId(String internalId) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("internalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.internalId = internalId;
        return _x;
    }

    @Property(name="isArchived")
    @JsonIgnore
    public Optional<Boolean> getIsArchived() {
        return Optional.ofNullable(isArchived);
    }

    public Team withIsArchived(Boolean isArchived) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("isArchived");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.isArchived = isArchived;
        return _x;
    }

    @Property(name="isMembershipLimitedToOwners")
    @JsonIgnore
    public Optional<Boolean> getIsMembershipLimitedToOwners() {
        return Optional.ofNullable(isMembershipLimitedToOwners);
    }

    public Team withIsMembershipLimitedToOwners(Boolean isMembershipLimitedToOwners) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("isMembershipLimitedToOwners");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.isMembershipLimitedToOwners = isMembershipLimitedToOwners;
        return _x;
    }

    @Property(name="memberSettings")
    @JsonIgnore
    public Optional<TeamMemberSettings> getMemberSettings() {
        return Optional.ofNullable(memberSettings);
    }

    public Team withMemberSettings(TeamMemberSettings memberSettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("memberSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.memberSettings = memberSettings;
        return _x;
    }

    @Property(name="messagingSettings")
    @JsonIgnore
    public Optional<TeamMessagingSettings> getMessagingSettings() {
        return Optional.ofNullable(messagingSettings);
    }

    public Team withMessagingSettings(TeamMessagingSettings messagingSettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("messagingSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.messagingSettings = messagingSettings;
        return _x;
    }

    @Property(name="specialization")
    @JsonIgnore
    public Optional<TeamSpecialization> getSpecialization() {
        return Optional.ofNullable(specialization);
    }

    public Team withSpecialization(TeamSpecialization specialization) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("specialization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.specialization = specialization;
        return _x;
    }

    @Property(name="summary")
    @JsonIgnore
    public Optional<TeamSummary> getSummary() {
        return Optional.ofNullable(summary);
    }

    public Team withSummary(TeamSummary summary) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("summary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.summary = summary;
        return _x;
    }

    @Property(name="visibility")
    @JsonIgnore
    public Optional<TeamVisibilityType> getVisibility() {
        return Optional.ofNullable(visibility);
    }

    public Team withVisibility(TeamVisibilityType visibility) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("visibility");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.visibility = visibility;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public Team withWebUrl(String webUrl) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.webUrl = webUrl;
        return _x;
    }

    public Team withUnmappedField(String name, Object value) {
        Team _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="channels")
    @JsonIgnore
    public ChannelCollectionRequest getChannels() {
        return new ChannelCollectionRequest(
                        contextPath.addSegment("channels"), Optional.ofNullable(channels));
    }

    @NavigationProperty(name="group")
    @JsonIgnore
    public GroupRequest getGroup() {
        return new GroupRequest(contextPath.addSegment("group"), RequestHelper.getValue(unmappedFields, "group"));
    }

    @NavigationProperty(name="installedApps")
    @JsonIgnore
    public TeamsAppInstallationCollectionRequest getInstalledApps() {
        return new TeamsAppInstallationCollectionRequest(
                        contextPath.addSegment("installedApps"), Optional.ofNullable(installedApps));
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public ConversationMemberCollectionRequest getMembers() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"), Optional.ofNullable(members));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public TeamsAsyncOperationCollectionRequest getOperations() {
        return new TeamsAsyncOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="owners")
    @JsonIgnore
    public UserCollectionRequest getOwners() {
        return new UserCollectionRequest(
                        contextPath.addSegment("owners"), RequestHelper.getValue(unmappedFields, "owners"));
    }

    @NavigationProperty(name="permissionGrants")
    @JsonIgnore
    public ResourceSpecificPermissionGrantCollectionRequest getPermissionGrants() {
        return new ResourceSpecificPermissionGrantCollectionRequest(
                        contextPath.addSegment("permissionGrants"), Optional.ofNullable(permissionGrants));
    }

    @NavigationProperty(name="photo")
    @JsonIgnore
    public ProfilePhotoRequest getPhoto() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"), Optional.ofNullable(photo));
    }

    @NavigationProperty(name="primaryChannel")
    @JsonIgnore
    public ChannelRequest getPrimaryChannel() {
        return new ChannelRequest(contextPath.addSegment("primaryChannel"), Optional.ofNullable(primaryChannel));
    }

    @NavigationProperty(name="tags")
    @JsonIgnore
    public TeamworkTagCollectionRequest getTags() {
        return new TeamworkTagCollectionRequest(
                        contextPath.addSegment("tags"), Optional.ofNullable(tags));
    }

    @NavigationProperty(name="template")
    @JsonIgnore
    public TeamsTemplateRequest getTemplate() {
        return new TeamsTemplateRequest(contextPath.addSegment("template"), RequestHelper.getValue(unmappedFields, "template"));
    }

    @NavigationProperty(name="schedule")
    @JsonIgnore
    public ScheduleRequest getSchedule() {
        return new ScheduleRequest(contextPath.addSegment("schedule"), Optional.ofNullable(schedule));
    }

    public Team withChannels(List<Channel> channels) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("channels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.channels = channels;
        return _x;
    }

    public Team withInstalledApps(List<TeamsAppInstallation> installedApps) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("installedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.installedApps = installedApps;
        return _x;
    }

    public Team withMembers(List<ConversationMember> members) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("members");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.members = members;
        return _x;
    }

    public Team withOperations(List<TeamsAsyncOperation> operations) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.operations = operations;
        return _x;
    }

    public Team withPermissionGrants(List<ResourceSpecificPermissionGrant> permissionGrants) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("permissionGrants");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.permissionGrants = permissionGrants;
        return _x;
    }

    public Team withPhoto(ProfilePhoto photo) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("photo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.photo = photo;
        return _x;
    }

    public Team withPrimaryChannel(Channel primaryChannel) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("primaryChannel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.primaryChannel = primaryChannel;
        return _x;
    }

    public Team withTags(List<TeamworkTag> tags) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("tags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.tags = tags;
        return _x;
    }

    public Team withSchedule(Schedule schedule) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("schedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.schedule = schedule;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Team patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Team put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Team _copy() {
        Team _x = new Team();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.classification = classification;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.discoverySettings = discoverySettings;
        _x.displayName = displayName;
        _x.funSettings = funSettings;
        _x.guestSettings = guestSettings;
        _x.internalId = internalId;
        _x.isArchived = isArchived;
        _x.isMembershipLimitedToOwners = isMembershipLimitedToOwners;
        _x.memberSettings = memberSettings;
        _x.messagingSettings = messagingSettings;
        _x.specialization = specialization;
        _x.summary = summary;
        _x.visibility = visibility;
        _x.webUrl = webUrl;
        _x.channels = channels;
        _x.installedApps = installedApps;
        _x.members = members;
        _x.operations = operations;
        _x.permissionGrants = permissionGrants;
        _x.photo = photo;
        _x.primaryChannel = primaryChannel;
        _x.tags = tags;
        _x.schedule = schedule;
        return _x;
    }

    @Action(name = "clone")
    @JsonIgnore
    public ActionRequestNoReturn clone(String displayName, String description, String mailNickname, String classification, TeamVisibilityType visibility, ClonableTeamParts partsToClone) {
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
        Preconditions.checkNotNull(partsToClone, "partsToClone cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("description", "Edm.String", Checks.checkIsAscii(description))
            .put("mailNickname", "Edm.String", Checks.checkIsAscii(mailNickname))
            .put("classification", "Edm.String", Checks.checkIsAscii(classification))
            .put("visibility", "microsoft.graph.teamVisibilityType", visibility)
            .put("partsToClone", "microsoft.graph.clonableTeamParts", partsToClone)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clone"), _parameters);
    }

    @Action(name = "archive")
    @JsonIgnore
    public ActionRequestNoReturn archive(Boolean shouldSetSpoSiteReadOnlyForMembers) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("shouldSetSpoSiteReadOnlyForMembers", "Edm.Boolean", shouldSetSpoSiteReadOnlyForMembers)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.archive"), _parameters);
    }

    @Action(name = "unarchive")
    @JsonIgnore
    public ActionRequestNoReturn unarchive() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unarchive"), _parameters);
    }

    @Action(name = "completeMigration")
    @JsonIgnore
    public ActionRequestNoReturn completeMigration() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.completeMigration"), _parameters);
    }

    @Action(name = "sendActivityNotification")
    @JsonIgnore
    public ActionRequestNoReturn sendActivityNotification(TeamworkActivityTopic topic, String activityType, Long chainId, ItemBody previewText, List<KeyValuePair> templateParameters, TeamworkNotificationRecipient recipient) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("topic", "microsoft.graph.teamworkActivityTopic", topic)
            .put("activityType", "Edm.String", Checks.checkIsAscii(activityType))
            .put("chainId", "Edm.Int64", chainId)
            .put("previewText", "microsoft.graph.itemBody", previewText)
            .put("templateParameters", "Collection(microsoft.graph.keyValuePair)", templateParameters)
            .put("recipient", "microsoft.graph.teamworkNotificationRecipient", recipient)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendActivityNotification"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Team[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("classification=");
        b.append(this.classification);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("discoverySettings=");
        b.append(this.discoverySettings);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("funSettings=");
        b.append(this.funSettings);
        b.append(", ");
        b.append("guestSettings=");
        b.append(this.guestSettings);
        b.append(", ");
        b.append("internalId=");
        b.append(this.internalId);
        b.append(", ");
        b.append("isArchived=");
        b.append(this.isArchived);
        b.append(", ");
        b.append("isMembershipLimitedToOwners=");
        b.append(this.isMembershipLimitedToOwners);
        b.append(", ");
        b.append("memberSettings=");
        b.append(this.memberSettings);
        b.append(", ");
        b.append("messagingSettings=");
        b.append(this.messagingSettings);
        b.append(", ");
        b.append("specialization=");
        b.append(this.specialization);
        b.append(", ");
        b.append("summary=");
        b.append(this.summary);
        b.append(", ");
        b.append("visibility=");
        b.append(this.visibility);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("channels=");
        b.append(this.channels);
        b.append(", ");
        b.append("installedApps=");
        b.append(this.installedApps);
        b.append(", ");
        b.append("members=");
        b.append(this.members);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("permissionGrants=");
        b.append(this.permissionGrants);
        b.append(", ");
        b.append("photo=");
        b.append(this.photo);
        b.append(", ");
        b.append("primaryChannel=");
        b.append(this.primaryChannel);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("schedule=");
        b.append(this.schedule);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
