package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.PatternedRecurrence;
import odata.msgraph.client.beta.complex.TaskViewpoint;
import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.enums.TaskStatus_v2;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class Task extends BaseTask implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.task";
    }

    protected Task() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTask() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime bodyLastModifiedDateTime;
        private OffsetDateTime completedDateTime;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private DateTimeTimeZone dueDateTime;
        private Importance importance;
        private OffsetDateTime lastModifiedDateTime;
        private PatternedRecurrence recurrence;
        private DateTimeTimeZone startDateTime;
        private TaskStatus_v2 status;
        private String textBody;
        private TaskViewpoint viewpoint;
        private List<ChecklistItem> checklistItems;
        private List<Extension> extensions;
        private List<LinkedResource_v2> linkedResources;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder bodyLastModifiedDateTime(OffsetDateTime bodyLastModifiedDateTime) {
            this.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
            this.changedFields = changedFields.add("bodyLastModifiedDateTime");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder dueDateTime(DateTimeTimeZone dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder importance(Importance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder recurrence(PatternedRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        public Builder startDateTime(DateTimeTimeZone startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder status(TaskStatus_v2 status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder textBody(String textBody) {
            this.textBody = textBody;
            this.changedFields = changedFields.add("textBody");
            return this;
        }

        public Builder viewpoint(TaskViewpoint viewpoint) {
            this.viewpoint = viewpoint;
            this.changedFields = changedFields.add("viewpoint");
            return this;
        }

        public Builder checklistItems(List<ChecklistItem> checklistItems) {
            this.checklistItems = checklistItems;
            this.changedFields = changedFields.add("checklistItems");
            return this;
        }

        public Builder checklistItems(ChecklistItem... checklistItems) {
            return checklistItems(Arrays.asList(checklistItems));
        }

        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder extensions(Extension... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        public Builder linkedResources(List<LinkedResource_v2> linkedResources) {
            this.linkedResources = linkedResources;
            this.changedFields = changedFields.add("linkedResources");
            return this;
        }

        public Builder linkedResources(LinkedResource_v2... linkedResources) {
            return linkedResources(Arrays.asList(linkedResources));
        }

        public Task build() {
            Task _x = new Task();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.task";
            _x.id = id;
            _x.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
            _x.completedDateTime = completedDateTime;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.dueDateTime = dueDateTime;
            _x.importance = importance;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.recurrence = recurrence;
            _x.startDateTime = startDateTime;
            _x.status = status;
            _x.textBody = textBody;
            _x.viewpoint = viewpoint;
            _x.checklistItems = checklistItems;
            _x.extensions = extensions;
            _x.linkedResources = linkedResources;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Task withUnmappedField(String name, Object value) {
        Task _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Task patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Task _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Task put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Task _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Task _copy() {
        Task _x = new Task();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
        _x.completedDateTime = completedDateTime;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.dueDateTime = dueDateTime;
        _x.importance = importance;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.recurrence = recurrence;
        _x.startDateTime = startDateTime;
        _x.status = status;
        _x.textBody = textBody;
        _x.viewpoint = viewpoint;
        _x.checklistItems = checklistItems;
        _x.extensions = extensions;
        _x.linkedResources = linkedResources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Task[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("bodyLastModifiedDateTime=");
        b.append(this.bodyLastModifiedDateTime);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("textBody=");
        b.append(this.textBody);
        b.append(", ");
        b.append("viewpoint=");
        b.append(this.viewpoint);
        b.append(", ");
        b.append("checklistItems=");
        b.append(this.checklistItems);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("linkedResources=");
        b.append(this.linkedResources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
