package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AttributeDefinition;
import odata.msgraph.client.beta.complex.ExpressionInputObject;
import odata.msgraph.client.beta.complex.ParseExpressionResponse;
import odata.msgraph.client.beta.complex.SynchronizationRule;
import odata.msgraph.client.beta.entity.collection.request.DirectoryDefinitionCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "synchronizationRules", 
    "version", 
    "directories"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationSchema extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationSchema";
    }

    @JsonProperty("synchronizationRules")
    protected List<SynchronizationRule> synchronizationRules;

    @JsonProperty("synchronizationRules@nextLink")
    protected String synchronizationRulesNextLink;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("directories")
    protected List<DirectoryDefinition> directories;

    protected SynchronizationSchema() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSynchronizationSchema() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<SynchronizationRule> synchronizationRules;
        private String synchronizationRulesNextLink;
        private String version;
        private List<DirectoryDefinition> directories;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder synchronizationRules(List<SynchronizationRule> synchronizationRules) {
            this.synchronizationRules = synchronizationRules;
            this.changedFields = changedFields.add("synchronizationRules");
            return this;
        }

        public Builder synchronizationRules(SynchronizationRule... synchronizationRules) {
            return synchronizationRules(Arrays.asList(synchronizationRules));
        }

        public Builder synchronizationRulesNextLink(String synchronizationRulesNextLink) {
            this.synchronizationRulesNextLink = synchronizationRulesNextLink;
            this.changedFields = changedFields.add("synchronizationRules");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder directories(List<DirectoryDefinition> directories) {
            this.directories = directories;
            this.changedFields = changedFields.add("directories");
            return this;
        }

        public Builder directories(DirectoryDefinition... directories) {
            return directories(Arrays.asList(directories));
        }

        public SynchronizationSchema build() {
            SynchronizationSchema _x = new SynchronizationSchema();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.synchronizationSchema";
            _x.id = id;
            _x.synchronizationRules = synchronizationRules;
            _x.synchronizationRulesNextLink = synchronizationRulesNextLink;
            _x.version = version;
            _x.directories = directories;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="synchronizationRules")
    @JsonIgnore
    public CollectionPage<SynchronizationRule> getSynchronizationRules() {
        return new CollectionPage<SynchronizationRule>(contextPath, SynchronizationRule.class, this.synchronizationRules, Optional.ofNullable(synchronizationRulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SynchronizationSchema withSynchronizationRules(List<SynchronizationRule> synchronizationRules) {
        SynchronizationSchema _x = _copy();
        _x.changedFields = changedFields.add("synchronizationRules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationSchema");
        _x.synchronizationRules = synchronizationRules;
        return _x;
    }

    @Property(name="synchronizationRules")
    @JsonIgnore
    public CollectionPage<SynchronizationRule> getSynchronizationRules(HttpRequestOptions options) {
        return new CollectionPage<SynchronizationRule>(contextPath, SynchronizationRule.class, this.synchronizationRules, Optional.ofNullable(synchronizationRulesNextLink), Collections.emptyList(), options);
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public SynchronizationSchema withVersion(String version) {
        SynchronizationSchema _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationSchema");
        _x.version = version;
        return _x;
    }

    public SynchronizationSchema withUnmappedField(String name, Object value) {
        SynchronizationSchema _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="directories")
    @JsonIgnore
    public DirectoryDefinitionCollectionRequest getDirectories() {
        return new DirectoryDefinitionCollectionRequest(
                        contextPath.addSegment("directories"), Optional.ofNullable(directories));
    }

    public SynchronizationSchema withDirectories(List<DirectoryDefinition> directories) {
        SynchronizationSchema _x = _copy();
        _x.changedFields = changedFields.add("directories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationSchema");
        _x.directories = directories;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SynchronizationSchema patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SynchronizationSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SynchronizationSchema put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SynchronizationSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SynchronizationSchema _copy() {
        SynchronizationSchema _x = new SynchronizationSchema();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.synchronizationRules = synchronizationRules;
        _x.version = version;
        _x.directories = directories;
        return _x;
    }

    @Action(name = "parseExpression")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ParseExpressionResponse> parseExpression(String expression, ExpressionInputObject testInputObject, AttributeDefinition targetAttributeDefinition) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("expression", "Edm.String", Checks.checkIsAscii(expression))
            .put("testInputObject", "microsoft.graph.expressionInputObject", testInputObject)
            .put("targetAttributeDefinition", "microsoft.graph.attributeDefinition", targetAttributeDefinition)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ParseExpressionResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.parseExpression"), ParseExpressionResponse.class, _parameters);
    }

    @Function(name = "filterOperators")
    @JsonIgnore
    public CollectionPageNonEntityRequest<FilterOperatorSchema> filterOperators() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterOperators"), FilterOperatorSchema.class, _parameters);
    }

    @Function(name = "functions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AttributeMappingFunctionSchema> functions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.functions"), AttributeMappingFunctionSchema.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationSchema[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("synchronizationRules=");
        b.append(this.synchronizationRules);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("directories=");
        b.append(this.directories);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
