package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.enums.ScheduleChangeRequestActor;
import odata.msgraph.client.beta.enums.ScheduleChangeState;

@JsonPropertyOrder({
    "@odata.type", 
    "recipientShiftId"})
@JsonInclude(Include.NON_NULL)
public class SwapShiftsChangeRequest extends OfferShiftRequest implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.swapShiftsChangeRequest";
    }

    @JsonProperty("recipientShiftId")
    protected String recipientShiftId;

    protected SwapShiftsChangeRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSwapShiftsChangeRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private ScheduleChangeRequestActor assignedTo;
        private OffsetDateTime managerActionDateTime;
        private String managerActionMessage;
        private String managerUserId;
        private OffsetDateTime senderDateTime;
        private String senderMessage;
        private String senderUserId;
        private ScheduleChangeState state;
        private OffsetDateTime recipientActionDateTime;
        private String recipientActionMessage;
        private String recipientUserId;
        private String senderShiftId;
        private String recipientShiftId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder assignedTo(ScheduleChangeRequestActor assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder managerActionDateTime(OffsetDateTime managerActionDateTime) {
            this.managerActionDateTime = managerActionDateTime;
            this.changedFields = changedFields.add("managerActionDateTime");
            return this;
        }

        public Builder managerActionMessage(String managerActionMessage) {
            this.managerActionMessage = managerActionMessage;
            this.changedFields = changedFields.add("managerActionMessage");
            return this;
        }

        public Builder managerUserId(String managerUserId) {
            this.managerUserId = managerUserId;
            this.changedFields = changedFields.add("managerUserId");
            return this;
        }

        public Builder senderDateTime(OffsetDateTime senderDateTime) {
            this.senderDateTime = senderDateTime;
            this.changedFields = changedFields.add("senderDateTime");
            return this;
        }

        public Builder senderMessage(String senderMessage) {
            this.senderMessage = senderMessage;
            this.changedFields = changedFields.add("senderMessage");
            return this;
        }

        public Builder senderUserId(String senderUserId) {
            this.senderUserId = senderUserId;
            this.changedFields = changedFields.add("senderUserId");
            return this;
        }

        public Builder state(ScheduleChangeState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder recipientActionDateTime(OffsetDateTime recipientActionDateTime) {
            this.recipientActionDateTime = recipientActionDateTime;
            this.changedFields = changedFields.add("recipientActionDateTime");
            return this;
        }

        public Builder recipientActionMessage(String recipientActionMessage) {
            this.recipientActionMessage = recipientActionMessage;
            this.changedFields = changedFields.add("recipientActionMessage");
            return this;
        }

        public Builder recipientUserId(String recipientUserId) {
            this.recipientUserId = recipientUserId;
            this.changedFields = changedFields.add("recipientUserId");
            return this;
        }

        public Builder senderShiftId(String senderShiftId) {
            this.senderShiftId = senderShiftId;
            this.changedFields = changedFields.add("senderShiftId");
            return this;
        }

        public Builder recipientShiftId(String recipientShiftId) {
            this.recipientShiftId = recipientShiftId;
            this.changedFields = changedFields.add("recipientShiftId");
            return this;
        }

        public SwapShiftsChangeRequest build() {
            SwapShiftsChangeRequest _x = new SwapShiftsChangeRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.swapShiftsChangeRequest";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.assignedTo = assignedTo;
            _x.managerActionDateTime = managerActionDateTime;
            _x.managerActionMessage = managerActionMessage;
            _x.managerUserId = managerUserId;
            _x.senderDateTime = senderDateTime;
            _x.senderMessage = senderMessage;
            _x.senderUserId = senderUserId;
            _x.state = state;
            _x.recipientActionDateTime = recipientActionDateTime;
            _x.recipientActionMessage = recipientActionMessage;
            _x.recipientUserId = recipientUserId;
            _x.senderShiftId = senderShiftId;
            _x.recipientShiftId = recipientShiftId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="recipientShiftId")
    @JsonIgnore
    public Optional<String> getRecipientShiftId() {
        return Optional.ofNullable(recipientShiftId);
    }

    public SwapShiftsChangeRequest withRecipientShiftId(String recipientShiftId) {
        SwapShiftsChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("recipientShiftId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.swapShiftsChangeRequest");
        _x.recipientShiftId = recipientShiftId;
        return _x;
    }

    public SwapShiftsChangeRequest withUnmappedField(String name, Object value) {
        SwapShiftsChangeRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SwapShiftsChangeRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SwapShiftsChangeRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SwapShiftsChangeRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SwapShiftsChangeRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SwapShiftsChangeRequest _copy() {
        SwapShiftsChangeRequest _x = new SwapShiftsChangeRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.assignedTo = assignedTo;
        _x.managerActionDateTime = managerActionDateTime;
        _x.managerActionMessage = managerActionMessage;
        _x.managerUserId = managerUserId;
        _x.senderDateTime = senderDateTime;
        _x.senderMessage = senderMessage;
        _x.senderUserId = senderUserId;
        _x.state = state;
        _x.recipientActionDateTime = recipientActionDateTime;
        _x.recipientActionMessage = recipientActionMessage;
        _x.recipientUserId = recipientUserId;
        _x.senderShiftId = senderShiftId;
        _x.recipientShiftId = recipientShiftId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SwapShiftsChangeRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("managerActionDateTime=");
        b.append(this.managerActionDateTime);
        b.append(", ");
        b.append("managerActionMessage=");
        b.append(this.managerActionMessage);
        b.append(", ");
        b.append("managerUserId=");
        b.append(this.managerUserId);
        b.append(", ");
        b.append("senderDateTime=");
        b.append(this.senderDateTime);
        b.append(", ");
        b.append("senderMessage=");
        b.append(this.senderMessage);
        b.append(", ");
        b.append("senderUserId=");
        b.append(this.senderUserId);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("recipientActionDateTime=");
        b.append(this.recipientActionDateTime);
        b.append(", ");
        b.append("recipientActionMessage=");
        b.append(this.recipientActionMessage);
        b.append(", ");
        b.append("recipientUserId=");
        b.append(this.recipientUserId);
        b.append(", ");
        b.append("senderShiftId=");
        b.append(this.senderShiftId);
        b.append(", ");
        b.append("recipientShiftId=");
        b.append(this.recipientShiftId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
