package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.OathTokenMetadata;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationType", 
    "authenticatorFlavor", 
    "deviceId", 
    "deviceName", 
    "deviceTag", 
    "deviceToken", 
    "hashFunction", 
    "lastAuthenticatedDateTime", 
    "notificationType", 
    "oathSecretKey", 
    "oathTokenMetadata", 
    "oathTokenTimeDriftInSeconds", 
    "phoneAppVersion", 
    "tenantDeviceId", 
    "tokenGenerationIntervalInSeconds"})
@JsonInclude(Include.NON_NULL)
public class StrongAuthenticationPhoneAppDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.strongAuthenticationPhoneAppDetail";
    }

    @JsonProperty("authenticationType")
    protected String authenticationType;

    @JsonProperty("authenticatorFlavor")
    protected String authenticatorFlavor;

    @JsonProperty("deviceId")
    protected UUID deviceId;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("deviceTag")
    protected String deviceTag;

    @JsonProperty("deviceToken")
    protected String deviceToken;

    @JsonProperty("hashFunction")
    protected String hashFunction;

    @JsonProperty("lastAuthenticatedDateTime")
    protected OffsetDateTime lastAuthenticatedDateTime;

    @JsonProperty("notificationType")
    protected String notificationType;

    @JsonProperty("oathSecretKey")
    protected String oathSecretKey;

    @JsonProperty("oathTokenMetadata")
    protected OathTokenMetadata oathTokenMetadata;

    @JsonProperty("oathTokenTimeDriftInSeconds")
    protected Integer oathTokenTimeDriftInSeconds;

    @JsonProperty("phoneAppVersion")
    protected String phoneAppVersion;

    @JsonProperty("tenantDeviceId")
    protected String tenantDeviceId;

    @JsonProperty("tokenGenerationIntervalInSeconds")
    protected Integer tokenGenerationIntervalInSeconds;

    protected StrongAuthenticationPhoneAppDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderStrongAuthenticationPhoneAppDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String authenticationType;
        private String authenticatorFlavor;
        private UUID deviceId;
        private String deviceName;
        private String deviceTag;
        private String deviceToken;
        private String hashFunction;
        private OffsetDateTime lastAuthenticatedDateTime;
        private String notificationType;
        private String oathSecretKey;
        private OathTokenMetadata oathTokenMetadata;
        private Integer oathTokenTimeDriftInSeconds;
        private String phoneAppVersion;
        private String tenantDeviceId;
        private Integer tokenGenerationIntervalInSeconds;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            this.changedFields = changedFields.add("authenticationType");
            return this;
        }

        public Builder authenticatorFlavor(String authenticatorFlavor) {
            this.authenticatorFlavor = authenticatorFlavor;
            this.changedFields = changedFields.add("authenticatorFlavor");
            return this;
        }

        public Builder deviceId(UUID deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        public Builder deviceTag(String deviceTag) {
            this.deviceTag = deviceTag;
            this.changedFields = changedFields.add("deviceTag");
            return this;
        }

        public Builder deviceToken(String deviceToken) {
            this.deviceToken = deviceToken;
            this.changedFields = changedFields.add("deviceToken");
            return this;
        }

        public Builder hashFunction(String hashFunction) {
            this.hashFunction = hashFunction;
            this.changedFields = changedFields.add("hashFunction");
            return this;
        }

        public Builder lastAuthenticatedDateTime(OffsetDateTime lastAuthenticatedDateTime) {
            this.lastAuthenticatedDateTime = lastAuthenticatedDateTime;
            this.changedFields = changedFields.add("lastAuthenticatedDateTime");
            return this;
        }

        public Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            this.changedFields = changedFields.add("notificationType");
            return this;
        }

        public Builder oathSecretKey(String oathSecretKey) {
            this.oathSecretKey = oathSecretKey;
            this.changedFields = changedFields.add("oathSecretKey");
            return this;
        }

        public Builder oathTokenMetadata(OathTokenMetadata oathTokenMetadata) {
            this.oathTokenMetadata = oathTokenMetadata;
            this.changedFields = changedFields.add("oathTokenMetadata");
            return this;
        }

        public Builder oathTokenTimeDriftInSeconds(Integer oathTokenTimeDriftInSeconds) {
            this.oathTokenTimeDriftInSeconds = oathTokenTimeDriftInSeconds;
            this.changedFields = changedFields.add("oathTokenTimeDriftInSeconds");
            return this;
        }

        public Builder phoneAppVersion(String phoneAppVersion) {
            this.phoneAppVersion = phoneAppVersion;
            this.changedFields = changedFields.add("phoneAppVersion");
            return this;
        }

        public Builder tenantDeviceId(String tenantDeviceId) {
            this.tenantDeviceId = tenantDeviceId;
            this.changedFields = changedFields.add("tenantDeviceId");
            return this;
        }

        public Builder tokenGenerationIntervalInSeconds(Integer tokenGenerationIntervalInSeconds) {
            this.tokenGenerationIntervalInSeconds = tokenGenerationIntervalInSeconds;
            this.changedFields = changedFields.add("tokenGenerationIntervalInSeconds");
            return this;
        }

        public StrongAuthenticationPhoneAppDetail build() {
            StrongAuthenticationPhoneAppDetail _x = new StrongAuthenticationPhoneAppDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.strongAuthenticationPhoneAppDetail";
            _x.id = id;
            _x.authenticationType = authenticationType;
            _x.authenticatorFlavor = authenticatorFlavor;
            _x.deviceId = deviceId;
            _x.deviceName = deviceName;
            _x.deviceTag = deviceTag;
            _x.deviceToken = deviceToken;
            _x.hashFunction = hashFunction;
            _x.lastAuthenticatedDateTime = lastAuthenticatedDateTime;
            _x.notificationType = notificationType;
            _x.oathSecretKey = oathSecretKey;
            _x.oathTokenMetadata = oathTokenMetadata;
            _x.oathTokenTimeDriftInSeconds = oathTokenTimeDriftInSeconds;
            _x.phoneAppVersion = phoneAppVersion;
            _x.tenantDeviceId = tenantDeviceId;
            _x.tokenGenerationIntervalInSeconds = tokenGenerationIntervalInSeconds;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="authenticationType")
    @JsonIgnore
    public Optional<String> getAuthenticationType() {
        return Optional.ofNullable(authenticationType);
    }

    public StrongAuthenticationPhoneAppDetail withAuthenticationType(String authenticationType) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("authenticationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.authenticationType = authenticationType;
        return _x;
    }

    @Property(name="authenticatorFlavor")
    @JsonIgnore
    public Optional<String> getAuthenticatorFlavor() {
        return Optional.ofNullable(authenticatorFlavor);
    }

    public StrongAuthenticationPhoneAppDetail withAuthenticatorFlavor(String authenticatorFlavor) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("authenticatorFlavor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.authenticatorFlavor = authenticatorFlavor;
        return _x;
    }

    @Property(name="deviceId")
    @JsonIgnore
    public Optional<UUID> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    public StrongAuthenticationPhoneAppDetail withDeviceId(UUID deviceId) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.deviceId = deviceId;
        return _x;
    }

    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    public StrongAuthenticationPhoneAppDetail withDeviceName(String deviceName) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.deviceName = deviceName;
        return _x;
    }

    @Property(name="deviceTag")
    @JsonIgnore
    public Optional<String> getDeviceTag() {
        return Optional.ofNullable(deviceTag);
    }

    public StrongAuthenticationPhoneAppDetail withDeviceTag(String deviceTag) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("deviceTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.deviceTag = deviceTag;
        return _x;
    }

    @Property(name="deviceToken")
    @JsonIgnore
    public Optional<String> getDeviceToken() {
        return Optional.ofNullable(deviceToken);
    }

    public StrongAuthenticationPhoneAppDetail withDeviceToken(String deviceToken) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("deviceToken");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.deviceToken = deviceToken;
        return _x;
    }

    @Property(name="hashFunction")
    @JsonIgnore
    public Optional<String> getHashFunction() {
        return Optional.ofNullable(hashFunction);
    }

    public StrongAuthenticationPhoneAppDetail withHashFunction(String hashFunction) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("hashFunction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.hashFunction = hashFunction;
        return _x;
    }

    @Property(name="lastAuthenticatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastAuthenticatedDateTime() {
        return Optional.ofNullable(lastAuthenticatedDateTime);
    }

    public StrongAuthenticationPhoneAppDetail withLastAuthenticatedDateTime(OffsetDateTime lastAuthenticatedDateTime) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("lastAuthenticatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.lastAuthenticatedDateTime = lastAuthenticatedDateTime;
        return _x;
    }

    @Property(name="notificationType")
    @JsonIgnore
    public Optional<String> getNotificationType() {
        return Optional.ofNullable(notificationType);
    }

    public StrongAuthenticationPhoneAppDetail withNotificationType(String notificationType) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("notificationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.notificationType = notificationType;
        return _x;
    }

    @Property(name="oathSecretKey")
    @JsonIgnore
    public Optional<String> getOathSecretKey() {
        return Optional.ofNullable(oathSecretKey);
    }

    public StrongAuthenticationPhoneAppDetail withOathSecretKey(String oathSecretKey) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("oathSecretKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.oathSecretKey = oathSecretKey;
        return _x;
    }

    @Property(name="oathTokenMetadata")
    @JsonIgnore
    public Optional<OathTokenMetadata> getOathTokenMetadata() {
        return Optional.ofNullable(oathTokenMetadata);
    }

    public StrongAuthenticationPhoneAppDetail withOathTokenMetadata(OathTokenMetadata oathTokenMetadata) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("oathTokenMetadata");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.oathTokenMetadata = oathTokenMetadata;
        return _x;
    }

    @Property(name="oathTokenTimeDriftInSeconds")
    @JsonIgnore
    public Optional<Integer> getOathTokenTimeDriftInSeconds() {
        return Optional.ofNullable(oathTokenTimeDriftInSeconds);
    }

    public StrongAuthenticationPhoneAppDetail withOathTokenTimeDriftInSeconds(Integer oathTokenTimeDriftInSeconds) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("oathTokenTimeDriftInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.oathTokenTimeDriftInSeconds = oathTokenTimeDriftInSeconds;
        return _x;
    }

    @Property(name="phoneAppVersion")
    @JsonIgnore
    public Optional<String> getPhoneAppVersion() {
        return Optional.ofNullable(phoneAppVersion);
    }

    public StrongAuthenticationPhoneAppDetail withPhoneAppVersion(String phoneAppVersion) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("phoneAppVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.phoneAppVersion = phoneAppVersion;
        return _x;
    }

    @Property(name="tenantDeviceId")
    @JsonIgnore
    public Optional<String> getTenantDeviceId() {
        return Optional.ofNullable(tenantDeviceId);
    }

    public StrongAuthenticationPhoneAppDetail withTenantDeviceId(String tenantDeviceId) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("tenantDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.tenantDeviceId = tenantDeviceId;
        return _x;
    }

    @Property(name="tokenGenerationIntervalInSeconds")
    @JsonIgnore
    public Optional<Integer> getTokenGenerationIntervalInSeconds() {
        return Optional.ofNullable(tokenGenerationIntervalInSeconds);
    }

    public StrongAuthenticationPhoneAppDetail withTokenGenerationIntervalInSeconds(Integer tokenGenerationIntervalInSeconds) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = changedFields.add("tokenGenerationIntervalInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.strongAuthenticationPhoneAppDetail");
        _x.tokenGenerationIntervalInSeconds = tokenGenerationIntervalInSeconds;
        return _x;
    }

    public StrongAuthenticationPhoneAppDetail withUnmappedField(String name, Object value) {
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public StrongAuthenticationPhoneAppDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public StrongAuthenticationPhoneAppDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        StrongAuthenticationPhoneAppDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private StrongAuthenticationPhoneAppDetail _copy() {
        StrongAuthenticationPhoneAppDetail _x = new StrongAuthenticationPhoneAppDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.authenticationType = authenticationType;
        _x.authenticatorFlavor = authenticatorFlavor;
        _x.deviceId = deviceId;
        _x.deviceName = deviceName;
        _x.deviceTag = deviceTag;
        _x.deviceToken = deviceToken;
        _x.hashFunction = hashFunction;
        _x.lastAuthenticatedDateTime = lastAuthenticatedDateTime;
        _x.notificationType = notificationType;
        _x.oathSecretKey = oathSecretKey;
        _x.oathTokenMetadata = oathTokenMetadata;
        _x.oathTokenTimeDriftInSeconds = oathTokenTimeDriftInSeconds;
        _x.phoneAppVersion = phoneAppVersion;
        _x.tenantDeviceId = tenantDeviceId;
        _x.tokenGenerationIntervalInSeconds = tokenGenerationIntervalInSeconds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StrongAuthenticationPhoneAppDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("authenticationType=");
        b.append(this.authenticationType);
        b.append(", ");
        b.append("authenticatorFlavor=");
        b.append(this.authenticatorFlavor);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("deviceTag=");
        b.append(this.deviceTag);
        b.append(", ");
        b.append("deviceToken=");
        b.append(this.deviceToken);
        b.append(", ");
        b.append("hashFunction=");
        b.append(this.hashFunction);
        b.append(", ");
        b.append("lastAuthenticatedDateTime=");
        b.append(this.lastAuthenticatedDateTime);
        b.append(", ");
        b.append("notificationType=");
        b.append(this.notificationType);
        b.append(", ");
        b.append("oathSecretKey=");
        b.append(this.oathSecretKey);
        b.append(", ");
        b.append("oathTokenMetadata=");
        b.append(this.oathTokenMetadata);
        b.append(", ");
        b.append("oathTokenTimeDriftInSeconds=");
        b.append(this.oathTokenTimeDriftInSeconds);
        b.append(", ");
        b.append("phoneAppVersion=");
        b.append(this.phoneAppVersion);
        b.append(", ");
        b.append("tenantDeviceId=");
        b.append(this.tenantDeviceId);
        b.append(", ");
        b.append("tokenGenerationIntervalInSeconds=");
        b.append(this.tokenGenerationIntervalInSeconds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
