package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "compliantDeviceCount", 
    "compliantUserCount", 
    "conflictDeviceCount", 
    "conflictUserCount", 
    "displayName", 
    "errorDeviceCount", 
    "errorUserCount", 
    "nonCompliantDeviceCount", 
    "nonCompliantUserCount", 
    "notApplicableDeviceCount", 
    "notApplicableUserCount", 
    "remediatedDeviceCount", 
    "remediatedUserCount", 
    "unknownDeviceCount", 
    "unknownUserCount"})
@JsonInclude(Include.NON_NULL)
public class SoftwareUpdateStatusSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.softwareUpdateStatusSummary";
    }

    @JsonProperty("compliantDeviceCount")
    protected Integer compliantDeviceCount;

    @JsonProperty("compliantUserCount")
    protected Integer compliantUserCount;

    @JsonProperty("conflictDeviceCount")
    protected Integer conflictDeviceCount;

    @JsonProperty("conflictUserCount")
    protected Integer conflictUserCount;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("errorDeviceCount")
    protected Integer errorDeviceCount;

    @JsonProperty("errorUserCount")
    protected Integer errorUserCount;

    @JsonProperty("nonCompliantDeviceCount")
    protected Integer nonCompliantDeviceCount;

    @JsonProperty("nonCompliantUserCount")
    protected Integer nonCompliantUserCount;

    @JsonProperty("notApplicableDeviceCount")
    protected Integer notApplicableDeviceCount;

    @JsonProperty("notApplicableUserCount")
    protected Integer notApplicableUserCount;

    @JsonProperty("remediatedDeviceCount")
    protected Integer remediatedDeviceCount;

    @JsonProperty("remediatedUserCount")
    protected Integer remediatedUserCount;

    @JsonProperty("unknownDeviceCount")
    protected Integer unknownDeviceCount;

    @JsonProperty("unknownUserCount")
    protected Integer unknownUserCount;

    protected SoftwareUpdateStatusSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSoftwareUpdateStatusSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer compliantDeviceCount;
        private Integer compliantUserCount;
        private Integer conflictDeviceCount;
        private Integer conflictUserCount;
        private String displayName;
        private Integer errorDeviceCount;
        private Integer errorUserCount;
        private Integer nonCompliantDeviceCount;
        private Integer nonCompliantUserCount;
        private Integer notApplicableDeviceCount;
        private Integer notApplicableUserCount;
        private Integer remediatedDeviceCount;
        private Integer remediatedUserCount;
        private Integer unknownDeviceCount;
        private Integer unknownUserCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of compliant devices.”</i>
         * 
         * @param compliantDeviceCount
         *            value of {@code compliantDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantDeviceCount(Integer compliantDeviceCount) {
            this.compliantDeviceCount = compliantDeviceCount;
            this.changedFields = changedFields.add("compliantDeviceCount");
            return this;
        }

        /**
         * <i>“Number of compliant users.”</i>
         * 
         * @param compliantUserCount
         *            value of {@code compliantUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantUserCount(Integer compliantUserCount) {
            this.compliantUserCount = compliantUserCount;
            this.changedFields = changedFields.add("compliantUserCount");
            return this;
        }

        /**
         * <i>“Number of conflict devices.”</i>
         * 
         * @param conflictDeviceCount
         *            value of {@code conflictDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictDeviceCount(Integer conflictDeviceCount) {
            this.conflictDeviceCount = conflictDeviceCount;
            this.changedFields = changedFields.add("conflictDeviceCount");
            return this;
        }

        /**
         * <i>“Number of conflict users.”</i>
         * 
         * @param conflictUserCount
         *            value of {@code conflictUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictUserCount(Integer conflictUserCount) {
            this.conflictUserCount = conflictUserCount;
            this.changedFields = changedFields.add("conflictUserCount");
            return this;
        }

        /**
         * <i>“The name of the policy.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Number of devices had error.”</i>
         * 
         * @param errorDeviceCount
         *            value of {@code errorDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorDeviceCount(Integer errorDeviceCount) {
            this.errorDeviceCount = errorDeviceCount;
            this.changedFields = changedFields.add("errorDeviceCount");
            return this;
        }

        /**
         * <i>“Number of users had error.”</i>
         * 
         * @param errorUserCount
         *            value of {@code errorUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorUserCount(Integer errorUserCount) {
            this.errorUserCount = errorUserCount;
            this.changedFields = changedFields.add("errorUserCount");
            return this;
        }

        /**
         * <i>“Number of non compliant devices.”</i>
         * 
         * @param nonCompliantDeviceCount
         *            value of {@code nonCompliantDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nonCompliantDeviceCount(Integer nonCompliantDeviceCount) {
            this.nonCompliantDeviceCount = nonCompliantDeviceCount;
            this.changedFields = changedFields.add("nonCompliantDeviceCount");
            return this;
        }

        /**
         * <i>“Number of non compliant users.”</i>
         * 
         * @param nonCompliantUserCount
         *            value of {@code nonCompliantUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nonCompliantUserCount(Integer nonCompliantUserCount) {
            this.nonCompliantUserCount = nonCompliantUserCount;
            this.changedFields = changedFields.add("nonCompliantUserCount");
            return this;
        }

        /**
         * <i>“Number of not applicable devices.”</i>
         * 
         * @param notApplicableDeviceCount
         *            value of {@code notApplicableDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableDeviceCount(Integer notApplicableDeviceCount) {
            this.notApplicableDeviceCount = notApplicableDeviceCount;
            this.changedFields = changedFields.add("notApplicableDeviceCount");
            return this;
        }

        /**
         * <i>“Number of not applicable users.”</i>
         * 
         * @param notApplicableUserCount
         *            value of {@code notApplicableUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableUserCount(Integer notApplicableUserCount) {
            this.notApplicableUserCount = notApplicableUserCount;
            this.changedFields = changedFields.add("notApplicableUserCount");
            return this;
        }

        /**
         * <i>“Number of remediated devices.”</i>
         * 
         * @param remediatedDeviceCount
         *            value of {@code remediatedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediatedDeviceCount(Integer remediatedDeviceCount) {
            this.remediatedDeviceCount = remediatedDeviceCount;
            this.changedFields = changedFields.add("remediatedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of remediated users.”</i>
         * 
         * @param remediatedUserCount
         *            value of {@code remediatedUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediatedUserCount(Integer remediatedUserCount) {
            this.remediatedUserCount = remediatedUserCount;
            this.changedFields = changedFields.add("remediatedUserCount");
            return this;
        }

        /**
         * <i>“Number of unknown devices.”</i>
         * 
         * @param unknownDeviceCount
         *            value of {@code unknownDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unknownDeviceCount(Integer unknownDeviceCount) {
            this.unknownDeviceCount = unknownDeviceCount;
            this.changedFields = changedFields.add("unknownDeviceCount");
            return this;
        }

        /**
         * <i>“Number of unknown users.”</i>
         * 
         * @param unknownUserCount
         *            value of {@code unknownUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unknownUserCount(Integer unknownUserCount) {
            this.unknownUserCount = unknownUserCount;
            this.changedFields = changedFields.add("unknownUserCount");
            return this;
        }

        public SoftwareUpdateStatusSummary build() {
            SoftwareUpdateStatusSummary _x = new SoftwareUpdateStatusSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.softwareUpdateStatusSummary";
            _x.id = id;
            _x.compliantDeviceCount = compliantDeviceCount;
            _x.compliantUserCount = compliantUserCount;
            _x.conflictDeviceCount = conflictDeviceCount;
            _x.conflictUserCount = conflictUserCount;
            _x.displayName = displayName;
            _x.errorDeviceCount = errorDeviceCount;
            _x.errorUserCount = errorUserCount;
            _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
            _x.nonCompliantUserCount = nonCompliantUserCount;
            _x.notApplicableDeviceCount = notApplicableDeviceCount;
            _x.notApplicableUserCount = notApplicableUserCount;
            _x.remediatedDeviceCount = remediatedDeviceCount;
            _x.remediatedUserCount = remediatedUserCount;
            _x.unknownDeviceCount = unknownDeviceCount;
            _x.unknownUserCount = unknownUserCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of compliant devices.”</i>
     * 
     * @return property compliantDeviceCount
     */
    @Property(name="compliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getCompliantDeviceCount() {
        return Optional.ofNullable(compliantDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of compliant devices.”</i>
     * 
     * @param compliantDeviceCount
     *            new value of {@code compliantDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantDeviceCount} field changed
     */
    public SoftwareUpdateStatusSummary withCompliantDeviceCount(Integer compliantDeviceCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("compliantDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.compliantDeviceCount = compliantDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of compliant users.”</i>
     * 
     * @return property compliantUserCount
     */
    @Property(name="compliantUserCount")
    @JsonIgnore
    public Optional<Integer> getCompliantUserCount() {
        return Optional.ofNullable(compliantUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of compliant users.”</i>
     * 
     * @param compliantUserCount
     *            new value of {@code compliantUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantUserCount} field changed
     */
    public SoftwareUpdateStatusSummary withCompliantUserCount(Integer compliantUserCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("compliantUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.compliantUserCount = compliantUserCount;
        return _x;
    }

    /**
     * <i>“Number of conflict devices.”</i>
     * 
     * @return property conflictDeviceCount
     */
    @Property(name="conflictDeviceCount")
    @JsonIgnore
    public Optional<Integer> getConflictDeviceCount() {
        return Optional.ofNullable(conflictDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * conflictDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of conflict devices.”</i>
     * 
     * @param conflictDeviceCount
     *            new value of {@code conflictDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conflictDeviceCount} field changed
     */
    public SoftwareUpdateStatusSummary withConflictDeviceCount(Integer conflictDeviceCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.conflictDeviceCount = conflictDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of conflict users.”</i>
     * 
     * @return property conflictUserCount
     */
    @Property(name="conflictUserCount")
    @JsonIgnore
    public Optional<Integer> getConflictUserCount() {
        return Optional.ofNullable(conflictUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code conflictUserCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of conflict users.”</i>
     * 
     * @param conflictUserCount
     *            new value of {@code conflictUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conflictUserCount} field changed
     */
    public SoftwareUpdateStatusSummary withConflictUserCount(Integer conflictUserCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.conflictUserCount = conflictUserCount;
        return _x;
    }

    /**
     * <i>“The name of the policy.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name of the policy.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public SoftwareUpdateStatusSummary withDisplayName(String displayName) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Number of devices had error.”</i>
     * 
     * @return property errorDeviceCount
     */
    @Property(name="errorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getErrorDeviceCount() {
        return Optional.ofNullable(errorDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorDeviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of devices had error.”</i>
     * 
     * @param errorDeviceCount
     *            new value of {@code errorDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorDeviceCount} field changed
     */
    public SoftwareUpdateStatusSummary withErrorDeviceCount(Integer errorDeviceCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("errorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.errorDeviceCount = errorDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of users had error.”</i>
     * 
     * @return property errorUserCount
     */
    @Property(name="errorUserCount")
    @JsonIgnore
    public Optional<Integer> getErrorUserCount() {
        return Optional.ofNullable(errorUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorUserCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of users had error.”</i>
     * 
     * @param errorUserCount
     *            new value of {@code errorUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorUserCount} field changed
     */
    public SoftwareUpdateStatusSummary withErrorUserCount(Integer errorUserCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("errorUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.errorUserCount = errorUserCount;
        return _x;
    }

    /**
     * <i>“Number of non compliant devices.”</i>
     * 
     * @return property nonCompliantDeviceCount
     */
    @Property(name="nonCompliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNonCompliantDeviceCount() {
        return Optional.ofNullable(nonCompliantDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * nonCompliantDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of non compliant devices.”</i>
     * 
     * @param nonCompliantDeviceCount
     *            new value of {@code nonCompliantDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nonCompliantDeviceCount} field changed
     */
    public SoftwareUpdateStatusSummary withNonCompliantDeviceCount(Integer nonCompliantDeviceCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("nonCompliantDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of non compliant users.”</i>
     * 
     * @return property nonCompliantUserCount
     */
    @Property(name="nonCompliantUserCount")
    @JsonIgnore
    public Optional<Integer> getNonCompliantUserCount() {
        return Optional.ofNullable(nonCompliantUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * nonCompliantUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of non compliant users.”</i>
     * 
     * @param nonCompliantUserCount
     *            new value of {@code nonCompliantUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nonCompliantUserCount} field changed
     */
    public SoftwareUpdateStatusSummary withNonCompliantUserCount(Integer nonCompliantUserCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("nonCompliantUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.nonCompliantUserCount = nonCompliantUserCount;
        return _x;
    }

    /**
     * <i>“Number of not applicable devices.”</i>
     * 
     * @return property notApplicableDeviceCount
     */
    @Property(name="notApplicableDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableDeviceCount() {
        return Optional.ofNullable(notApplicableDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable devices.”</i>
     * 
     * @param notApplicableDeviceCount
     *            new value of {@code notApplicableDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableDeviceCount} field changed
     */
    public SoftwareUpdateStatusSummary withNotApplicableDeviceCount(Integer notApplicableDeviceCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of not applicable users.”</i>
     * 
     * @return property notApplicableUserCount
     */
    @Property(name="notApplicableUserCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableUserCount() {
        return Optional.ofNullable(notApplicableUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableUserCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable users.”</i>
     * 
     * @param notApplicableUserCount
     *            new value of {@code notApplicableUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableUserCount} field changed
     */
    public SoftwareUpdateStatusSummary withNotApplicableUserCount(Integer notApplicableUserCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.notApplicableUserCount = notApplicableUserCount;
        return _x;
    }

    /**
     * <i>“Number of remediated devices.”</i>
     * 
     * @return property remediatedDeviceCount
     */
    @Property(name="remediatedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getRemediatedDeviceCount() {
        return Optional.ofNullable(remediatedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediatedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of remediated devices.”</i>
     * 
     * @param remediatedDeviceCount
     *            new value of {@code remediatedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediatedDeviceCount} field changed
     */
    public SoftwareUpdateStatusSummary withRemediatedDeviceCount(Integer remediatedDeviceCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("remediatedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.remediatedDeviceCount = remediatedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of remediated users.”</i>
     * 
     * @return property remediatedUserCount
     */
    @Property(name="remediatedUserCount")
    @JsonIgnore
    public Optional<Integer> getRemediatedUserCount() {
        return Optional.ofNullable(remediatedUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediatedUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of remediated users.”</i>
     * 
     * @param remediatedUserCount
     *            new value of {@code remediatedUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediatedUserCount} field changed
     */
    public SoftwareUpdateStatusSummary withRemediatedUserCount(Integer remediatedUserCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("remediatedUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.remediatedUserCount = remediatedUserCount;
        return _x;
    }

    /**
     * <i>“Number of unknown devices.”</i>
     * 
     * @return property unknownDeviceCount
     */
    @Property(name="unknownDeviceCount")
    @JsonIgnore
    public Optional<Integer> getUnknownDeviceCount() {
        return Optional.ofNullable(unknownDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unknownDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of unknown devices.”</i>
     * 
     * @param unknownDeviceCount
     *            new value of {@code unknownDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unknownDeviceCount} field changed
     */
    public SoftwareUpdateStatusSummary withUnknownDeviceCount(Integer unknownDeviceCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("unknownDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.unknownDeviceCount = unknownDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of unknown users.”</i>
     * 
     * @return property unknownUserCount
     */
    @Property(name="unknownUserCount")
    @JsonIgnore
    public Optional<Integer> getUnknownUserCount() {
        return Optional.ofNullable(unknownUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code unknownUserCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of unknown users.”</i>
     * 
     * @param unknownUserCount
     *            new value of {@code unknownUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unknownUserCount} field changed
     */
    public SoftwareUpdateStatusSummary withUnknownUserCount(Integer unknownUserCount) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = changedFields.add("unknownUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.softwareUpdateStatusSummary");
        _x.unknownUserCount = unknownUserCount;
        return _x;
    }

    public SoftwareUpdateStatusSummary withUnmappedField(String name, Object value) {
        SoftwareUpdateStatusSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SoftwareUpdateStatusSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SoftwareUpdateStatusSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SoftwareUpdateStatusSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SoftwareUpdateStatusSummary _copy() {
        SoftwareUpdateStatusSummary _x = new SoftwareUpdateStatusSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.compliantDeviceCount = compliantDeviceCount;
        _x.compliantUserCount = compliantUserCount;
        _x.conflictDeviceCount = conflictDeviceCount;
        _x.conflictUserCount = conflictUserCount;
        _x.displayName = displayName;
        _x.errorDeviceCount = errorDeviceCount;
        _x.errorUserCount = errorUserCount;
        _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
        _x.nonCompliantUserCount = nonCompliantUserCount;
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        _x.notApplicableUserCount = notApplicableUserCount;
        _x.remediatedDeviceCount = remediatedDeviceCount;
        _x.remediatedUserCount = remediatedUserCount;
        _x.unknownDeviceCount = unknownDeviceCount;
        _x.unknownUserCount = unknownUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SoftwareUpdateStatusSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("compliantDeviceCount=");
        b.append(this.compliantDeviceCount);
        b.append(", ");
        b.append("compliantUserCount=");
        b.append(this.compliantUserCount);
        b.append(", ");
        b.append("conflictDeviceCount=");
        b.append(this.conflictDeviceCount);
        b.append(", ");
        b.append("conflictUserCount=");
        b.append(this.conflictUserCount);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("errorDeviceCount=");
        b.append(this.errorDeviceCount);
        b.append(", ");
        b.append("errorUserCount=");
        b.append(this.errorUserCount);
        b.append(", ");
        b.append("nonCompliantDeviceCount=");
        b.append(this.nonCompliantDeviceCount);
        b.append(", ");
        b.append("nonCompliantUserCount=");
        b.append(this.nonCompliantUserCount);
        b.append(", ");
        b.append("notApplicableDeviceCount=");
        b.append(this.notApplicableDeviceCount);
        b.append(", ");
        b.append("notApplicableUserCount=");
        b.append(this.notApplicableUserCount);
        b.append(", ");
        b.append("remediatedDeviceCount=");
        b.append(this.remediatedDeviceCount);
        b.append(", ");
        b.append("remediatedUserCount=");
        b.append(this.remediatedUserCount);
        b.append(", ");
        b.append("unknownDeviceCount=");
        b.append(this.unknownDeviceCount);
        b.append(", ");
        b.append("unknownUserCount=");
        b.append(this.unknownUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
